CREATE TABLE `access_info` (
  `user_id` int(10) unsigned NOT NULL,
  `login_period` datetime NOT NULL,
  `logout_period` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `ad_pay` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `pay_amount` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `ad_salary` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` int(10) NOT NULL,
  `date` date NOT NULL,
  `advance_amount` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `admissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guardian` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `seat` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bill` int(11) NOT NULL COMMENT 'ID of bills table',
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'admitted' COMMENT 'admitted or released',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `admit_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `room_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cabin_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `seat_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `advanced_payment` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT,
  `created` date NOT NULL,
  `payment_date` date NOT NULL,
  `emp_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `payment_date` (`payment_date`),
  KEY `emp_id` (`emp_id`(250))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `altra_doctor_payment` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `doctor_id` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment` decimal(8,2) NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`),
  KEY `rf_pc_id` (`doctor_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `patient_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `father_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `religion` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `village` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_office` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `district` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `upazila` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `admission_date` date NOT NULL,
  `admission_time` time NOT NULL,
  `disease` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `doctor_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `clearance_date` date NOT NULL,
  `clearance_time` time NOT NULL,
  `bed_no` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_doctor_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `op_relation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `op_pa_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `op_age` int(7) NOT NULL,
  `op_village` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `op_post_office` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `op_district` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `op_upazila` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_of_unconscious` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_of_operation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_of_witness` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `father_name_of_witness` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `village_of_witness` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `witness_district` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `witness_upazila` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `witness_date` date NOT NULL,
  `name_of_consentant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `father_name_of_consentant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `village_of_consentant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consentant_district` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consentant_upazila` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consentant_date` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `bank` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `bank_name` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `bank_account` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` date NOT NULL,
  `bank_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `branch_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `holder_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `holder_contact` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_number` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `init_balance` decimal(10,2) NOT NULL,
  `pre_balance` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `bank_name` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `bank_name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `barcode` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `img_height` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `img_width` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_width` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_height` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pos_x` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pos_y` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `bills` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `time` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `voucher` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `subtotal` decimal(10,2) NOT NULL COMMENT 'Without  Vat amount',
  `vat` int(100) NOT NULL COMMENT 'Vat percentage',
  `vat_amount` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `less_type` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `service_charge` decimal(10,2) NOT NULL DEFAULT 0.00,
  `due` decimal(10,2) NOT NULL,
  `last_paid` decimal(10,2) NOT NULL,
  `last_payment_date` date NOT NULL,
  `payment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `refereed_doctor` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `other_rf_doctor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delivery_time` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `voucher` (`voucher`),
  KEY `pid` (`pid`),
  KEY `title` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=1168 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `bonus` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT,
  `created` date NOT NULL,
  `bonus_date` date NOT NULL,
  `emp_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bonus` decimal(10,2) NOT NULL COMMENT 'Bonus  (%)',
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `emp_id` (`emp_id`(250)),
  KEY `bonus_date` (`bonus_date`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `bonus_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `percentage` decimal(10,2) NOT NULL,
  `remarks` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `brand` (
  `id` int(45) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `name` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `category` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brand` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `closing` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `opening` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `income` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `salary_cost` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bank` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hand_cash` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `opening_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'auto',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `commission_payment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_date` date NOT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `balance` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `commissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `ref` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'expression [ registration:10 or pathology:15 ]. registration -> ID = 10 and pathology -> ID = 15',
  `person` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'doctors:ID or marketer:ID or pc:ID',
  `type` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `consultancies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `doctor` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ID of doctors table',
  `reference_name` int(100) NOT NULL,
  `room` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'any description for patient',
  `bill` int(11) NOT NULL COMMENT 'ID of bills table',
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending' COMMENT 'pending or complete',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `cost` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `cost_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `spend_by` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` tinyint(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `cost_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `voucher` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bill_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_qty` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  `date` date NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `cost_bill_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voucher` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_id` int(11) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `cost_field` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `create_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `procedure_id` int(11) NOT NULL,
  `standard` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `condition` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `daily_wages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` date NOT NULL,
  `emp_id` int(11) NOT NULL,
  `attendance` decimal(10,2) NOT NULL,
  `salary` decimal(10,2) NOT NULL,
  `bonus` decimal(10,2) NOT NULL,
  `payment` decimal(10,2) NOT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `created_at` (`created_at`),
  KEY `emp_id` (`emp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `deduction_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `remarks` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `designations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` date NOT NULL,
  `designation_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `diagnosis` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `delivery` date NOT NULL COMMENT 'Date value',
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Test name',
  `group_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_id` int(11) NOT NULL,
  `gender` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `refereed_doctor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Test group',
  `room` varchar(110) COLLATE utf8mb4_unicode_ci NOT NULL,
  `result` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_doctor_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt_doctor_fee` decimal(8,2) NOT NULL,
  `remarks` text COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Normal, High, Low etc',
  `amount` decimal(10,2) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `bill` int(11) NOT NULL,
  `user_id` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `refereed_doctor` (`refereed_doctor`),
  KEY `alt_doctor_id` (`alt_doctor_id`),
  KEY `bill` (`bill`),
  KEY `group_id` (`group_id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4330 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `doctor_payment` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `doctor_id` int(100) NOT NULL,
  `total_paid` decimal(8,2) NOT NULL,
  `payment` decimal(8,2) NOT NULL,
  `less` decimal(8,2) NOT NULL,
  `due` decimal(8,2) NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`),
  KEY `rf_pc_id` (`doctor_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `doctors` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fullName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `designation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `degree` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `specialised` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hospital` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fee` decimal(8,2) NOT NULL DEFAULT 0.00,
  `commission` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `room_no` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `due_collection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pid` int(11) NOT NULL,
  `admission_id` int(11) NOT NULL,
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `previous_paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `due_payment` (
  `id` int(45) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `time` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `voucher_number` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `prev_paid` decimal(10,2) NOT NULL,
  `prev_due` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `remission` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=259 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `emergencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bill` int(11) NOT NULL COMMENT 'ID of bills table',
  `status` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `employee` (
  `id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `emp_id` int(20) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `joining_date` date NOT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `overtime` int(11) NOT NULL,
  `entry_time` time NOT NULL,
  `exit_time` time NOT NULL,
  `present_address` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `permanent_address` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `designation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `employee_salary` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `path` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `emp_id` (`emp_id`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `group_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `test_id` (`test_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4293 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `group_name` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `position` int(11) DEFAULT NULL,
  `group_name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `incentive_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `percentage` decimal(10,2) NOT NULL,
  `remarks` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `income` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `income_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `income_by` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` tinyint(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `income_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `income_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `code` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `investigation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_fee` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `room` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `status` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `trash` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `journal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `ref` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'expression [ registration:10 or pathology:15 or pid:123456 ]. registration -> ID = 10 and pathology -> ID = 15 and pid = patient ID',
  `details` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'income or cost or liability or assets',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1168 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `marketer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `create_at` date NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `commission` decimal(10,2) NOT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  `img_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`) USING HASH
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `medicine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_code` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_cat` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subcategory` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  `purchase_price` decimal(10,2) NOT NULL,
  `sale_price` decimal(10,2) NOT NULL,
  `unit` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `messages_date` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `messages_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `messages_mobile` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `messages_text` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `messages_condition` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `meta_info` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_status` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `mixed_patient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `refd_doctor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lab_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `examination` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `comments` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `mixed_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `test_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `result` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `opening_balance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `opening_amount` decimal(10,2) NOT NULL,
  `initial_invest` decimal(10,2) NOT NULL,
  `closing_amount` decimal(10,2) NOT NULL,
  `status` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '1st : opening balance always on top',
  `trash` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `outstock` (
  `id` int(200) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `voucher_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stock_voucher_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reagent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `overtime` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `emp_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `hourly_rate` decimal(10,2) NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `emp_id` (`emp_id`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `parameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position` int(11) DEFAULT 0,
  `parameter_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `result` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` date NOT NULL,
  `trash` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `trash` (`trash`)
) ENGINE=InnoDB AUTO_INCREMENT=848 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `patient_admission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `admit_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `room_no` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seat_no` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cabin_no` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `days` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `paid` decimal(10,2) DEFAULT NULL,
  `due` decimal(10,2) DEFAULT NULL,
  `pair` decimal(10,2) DEFAULT NULL,
  `patient_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_report` int(1) NOT NULL DEFAULT 0,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `patient_barcode` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `img_height` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `img_width` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_width` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_height` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pos_x` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pos_y` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `patient_histories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_id` int(11) NOT NULL,
  `parameter_id` int(11) NOT NULL,
  `test_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parameter` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `standard` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `test_id` (`test_id`),
  KEY `parameter_id` (`parameter_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1657 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `patient_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `patient_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `patient_pid` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `patients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guardian` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON String. { ''relation'' : ''person name'' }',
  `gender` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` int(11) NOT NULL,
  `age_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'year',
  `address` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_report` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1171 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `pc` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fullName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `commission` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `prescription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symptoms` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `diagnosis` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `patient_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `medicine` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `test` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `privileges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `privilege_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(100) NOT NULL,
  `access` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `procedures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `test_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parameter` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `referral_value` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'with Condition',
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brand` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subcategory` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `purchase_price` decimal(10,2) NOT NULL,
  `sale_price` decimal(10,2) NOT NULL,
  `unit` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remarks` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `purchase` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `voucher_no` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subcategory` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brand` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `purchase_price` decimal(10,2) NOT NULL,
  `quantity` int(10) unsigned NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `total_discount` decimal(10,2) NOT NULL,
  `transport_cost` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `final_due` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `reagent` (
  `id` int(200) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `reagent` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `reagent_stock` (
  `id` int(200) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `voucher_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reagent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expire_date` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `recharge_sms` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `amount` varchar(192) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sms` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `registrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ID of patients. Connect to patients table. ',
  `type` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'admission or, consultancy or, emergency or, pathology',
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending' COMMENT 'pending or admitted or released or consultancy or emergency',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `remark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `remark` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remark_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `rf_pc_commission_payment` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `rf_pc_id` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment` decimal(8,2) NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`),
  KEY `rf_pc_id` (`rf_pc_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `salary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` date NOT NULL,
  `payment_date` date NOT NULL,
  `emp_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_salary` decimal(10,2) NOT NULL,
  `adjust_amount` decimal(10,2) NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `payment_date` (`payment_date`),
  KEY `emp_id` (`emp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `salary_records` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` date NOT NULL,
  `payment_date` date NOT NULL,
  `emp_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `remarks` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `payment_date` (`payment_date`),
  KEY `emp_id` (`emp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `salary_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `basic` decimal(10,2) NOT NULL,
  `incentive` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `deduction` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `bonus` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `sale` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `time` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `voucher_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` int(10) unsigned NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `remission` decimal(10,2) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `sessions` (
  `session_id` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `user_agent` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(10) unsigned NOT NULL DEFAULT 0,
  `user_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `last_activity_idx` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `sitemeta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `sms_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `delivery_date` date NOT NULL,
  `delivery_time` time NOT NULL,
  `mobile` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_characters` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_messages` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delivery_report` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `stock` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pcs',
  `purchase_price` decimal(10,2) NOT NULL,
  `sell_price` decimal(10,2) NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position` int(11) DEFAULT NULL,
  `test_name` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  `room` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fee` decimal(10,2) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `rf_com` decimal(10,2) NOT NULL DEFAULT 0.00,
  `created_at` date NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=903 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `test_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position` int(11) DEFAULT NULL,
  `group_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `remarks` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` date NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `trash` (`trash`)
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `test_histories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `procedure_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `patient_voucher` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `standerd` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `condition` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `report` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remark` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `test_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `parameter_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `test_id` (`test_id`),
  KEY `parameter_id` (`parameter_id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `test_name` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `group_name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=139 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `theme_setting` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `theme_color` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `background_pattern` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `login_background` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `google_map` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `footer` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `header` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `menu_icon` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `social_icon` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `signature` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `transaction` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_date` date NOT NULL,
  `bank` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_by` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remarks` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `ultra_patient` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` date NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `specimen` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reff_doctor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `ultra_patient_report` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `created_at` date NOT NULL,
  `patient_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_name` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_report` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `users` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `opening` datetime NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `l_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `birthday` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `maritial_status` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `about` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `website` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `facecbook` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `twitter` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `privilege` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `branch` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `vat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `percentage` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vat_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 
 
INSERT INTO `access_info` ( `user_id`, `login_period`, `logout_period`) VALUES 
('13', '2021-04-05 10:50:09', '0000-00-00 00:00:00'), 
('13', '2021-04-05 11:20:59', '2021-04-05 11:30:25'), 
('13', '2021-04-05 11:32:24', '0000-00-00 00:00:00'), 
('13', '2021-04-17 11:15:44', '0000-00-00 00:00:00'), 
('13', '2021-04-18 10:50:22', '0000-00-00 00:00:00'), 
('13', '2021-04-18 10:57:49', '0000-00-00 00:00:00'), 
('13', '2021-04-20 14:57:39', '0000-00-00 00:00:00'), 
('13', '2021-04-20 15:49:14', '2021-04-20 16:11:52'), 
('13', '2021-04-20 16:12:02', '2021-04-20 16:13:12'), 
('13', '2021-04-20 16:13:40', '2021-04-20 16:14:03'), 
('13', '2021-04-20 16:15:12', '2021-04-20 16:40:32'), 
('13', '2021-04-20 16:40:44', '2021-04-20 16:45:16'), 
('14', '2021-04-20 16:45:29', '2021-04-20 16:55:37'), 
('13', '2021-04-20 17:37:32', '0000-00-00 00:00:00'), 
('13', '2021-04-20 18:12:10', '0000-00-00 00:00:00'), 
('13', '2021-04-20 18:15:02', '0000-00-00 00:00:00'), 
('13', '2021-04-20 18:41:03', '0000-00-00 00:00:00'), 
('13', '2021-04-20 19:12:07', '0000-00-00 00:00:00'), 
('13', '2021-04-21 00:12:17', '0000-00-00 00:00:00'), 
('13', '2021-04-21 11:49:23', '0000-00-00 00:00:00'), 
('13', '2021-04-21 13:50:02', '0000-00-00 00:00:00'), 
('13', '2021-04-21 13:55:20', '2021-04-21 14:50:40'), 
('13', '2021-04-21 13:56:26', '0000-00-00 00:00:00'), 
('13', '2021-04-21 14:01:34', '0000-00-00 00:00:00'), 
('15', '2021-04-21 14:50:45', '2021-04-22 15:47:47'), 
('13', '2021-04-21 16:32:53', '0000-00-00 00:00:00'), 
('13', '2021-04-22 04:20:48', '0000-00-00 00:00:00'), 
('13', '2021-04-22 04:21:52', '0000-00-00 00:00:00'), 
('13', '2021-04-22 13:50:56', '0000-00-00 00:00:00'), 
('13', '2021-04-22 13:51:08', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:06:15', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:06:21', '2021-04-22 14:34:03'), 
('13', '2021-04-22 14:09:06', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:10:51', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:31:59', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:34:08', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:34:49', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:37:03', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:47:27', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:51:12', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:57:54', '0000-00-00 00:00:00'), 
('13', '2021-04-22 15:00:26', '0000-00-00 00:00:00'), 
('13', '2021-04-22 15:03:19', '0000-00-00 00:00:00'), 
('15', '2021-04-22 15:03:58', '2021-04-22 15:17:56'), 
('13', '2021-04-22 15:18:02', '2021-04-22 15:22:35'), 
('13', '2021-04-22 15:19:55', '0000-00-00 00:00:00'), 
('13', '2021-04-22 15:29:47', '2021-04-22 16:23:46'), 
('15', '2021-04-22 15:47:54', '0000-00-00 00:00:00'), 
('15', '2021-04-22 15:48:07', '0000-00-00 00:00:00'), 
('15', '2021-04-22 16:24:01', '2021-04-22 16:28:31'), 
('16', '2021-04-22 16:28:39', '2021-04-22 16:28:44'), 
('15', '2021-04-22 16:28:52', '2021-04-22 16:30:55'), 
('16', '2021-04-22 16:31:02', '2021-04-22 16:33:18'), 
('17', '2021-04-22 16:33:04', '0000-00-00 00:00:00'), 
('15', '2021-04-22 16:33:26', '2021-04-22 16:35:01'), 
('16', '2021-04-22 16:35:07', '2021-04-22 16:35:17'), 
('13', '2021-04-22 16:35:21', '2021-04-22 16:35:26'), 
('17', '2021-04-22 16:38:25', '0000-00-00 00:00:00'), 
('17', '2021-04-22 16:38:59', '2021-04-22 16:41:50'), 
('15', '2021-04-22 16:42:02', '0000-00-00 00:00:00'), 
('13', '2021-04-22 17:12:15', '2021-04-22 17:12:29'), 
('17', '2021-04-22 17:12:50', '0000-00-00 00:00:00'), 
('17', '2021-04-22 17:14:17', '0000-00-00 00:00:00'), 
('18', '2021-04-22 17:59:34', '0000-00-00 00:00:00'), 
('17', '2021-04-22 18:00:20', '0000-00-00 00:00:00'), 
('17', '2021-04-22 18:01:20', '0000-00-00 00:00:00'), 
('15', '2021-04-24 10:48:02', '2021-04-24 14:41:44'), 
('18', '2021-04-24 13:48:51', '0000-00-00 00:00:00'), 
('18', '2021-04-24 13:50:45', '0000-00-00 00:00:00'), 
('17', '2021-04-24 13:51:28', '0000-00-00 00:00:00'), 
('17', '2021-04-24 13:51:28', '0000-00-00 00:00:00'), 
('17', '2021-04-24 13:56:52', '0000-00-00 00:00:00'), 
('17', '2021-04-24 13:58:17', '0000-00-00 00:00:00'), 
('15', '2021-04-24 14:41:50', '2021-04-24 16:01:41'), 
('17', '2021-04-24 15:15:57', '0000-00-00 00:00:00'), 
('15', '2021-04-24 15:22:48', '0000-00-00 00:00:00'), 
('17', '2021-04-24 15:57:02', '0000-00-00 00:00:00'), 
('18', '2021-04-24 16:12:21', '0000-00-00 00:00:00'), 
('17', '2021-04-24 16:14:03', '0000-00-00 00:00:00'), 
('17', '2021-04-24 16:17:23', '0000-00-00 00:00:00'), 
('15', '2021-04-24 16:29:33', '2021-04-24 16:31:01'), 
('18', '2021-04-24 16:31:09', '2021-04-24 16:31:19'), 
('15', '2021-04-24 16:31:23', '2021-04-24 16:32:10'), 
('17', '2021-04-24 16:32:15', '2021-04-24 16:32:22'), 
('15', '2021-04-24 16:32:26', '2021-04-24 16:36:04'), 
('15', '2021-04-24 16:42:10', '2021-04-24 16:50:29'), 
('3', '2021-04-24 16:50:35', '2021-04-24 16:56:16'), 
('4', '2021-04-24 17:27:03', '0000-00-00 00:00:00'), 
('3', '2021-04-24 17:36:24', '0000-00-00 00:00:00'), 
('3', '2021-04-24 17:51:04', '0000-00-00 00:00:00'), 
('1', '2021-04-24 18:04:09', '2021-04-24 18:08:43'), 
('2', '2021-04-24 18:08:59', '0000-00-00 00:00:00'), 
('3', '2021-04-24 19:44:02', '0000-00-00 00:00:00'), 
('2', '2021-04-24 21:51:52', '2021-04-24 23:31:43'), 
('3', '2021-04-24 22:09:37', '0000-00-00 00:00:00'), 
('3', '2021-04-24 22:10:10', '0000-00-00 00:00:00'), 
('1', '2021-04-24 23:31:55', '2021-04-24 23:32:03'), 
('2', '2021-04-24 23:32:11', '0000-00-00 00:00:00'), 
('2', '2021-04-25 03:07:02', '0000-00-00 00:00:00'), 
('2', '2021-04-25 09:30:23', '2021-04-25 11:23:24'), 
('4', '2021-04-25 11:13:51', '0000-00-00 00:00:00'), 
('3', '2021-04-25 11:14:21', '0000-00-00 00:00:00'), 
('3', '2021-04-25 11:15:20', '0000-00-00 00:00:00'), 
('3', '2021-04-25 11:15:25', '0000-00-00 00:00:00'), 
('3', '2021-04-25 11:23:29', '2021-04-25 11:23:40'), 
('4', '2021-04-25 11:23:47', '2021-04-25 11:23:59'), 
('1', '2021-04-25 11:24:04', '2021-04-25 11:24:11'), 
('3', '2021-04-25 11:24:16', '0000-00-00 00:00:00'), 
('2', '2021-04-25 11:24:19', '0000-00-00 00:00:00'), 
('3', '2021-04-25 11:24:59', '0000-00-00 00:00:00'), 
('4', '2021-04-25 11:24:59', '0000-00-00 00:00:00'), 
('1', '2021-04-25 11:25:25', '0000-00-00 00:00:00'), 
('4', '2021-04-25 11:25:51', '0000-00-00 00:00:00'), 
('3', '2021-04-25 12:09:52', '0000-00-00 00:00:00'), 
('4', '2021-04-25 12:13:27', '0000-00-00 00:00:00'), 
('3', '2021-04-25 12:18:19', '0000-00-00 00:00:00'), 
('2', '2021-04-25 12:31:06', '2021-04-25 13:43:48'), 
('3', '2021-04-25 12:57:04', '0000-00-00 00:00:00'), 
('4', '2021-04-25 13:45:21', '0000-00-00 00:00:00'), 
('1', '2021-04-25 13:48:25', '0000-00-00 00:00:00'), 
('2', '2021-04-25 14:15:54', '0000-00-00 00:00:00'), 
('1', '2021-04-25 16:08:31', '0000-00-00 00:00:00'), 
('4', '2021-04-25 16:12:35', '0000-00-00 00:00:00'), 
('1', '2021-04-25 16:27:02', '2021-04-25 17:27:22'), 
('1', '2021-04-25 17:27:29', '2021-04-25 17:47:52'), 
('4', '2021-04-25 17:33:07', '0000-00-00 00:00:00'), 
('4', '2021-04-25 17:48:16', '0000-00-00 00:00:00'), 
('4', '2021-04-25 19:01:15', '0000-00-00 00:00:00'), 
('4', '2021-04-25 19:14:28', '0000-00-00 00:00:00'), 
('4', '2021-04-25 19:37:52', '0000-00-00 00:00:00'), 
('4', '2021-04-25 19:41:36', '0000-00-00 00:00:00'), 
('4', '2021-04-25 20:17:43', '0000-00-00 00:00:00'), 
('4', '2021-04-26 11:35:30', '0000-00-00 00:00:00'), 
('5', '2021-04-26 11:46:18', '0000-00-00 00:00:00'), 
('4', '2021-04-26 11:54:11', '0000-00-00 00:00:00'), 
('4', '2021-04-26 11:59:48', '0000-00-00 00:00:00'), 
('4', '2021-04-26 12:02:03', '0000-00-00 00:00:00'), 
('2', '2021-04-26 12:19:35', '2021-04-26 14:15:16'), 
('1', '2021-04-26 12:29:10', '0000-00-00 00:00:00'), 
('1', '2021-04-26 13:05:20', '0000-00-00 00:00:00'), 
('4', '2021-04-26 13:52:23', '0000-00-00 00:00:00'), 
('4', '2021-04-26 13:55:00', '0000-00-00 00:00:00'), 
('4', '2021-04-26 13:55:36', '0000-00-00 00:00:00'), 
('2', '2021-04-26 13:59:33', '2021-04-26 13:59:47'), 
('1', '2021-04-26 13:59:50', '2021-04-28 14:08:14'), 
('2', '2021-04-26 14:02:06', '0000-00-00 00:00:00'), 
('1', '2021-04-26 14:16:24', '2021-04-26 16:27:01'), 
('6', '2021-04-26 16:03:07', '0000-00-00 00:00:00'), 
('4', '2021-04-26 19:03:39', '0000-00-00 00:00:00'), 
('6', '2021-04-26 19:31:28', '2021-04-26 19:33:09'), 
('1', '2021-04-26 19:33:38', '0000-00-00 00:00:00'), 
('1', '2021-04-27 12:56:33', '0000-00-00 00:00:00'), 
('4', '2021-04-27 14:22:03', '0000-00-00 00:00:00'), 
('4', '2021-04-27 16:33:55', '0000-00-00 00:00:00'), 
('2', '2021-04-27 17:08:40', '0000-00-00 00:00:00'), 
('4', '2021-04-27 17:12:05', '0000-00-00 00:00:00'), 
('1', '2021-04-27 19:01:43', '2021-04-27 19:11:00'), 
('6', '2021-04-27 19:11:09', '0000-00-00 00:00:00'), 
('1', '2021-04-27 19:48:36', '0000-00-00 00:00:00'), 
('1', '2021-04-27 19:59:28', '0000-00-00 00:00:00'), 
('1', '2021-04-27 20:14:44', '0000-00-00 00:00:00'), 
('1', '2021-04-28 10:24:28', '0000-00-00 00:00:00'), 
('1', '2021-04-28 10:24:28', '0000-00-00 00:00:00'), 
('4', '2021-04-28 13:46:58', '0000-00-00 00:00:00'), 
('2', '2021-04-28 14:07:53', '2021-04-28 14:08:30'), 
('2', '2021-04-28 14:08:22', '2021-04-28 14:12:45'), 
('1', '2021-04-28 14:08:57', '0000-00-00 00:00:00'), 
('1', '2021-04-28 14:09:50', '0000-00-00 00:00:00'), 
('4', '2021-04-28 14:12:27', '0000-00-00 00:00:00'), 
('1', '2021-04-28 14:12:48', '2021-04-28 14:24:42'), 
('1', '2021-04-28 14:25:00', '2021-04-28 14:25:18'), 
('1', '2021-04-28 14:25:21', '2021-04-28 14:49:48'), 
('1', '2021-04-28 14:45:30', '0000-00-00 00:00:00'), 
('4', '2021-04-28 14:48:27', '0000-00-00 00:00:00'), 
('2', '2021-04-28 14:50:09', '2021-04-28 14:51:57'), 
('1', '2021-04-28 14:52:00', '0000-00-00 00:00:00'), 
('1', '2021-04-28 15:54:15', '0000-00-00 00:00:00'), 
('1', '2021-04-28 17:35:26', '0000-00-00 00:00:00'), 
('1', '2021-04-28 18:51:01', '0000-00-00 00:00:00'), 
('1', '2021-04-28 18:52:30', '0000-00-00 00:00:00'), 
('1', '2021-04-28 18:56:34', '0000-00-00 00:00:00'), 
('4', '2021-04-28 18:58:33', '0000-00-00 00:00:00'), 
('1', '2021-04-29 10:14:12', '0000-00-00 00:00:00'), 
('1', '2021-04-29 10:30:05', '0000-00-00 00:00:00'), 
('1', '2021-04-29 13:36:09', '0000-00-00 00:00:00'), 
('4', '2021-04-29 13:50:17', '0000-00-00 00:00:00'), 
('4', '2021-04-29 15:20:22', '0000-00-00 00:00:00'), 
('4', '2021-04-29 16:05:32', '0000-00-00 00:00:00'), 
('4', '2021-04-29 18:31:51', '0000-00-00 00:00:00'), 
('1', '2021-04-30 12:41:05', '0000-00-00 00:00:00'), 
('1', '2021-05-01 09:54:23', '0000-00-00 00:00:00'), 
('1', '2021-05-01 14:03:20', '0000-00-00 00:00:00'), 
('4', '2021-05-01 14:06:55', '0000-00-00 00:00:00'), 
('1', '2021-05-01 15:07:05', '0000-00-00 00:00:00'), 
('4', '2021-05-01 15:08:29', '0000-00-00 00:00:00'), 
('1', '2021-05-01 15:09:35', '0000-00-00 00:00:00'), 
('4', '2021-05-01 15:24:00', '0000-00-00 00:00:00'), 
('1', '2021-05-01 19:33:56', '0000-00-00 00:00:00'), 
('4', '2021-05-01 19:35:28', '0000-00-00 00:00:00'), 
('1', '2021-05-01 19:52:47', '0000-00-00 00:00:00'), 
('1', '2021-05-01 20:00:31', '0000-00-00 00:00:00'), 
('1', '2021-05-02 09:50:27', '0000-00-00 00:00:00'), 
('1', '2021-05-02 11:14:09', '0000-00-00 00:00:00'), 
('1', '2021-05-02 12:46:12', '0000-00-00 00:00:00'), 
('2', '2021-05-02 14:01:21', '0000-00-00 00:00:00'), 
('1', '2021-05-02 14:13:27', '0000-00-00 00:00:00'), 
('1', '2021-05-02 14:24:38', '0000-00-00 00:00:00'), 
('4', '2021-05-02 14:31:39', '0000-00-00 00:00:00'), 
('4', '2021-05-02 14:46:05', '0000-00-00 00:00:00'), 
('6', '2021-05-02 14:50:57', '2021-05-02 14:51:56'), 
('6', '2021-05-02 14:54:31', '2021-05-02 14:55:13'), 
('6', '2021-05-02 14:56:07', '2021-05-02 14:57:22'), 
('4', '2021-05-02 14:56:39', '0000-00-00 00:00:00'), 
('6', '2021-05-02 15:00:29', '2021-05-02 15:43:41'), 
('6', '2021-05-02 15:43:57', '2021-05-02 15:55:07'), 
('6', '2021-05-02 16:00:53', '2021-05-02 16:11:19'), 
('7', '2021-05-02 16:11:32', '0000-00-00 00:00:00'), 
('4', '2021-05-02 16:12:27', '2021-05-02 16:12:42'), 
('7', '2021-05-02 16:13:13', '0000-00-00 00:00:00'), 
('6', '2021-05-02 16:13:36', '2021-05-02 16:14:26'), 
('4', '2021-05-02 16:13:55', '0000-00-00 00:00:00'), 
('8', '2021-05-02 16:14:37', '2021-05-02 16:14:58'), 
('6', '2021-05-02 16:15:08', '2021-05-02 16:15:52'), 
('6', '2021-05-02 16:16:21', '0000-00-00 00:00:00'), 
('4', '2021-05-02 18:03:48', '0000-00-00 00:00:00'), 
('4', '2021-05-02 18:50:40', '0000-00-00 00:00:00'), 
('6', '2021-05-03 00:41:22', '0000-00-00 00:00:00'), 
('6', '2021-05-03 00:53:39', '0000-00-00 00:00:00'), 
('6', '2021-05-03 00:59:38', '0000-00-00 00:00:00'), 
('6', '2021-05-03 01:05:02', '0000-00-00 00:00:00'), 
('6', '2021-05-03 01:07:22', '0000-00-00 00:00:00'), 
('8', '2021-05-03 09:58:07', '0000-00-00 00:00:00'), 
('8', '2021-05-03 11:38:16', '2021-05-03 11:38:45'), 
('8', '2021-05-03 11:39:04', '2021-05-03 11:39:28'), 
('6', '2021-05-03 11:39:57', '0000-00-00 00:00:00'), 
('2', '2021-05-03 11:53:51', '0000-00-00 00:00:00'), 
('2', '2021-05-03 13:37:50', '2021-05-05 15:41:43'), 
('2', '2021-05-03 13:52:23', '0000-00-00 00:00:00'), 
('4', '2021-05-03 14:52:58', '0000-00-00 00:00:00'), 
('2', '2021-05-03 15:12:11', '0000-00-00 00:00:00'), 
('2', '2021-05-03 15:53:18', '0000-00-00 00:00:00'), 
('9', '2021-05-03 16:54:59', '0000-00-00 00:00:00'), 
('4', '2021-05-03 17:11:18', '0000-00-00 00:00:00'), 
('4', '2021-05-03 18:20:56', '0000-00-00 00:00:00'), 
('6', '2021-05-04 10:09:27', '0000-00-00 00:00:00'), 
('6', '2021-05-04 12:24:16', '0000-00-00 00:00:00'), 
('4', '2021-05-04 14:21:21', '0000-00-00 00:00:00'), 
('4', '2021-05-04 17:19:42', '0000-00-00 00:00:00'), 
('8', '2021-05-05 10:02:34', '0000-00-00 00:00:00'), 
('8', '2021-05-05 11:23:56', '0000-00-00 00:00:00'), 
('8', '2021-05-05 13:25:58', '0000-00-00 00:00:00'), 
('8', '2021-05-05 13:27:49', '0000-00-00 00:00:00'), 
('8', '2021-05-05 13:46:44', '0000-00-00 00:00:00'), 
('9', '2021-05-05 14:01:20', '2021-05-05 14:02:28'), 
('4', '2021-05-05 14:01:41', '0000-00-00 00:00:00'), 
('9', '2021-05-05 14:02:31', '0000-00-00 00:00:00'), 
('9', '2021-05-05 15:41:51', '0000-00-00 00:00:00'), 
('9', '2021-05-05 15:46:43', '2021-05-05 16:24:49'), 
('9', '2021-05-05 15:48:06', '0000-00-00 00:00:00'), 
('9', '2021-05-05 16:00:23', '0000-00-00 00:00:00'), 
('4', '2021-05-05 16:27:42', '0000-00-00 00:00:00'), 
('8', '2021-05-06 09:44:12', '0000-00-00 00:00:00'), 
('8', '2021-05-06 13:56:29', '0000-00-00 00:00:00'), 
('8', '2021-05-06 14:01:21', '0000-00-00 00:00:00'), 
('4', '2021-05-06 15:13:22', '0000-00-00 00:00:00'), 
('4', '2021-05-06 15:25:39', '0000-00-00 00:00:00'), 
('4', '2021-05-06 15:40:14', '0000-00-00 00:00:00'), 
('4', '2021-05-07 14:23:34', '0000-00-00 00:00:00'), 
('4', '2021-05-07 15:28:00', '0000-00-00 00:00:00'), 
('8', '2021-05-08 14:26:04', '0000-00-00 00:00:00'), 
('4', '2021-05-08 14:29:21', '0000-00-00 00:00:00'), 
('4', '2021-05-08 14:47:41', '0000-00-00 00:00:00'), 
('8', '2021-05-08 14:53:53', '0000-00-00 00:00:00'), 
('8', '2021-05-08 15:11:02', '0000-00-00 00:00:00'), 
('4', '2021-05-08 16:01:51', '0000-00-00 00:00:00'), 
('8', '2021-05-08 19:14:52', '0000-00-00 00:00:00'), 
('8', '2021-05-08 20:18:23', '0000-00-00 00:00:00'), 
('4', '2021-05-09 10:17:54', '0000-00-00 00:00:00'), 
('4', '2021-05-09 11:52:09', '0000-00-00 00:00:00'), 
('8', '2021-05-09 14:15:09', '0000-00-00 00:00:00'), 
('8', '2021-05-09 15:43:04', '0000-00-00 00:00:00'), 
('8', '2021-05-09 16:04:07', '0000-00-00 00:00:00'), 
('8', '2021-05-09 17:16:07', '0000-00-00 00:00:00'), 
('8', '2021-05-09 18:22:42', '0000-00-00 00:00:00'), 
('8', '2021-05-10 15:42:01', '0000-00-00 00:00:00'), 
('8', '2021-05-10 17:31:08', '0000-00-00 00:00:00'), 
('8', '2021-05-10 17:55:30', '0000-00-00 00:00:00'), 
('4', '2021-05-11 10:08:25', '0000-00-00 00:00:00'), 
('8', '2021-05-11 14:35:45', '0000-00-00 00:00:00'), 
('8', '2021-05-11 15:00:10', '0000-00-00 00:00:00'), 
('8', '2021-05-11 17:19:17', '0000-00-00 00:00:00'), 
('8', '2021-05-11 19:07:34', '0000-00-00 00:00:00'), 
('4', '2021-05-12 10:24:45', '0000-00-00 00:00:00'), 
('4', '2021-05-12 12:57:41', '2021-05-12 15:41:06'), 
('8', '2021-05-12 15:41:17', '0000-00-00 00:00:00'), 
('8', '2021-05-12 19:24:32', '0000-00-00 00:00:00'), 
('8', '2021-05-12 19:25:01', '0000-00-00 00:00:00'), 
('8', '2021-05-12 19:33:23', '2021-05-12 20:13:51'), 
('8', '2021-05-16 14:20:42', '0000-00-00 00:00:00'), 
('8', '2021-05-16 16:15:31', '0000-00-00 00:00:00'), 
('8', '2021-05-16 17:24:03', '0000-00-00 00:00:00'), 
('8', '2021-05-17 10:24:46', '0000-00-00 00:00:00'), 
('8', '2021-05-17 11:31:51', '0000-00-00 00:00:00'), 
('6', '2021-05-17 13:10:48', '0000-00-00 00:00:00'), 
('8', '2021-05-17 14:16:04', '0000-00-00 00:00:00'), 
('8', '2021-05-17 19:42:22', '0000-00-00 00:00:00'), 
('8', '2021-05-17 19:43:57', '0000-00-00 00:00:00'), 
('8', '2021-05-18 10:36:06', '0000-00-00 00:00:00'), 
('8', '2021-05-18 11:52:29', '0000-00-00 00:00:00'), 
('8', '2021-05-18 12:46:53', '2021-05-18 12:49:00'), 
('8', '2021-05-18 12:49:16', '0000-00-00 00:00:00'), 
('8', '2021-05-18 13:28:40', '0000-00-00 00:00:00'), 
('4', '2021-05-18 14:51:43', '0000-00-00 00:00:00'), 
('4', '2021-05-18 17:31:09', '0000-00-00 00:00:00'), 
('8', '2021-05-19 09:25:06', '0000-00-00 00:00:00'), 
('4', '2021-05-19 14:17:49', '0000-00-00 00:00:00'), 
('4', '2021-05-19 14:36:26', '0000-00-00 00:00:00'), 
('4', '2021-05-19 14:45:00', '0000-00-00 00:00:00'), 
('4', '2021-05-19 14:56:59', '0000-00-00 00:00:00'), 
('4', '2021-05-19 15:36:55', '0000-00-00 00:00:00'), 
('10', '2021-05-19 15:37:11', '0000-00-00 00:00:00'), 
('4', '2021-05-19 17:35:01', '0000-00-00 00:00:00'), 
('4', '2021-05-19 17:50:10', '0000-00-00 00:00:00'), 
('4', '2021-05-19 18:22:05', '0000-00-00 00:00:00'), 
('4', '2021-05-19 18:40:18', '0000-00-00 00:00:00'), 
('4', '2021-05-19 18:40:58', '0000-00-00 00:00:00'), 
('4', '2021-05-19 18:48:05', '0000-00-00 00:00:00'), 
('4', '2021-05-19 21:03:46', '0000-00-00 00:00:00'), 
('8', '2021-05-20 09:16:07', '0000-00-00 00:00:00'), 
('8', '2021-05-20 12:49:26', '0000-00-00 00:00:00'), 
('8', '2021-05-20 12:54:53', '0000-00-00 00:00:00'), 
('8', '2021-05-20 13:06:03', '0000-00-00 00:00:00'), 
('4', '2021-05-20 14:18:21', '0000-00-00 00:00:00'), 
('4', '2021-05-20 18:41:11', '0000-00-00 00:00:00'), 
('4', '2021-05-20 22:05:39', '0000-00-00 00:00:00'), 
('4', '2021-05-21 11:32:08', '0000-00-00 00:00:00'), 
('4', '2021-05-21 12:45:48', '0000-00-00 00:00:00'), 
('4', '2021-05-21 13:18:27', '0000-00-00 00:00:00'), 
('4', '2021-05-21 15:38:15', '0000-00-00 00:00:00'), 
('8', '2021-05-22 09:57:56', '0000-00-00 00:00:00'), 
('8', '2021-05-22 11:04:54', '0000-00-00 00:00:00'), 
('4', '2021-05-22 14:59:52', '0000-00-00 00:00:00'), 
('4', '2021-05-22 15:28:22', '0000-00-00 00:00:00'), 
('4', '2021-05-22 16:43:14', '0000-00-00 00:00:00'), 
('4', '2021-05-22 16:49:43', '0000-00-00 00:00:00'), 
('4', '2021-05-22 17:55:45', '0000-00-00 00:00:00'), 
('8', '2021-05-23 09:33:35', '2021-05-23 13:55:19'), 
('8', '2021-05-23 10:47:10', '0000-00-00 00:00:00'), 
('4', '2021-05-23 11:37:45', '0000-00-00 00:00:00'), 
('8', '2021-05-23 13:04:34', '0000-00-00 00:00:00'), 
('8', '2021-05-23 13:57:28', '0000-00-00 00:00:00'), 
('4', '2021-05-23 14:15:09', '0000-00-00 00:00:00'), 
('4', '2021-05-23 14:24:26', '0000-00-00 00:00:00'), 
('4', '2021-05-23 17:34:26', '0000-00-00 00:00:00'), 
('8', '2021-05-24 09:35:40', '0000-00-00 00:00:00'), 
('8', '2021-05-24 14:17:55', '0000-00-00 00:00:00'), 
('4', '2021-05-24 15:56:24', '0000-00-00 00:00:00'), 
('4', '2021-05-24 17:44:33', '0000-00-00 00:00:00'), 
('4', '2021-05-24 19:33:47', '0000-00-00 00:00:00'), 
('4', '2021-05-24 21:23:36', '0000-00-00 00:00:00'), 
('8', '2021-05-25 09:19:28', '0000-00-00 00:00:00'), 
('4', '2021-05-25 14:58:12', '0000-00-00 00:00:00'), 
('4', '2021-05-25 17:22:37', '0000-00-00 00:00:00'), 
('4', '2021-05-25 19:35:44', '0000-00-00 00:00:00'), 
('4', '2021-05-25 20:34:00', '0000-00-00 00:00:00'), 
('8', '2021-05-26 10:05:52', '0000-00-00 00:00:00'), 
('4', '2021-05-26 14:17:53', '0000-00-00 00:00:00'), 
('4', '2021-05-26 14:49:06', '0000-00-00 00:00:00'), 
('4', '2021-05-26 14:50:02', '0000-00-00 00:00:00'), 
('6', '2021-05-26 16:03:52', '0000-00-00 00:00:00'), 
('6', '2021-05-26 16:48:59', '0000-00-00 00:00:00'), 
('8', '2021-05-26 21:29:40', '0000-00-00 00:00:00'), 
('8', '2021-05-27 09:13:08', '0000-00-00 00:00:00'), 
('8', '2021-05-27 09:46:32', '0000-00-00 00:00:00'), 
('8', '2021-05-27 10:19:22', '0000-00-00 00:00:00'), 
('8', '2021-05-27 12:35:50', '0000-00-00 00:00:00'), 
('8', '2021-05-27 13:31:17', '0000-00-00 00:00:00'), 
('8', '2021-05-27 13:32:57', '0000-00-00 00:00:00'), 
('4', '2021-05-27 14:25:42', '0000-00-00 00:00:00'), 
('4', '2021-05-27 15:33:30', '0000-00-00 00:00:00'), 
('4', '2021-05-27 17:41:54', '0000-00-00 00:00:00'), 
('4', '2021-05-27 18:02:11', '0000-00-00 00:00:00'), 
('4', '2021-05-27 19:11:55', '0000-00-00 00:00:00'), 
('8', '2021-05-28 12:41:23', '2021-05-28 15:12:14'), 
('8', '2021-05-28 15:12:48', '2021-05-28 15:14:17'), 
('8', '2021-05-28 15:36:06', '2021-05-28 18:50:56'), 
('8', '2021-05-28 19:37:53', '0000-00-00 00:00:00'), 
('8', '2021-05-28 20:16:33', '2021-05-28 20:31:25'), 
('8', '2021-05-28 21:01:56', '0000-00-00 00:00:00'), 
('8', '2021-05-29 10:04:21', '0000-00-00 00:00:00'), 
('8', '2021-05-29 11:44:36', '0000-00-00 00:00:00'), 
('4', '2021-05-29 14:16:45', '0000-00-00 00:00:00'), 
('8', '2021-05-30 09:14:30', '0000-00-00 00:00:00'), 
('8', '2021-05-30 10:12:25', '2021-05-30 14:03:40'), 
('4', '2021-05-30 14:04:13', '0000-00-00 00:00:00'), 
('8', '2021-05-30 14:08:47', '2021-05-30 15:13:41'), 
('4', '2021-05-30 15:14:20', '0000-00-00 00:00:00'), 
('4', '2021-05-30 17:12:36', '0000-00-00 00:00:00'), 
('4', '2021-05-30 21:22:17', '0000-00-00 00:00:00'), 
('8', '2021-05-31 09:16:12', '0000-00-00 00:00:00'), 
('8', '2021-05-31 13:18:54', '2021-05-31 13:58:56'), 
('4', '2021-05-31 14:00:46', '0000-00-00 00:00:00'), 
('4', '2021-05-31 16:19:38', '0000-00-00 00:00:00'), 
('4', '2021-05-31 18:28:01', '0000-00-00 00:00:00'), 
('8', '2021-06-01 09:26:32', '0000-00-00 00:00:00'), 
('8', '2021-06-01 13:52:18', '2021-06-01 13:59:13'), 
('4', '2021-06-01 14:00:07', '0000-00-00 00:00:00'), 
('4', '2021-06-01 14:07:58', '0000-00-00 00:00:00'), 
('8', '2021-06-02 09:21:44', '0000-00-00 00:00:00'), 
('8', '2021-06-02 12:04:22', '0000-00-00 00:00:00'), 
('8', '2021-06-02 13:34:26', '0000-00-00 00:00:00'), 
('4', '2021-06-02 14:03:59', '0000-00-00 00:00:00'), 
('4', '2021-06-02 14:18:14', '0000-00-00 00:00:00'), 
('4', '2021-06-02 14:23:20', '0000-00-00 00:00:00'), 
('4', '2021-06-02 19:15:35', '0000-00-00 00:00:00'), 
('8', '2021-06-03 09:44:08', '0000-00-00 00:00:00'), 
('8', '2021-06-03 09:45:02', '2021-06-03 16:29:55'), 
('11', '2021-06-03 15:40:02', '0000-00-00 00:00:00'), 
('4', '2021-06-03 16:12:23', '2021-06-03 16:15:36'), 
('13', '2021-06-03 16:15:51', '0000-00-00 00:00:00'), 
('13', '2021-06-03 16:25:22', '0000-00-00 00:00:00'), 
('4', '2021-06-03 16:30:29', '0000-00-00 00:00:00'), 
('13', '2021-06-03 17:05:09', '0000-00-00 00:00:00'), 
('4', '2021-06-04 11:04:39', '0000-00-00 00:00:00'), 
('13', '2021-06-04 13:48:48', '2021-06-04 13:54:44'), 
('4', '2021-06-04 18:58:31', '0000-00-00 00:00:00'), 
('4', '2021-06-05 10:30:33', '0000-00-00 00:00:00'), 
('4', '2021-06-05 18:02:06', '0000-00-00 00:00:00'), 
('6', '2021-06-05 18:56:37', '0000-00-00 00:00:00'), 
('8', '2021-06-06 09:39:04', '0000-00-00 00:00:00'), 
('8', '2021-06-06 11:19:41', '2021-06-06 13:53:04'), 
('4', '2021-06-06 13:54:05', '0000-00-00 00:00:00'), 
('4', '2021-06-06 15:09:02', '0000-00-00 00:00:00'), 
('8', '2021-06-07 09:32:07', '2021-06-07 14:12:43'), 
('8', '2021-06-07 11:14:00', '2021-06-07 11:18:03'), 
('6', '2021-06-07 11:49:41', '0000-00-00 00:00:00'), 
('8', '2021-06-07 12:12:09', '2021-06-07 12:17:25'), 
('4', '2021-06-07 13:36:39', '0000-00-00 00:00:00'), 
('4', '2021-06-07 15:01:32', '0000-00-00 00:00:00'), 
('8', '2021-06-08 09:39:17', '2021-06-08 13:51:28'), 
('4', '2021-06-08 14:07:54', '0000-00-00 00:00:00'), 
('8', '2021-06-09 09:44:32', '0000-00-00 00:00:00'), 
('4', '2021-06-09 13:41:22', '0000-00-00 00:00:00'), 
('8', '2021-06-09 13:53:20', '0000-00-00 00:00:00'), 
('4', '2021-06-09 19:55:59', '0000-00-00 00:00:00'), 
('4', '2021-06-09 22:32:23', '0000-00-00 00:00:00'), 
('8', '2021-06-10 09:21:30', '0000-00-00 00:00:00'), 
('14', '2021-06-10 13:32:18', '2021-06-10 13:33:51'), 
('14', '2021-06-10 13:34:12', '0000-00-00 00:00:00'), 
('14', '2021-06-10 13:58:19', '0000-00-00 00:00:00'), 
('14', '2021-06-10 14:07:56', '0000-00-00 00:00:00'), 
('14', '2021-06-10 14:44:06', '0000-00-00 00:00:00'), 
('10', '2021-06-15 15:15:25', '2021-06-15 15:16:08'), 
('10', '2021-06-15 15:16:35', '2021-06-15 15:16:53'), 
('14', '2021-06-15 15:17:19', '0000-00-00 00:00:00'), 
('14', '2021-06-15 16:25:17', '0000-00-00 00:00:00'), 
('14', '2021-06-16 09:18:40', '0000-00-00 00:00:00'), 
('14', '2021-06-17 18:36:46', '2021-06-17 18:43:55'), 
('14', '2021-06-18 18:00:23', '0000-00-00 00:00:00'), 
('14', '2021-06-19 10:38:58', '2021-06-19 14:43:47'), 
('14', '2021-06-19 11:23:47', '0000-00-00 00:00:00'), 
('14', '2021-06-19 11:44:27', '0000-00-00 00:00:00'), 
('14', '2021-06-19 14:43:52', '0000-00-00 00:00:00'), 
('14', '2021-06-19 16:47:13', '0000-00-00 00:00:00'), 
('14', '2021-06-19 16:48:50', '0000-00-00 00:00:00'), 
('14', '2021-06-20 12:01:08', '0000-00-00 00:00:00'), 
('14', '2021-06-20 18:10:12', '0000-00-00 00:00:00'), 
('14', '2021-06-20 19:45:38', '0000-00-00 00:00:00'), 
('14', '2021-06-21 11:04:39', '0000-00-00 00:00:00'), 
('14', '2021-06-21 11:07:34', '0000-00-00 00:00:00'), 
('14', '2021-06-21 12:31:38', '0000-00-00 00:00:00'), 
('14', '2021-06-21 14:17:03', '0000-00-00 00:00:00'), 
('14', '2021-06-21 15:25:01', '0000-00-00 00:00:00'), 
('10', '2021-06-22 11:05:29', '2021-06-22 11:05:52'), 
('14', '2021-06-22 11:05:55', '0000-00-00 00:00:00'), 
('14', '2021-06-22 11:32:54', '2021-06-22 15:53:45'), 
('14', '2021-06-22 12:25:25', '0000-00-00 00:00:00'), 
('14', '2021-06-23 11:13:46', '0000-00-00 00:00:00'), 
('14', '2021-06-23 11:36:47', '0000-00-00 00:00:00'), 
('14', '2021-06-23 11:52:31', '2021-06-23 11:54:37'), 
('14', '2021-06-23 15:03:49', '0000-00-00 00:00:00'), 
('14', '2021-06-23 15:36:16', '2021-06-23 15:49:11'), 
('14', '2021-06-23 17:13:45', '2021-06-23 18:36:14'), 
('14', '2021-06-23 17:48:37', '0000-00-00 00:00:00'), 
('14', '2021-06-23 20:37:28', '0000-00-00 00:00:00'), 
('14', '2021-06-23 23:04:11', '0000-00-00 00:00:00'), 
('14', '2021-06-24 00:36:08', '2021-06-24 00:42:34'), 
('14', '2021-06-24 11:52:18', '0000-00-00 00:00:00'), 
('14', '2021-06-24 18:00:15', '0000-00-00 00:00:00'), 
('14', '2021-06-24 18:33:22', '0000-00-00 00:00:00'), 
('14', '2021-06-24 18:42:01', '0000-00-00 00:00:00'), 
('14', '2021-06-25 11:02:00', '2021-06-26 17:01:43'), 
('14', '2021-06-26 11:41:45', '0000-00-00 00:00:00'), 
('14', '2021-06-26 18:00:55', '0000-00-00 00:00:00'), 
('14', '2021-06-27 10:48:50', '0000-00-00 00:00:00'), 
('14', '2021-06-27 14:15:17', '2021-06-27 18:54:27'), 
('14', '2021-06-27 16:11:27', '0000-00-00 00:00:00'), 
('14', '2021-06-27 19:31:54', '0000-00-00 00:00:00'), 
('14', '2021-06-27 20:15:32', '2021-06-27 20:40:13'), 
('14', '2021-06-27 20:50:46', '0000-00-00 00:00:00'), 
('14', '2021-06-28 11:57:52', '0000-00-00 00:00:00'), 
('14', '2021-06-28 12:12:18', '2021-06-28 12:59:50'), 
('14', '2021-06-28 13:10:17', '0000-00-00 00:00:00'), 
('14', '2021-06-28 13:55:10', '0000-00-00 00:00:00'), 
('14', '2021-06-28 17:18:10', '0000-00-00 00:00:00'), 
('14', '2021-06-29 09:33:25', '0000-00-00 00:00:00'), 
('14', '2021-06-29 19:25:02', '2021-06-29 19:26:28'), 
('14', '2021-06-30 12:11:07', '0000-00-00 00:00:00'), 
('14', '2021-06-30 15:37:11', '2021-06-30 15:41:27'), 
('14', '2021-07-01 13:17:20', '2021-07-01 13:20:16'), 
('14', '2021-07-02 11:41:21', '0000-00-00 00:00:00'), 
('14', '2021-07-03 12:05:47', '2021-07-03 15:34:27'), 
('10', '2021-07-03 14:26:05', '2021-07-03 14:26:18'), 
('14', '2021-07-03 14:26:45', '0000-00-00 00:00:00'), 
('14', '2021-07-04 16:07:01', '2021-07-04 16:09:31'), 
('14', '2021-07-06 13:05:34', '2021-07-06 13:06:40'), 
('14', '2021-07-07 14:06:34', '0000-00-00 00:00:00'), 
('14', '2021-07-07 16:03:38', '0000-00-00 00:00:00'), 
('14', '2021-07-08 16:23:53', '0000-00-00 00:00:00'), 
('14', '2021-07-09 13:20:40', '0000-00-00 00:00:00'), 
('14', '2021-07-11 18:11:39', '0000-00-00 00:00:00'), 
('14', '2021-07-15 13:12:35', '0000-00-00 00:00:00'), 
('14', '2021-07-16 17:37:22', '2021-07-16 17:41:35'), 
('14', '2021-07-20 11:40:57', '0000-00-00 00:00:00'), 
('14', '2021-07-24 18:49:43', '0000-00-00 00:00:00'), 
('14', '2021-07-24 19:18:07', '0000-00-00 00:00:00'), 
('14', '2021-07-24 19:18:27', '0000-00-00 00:00:00'), 
('14', '2021-07-26 13:09:00', '0000-00-00 00:00:00'), 
('14', '2021-07-27 12:12:49', '0000-00-00 00:00:00'), 
('14', '2021-07-30 13:04:41', '2021-07-30 13:52:51'), 
('15', '2021-08-03 15:52:32', '0000-00-00 00:00:00'), 
('15', '2021-08-03 16:05:03', '0000-00-00 00:00:00'), 
('15', '2021-08-03 16:20:49', '0000-00-00 00:00:00'), 
('15', '2021-08-03 16:25:36', '0000-00-00 00:00:00'), 
('15', '2021-08-03 17:20:49', '2021-08-03 18:36:02'), 
('15', '2021-08-04 11:16:29', '2021-08-04 11:25:03'), 
('16', '2021-08-04 11:26:30', '0000-00-00 00:00:00'), 
('15', '2021-08-04 11:41:50', '0000-00-00 00:00:00'), 
('15', '2021-08-04 12:10:51', '2021-08-04 14:04:42'), 
('15', '2021-08-04 12:15:21', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:04:14', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:05:02', '2021-08-04 14:12:50'), 
('15', '2021-08-04 14:06:34', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:13:02', '2021-08-04 14:14:23'), 
('17', '2021-08-04 14:14:32', '2021-08-04 14:14:41'), 
('17', '2021-08-04 14:15:06', '2021-08-04 14:17:51'), 
('15', '2021-08-04 14:18:02', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:27:02', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:41:23', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:52:45', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:57:05', '0000-00-00 00:00:00'), 
('15', '2021-08-04 15:01:31', '0000-00-00 00:00:00'), 
('15', '2021-08-04 15:04:08', '0000-00-00 00:00:00'), 
('15', '2021-08-04 15:46:43', '0000-00-00 00:00:00'), 
('15', '2021-08-04 17:51:48', '2021-08-04 19:40:26'), 
('15', '2021-08-04 18:56:53', '0000-00-00 00:00:00'), 
('15', '2021-08-04 20:01:11', '2021-08-04 20:02:08'), 
('15', '2021-08-04 20:35:17', '0000-00-00 00:00:00'), 
('15', '2021-08-05 10:57:23', '0000-00-00 00:00:00'), 
('17', '2021-08-05 12:03:28', '0000-00-00 00:00:00'), 
('15', '2021-08-05 14:05:47', '0000-00-00 00:00:00'), 
('15', '2021-08-06 10:57:46', '0000-00-00 00:00:00'), 
('15', '2021-08-08 11:51:22', '0000-00-00 00:00:00'), 
('15', '2021-08-09 12:08:23', '0000-00-00 00:00:00'), 
('15', '2021-08-10 13:58:54', '0000-00-00 00:00:00'), 
('15', '2021-08-10 17:38:38', '0000-00-00 00:00:00'), 
('15', '2021-08-10 17:58:13', '0000-00-00 00:00:00'), 
('15', '2021-08-10 18:38:57', '0000-00-00 00:00:00'), 
('15', '2021-08-10 19:06:02', '0000-00-00 00:00:00'), 
('15', '2021-08-10 19:46:43', '0000-00-00 00:00:00'), 
('15', '2021-08-10 20:06:21', '0000-00-00 00:00:00'), 
('15', '2021-08-10 20:09:15', '2021-08-10 20:13:22'), 
('15', '2021-08-11 10:01:49', '0000-00-00 00:00:00'), 
('15', '2021-08-11 10:12:54', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:10:38', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:14:21', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:16:51', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:30:28', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:30:35', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:50:07', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:54:03', '0000-00-00 00:00:00'), 
('15', '2021-08-11 12:21:32', '0000-00-00 00:00:00'), 
('15', '2021-08-11 12:56:26', '0000-00-00 00:00:00'), 
('15', '2021-08-11 13:03:43', '0000-00-00 00:00:00'), 
('15', '2021-08-11 13:10:40', '0000-00-00 00:00:00'), 
('15', '2021-08-11 13:29:04', '0000-00-00 00:00:00'), 
('15', '2021-08-11 14:25:19', '0000-00-00 00:00:00'), 
('15', '2021-08-11 14:39:49', '2021-08-11 14:41:34'), 
('15', '2021-08-11 14:41:37', '0000-00-00 00:00:00'), 
('15', '2021-08-11 14:50:10', '0000-00-00 00:00:00'), 
('15', '2021-08-11 15:06:21', '0000-00-00 00:00:00'), 
('18', '2021-08-11 15:57:07', '2021-08-11 16:01:56'), 
('15', '2021-08-11 16:02:51', '0000-00-00 00:00:00'), 
('18', '2021-08-11 16:03:54', '2021-08-11 16:04:23'), 
('18', '2021-08-11 16:12:35', '0000-00-00 00:00:00'), 
('15', '2021-08-11 16:25:44', '0000-00-00 00:00:00'), 
('15', '2021-08-11 16:26:44', '0000-00-00 00:00:00');  



 



 



 



INSERT INTO `admit_type` ( `id`, `type`, `room_no`, `cabin_no`, `seat_no`, `price`, `trash`) VALUES 
('11', 'cabin', '', '208', '', '5000.00', '0'), 
('10', 'cabin', '', '207', '', '0.00', '0'), 
('9', 'cabin', '', '206', '', '0.00', '0'), 
('8', 'cabin', '', '205', '', '0.00', '0'), 
('12', 'seat', '305', '', '1', '1000.00', '0'), 
('13', 'cabin', '', '10', '', '5000.00', '0'), 
('14', 'seat', '304', '', '12', '500.00', '0');  



INSERT INTO `advanced_payment` ( `id`, `created`, `payment_date`, `emp_id`, `amount`, `trash`) VALUES 
('5', '2021-06-10', '2021-06-30', '21001', '30000.00', '0');  



INSERT INTO `altra_doctor_payment` ( `id`, `date`, `doctor_id`, `payment`, `trash`) VALUES 
('1', '2021-06-10', '21', '500.00', '0'), 
('2', '2021-06-10', '27', '1200.00', '0');  



 



INSERT INTO `bank` ( `id`, `date`, `bank_name`) VALUES 
('1', '2021-06-10', 'Datch Bangla Bank Ltd'), 
('2', '2021-06-10', 'Islami Bank');  



INSERT INTO `bank_account` ( `id`, `datetime`, `bank_name`, `branch_name`, `holder_name`, `holder_contact`, `account_number`, `init_balance`, `pre_balance`) VALUES 
('1', '2021-06-10', 'Datch Bangla Bank Ltd', 'Mymensingh ', 'Hridoy', '01953238865', '120458795201254', '25000.00', '25000'), 
('2', '2021-06-10', 'Datch Bangla Bank Ltd', 'Mymensingh ', 'Tareq', '01909890498', '012365987521', '12000.00', '12000'), 
('3', '2021-04-10', 'Datch Bangla Bank Ltd', 'Mymensingh ', 'fghfhbd', '01953238865', '43464531234516+', '41000.00', '41000'), 
('4', '2021-06-10', 'Islami Bank', 'Mymensingh ', 'Aminur', '524234196', '1245548795225', '10000.00', '10000');  



 



INSERT INTO `barcode` ( `id`, `img_height`, `img_width`, `code_width`, `code_height`, `pos_x`, `pos_y`, `code_type`) VALUES 
('1', '68', '209', '2', '40', '104', '23', 'code128'), 
('2', '68', '209', '2', '40', '104', '23', 'code128');  



INSERT INTO `bills` ( `id`, `date`, `time`, `voucher`, `pid`, `title`, `details`, `subtotal`, `vat`, `vat_amount`, `total`, `discount`, `less_type`, `grand_total`, `paid`, `service_charge`, `due`, `last_paid`, `last_payment_date`, `payment_status`, `refereed_doctor`, `user_id`, `other_rf_doctor`, `status`, `delivery_time`) VALUES 
('1', '2021-04-05', '', '2104050001', '00001', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '100.00', 'Flat', '1000.00', '800.00', '0.00', '200.00', '800.00', '2021-04-05', 'pending', '', '0', '', 'diagnosis', ''), 
('2', '2021-04-18', '', '2104180002', '0002', 'consultancy', '', '0.00', '0', '0.00', '500.00', '50.00', '', '450.00', '350.00', '0.00', '100.00', '300.00', '2021-04-18', 'pending', '', '0', '', '', ''), 
('3', '2021-04-18', '', '2104180003', '0002', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '200.00', '0.00', '100.00', '0.00', '2021-04-18', 'pending', '', '0', '', 'diagnosis', ''), 
('4', '2021-04-18', '', '2104180004', '0004', 'consultancy', '', '0.00', '0', '0.00', '500.00', '0.00', '', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-04-18', 'pending', '', '0', '', '', ''), 
('5', '2021-04-18', '', '2104180005', '0004', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '0.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-04-18', 'pending', '', '0', '', 'diagnosis', ''), 
('6', '2021-04-20', '', '2104200006', '0006', 'consultancy', '', '0.00', '0', '0.00', '500.00', '0.00', '', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-04-20', 'pending', '', '0', '', '', ''), 
('7', '2021-04-20', '', '2104200007', '0006', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-04-20', 'pending', '', '0', '', 'diagnosis', ''), 
('8', '2021-04-20', '', '2104200008', '0008', 'consultancy', '', '0.00', '0', '0.00', '500.00', '0.00', '', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-04-20', 'pending', '', '0', '', '', ''), 
('9', '2021-04-20', '', '2104200009', '0009', 'consultancy', '', '0.00', '0', '0.00', '0.00', '0.00', '', '0.00', '500.00', '0.00', '0.00', '500.00', '2021-04-20', 'pending', '', '0', '', '', ''), 
('10', '2021-04-20', '', '2104200010', '0010', 'consultancy', '', '0.00', '0', '0.00', '0.00', '0.00', '', '0.00', '500.00', '0.00', '0.00', '500.00', '2021-04-20', 'pending', '', '0', '', '', ''), 
('11', '2021-04-20', '', '2104200011', '0011', 'consultancy', '', '0.00', '0', '0.00', '0.00', '0.00', '', '0.00', '500.00', '0.00', '0.00', '500.00', '2021-04-20', 'pending', '', '0', '', '', ''), 
('12', '2021-04-20', '', '2104200012', '00002', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-04-20', 'pending', '', '0', '', 'diagnosis', ''), 
('13', '2021-04-20', '', '2104200012', '00002', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', 'Flat', '0.00', '200.00', '0.00', '0.00', '200.00', '2021-04-20', 'pending', '', '0', '', 'diagnosis', ''), 
('14', '2021-04-20', '', '2104200012', '00002', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '200.00', '0.00', '400.00', '200.00', '2021-04-20', 'pending', '', '0', '', 'diagnosis', ''), 
('15', '2021-04-20', '', '2104200015', '00003', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-04-20', 'pending', '', '0', '', 'diagnosis', ''), 
('16', '2021-04-20', '', '2104200016', '00004', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-04-20', 'pending', '', '0', '', 'diagnosis', ''), 
('17', '2021-04-20', '', '2104200016', '00004', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', 'Flat', '0.00', '400.00', '0.00', '0.00', '400.00', '2021-04-20', 'pending', '', '0', '', 'diagnosis', ''), 
('18', '2021-04-20', '', '2104200016', '00004', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', 'Flat', '0.00', '400.00', '0.00', '0.00', '400.00', '2021-04-20', 'pending', '', '0', '', 'diagnosis', ''), 
('19', '2021-04-21', '', '2104210019', '00005', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '12.00', 'Flat', '388.00', '300.00', '0.00', '88.00', '300.00', '2021-04-21', 'pending', '', '0', '', 'diagnosis', ''), 
('20', '2021-04-21', '', '2104210020', '0020', 'consultancy', '', '0.00', '0', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-04-21', 'pending', '', '0', '', '', ''), 
('21', '2021-04-21', '', '2104210020', '0020', 'consultancy', '', '0.00', '0', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-04-21', 'pending', '', '0', '', '', ''), 
('22', '2021-04-21', '', '2104210022', '0021', 'consultancy', '', '0.00', '0', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-04-21', 'pending', '', '0', '', '', ''), 
('23', '2021-04-22', '', '2104220023', '00006', 'diagnosis', 'diagnosis', '2600.00', '0', '0.00', '2600.00', '0.00', 'Flat', '2600.00', '0.00', '0.00', '2600.00', '0.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('24', '2021-04-22', '', '2104220024', '00007', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('25', '2021-04-22', '', '2104220025', '00008', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '1700.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('26', '2021-04-22', '', '2104220026', '00009', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('27', '2021-04-22', '', '2104220027', '00010', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '0.00', 'Flat', '1400.00', '0.00', '0.00', '1400.00', '0.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('28', '2021-04-22', '', '2104220027', '00010', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '700.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('29', '2021-04-22', '', '2104220029', '00011', 'diagnosis', 'diagnosis', '400.00', '5', '20.00', '420.00', '0.00', 'Flat', '420.00', '400.00', '0.00', '20.00', '400.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('30', '2021-04-22', '', '2104220030', '00012', 'diagnosis', 'diagnosis', '100.00', '0', '0.00', '100.00', '0.00', 'Flat', '120.00', '120.00', '20.00', '0.00', '120.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('31', '2021-04-22', '', '2104220030', '00012', 'diagnosis', 'diagnosis', '1800.00', '5', '90.00', '1890.00', '90.00', 'Flat', '1800.00', '0.00', '0.00', '1800.00', '0.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('32', '2021-04-22', '', '2104220032', '00013', 'diagnosis', 'diagnosis', '100.00', '0', '0.00', '100.00', '0.00', 'Flat', '120.00', '100.00', '20.00', '20.00', '100.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('33', '2021-04-22', '', '2104220033', '00014', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1050.00', '1050.00', '50.00', '0.00', '1050.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('34', '2021-04-22', '', '2104220034', '00015', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '950.00', 'Flat', '0.00', '0.00', '50.00', '0.00', '0.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('35', '2021-04-22', '', '2104220035', '00016', 'diagnosis', 'diagnosis', '100.00', '0', '0.00', '100.00', '0.00', 'Flat', '100.00', '0.00', '0.00', '100.00', '0.00', '2021-04-22', 'pending', '', '0', '', 'diagnosis', ''), 
('36', '2021-04-24', '', '2104240036', '00017', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '1200.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-04-24', 'pending', '', '0', '', 'diagnosis', ''), 
('37', '2021-04-24', '', '2104240036', '00017', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-04-24', 'pending', '', '0', '', 'diagnosis', ''), 
('41', '2021-04-24', '', '2104240038', '00021', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '850.00', 'Flat', '0.00', '0.00', '50.00', '0.00', '0.00', '2021-04-24', 'pending', '', '0', '', 'diagnosis', ''), 
('42', '2021-04-24', '', '2104240038', '00021', 'diagnosis', 'diagnosis', '2600.00', '0', '0.00', '2600.00', '0.00', 'Flat', '0.00', '1000.00', '50.00', '0.00', '1000.00', '2021-04-24', 'pending', '', '0', '', 'diagnosis', ''), 
('43', '2021-04-24', '', '2104240038', '00021', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2350.00', '0.00', 'Flat', '0.00', '1000.00', '50.00', '0.00', '1000.00', '2021-04-24', 'pending', '', '0', '', 'diagnosis', ''), 
('44', '2021-04-24', '', '2104240044', '00022', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-04-24', 'pending', '', '0', '', 'diagnosis', ''), 
('45', '2021-04-24', '', '2104240045', '00023', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-04-24', 'pending', '', '0', '', 'diagnosis', ''), 
('46', '2021-04-24', '', '2104240046', '00024', 'diagnosis', 'diagnosis', '3000.00', '0', '0.00', '3000.00', '0.00', 'Flat', '3000.00', '0.00', '0.00', '3000.00', '0.00', '2021-04-24', 'pending', '', '0', '', 'diagnosis', ''), 
('47', '2021-04-24', '', '2104240047', '00025', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2900.00', '0.00', 'Flat', '2950.00', '2000.00', '50.00', '950.00', '2000.00', '2021-04-24', 'pending', '', '0', '', 'diagnosis', ''), 
('48', '2021-04-24', '', '2104240048', '00026', 'diagnosis', 'diagnosis', '3000.00', '0', '0.00', '3000.00', '0.00', 'Flat', '3000.00', '300.00', '0.00', '2700.00', '300.00', '2021-04-24', 'pending', '', '0', '', 'diagnosis', ''), 
('49', '2021-04-24', '', '2104240049', '00027', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '300.00', '0.00', '100.00', '300.00', '2021-04-24', 'pending', '', '0', '', 'diagnosis', ''), 
('50', '2021-04-25', '', '2104250050', '00028', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-04-25', 'pending', '', '0', '', 'diagnosis', ''), 
('55', '2021-04-25', '', '2104250055', '00033', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-04-25', 'pending', '', '4', 'dr.shafiqul islam', 'diagnosis', '08:21'), 
('56', '2021-04-25', '', '2104250055', '00033', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-04-25', 'pending', '', '4', 'dr.shafiqul islam', 'diagnosis', '08:21'), 
('62', '2021-04-25', '', '2104250057', '00038', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-04-25', 'pending', '', '2', '', 'diagnosis', '08:21'), 
('63', '2021-04-25', '', '2104250063', '00039', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-04-25', 'pending', '', '2', '', 'diagnosis', '08:21'), 
('64', '2021-04-25', '', '2104250064', '00040', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-04-25', 'pending', '', '1', 'DR. M. H. ATAUR', 'diagnosis', '08:21'), 
('65', '2021-04-25', '', '2104250065', '00041', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '0.00', '0.00', '700.00', '0.00', '2021-04-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('66', '2021-04-25', '', '2104250066', '00042', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '600.00', '0.00', '200.00', '600.00', '2021-04-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('67', '2021-04-25', '', '2104250067', '00043', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1900.00', '1500.00', '0.00', '400.00', '1500.00', '2021-04-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('68', '2021-04-26', '', '2104260068', '00044', 'diagnosis', 'diagnosis', '4800.00', '0', '0.00', '4800.00', '0.00', 'Flat', '4800.00', '0.00', '0.00', '4800.00', '0.00', '2021-04-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('69', '2021-04-26', '', '2104260068', '00044', 'diagnosis', 'diagnosis', '5500.00', '0', '0.00', '5500.00', '2500.00', 'Flat', '3000.00', '3000.00', '0.00', '0.00', '3000.00', '2021-04-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('70', '2021-04-26', '', '2104260070', '00045', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '0.00', 'Percentage', '1900.00', '1000.00', '0.00', '900.00', '1000.00', '2021-04-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('71', '2021-04-26', '', '2104260070', '00045', 'diagnosis', 'diagnosis', '3350.00', '0', '0.00', '3350.00', '350.00', 'Flat', '3000.00', '3000.00', '0.00', '0.00', '3000.00', '2021-04-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('72', '2021-04-26', '', '2104260072', '00046', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-04-26', 'pending', '', '1', '', 'diagnosis', '08:21'), 
('73', '2021-04-26', '', '2104260073', '00047', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '0.00', 'Flat', '1550.00', '0.00', '0.00', '1550.00', '0.00', '2021-04-26', 'pending', '', '1', '', 'diagnosis', '08:21'), 
('74', '2021-04-26', '', '2104260074', '00048', 'diagnosis', 'diagnosis', '8250.00', '0', '0.00', '8250.00', '8300.00', 'Flat', '0.00', '0.00', '50.00', '0.00', '0.00', '2021-04-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('75', '2021-04-26', '', '2104260075', '00049', 'diagnosis', 'diagnosis', '7450.00', '0', '0.00', '7450.00', '0.00', 'Flat', '7450.00', '0.00', '0.00', '7450.00', '0.00', '2021-04-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('76', '2021-04-26', '', '2104260076', '00050', 'diagnosis', 'diagnosis', '3500.00', '0', '0.00', '3500.00', '0.00', 'Flat', '3500.00', '0.00', '0.00', '3500.00', '0.00', '2021-04-26', 'pending', '', '4', 'dr.saiful malek mbbs bcs', 'diagnosis', '08:21'), 
('77', '2021-04-26', '', '2104260077', '00051', 'diagnosis', 'diagnosis', '6050.00', '0', '0.00', '6050.00', '0.00', 'Flat', '6100.00', '2000.00', '50.00', '4100.00', '2000.00', '2021-04-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('78', '2021-04-27', '', '2104270078', '00052', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '450.00', 'Flat', '900.00', '0.00', '50.00', '900.00', '0.00', '2021-04-27', 'pending', '', '1', '', 'diagnosis', '08:21'), 
('79', '2021-04-27', '', '2104270079', '00053', 'diagnosis', 'diagnosis', '6000.00', '0', '0.00', '6000.00', '0.00', 'Flat', '6050.00', '0.00', '50.00', '6050.00', '0.00', '2021-04-27', 'pending', '', '1', 'Self', 'diagnosis', '08:21'), 
('80', '2021-04-27', '', '2104270080', '00054', 'diagnosis', 'diagnosis', '6000.00', '0', '0.00', '6000.00', '2050.00', 'Flat', '4000.00', '4000.00', '50.00', '0.00', '4000.00', '2021-04-27', 'pending', '', '1', '', 'diagnosis', '08:21'), 
('82', '2021-04-28', '', '2104280082', '0002', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-04-28', 'pending', '', '1', '', 'diagnosis', '08:21'), 
('83', '2021-04-28', '', '2104280083', '00056', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '1300.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-04-28', 'pending', '', '1', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('84', '2021-04-28', '', '2104280084', '00057', 'diagnosis', 'diagnosis', '10650.00', '0', '0.00', '10650.00', '700.00', 'Flat', '10000.00', '10000.00', '50.00', '0.00', '10000.00', '2021-04-28', 'pending', '', '1', 'Self', 'diagnosis', '08:21'), 
('85', '2021-04-29', '', '2104290085', '00058', 'diagnosis', 'diagnosis', '3550.00', '0', '0.00', '3550.00', '0.00', 'Flat', '3600.00', '0.00', '50.00', '3600.00', '0.00', '2021-04-29', 'pending', '', '4', 'DR.GOUTAM SAHA MBBS(DHAKA)BCS(H)FCPS(MED)MD(NEP.)ASSI.PRO.MMCH', 'diagnosis', '08:21'), 
('86', '2021-04-29', '', '2104290085', '00058', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2500.00', '0.00', 'Flat', '2500.00', '0.00', '0.00', '2500.00', '0.00', '2021-04-29', 'pending', '', '4', 'DR.GOUTAM SAHA MBBS(DHAKA)BCS(H)FCPS(MED)MD(NEP.)ASSI.PRO.MMCH', 'diagnosis', '08:21'), 
('87', '2021-04-29', '', '2104290085', '00058', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2500.00', '0.00', 'Flat', '2500.00', '0.00', '0.00', '2500.00', '0.00', '2021-04-29', 'pending', '', '4', '', 'diagnosis', '2021-04-29'), 
('88', '2021-04-29', '', '2104290088', '00059', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2500.00', '600.00', 'Flat', '1900.00', '0.00', '0.00', '1900.00', '0.00', '2021-04-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('89', '2021-04-29', '', '2104290089', '00060', 'diagnosis', 'diagnosis', '3550.00', '0', '0.00', '3550.00', '0.00', 'Flat', '3600.00', '0.00', '50.00', '3600.00', '0.00', '2021-04-29', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('90', '2021-04-29', '', '2104290090', '00061', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '0.00', 'Flat', '2500.00', '2500.00', '50.00', '0.00', '2500.00', '2021-04-29', 'pending', '', '4', 'DR.A.S.M. SHAFIQUL ISLAM(MILON)MBBS.BCS.(H)MD(MED)MMCH', 'diagnosis', '08:21'), 
('91', '2021-04-29', '', '2104290091', '00062', 'diagnosis', 'diagnosis', '3850.00', '0', '0.00', '3850.00', '100.00', 'Flat', '3800.00', '3000.00', '50.00', '800.00', '3000.00', '2021-04-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('93', '2021-04-29', '', '2104290093', '00064', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '1250.00', 'Flat', '-50.00', '0.00', '50.00', '0.00', '0.00', '2021-04-29', 'pending', '', '4', 'DR.MOHAMMMAD RUHUL HAIDER MBBS.(MMC)BCS(H)MD(NEP.)MMCH', 'diagnosis', '08:21'), 
('94', '2021-04-30', '', '2104300094', '00065', 'diagnosis', 'diagnosis', '3850.00', '0', '0.00', '3850.00', '1700.00', 'Flat', '2200.00', '1500.00', '50.00', '700.00', '1500.00', '2021-04-30', 'pending', '', '1', 'SELF', 'diagnosis', '08:21'), 
('99', '2021-05-01', '', '2105010099', '00069', 'diagnosis', 'diagnosis', '4300.00', '0', '0.00', '4300.00', '1300.00', 'Flat', '3000.00', '3000.00', '0.00', '0.00', '3000.00', '2021-05-01', 'pending', '', '1', '', 'diagnosis', '08:21'), 
('100', '2021-05-01', '', '2105010100', '00070', 'diagnosis', 'diagnosis', '2850.00', '0', '0.00', '2850.00', '400.00', 'Flat', '2500.00', '2500.00', '50.00', '0.00', '2500.00', '2021-05-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('101', '2021-05-01', '', '2105010101', '00071', 'diagnosis', 'diagnosis', '3150.00', '0', '0.00', '3150.00', '200.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-05-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('102', '2021-05-01', '', '2105010102', '00072', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '550.00', '0.00', '150.00', '550.00', '2021-05-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('103', '2021-05-01', '', '2105010103', '00073', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '300.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-01', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('105', '2021-05-02', '', '2105020105', '00075', 'diagnosis', 'diagnosis', '3400.00', '0', '0.00', '3400.00', '1450.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-02', 'pending', '', '1', 'RAJ', 'diagnosis', '08:21'), 
('106', '2021-05-02', '', '2105020106', '00076', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '470.00', 'Flat', '530.00', '530.00', '50.00', '0.00', '530.00', '2021-05-02', 'pending', '', '1', 'SELF', 'diagnosis', '08:21'), 
('107', '2021-05-02', '', '2105020107', '00077', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1100.00', '0.00', '50.00', '1100.00', '0.00', '2021-05-02', 'pending', '', '1', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('109', '2021-05-02', '', '2105020109', '00079', 'diagnosis', 'diagnosis', '3150.00', '0', '0.00', '3150.00', '0.00', 'Flat', '3150.00', '0.00', '0.00', '3150.00', '0.00', '2021-05-02', 'pending', '', '6', '', 'diagnosis', '08:21'), 
('111', '2021-05-02', '', '2105020111', '00080', 'diagnosis', 'diagnosis', '5300.00', '0', '0.00', '5300.00', '3300.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-05-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('112', '2021-05-02', '', '2105020112', '00081', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2800.00', '0.00', 'Flat', '2850.00', '2000.00', '50.00', '850.00', '2000.00', '2021-05-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('113', '2021-05-02', '', '2105020112', '00081', 'diagnosis', 'diagnosis', '6350.00', '0', '0.00', '6350.00', '3000.00', 'Flat', '3400.00', '3400.00', '50.00', '0.00', '3400.00', '2021-05-02', 'pending', '', '6', '', 'diagnosis', '08:21'), 
('115', '2021-05-02', '', '2105020115', '00083', 'diagnosis', 'diagnosis', '6350.00', '0', '0.00', '6350.00', '3000.00', 'Flat', '3400.00', '3400.00', '50.00', '0.00', '3400.00', '2021-05-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('116', '2021-05-02', '', '2105020116', '00084', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '300.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-02', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('118', '2021-05-02', '', '2105020118', '00086', 'diagnosis', 'diagnosis', '2850.00', '0', '0.00', '2850.00', '900.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('120', '2021-05-02', '', '2105020119', '00088', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-05-02', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('121', '2021-05-03', '', '2105030121', '00089', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '250.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-03', 'pending', '', '6', 'SELF', 'diagnosis', '08:21'), 
('122', '2021-05-03', '', '2105030122', '00090', 'diagnosis', 'diagnosis', '3300.00', '0', '0.00', '3300.00', '0.00', 'Flat', '3350.00', '1000.00', '50.00', '2350.00', '1000.00', '2021-05-03', 'pending', '', '6', '', 'diagnosis', '08:21'), 
('123', '2021-05-03', '', '2105030123', '00091', 'diagnosis', 'diagnosis', '4900.00', '0', '0.00', '4900.00', '700.00', 'Flat', '4200.00', '4200.00', '0.00', '0.00', '4200.00', '2021-05-03', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('124', '2021-05-03', '', '2105030124', '00092', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-05-03', 'pending', '', '4', 'RAJDHANI HOSPITAL ', 'diagnosis', '08:21'), 
('127', '2021-05-03', '', '2105030127', '00095', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '1000.00', '0.00', '200.00', '1000.00', '2021-05-03', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('131', '2021-05-03', '', '2105030131', '00099', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '700.00', '0.00', '100.00', '700.00', '2021-05-03', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('132', '2021-05-03', '', '2105030132', '00100', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '100.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-03', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('133', '2021-05-03', '', '2105030133', '00101', 'diagnosis', 'diagnosis', '2550.00', '0', '0.00', '2550.00', '0.00', 'Flat', '2600.00', '300.00', '50.00', '2300.00', '300.00', '2021-05-03', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('134', '2021-05-03', '', '2105030134', '00102', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2300.00', '0.00', 'Flat', '2350.00', '1500.00', '50.00', '850.00', '1500.00', '2021-05-03', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('136', '2021-05-04', '', '2105040135', '00104', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '150.00', 'Flat', '600.00', '600.00', '50.00', '0.00', '600.00', '2021-05-04', 'pending', '', '6', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('138', '2021-05-04', '', '2105040137', '00106', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1100.00', '0.00', '50.00', '1100.00', '0.00', '2021-05-04', 'pending', '', '6', 'SELF', 'diagnosis', '08:21'), 
('139', '2021-05-04', '', '2105040139', '00107', 'diagnosis', 'diagnosis', '3300.00', '0', '0.00', '3300.00', '350.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-05-04', 'pending', '', '6', '', 'diagnosis', '08:21'), 
('141', '2021-05-04', '', '2105040140', '00109', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '0.00', 'Flat', '2450.00', '1000.00', '50.00', '1450.00', '1000.00', '2021-05-04', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('147', '2021-05-04', '', '2105040147', '00115', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '100.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-05-04', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('148', '2021-05-04', '', '2105040148', '00116', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '100.00', 'Flat', '2200.00', '2200.00', '50.00', '0.00', '2200.00', '2021-05-04', 'pending', '', '4', 'DR.M.A.ZAMAN MBBS(DHAKA)BCS(H)MCPS.FCPS.MMCH', 'diagnosis', '08:21'), 
('149', '2021-05-05', '', '2105050149', '00117', 'diagnosis', 'diagnosis', '3100.00', '0', '0.00', '3100.00', '0.00', 'Flat', '3150.00', '1000.00', '50.00', '2150.00', '1000.00', '2021-05-05', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('151', '2021-05-05', '', '2105050150', '00119', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1100.00', '1100.00', '50.00', '0.00', '1100.00', '2021-05-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('152', '2021-05-05', '', '2105050152', '00120', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '750.00', '500.00', '50.00', '250.00', '500.00', '2021-05-05', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('153', '2021-05-05', '', '2105050153', '00121', 'diagnosis', 'diagnosis', '3800.00', '0', '0.00', '3800.00', '250.00', 'Flat', '3600.00', '3600.00', '50.00', '0.00', '3600.00', '2021-05-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('155', '2021-05-05', '', '2105050153', '00121', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '100.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-05-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('156', '2021-05-05', '', '2105050156', '00122', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '100.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-05-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('157', '2021-05-05', '', '2105050156', '0020', 'diagnosis', 'diagnosis', '100.00', '0', '0.00', '100.00', '0.00', 'Flat', '100.00', '50.00', '0.00', '50.00', '50.00', '2021-05-05', 'pending', '', '9', '', 'diagnosis', '08:21'), 
('158', '2021-05-05', '', '2105050156', '00122', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '101.00', '0.00', '49.00', '101.00', '2021-05-05', 'pending', '', '9', '', 'diagnosis', '08:21'), 
('159', '2021-05-05', '', '2105050150', '00118', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '100.00', '0.00', '400.00', '100.00', '2021-05-05', 'pending', '', '9', '', 'diagnosis', '08:21'), 
('160', '2021-05-05', '', '2105050150', '00118', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '250.00', '0.00', '250.00', '250.00', '2021-05-05', 'pending', '', '9', '', 'diagnosis', '08:21'), 
('165', '2021-05-05', '', '90630574772', '00125', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1900.00', '1000.00', '0.00', '900.00', '1000.00', '2021-05-05', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('167', '2021-05-05', '', '44287769123', '17374', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '100.00', '0.00', '400.00', '100.00', '2021-05-05', 'pending', '', '9', '', 'diagnosis', '08:21'), 
('172', '2021-05-05', '', '99395935485', '52475', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '0.00', 'Flat', '2100.00', '500.00', '50.00', '1600.00', '500.00', '2021-05-05', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('175', '2021-05-06', '', '11670415517', '62116', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '800.00', 'Flat', '700.00', '700.00', '50.00', '0.00', '700.00', '2021-05-06', 'pending', '', '4', 'DR.PRADIP CHANDRA KAR MBBS.FCPS.CCD.(BIRDEM)MRCG', 'diagnosis', '08:21'), 
('176', '2021-05-06', '', '71813751053', '33150', 'diagnosis', 'diagnosis', '4900.00', '0', '0.00', '4900.00', '150.00', 'Flat', '4800.00', '4800.00', '50.00', '0.00', '4800.00', '2021-05-06', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('180', '2021-05-06', '', '72456026863', '79338', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-05-06', 'pending', '', '4', 'DR.ABU ZAFOR MD. SALAUDDIN MBBS.(DHAKA)BCS(H)MD(NEP-)MMCH', 'diagnosis', '08:21'), 
('181', '2021-05-06', '', '31050294099', '41306', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '400.00', 'Flat', '1700.00', '1600.00', '50.00', '100.00', '1600.00', '2021-05-06', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('182', '2021-05-07', '', '96987594539', '95174', 'diagnosis', 'diagnosis', '2550.00', '0', '0.00', '2550.00', '1000.00', 'Flat', '1600.00', '1600.00', '50.00', '0.00', '1600.00', '2021-05-07', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('183', '2021-05-07', '', '49808479431', '79472', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '580.00', 'Flat', '420.00', '420.00', '0.00', '0.00', '420.00', '2021-05-07', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('185', '2021-05-07', '', '77429546829', '44364', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2500.00', '50.00', 'Flat', '2500.00', '1000.00', '50.00', '1500.00', '1000.00', '2021-05-07', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('186', '2021-05-07', '', '23526592842', '63094', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2300.00', '500.00', 'Flat', '1850.00', '1850.00', '50.00', '0.00', '1850.00', '2021-05-07', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('187', '2021-05-07', '', '85496320989', '76494', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '200.00', 'Flat', '600.00', '600.00', '50.00', '0.00', '600.00', '2021-05-07', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('188', '2021-05-07', '', '57158593336', '21157', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '600.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-07', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('191', '2021-05-08', '', '68153620262', '45503', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '900.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-05-08', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('192', '2021-05-08', '', '51003640476', '41701', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '100.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-08', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('193', '2021-05-08', '', '55345464911', '18880', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '600.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-08', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('194', '2021-05-08', '', '52957029806', '36810', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '200.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-05-08', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('197', '2021-05-08', '', '27233889367', '63037', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '0.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-08', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('198', '2021-05-08', '', '43767492141', '92806', 'diagnosis', 'diagnosis', '5200.00', '0', '0.00', '5200.00', '250.00', 'Flat', '5000.00', '3600.00', '50.00', '1400.00', '3600.00', '2021-05-08', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('199', '2021-05-08', '', '72466135645', '76543', 'diagnosis', 'diagnosis', '3150.00', '0', '0.00', '3150.00', '200.00', 'Flat', '3000.00', '700.00', '50.00', '2300.00', '700.00', '2021-05-08', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('201', '2021-05-08', '', '37370982807', '73841', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2950.00', '600.00', 'Flat', '2400.00', '2400.00', '50.00', '0.00', '2400.00', '2021-05-08', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('203', '2021-05-08', '', '31017186327', '52844', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '650.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-05-08', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('205', '2021-05-08', '', '36746064407', '72000', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '300.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-08', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('206', '2021-05-08', '', '50958028187', '12268', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '600.00', 'Flat', '900.00', '900.00', '50.00', '0.00', '900.00', '2021-05-08', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('207', '2021-05-09', '', '30749328475', '22404', 'diagnosis', 'diagnosis', '3100.00', '0', '0.00', '3100.00', '0.00', 'Flat', '3150.00', '2400.00', '50.00', '750.00', '2400.00', '2021-05-09', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('208', '2021-05-09', '', '16154413794', '23296', 'diagnosis', 'diagnosis', '3750.00', '0', '0.00', '3750.00', '0.00', 'Flat', '3800.00', '1700.00', '50.00', '2100.00', '1700.00', '2021-05-09', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('209', '2021-05-09', '', '60100832788', '21079', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2350.00', '100.00', 'Flat', '2250.00', '2300.00', '50.00', '0.00', '2300.00', '2021-05-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('210', '2021-05-09', '', '92949838605', '44218', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1100.00', '0.00', '50.00', '1100.00', '0.00', '2021-05-09', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('211', '2021-05-09', '', '77900996431', '26344', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '700.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-09', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('212', '2021-05-09', '', '49878757778', '71439', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '500.00', 'Flat', '600.00', '600.00', '50.00', '0.00', '600.00', '2021-05-09', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('214', '2021-05-09', '', '25766131819', '19350', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2950.00', '1500.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('215', '2021-05-09', '', '55190090255', '77908', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '280.00', 'Flat', '670.00', '670.00', '50.00', '0.00', '670.00', '2021-05-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('217', '2021-05-09', '', '38178620652', '85079', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '50.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('218', '2021-05-10', '', '41617505252', '68407', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '700.00', 'Flat', '1400.00', '1400.00', '50.00', '0.00', '1400.00', '2021-05-10', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('219', '2021-05-10', '', '83595169666', '12586', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '500.00', 'Flat', '600.00', '600.00', '50.00', '0.00', '600.00', '2021-05-10', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('220', '2021-05-10', '', '23747565473', '38952', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2300.00', '750.00', 'Flat', '1600.00', '1600.00', '50.00', '0.00', '1600.00', '2021-05-10', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('222', '2021-05-10', '', '45170477736', '33525', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '60.00', 'Flat', '1340.00', '1340.00', '50.00', '0.00', '1340.00', '2021-05-10', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('224', '2021-05-10', '', '79412657974', '53828', 'diagnosis', 'diagnosis', '4400.00', '0', '0.00', '4400.00', '0.00', 'Flat', '4450.00', '600.00', '50.00', '3850.00', '600.00', '2021-05-10', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('225', '2021-05-10', '', '96020731288', '20165', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '0.00', 'Flat', '1450.00', '900.00', '50.00', '550.00', '900.00', '2021-05-10', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('226', '2021-05-11', '', '49373376824', '70010', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '300.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-11', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('227', '2021-05-11', '', '63840693276', '72443', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '1000.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-11', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('229', '2021-05-11', '', '16618537737', '12202', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '700.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-11', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('231', '2021-05-12', '', '79847969777', '49163', 'diagnosis', 'diagnosis', '3500.00', '0', '0.00', '3500.00', '550.00', 'Flat', '2950.00', '3000.00', '50.00', '0.00', '2000.00', '2021-05-12', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('232', '2021-05-12', '', '35600527086', '39501', 'diagnosis', 'diagnosis', '4400.00', '0', '0.00', '4400.00', '1250.00', 'Flat', '3200.00', '3200.00', '50.00', '0.00', '3200.00', '2021-05-12', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('233', '2021-05-12', '', '77327722807', '54442', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-05-12', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('239', '2021-05-12', '', '20368489498', '63420', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-12', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('240', '2021-05-12', '', '97379599511', '54070', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '350.00', 'Flat', '1600.00', '1600.00', '50.00', '0.00', '1600.00', '2021-05-12', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('241', '2021-05-12', '', '40531714012', '46291', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2900.00', '650.00', 'Flat', '2300.00', '2300.00', '50.00', '0.00', '2300.00', '2021-05-12', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('242', '2021-05-16', '', '66922371048', '20448', 'diagnosis', 'diagnosis', '4850.00', '0', '0.00', '4850.00', '1400.00', 'Flat', '3500.00', '3500.00', '50.00', '0.00', '3500.00', '2021-05-16', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('243', '2021-05-16', '', '47928845385', '89737', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '300.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-05-16', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('244', '2021-05-16', '', '44014045306', '54550', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2900.00', '350.00', 'Flat', '2600.00', '2600.00', '50.00', '0.00', '2600.00', '2021-05-16', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('245', '2021-05-16', '', '57105186209', '68073', 'diagnosis', 'diagnosis', '3850.00', '0', '0.00', '3850.00', '500.00', 'Flat', '3350.00', '3400.00', '50.00', '0.00', '2500.00', '2021-05-16', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('247', '2021-05-16', '', '15983548967', '77250', 'diagnosis', 'diagnosis', '4600.00', '0', '0.00', '4600.00', '150.00', 'Flat', '4500.00', '4500.00', '50.00', '0.00', '4500.00', '2021-05-16', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('248', '2021-05-16', '', '86870919333', '13235', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '400.00', 'Flat', '1700.00', '1700.00', '50.00', '0.00', '1700.00', '2021-05-16', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('249', '2021-05-16', '', '96818960375', '94901', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1500.00', '1500.00', '150.00', '0.00', '1500.00', '2021-05-16', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('250', '2021-05-16', '', '62324041624', '28951', 'diagnosis', 'diagnosis', '3450.00', '0', '0.00', '3450.00', '200.00', 'Flat', '3300.00', '3300.00', '50.00', '0.00', '3300.00', '2021-05-16', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('251', '2021-05-16', '', '39700546819', '37551', 'diagnosis', 'diagnosis', '3150.00', '0', '0.00', '3150.00', '900.00', 'Flat', '2250.00', '2300.00', '50.00', '0.00', '1500.00', '2021-05-16', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('252', '2021-05-16', '', '30947634701', '47130', 'diagnosis', 'diagnosis', '4200.00', '0', '0.00', '4200.00', '2050.00', 'Flat', '2150.00', '2200.00', '50.00', '0.00', '1000.00', '2021-05-16', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('253', '2021-05-16', '', '64586847937', '15821', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '1100.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-16', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('254', '2021-05-16', '', '63747958714', '71844', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '300.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-16', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('257', '2021-05-17', '', '37071985792', '13740', 'diagnosis', 'diagnosis', '2850.00', '0', '0.00', '2850.00', '0.00', 'Flat', '2850.00', '2900.00', '50.00', '0.00', '2500.00', '2021-05-17', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('258', '2021-05-17', '', '30554591450', '37939', 'diagnosis', 'diagnosis', '3750.00', '0', '0.00', '3750.00', '300.00', 'Flat', '3450.00', '3500.00', '50.00', '0.00', '3000.00', '2021-05-17', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('259', '2021-05-17', '', '13511226077', '15896', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '400.00', 'Flat', '1650.00', '1650.00', '50.00', '0.00', '1650.00', '2021-05-17', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('260', '2021-05-17', '', '99113019762', '28489', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '400.00', 'Flat', '1100.00', '1100.00', '50.00', '0.00', '1100.00', '2021-05-17', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('261', '2021-05-17', '', '98334892756', '56309', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '500.00', 'Flat', '1550.00', '1600.00', '50.00', '0.00', '1000.00', '2021-05-17', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('262', '2021-05-17', '', '68046452932', '87537', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2900.00', '200.00', 'Flat', '2750.00', '2750.00', '50.00', '0.00', '2750.00', '2021-05-17', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('263', '2021-05-17', '', '75136100169', '69099', 'diagnosis', 'diagnosis', '3700.00', '0', '0.00', '3700.00', '0.00', 'Flat', '3750.00', '1500.00', '50.00', '2250.00', '1500.00', '2021-05-17', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('264', '2021-05-17', '', '99686087378', '17844', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-05-17', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('265', '2021-05-17', '', '23583306868', '62965', 'diagnosis', 'diagnosis', '4050.00', '0', '0.00', '4050.00', '0.00', 'Flat', '4050.00', '2500.00', '50.00', '1600.00', '500.00', '2021-05-17', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('266', '2021-05-17', '', '24596972266', '15460', 'diagnosis', 'diagnosis', '3550.00', '0', '0.00', '3550.00', '0.00', 'Flat', '3600.00', '1000.00', '50.00', '2600.00', '1000.00', '2021-05-17', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('267', '2021-05-17', '', '22819688253', '53543', 'diagnosis', 'diagnosis', '3800.00', '0', '0.00', '3800.00', '850.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-05-17', 'pending', '', '8', 'Dr.Md.Sultan Ahamed', 'diagnosis', '08:21'), 
('268', '2021-05-17', '', '44581573704', '52496', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '250.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-17', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('269', '2021-05-17', '', '52317621765', '78159', 'diagnosis', 'diagnosis', '4050.00', '0', '0.00', '4050.00', '300.00', 'Flat', '3800.00', '3800.00', '50.00', '0.00', '3800.00', '2021-05-17', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('270', '2021-05-17', '', '43323203217', '37901', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '550.00', '550.00', '50.00', '0.00', '550.00', '2021-05-17', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('271', '2021-05-17', '', '73185528607', '41432', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '450.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-17', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('274', '2021-05-17', '', '49884826441', '71298', 'diagnosis', 'diagnosis', '3800.00', '0', '0.00', '3800.00', '1350.00', 'Flat', '2450.00', '2500.00', '50.00', '0.00', '2000.00', '2021-05-17', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('275', '2021-05-17', '', '72206713341', '28475', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '275.00', 'Flat', '825.00', '825.00', '50.00', '0.00', '825.00', '2021-05-17', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('276', '2021-05-17', '', '85330901708', '22785', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '300.00', 'Flat', '900.00', '900.00', '50.00', '0.00', '900.00', '2021-05-17', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('277', '2021-05-17', '', '76317975504', '85023', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '600.00', 'Flat', '350.00', '350.00', '50.00', '0.00', '350.00', '2021-05-17', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('278', '2021-05-17', '', '68914815452', '14129', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2950.00', '1100.00', 'Flat', '1900.00', '1900.00', '50.00', '0.00', '1900.00', '2021-05-17', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('279', '2021-05-17', '', '11654027261', '30571', 'diagnosis', 'diagnosis', '1030.00', '0', '0.00', '1030.00', '80.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-17', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('281', '2021-05-17', '', '22507987419', '48858', 'diagnosis', 'diagnosis', '4650.00', '0', '0.00', '4650.00', '700.00', 'Flat', '4000.00', '4000.00', '50.00', '0.00', '4000.00', '2021-05-17', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('282', '2021-05-17', '', '27454401718', '59824', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '50.00', 'Flat', '1400.00', '1400.00', '50.00', '0.00', '1400.00', '2021-05-17', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('283', '2021-05-17', '', '40619708680', '73114', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '250.00', 'Flat', '1300.00', '1300.00', '50.00', '0.00', '1300.00', '2021-05-17', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('284', '2021-05-18', '', '47027041887', '76754', 'diagnosis', 'diagnosis', '5100.00', '0', '0.00', '5100.00', '0.00', 'Flat', '5150.00', '2500.00', '50.00', '2650.00', '2500.00', '2021-05-18', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('285', '2021-05-18', '', '78384478017', '87053', 'diagnosis', 'diagnosis', '4700.00', '0', '0.00', '4700.00', '0.00', 'Flat', '4750.00', '2000.00', '50.00', '2750.00', '2000.00', '2021-05-18', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('286', '2021-05-18', '', '35160377580', '36967', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '250.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-05-18', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('287', '2021-05-18', '', '60453951772', '63930', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-05-18', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('288', '2021-05-18', '', '26208728634', '22023', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '400.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-05-18', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('289', '2021-05-18', '', '96179966131', '69334', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '400.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-05-18', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('290', '2021-05-18', '', '33945947968', '25217', 'diagnosis', 'diagnosis', '3150.00', '0', '0.00', '3150.00', '0.00', 'Flat', '3200.00', '3200.00', '50.00', '0.00', '3200.00', '2021-05-18', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('292', '2021-05-18', '', '60026021094', '85742', 'diagnosis', 'diagnosis', '4050.00', '0', '0.00', '4050.00', '100.00', 'Flat', '4000.00', '4000.00', '50.00', '0.00', '4000.00', '2021-05-18', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('293', '2021-05-18', '', '14627472062', '85392', 'diagnosis', 'diagnosis', '3700.00', '0', '0.00', '3700.00', '1450.00', 'Flat', '2300.00', '2300.00', '50.00', '0.00', '2300.00', '2021-05-18', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('294', '2021-05-18', '', '62004807218', '36201', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '400.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-05-18', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('295', '2021-05-18', '', '68253738267', '19633', 'diagnosis', 'diagnosis', '2850.00', '0', '0.00', '2850.00', '0.00', 'Flat', '2900.00', '2000.00', '50.00', '900.00', '2000.00', '2021-05-18', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('296', '2021-05-18', '', '66041708820', '58317', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1250.00', '1250.00', '50.00', '0.00', '1250.00', '2021-05-18', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('297', '2021-05-18', '', '29924484673', '84156', 'diagnosis', 'diagnosis', '3700.00', '0', '0.00', '3700.00', '250.00', 'Flat', '3500.00', '3500.00', '50.00', '0.00', '3500.00', '2021-05-18', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('299', '2021-05-18', '', '88744228126', '37073', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '250.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-18', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('300', '2021-05-18', '', '38242293149', '34991', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '300.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-05-18', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('301', '2021-05-18', '', '65249471945', '71319', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-05-18', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('302', '2021-05-18', '', '94095764019', '28365', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '500.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-18', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('303', '2021-05-18', '', '52206950344', '37853', 'diagnosis', 'diagnosis', '3350.00', '0', '0.00', '3350.00', '1400.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-18', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('304', '2021-05-18', '', '96247565084', '98072', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '800.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-18', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('305', '2021-05-18', '', '29792898727', '70076', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-18', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('306', '2021-05-19', '', '62709787612', '35733', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-05-19', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('308', '2021-05-19', '', '97078676563', '76302', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2900.00', '950.00', 'Flat', '2000.00', '200.00', '50.00', '1800.00', '200.00', '2021-05-19', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('309', '2021-05-19', '', '63721247265', '98696', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '500.00', 'Flat', '1950.00', '2000.00', '50.00', '0.00', '1000.00', '2021-05-19', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('310', '2021-05-19', '', '29191284999', '34874', 'diagnosis', 'diagnosis', '2700.00', '0', '0.00', '2700.00', '0.00', 'Flat', '2750.00', '1000.00', '50.00', '1750.00', '1000.00', '2021-05-19', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('312', '2021-05-19', '', '86960325100', '47103', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '100.00', '0.00', '200.00', '100.00', '2021-05-19', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('313', '2021-05-19', '', '18180341480', '87464', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-05-19', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('314', '2021-05-19', '', '86356017531', '55532', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-19', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('315', '2021-05-19', '', '94222298057', '47966', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '0.00', 'Flat', '2200.00', '500.00', '0.00', '1700.00', '500.00', '2021-05-19', 'pending', '', '4', 'DR.MD.SONAULLAH MONDAL MBBS(DHAKA)BCS9H)MS. MMCH', 'diagnosis', '08:21'), 
('316', '2021-05-19', '', '82474592659', '53965', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '500.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-05-19', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('317', '2021-05-19', '', '30277613715', '60291', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '0.00', 'Flat', '1700.00', '1700.00', '50.00', '0.00', '1700.00', '2021-05-19', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('320', '2021-05-19', '', '95138494090', '77850', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', 'Flat', '0.00', '400.00', '0.00', '-400.00', '400.00', '2021-05-19', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('321', '2021-05-19', '', '65554235875', '34085', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-19', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('322', '2021-05-19', '', '95429276716', '95326', 'diagnosis', 'diagnosis', '3750.00', '0', '0.00', '3750.00', '0.00', 'Flat', '3750.00', '1000.00', '50.00', '2800.00', '1000.00', '2021-05-19', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('325', '2021-05-19', '05:06:12 PM', '31271161180', '18111', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '0.00', 'Flat', '2400.00', '2400.00', '0.00', '0.00', '2400.00', '2021-05-19', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('326', '2021-05-19', '05:24:45 PM', '69574641436', '31081', 'diagnosis', 'diagnosis', '2850.00', '0', '0.00', '2850.00', '1300.00', 'Flat', '1550.00', '1500.00', '50.00', '100.00', '1500.00', '2021-05-19', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('328', '2021-05-19', '06:01:50 PM', '53993716132', '46818', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-05-19', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('329', '2021-05-19', '06:05:58 PM', '54219624234', '77296', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '500.00', '0.00', '300.00', '500.00', '2021-05-19', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('330', '2021-05-19', '06:08:45 PM', '20545114866', '93507', 'diagnosis', 'diagnosis', '3600.00', '0', '0.00', '3550.00', '1600.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-19', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('332', '2021-05-19', '06:11:40 PM', '68686776484', '43255', 'diagnosis', 'diagnosis', '3850.00', '0', '0.00', '3800.00', '1850.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-19', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('334', '2021-05-19', '06:17:49 PM', '63068291544', '19284', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-19', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('335', '2021-05-19', '06:37:05 PM', '53164983582', '74822', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '850.00', '450.00', 'Flat', '450.00', '450.00', '50.00', '0.00', '450.00', '2021-05-19', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('336', '2021-05-19', '07:33:53 PM', '77314081456', '72920', 'diagnosis', 'diagnosis', '3550.00', '0', '0.00', '3500.00', '0.00', 'Flat', '3550.00', '1000.00', '50.00', '2550.00', '1000.00', '2021-05-19', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('338', '2021-05-20', '10:19:58 AM', '33624182061', '72686', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-20', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('339', '2021-05-20', '10:21:22 AM', '21048510736', '18263', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-20', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('340', '2021-05-20', '10:21:55 AM', '94969745559', '54120', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-20', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('341', '2021-05-20', '11:41:47 AM', '47531637839', '78645', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1050.00', '600.00', 'Flat', '500.00', '500.00', '50.00', '0.00', '500.00', '2021-05-20', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('342', '2021-05-20', '12:25:15 PM', '58591938018', '66813', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2050.00', '900.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-05-20', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('343', '2021-05-20', '12:35:06 PM', '18006437727', '13276', 'diagnosis', 'diagnosis', '3750.00', '0', '0.00', '3700.00', '0.00', 'Flat', '3750.00', '1500.00', '50.00', '2250.00', '1500.00', '2021-05-20', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('344', '2021-05-20', '12:39:36 PM', '15379231298', '28562', 'diagnosis', 'diagnosis', '4850.00', '0', '0.00', '4800.00', '0.00', 'Flat', '4850.00', '3000.00', '50.00', '1850.00', '3000.00', '2021-05-20', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('346', '2021-05-20', '01:32:44 PM', '92900854390', '36861', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-20', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('347', '2021-05-20', '02:03:02 PM', '16765041773', '21900', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1300.00', '150.00', 'Flat', '1200.00', '400.00', '50.00', '800.00', '400.00', '2021-05-20', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('348', '2021-05-20', '02:08:25 PM', '28239060855', '98039', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1200.00', '250.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-20', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('349', '2021-05-20', '02:22:59 PM', '83815735619', '91230', 'diagnosis', 'diagnosis', '2550.00', '0', '0.00', '2500.00', '550.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-20', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('350', '2021-05-20', '02:50:22 PM', '50498849070', '52459', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1150.00', '200.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-20', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('351', '2021-05-20', '03:06:38 PM', '59144408007', '68524', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '500.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-05-20', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('353', '2021-05-20', '03:44:15 PM', '12476236041', '65826', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-20', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('354', '2021-05-20', '03:45:49 PM', '56266833096', '23337', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-20', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('355', '2021-05-20', '04:01:03 PM', '30597435351', '86266', 'diagnosis', 'diagnosis', '3250.00', '0', '0.00', '3250.00', '250.00', 'Flat', '3000.00', '3000.00', '0.00', '0.00', '3000.00', '2021-05-20', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('356', '2021-05-20', '04:04:10 PM', '86955995154', '55788', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1900.00', '950.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-20', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('357', '2021-05-20', '04:07:07 PM', '97734863931', '15110', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2050.00', '0.00', 'Flat', '2100.00', '800.00', '50.00', '1300.00', '800.00', '2021-05-20', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('358', '2021-05-20', '04:19:59 PM', '71557982390', '19495', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-20', 'pending', '', '4', 'DR.MD.OMAR FARUQUE MIAH MBBS(DHAKA)BCS(H)MD(NEPHROLOGY)ASSI.PRO.MMCH', 'diagnosis', '08:21'), 
('359', '2021-05-20', '05:18:24 PM', '16226421834', '89595', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-20', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('360', '2021-05-20', '05:28:58 PM', '17916279410', '66626', 'diagnosis', 'diagnosis', '3650.00', '0', '0.00', '3600.00', '0.00', 'Flat', '3650.00', '2500.00', '50.00', '1150.00', '2500.00', '2021-05-20', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('361', '2021-05-20', '05:40:28 PM', '45079492239', '19770', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-20', 'pending', '', '4', 'DR.R.C.DEBNATH MBBS.DTCD.FCPS.ASSI.PRO.MMCH', 'diagnosis', '08:21'), 
('363', '2021-05-20', '05:55:32 PM', '86914768608', '74853', 'diagnosis', 'diagnosis', '3450.00', '0', '0.00', '3400.00', '450.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-05-20', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('364', '2021-05-20', '06:03:56 PM', '54168228432', '80875', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-05-20', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('365', '2021-05-20', '06:06:08 PM', '67392428467', '56056', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-05-20', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('366', '2021-05-20', '07:40:15 PM', '73112472850', '28135', 'diagnosis', 'diagnosis', '4200.00', '0', '0.00', '4150.00', '1200.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-05-20', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('367', '2021-05-20', '08:31:15 PM', '22868742835', '21017', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2250.00', '400.00', 'Flat', '1900.00', '1900.00', '50.00', '0.00', '1900.00', '2021-05-20', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('368', '2021-05-21', '11:46:46 AM', '44669234711', '97116', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-05-21', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('369', '2021-05-21', '12:47:05 PM', '57935419388', '61190', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '750.00', '400.00', 'Flat', '400.00', '400.00', '50.00', '0.00', '400.00', '2021-05-21', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('371', '2021-05-21', '12:49:38 PM', '13908538429', '93344', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1100.00', '0.00', '50.00', '1100.00', '0.00', '2021-05-21', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('372', '2021-05-21', '01:20:42 PM', '26705823383', '93811', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-05-21', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('373', '2021-05-21', '01:57:06 PM', '91263288300', '80497', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1100.00', '0.00', '50.00', '1100.00', '0.00', '2021-05-21', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('374', '2021-05-21', '02:14:23 PM', '23809064469', '32591', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-05-21', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('375', '2021-05-21', '02:14:56 PM', '61151384603', '11887', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-05-21', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('376', '2021-05-21', '03:55:46 PM', '33109729736', '35640', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-05-21', 'pending', '', '4', 'DR.ARIFL BASHER FCPS.9MED)MMCH', 'diagnosis', '08:21'), 
('377', '2021-05-21', '03:57:57 PM', '63210073361', '70308', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-21', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('378', '2021-05-21', '04:11:12 PM', '55352534436', '78690', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-05-21', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('379', '2021-05-21', '04:46:01 PM', '85684742074', '80049', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1900.00', '950.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-21', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('380', '2021-05-21', '05:37:42 PM', '13244618061', '44014', 'diagnosis', 'diagnosis', '3650.00', '0', '0.00', '3600.00', '950.00', 'Flat', '2700.00', '2700.00', '50.00', '0.00', '2700.00', '2021-05-21', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('381', '2021-05-21', '06:40:47 PM', '61431832073', '34394', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2050.00', '500.00', 'Flat', '1600.00', '1600.00', '50.00', '0.00', '1600.00', '2021-05-21', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('382', '2021-05-21', '07:35:05 PM', '42564403265', '27831', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-05-21', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('383', '2021-05-21', '07:51:40 PM', '23071826083', '87211', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '600.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-21', 'pending', '', '4', 'CT HOSPITAL(PVT)', 'diagnosis', '08:21'), 
('384', '2021-05-21', '08:04:57 PM', '55893320424', '92437', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '900.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-05-21', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('385', '2021-05-21', '08:06:48 PM', '57628494211', '41460', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-21', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('386', '2021-05-21', '08:07:38 PM', '42985149224', '63185', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-21', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('387', '2021-05-22', '10:25:01 AM', '49486937622', '85217', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '600.00', 'Flat', '400.00', '450.00', '50.00', '0.00', '450.00', '2021-05-22', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('388', '2021-05-22', '10:31:35 AM', '57740158049', '48982', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1200.00', '50.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-05-22', 'pending', '', '8', 'MMCH', 'diagnosis', '08:21'), 
('391', '2021-05-22', '10:43:41 AM', '81629995049', '61170', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2450.00', '0.00', 'Flat', '2500.00', '2500.00', '50.00', '0.00', '2500.00', '2021-05-22', 'pending', '', '8', 'Dr.Md. Al-Ujjol  BUMS (DU) DMDS,DMF,MLOP CHW. PDT (Gynecology)', 'diagnosis', '08:21'), 
('393', '2021-05-22', '11:52:11 AM', '24850709777', '17161', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1000.00', '750.00', 'Flat', '300.00', '300.00', '50.00', '0.00', '300.00', '2021-05-22', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('394', '2021-05-22', '01:11:12 PM', '82302872505', '78456', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '400.00', '0.00', 'Flat', '450.00', '200.00', '50.00', '250.00', '200.00', '2021-05-22', 'pending', '', '8', 'MMCH', 'diagnosis', '08:21'), 
('396', '2021-05-22', '02:05:57 PM', '56867360075', '82613', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '800.00', '0.00', 'Flat', '850.00', '850.00', '50.00', '0.00', '850.00', '2021-05-22', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('397', '2021-05-22', '02:17:13 PM', '91302147590', '49594', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1000.00', '450.00', 'Flat', '600.00', '600.00', '50.00', '0.00', '600.00', '2021-05-22', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('399', '2021-05-22', '02:42:33 PM', '35742554192', '75859', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1450.00', '450.00', 'Flat', '1050.00', '1050.00', '50.00', '0.00', '1050.00', '2021-05-22', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('400', '2021-05-22', '02:56:28 PM', '60517010630', '76006', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '800.00', '0.00', '700.00', '800.00', '2021-05-22', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('401', '2021-05-22', '03:13:02 PM', '67192620577', '72953', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '600.00', '0.00', '200.00', '600.00', '2021-05-22', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('402', '2021-05-22', '03:13:55 PM', '32905634202', '12405', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-22', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('403', '2021-05-22', '03:35:28 PM', '60261299792', '17959', 'diagnosis', 'diagnosis', '4600.00', '0', '0.00', '4550.00', '0.00', 'Flat', '4600.00', '0.00', '50.00', '4600.00', '0.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('404', '2021-05-22', '03:39:11 PM', '44823117264', '17162', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2400.00', '50.00', 'Flat', '2400.00', '2400.00', '50.00', '0.00', '2400.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('405', '2021-05-22', '03:43:50 PM', '17592250679', '37165', 'diagnosis', 'diagnosis', '4200.00', '0', '0.00', '4150.00', '0.00', 'Flat', '4200.00', '500.00', '50.00', '3700.00', '500.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('406', '2021-05-22', '03:45:50 PM', '69851348424', '58739', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1250.00', '100.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('408', '2021-05-22', '03:50:17 PM', '12136763168', '96444', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('409', '2021-05-22', '03:53:09 PM', '41145260259', '88120', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '500.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('410', '2021-05-22', '03:59:28 PM', '34608962303', '66577', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2900.00', '50.00', 'Flat', '2900.00', '2900.00', '50.00', '0.00', '2900.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('411', '2021-05-22', '04:12:12 PM', '32537662486', '85643', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('413', '2021-05-22', '04:14:48 PM', '88329870253', '28593', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1900.00', '250.00', 'Flat', '1700.00', '1700.00', '50.00', '0.00', '1700.00', '2021-05-22', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('416', '2021-05-22', '04:30:59 PM', '83060547254', '48465', 'diagnosis', 'diagnosis', '3700.00', '0', '0.00', '3650.00', '1200.00', 'Flat', '2500.00', '2500.00', '50.00', '0.00', '2500.00', '2021-05-22', 'pending', '', '4', 'PRO.DR.HAJJI MOHD.ABUL MANSUR MBBS. FCPS.(BCPS)DFL(BSMMU)', 'diagnosis', '08:21'), 
('417', '2021-05-22', '04:33:57 PM', '20907593063', '24339', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2450.00', '1000.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('418', '2021-05-22', '04:46:45 PM', '69035630631', '88628', 'diagnosis', 'diagnosis', '3350.00', '0', '0.00', '3300.00', '0.00', 'Flat', '3350.00', '3350.00', '50.00', '0.00', '3350.00', '2021-05-22', 'pending', '', '4', 'DR.MD.SHAFIQUR RAHMAN MBBS,FCPS(SUR)MMCH', 'diagnosis', '08:21'), 
('419', '2021-05-22', '04:57:58 PM', '25341602373', '15143', 'diagnosis', 'diagnosis', '3250.00', '0', '0.00', '3200.00', '250.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('420', '2021-05-22', '05:16:12 PM', '59751308419', '31448', 'diagnosis', 'diagnosis', '3200.00', '0', '0.00', '3150.00', '0.00', 'Flat', '3200.00', '3200.00', '50.00', '0.00', '3200.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('421', '2021-05-22', '05:25:57 PM', '35910261215', '92858', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2100.00', '650.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('422', '2021-05-22', '05:36:24 PM', '22570929096', '25895', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2450.00', '500.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('423', '2021-05-22', '06:04:05 PM', '84799256920', '12432', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '550.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('424', '2021-05-22', '06:19:20 PM', '95732078038', '15621', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '500.00', '0.00', '1000.00', '500.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('425', '2021-05-22', '06:32:59 PM', '17663290227', '49623', 'diagnosis', 'diagnosis', '3900.00', '0', '0.00', '3850.00', '900.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('426', '2021-05-22', '07:28:36 PM', '69591076382', '21752', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('427', '2021-05-22', '07:33:18 PM', '83520501520', '41561', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '1950.00', '100.00', 'Flat', '1900.00', '1900.00', '50.00', '0.00', '1900.00', '2021-05-22', 'pending', '', '4', 'DR.DELUARA PAVEEN(DOLLY)MBBS.(DHAKA)MCPS(GYNEE&OBS)BCS(H)', 'diagnosis', '08:21'), 
('428', '2021-05-22', '07:43:20 PM', '25239381235', '56394', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-05-22', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('429', '2021-05-23', '10:58:04 AM', '88299762871', '87225', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '650.00', '325.00', 'Flat', '375.00', '375.00', '50.00', '0.00', '375.00', '2021-05-23', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('431', '2021-05-23', '11:40:08 AM', '58341898230', '88171', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '250.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-05-23', 'pending', '', '8', 'MMCH', 'diagnosis', '08:21'), 
('432', '2021-05-23', '12:11:52 PM', '37907493528', '99867', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-05-23', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('433', '2021-05-23', '12:17:50 PM', '40949727718', '26538', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '400.00', '0.00', '600.00', '0.00', '2021-05-23', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('435', '2021-05-23', '12:55:23 PM', '71405922455', '48572', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '950.00', '0.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-23', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('437', '2021-05-23', '02:33:32 PM', '46926022859', '30360', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '300.00', '0.00', '100.00', '300.00', '2021-05-23', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('438', '2021-05-23', '02:35:17 PM', '15067749884', '73847', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '200.00', '0.00', '200.00', '200.00', '2021-05-23', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('439', '2021-05-23', '02:57:57 PM', '95403964072', '99942', 'diagnosis', 'diagnosis', '2750.00', '0', '0.00', '2700.00', '50.00', 'Flat', '2700.00', '2700.00', '50.00', '0.00', '2700.00', '2021-05-23', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('441', '2021-05-23', '03:08:24 PM', '65709633669', '39553', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-05-23', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('442', '2021-05-23', '03:55:49 PM', '42032445884', '20305', 'diagnosis', 'diagnosis', '4100.00', '0', '0.00', '4050.00', '0.00', 'Flat', '4100.00', '2000.00', '50.00', '2100.00', '2000.00', '2021-05-23', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('443', '2021-05-23', '03:59:39 PM', '17993038313', '32344', 'diagnosis', 'diagnosis', '3900.00', '0', '0.00', '3850.00', '0.00', 'Flat', '3900.00', '1000.00', '50.00', '2900.00', '1000.00', '2021-05-23', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('444', '2021-05-23', '04:02:45 PM', '92177302390', '59074', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-23', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('445', '2021-05-23', '04:13:06 PM', '64844054728', '68690', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-05-23', 'pending', '', '4', 'DR.MOHAMMAD DELWAR JAHAN KHAN MBBS.BCS(H)DTCD MMCH', 'diagnosis', '08:21'), 
('447', '2021-05-23', '04:33:46 PM', '70962616263', '65266', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-23', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('448', '2021-05-23', '04:38:40 PM', '90170025080', '99236', 'diagnosis', 'diagnosis', '5950.00', '0', '0.00', '5900.00', '0.00', 'Flat', '5950.00', '3000.00', '50.00', '2950.00', '3000.00', '2021-05-23', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('449', '2021-05-23', '04:59:30 PM', '83954851660', '14412', 'diagnosis', 'diagnosis', '3300.00', '0', '0.00', '3250.00', '1000.00', 'Flat', '2300.00', '2300.00', '50.00', '0.00', '2300.00', '2021-05-23', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('450', '2021-05-23', '05:11:01 PM', '48797452656', '54422', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '200.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-05-23', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('451', '2021-05-23', '05:41:30 PM', '40404222408', '53002', 'diagnosis', 'diagnosis', '3850.00', '0', '0.00', '3800.00', '0.00', 'Flat', '3850.00', '2500.00', '50.00', '1350.00', '2500.00', '2021-05-23', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('452', '2021-05-23', '05:49:08 PM', '62158805463', '22204', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2150.00', '700.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-23', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('453', '2021-05-23', '06:19:41 PM', '12510642657', '47452', 'diagnosis', 'diagnosis', '5000.00', '0', '0.00', '4950.00', '0.00', 'Flat', '5000.00', '1000.00', '50.00', '4000.00', '1000.00', '2021-05-23', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('454', '2021-05-23', '06:50:27 PM', '44595107104', '34915', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '800.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-23', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('455', '2021-05-23', '07:26:29 PM', '87329633161', '14284', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '850.00', '200.00', 'Flat', '700.00', '700.00', '50.00', '0.00', '700.00', '2021-05-23', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('456', '2021-05-23', '08:06:48 PM', '71369768472', '86967', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2350.00', '800.00', 'Flat', '1600.00', '1000.00', '50.00', '600.00', '1000.00', '2021-05-23', 'pending', '', '4', 'DR.MOHAMMAD IMRUL HASAN (ROBI)ASSI.PRO.MBBS.FCPS(MED)', 'diagnosis', '08:21'), 
('457', '2021-05-23', '09:40:53 PM', '57195524871', '93978', 'diagnosis', 'diagnosis', '7700.00', '0', '0.00', '7650.00', '0.00', 'Flat', '7700.00', '1000.00', '50.00', '6700.00', '1000.00', '2021-05-23', 'pending', '', '4', 'DR.POLASH KUMAR CHANDRA MBBS.BCS(H)MMCH', 'diagnosis', '08:21'), 
('458', '2021-05-24', '10:02:05 AM', '89623762791', '53899', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2050.00', '600.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-24', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('459', '2021-05-24', '10:03:32 AM', '56174824386', '90516', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1450.00', '0.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-24', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('460', '2021-05-24', '10:12:12 AM', '63395167349', '23313', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-05-24', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('461', '2021-05-24', '11:31:33 AM', '25791961120', '82494', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '110.00', 'Flat', '40.00', '40.00', '0.00', '0.00', '40.00', '2021-05-24', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('462', '2021-05-24', '01:56:05 PM', '27539407420', '17727', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '200.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-05-24', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('463', '2021-05-24', '02:26:36 PM', '41689322019', '82018', 'diagnosis', 'diagnosis', '4550.00', '0', '0.00', '4500.00', '0.00', 'Flat', '4550.00', '4000.00', '50.00', '550.00', '4000.00', '2021-05-24', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('464', '2021-05-24', '02:39:52 PM', '75362726383', '33186', 'diagnosis', 'diagnosis', '5300.00', '0', '0.00', '5250.00', '0.00', 'Flat', '5300.00', '3000.00', '50.00', '2300.00', '3000.00', '2021-05-24', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('465', '2021-05-24', '03:02:28 PM', '60671584639', '29240', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1450.00', '0.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-24', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('466', '2021-05-24', '03:10:43 PM', '34206749498', '44420', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '700.00', '0.00', '300.00', '700.00', '2021-05-24', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('467', '2021-05-24', '04:05:58 PM', '95658912675', '84626', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1250.00', '500.00', '50.00', '750.00', '500.00', '2021-05-24', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('468', '2021-05-24', '04:37:53 PM', '92806308261', '64639', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '500.00', '0.00', '700.00', '500.00', '2021-05-24', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('469', '2021-05-24', '04:40:50 PM', '80959128257', '92117', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1050.00', '100.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-24', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('470', '2021-05-24', '04:55:41 PM', '87485356918', '71318', 'diagnosis', 'diagnosis', '3300.00', '0', '0.00', '3250.00', '0.00', 'Flat', '3300.00', '3000.00', '50.00', '300.00', '3000.00', '2021-05-24', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('471', '2021-05-24', '06:04:49 PM', '22821008662', '62263', 'diagnosis', 'diagnosis', '3650.00', '0', '0.00', '3600.00', '0.00', 'Flat', '3650.00', '1000.00', '50.00', '2650.00', '1000.00', '2021-05-24', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('472', '2021-05-24', '06:31:12 PM', '14387123286', '29229', 'diagnosis', 'diagnosis', '5700.00', '0', '0.00', '5650.00', '0.00', 'Flat', '5700.00', '2000.00', '50.00', '3700.00', '2000.00', '2021-05-24', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('473', '2021-05-24', '06:54:28 PM', '31755799344', '51570', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '500.00', '0.00', '1000.00', '500.00', '2021-05-24', 'pending', '', '4', 'DR.MOHAMMAD RUHUL AMIN(RAFIN) MBBS.(MMCH)FCPS(MED)MMCH', 'diagnosis', '08:21'), 
('474', '2021-05-24', '06:59:18 PM', '92148612191', '86041', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-24', 'pending', '', '4', 'DR.MD.SAKHAWAT HOSSAIN MBBS(DHAKA)BCS(H)MS(SUR)', 'diagnosis', '08:21'), 
('475', '2021-05-24', '07:34:38 PM', '52691001320', '52304', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-05-24', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('476', '2021-05-24', '08:00:49 PM', '47195156787', '36145', 'diagnosis', 'diagnosis', '3800.00', '0', '0.00', '3750.00', '0.00', 'Flat', '3800.00', '800.00', '50.00', '3000.00', '800.00', '2021-05-24', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('477', '2021-05-24', '08:33:04 PM', '53131277196', '57983', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-05-24', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('478', '2021-05-25', '10:30:40 AM', '88418560309', '82980', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1250.00', '700.00', 'Flat', '600.00', '600.00', '50.00', '0.00', '600.00', '2021-05-25', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('479', '2021-05-25', '10:40:50 AM', '85006057098', '61999', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1000.00', '550.00', 'Flat', '500.00', '500.00', '50.00', '0.00', '500.00', '2021-05-25', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('480', '2021-05-25', '10:42:24 AM', '55098222899', '71845', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2050.00', '200.00', 'Flat', '1900.00', '1000.00', '50.00', '900.00', '1000.00', '2021-05-25', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('481', '2021-05-25', '11:21:00 AM', '17772661687', '98409', 'diagnosis', 'diagnosis', '2650.00', '0', '0.00', '2600.00', '0.00', 'Flat', '2650.00', '1000.00', '50.00', '1650.00', '1000.00', '2021-05-25', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('482', '2021-05-25', '11:51:35 AM', '81844293574', '18572', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-25', 'pending', '', '8', 'Sristy Hospital', 'diagnosis', '08:21'), 
('483', '2021-05-25', '12:40:17 PM', '64410507430', '80029', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '110.00', 'Flat', '40.00', '40.00', '0.00', '0.00', '40.00', '2021-05-25', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('484', '2021-05-25', '01:36:30 PM', '40541379815', '37589', 'diagnosis', 'diagnosis', '4600.00', '0', '0.00', '4550.00', '0.00', 'Flat', '4600.00', '4500.00', '50.00', '100.00', '4500.00', '2021-05-25', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('485', '2021-05-25', '01:38:53 PM', '84609914860', '65178', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1750.00', '700.00', 'Flat', '1100.00', '1000.00', '50.00', '100.00', '1000.00', '2021-05-25', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('486', '2021-05-25', '01:55:24 PM', '30322038630', '97080', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-25', 'pending', '', '8', 'Dr.Khelek Hasan', 'diagnosis', '08:21'), 
('487', '2021-05-25', '02:28:30 PM', '49179794059', '81318', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1050.00', '300.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-25', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('488', '2021-05-25', '02:58:52 PM', '25072407101', '18456', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '0.00', '0.00', '250.00', '0.00', '2021-05-25', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('490', '2021-05-25', '03:11:17 PM', '49630735028', '35593', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2250.00', '300.00', 'Flat', '2000.00', '500.00', '50.00', '1500.00', '500.00', '2021-05-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('491', '2021-05-25', '03:13:37 PM', '32278737632', '99159', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-25', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('492', '2021-05-25', '03:18:25 PM', '26111088693', '77080', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '0.00', '0.00', '250.00', '0.00', '2021-05-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('493', '2021-05-25', '03:39:05 PM', '44444734023', '38601', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '600.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-25', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('494', '2021-05-25', '03:41:05 PM', '40319428758', '32586', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-05-25', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('496', '2021-05-25', '03:46:43 PM', '96571483214', '87046', 'diagnosis', 'diagnosis', '3150.00', '0', '0.00', '3100.00', '650.00', 'Flat', '2500.00', '2500.00', '50.00', '0.00', '2500.00', '2021-05-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('497', '2021-05-25', '03:52:33 PM', '63828434463', '81454', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '700.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-05-25', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('499', '2021-05-25', '04:08:55 PM', '97398072025', '51871', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2350.00', '0.00', 'Flat', '2400.00', '2000.00', '50.00', '400.00', '2000.00', '2021-05-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('500', '2021-05-25', '05:32:39 PM', '55263008632', '38436', 'diagnosis', 'diagnosis', '2700.00', '0', '0.00', '2650.00', '0.00', 'Flat', '2700.00', '500.00', '50.00', '2200.00', '500.00', '2021-05-25', 'pending', '', '4', 'DR.SAMIR KUMAR DAS MBBS.(DU)BCS(H)FCPSASSI.PRO..', 'diagnosis', '08:21'), 
('501', '2021-05-25', '05:36:16 PM', '86019164282', '54445', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2350.00', '200.00', 'Flat', '2200.00', '2200.00', '50.00', '0.00', '2200.00', '2021-05-25', 'pending', '', '4', 'DR.LABIB KHAN MBBS.BCSA.MMCH', 'diagnosis', '08:21'), 
('502', '2021-05-25', '05:49:58 PM', '33738823980', '85771', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-05-25', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('503', '2021-05-25', '06:15:59 PM', '25182485745', '91336', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1400.00', '0.00', 'Flat', '1450.00', '1450.00', '50.00', '0.00', '1450.00', '2021-05-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('504', '2021-05-25', '06:51:32 PM', '80896806841', '27588', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2900.00', '750.00', 'Flat', '2200.00', '2200.00', '50.00', '0.00', '2200.00', '2021-05-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('505', '2021-05-25', '06:54:35 PM', '22486582149', '17107', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3000.00', '550.00', 'Flat', '2500.00', '2500.00', '50.00', '0.00', '2500.00', '2021-05-25', 'pending', '', '4', 'DR. SAIFUL ISLAM', 'diagnosis', '08:21'), 
('506', '2021-05-25', '06:59:53 PM', '62652331383', '39804', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1350.00', '200.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-05-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('507', '2021-05-25', '07:06:07 PM', '32558898958', '89656', 'diagnosis', 'diagnosis', '4450.00', '0', '0.00', '4400.00', '650.00', 'Flat', '3800.00', '3800.00', '50.00', '0.00', '3800.00', '2021-05-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('508', '2021-05-25', '07:08:28 PM', '46348670869', '79656', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-25', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('509', '2021-05-25', '07:09:20 PM', '68330384832', '27030', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-25', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('510', '2021-05-25', '07:10:00 PM', '95066345979', '66487', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-25', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('511', '2021-05-25', '07:13:01 PM', '37577519151', '22839', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2050.00', '700.00', 'Flat', '1400.00', '1400.00', '50.00', '0.00', '1400.00', '2021-05-25', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('512', '2021-05-25', '07:41:24 PM', '59702701121', '55889', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '400.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-05-25', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('513', '2021-05-25', '07:42:54 PM', '25199672496', '48653', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1200.00', '550.00', 'Flat', '700.00', '700.00', '50.00', '0.00', '700.00', '2021-05-25', 'pending', '', '4', 'DR.RUHUL AMIN(RAFIN)', 'diagnosis', '08:21'), 
('514', '2021-05-25', '07:43:57 PM', '15806078827', '63038', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-05-25', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('515', '2021-05-25', '07:45:48 PM', '32197016477', '16942', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1300.00', '350.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('516', '2021-05-25', '07:50:05 PM', '94576100260', '22109', 'diagnosis', 'diagnosis', '3300.00', '0', '0.00', '3250.00', '300.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-05-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('517', '2021-05-25', '08:08:26 PM', '47780742744', '87027', 'diagnosis', 'diagnosis', '5050.00', '0', '0.00', '5000.00', '550.00', 'Flat', '4500.00', '4500.00', '50.00', '0.00', '4500.00', '2021-05-25', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('518', '2021-05-25', '08:10:03 PM', '25437093981', '36232', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-05-25', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('519', '2021-05-25', '08:19:21 PM', '47814140096', '51533', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-25', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('520', '2021-05-26', '10:36:02 AM', '24288547783', '20752', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2050.00', '700.00', 'Flat', '1400.00', '1400.00', '50.00', '0.00', '1400.00', '2021-05-26', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('521', '2021-05-26', '10:40:39 AM', '13782308705', '14788', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1300.00', '350.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-26', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('522', '2021-05-26', '10:41:54 AM', '65712015951', '62378', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1450.00', '400.00', 'Flat', '1100.00', '1100.00', '50.00', '0.00', '1100.00', '2021-05-26', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('523', '2021-05-26', '10:47:29 AM', '59878894355', '37060', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '500.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-05-26', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('524', '2021-05-26', '10:49:43 AM', '70613923668', '83551', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1300.00', '550.00', 'Flat', '800.00', '0.00', '50.00', '800.00', '0.00', '2021-05-26', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('525', '2021-05-26', '11:08:56 AM', '14751534039', '42603', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-26', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('526', '2021-05-26', '11:15:00 AM', '11491027101', '69907', 'diagnosis', 'diagnosis', '4750.00', '0', '0.00', '4700.00', '2350.00', 'Flat', '2400.00', '2400.00', '50.00', '0.00', '2000.00', '2021-05-26', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('527', '2021-05-26', '11:17:25 AM', '86068088933', '52285', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-05-26', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('528', '2021-05-26', '11:18:36 AM', '78978286849', '92320', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-05-26', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('529', '2021-05-26', '11:33:37 AM', '39173835308', '60201', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-26', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('531', '2021-05-26', '02:16:38 PM', '20495134509', '99130', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1900.00', '750.00', 'Flat', '1200.00', '1000.00', '50.00', '200.00', '1000.00', '2021-05-26', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('532', '2021-05-26', '02:34:27 PM', '34840463432', '45297', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-05-26', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('533', '2021-05-26', '02:44:08 PM', '96361545183', '98467', 'diagnosis', 'diagnosis', '5200.00', '0', '0.00', '5150.00', '200.00', 'Flat', '5000.00', '5000.00', '50.00', '0.00', '5000.00', '2021-05-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('535', '2021-05-26', '02:48:45 PM', '82835113671', '25056', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1950.00', '1950.00', '50.00', '0.00', '1950.00', '2021-05-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('536', '2021-05-26', '02:51:35 PM', '68953142439', '17429', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '350.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-05-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('537', '2021-05-26', '02:52:05 PM', '97240321917', '72323', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '900.00', '250.00', 'Flat', '700.00', '700.00', '50.00', '0.00', '700.00', '2021-05-26', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('538', '2021-05-26', '03:17:10 PM', '68371368116', '12189', 'diagnosis', 'diagnosis', '4450.00', '0', '0.00', '4400.00', '450.00', 'Flat', '4000.00', '4000.00', '50.00', '0.00', '4000.00', '2021-05-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('540', '2021-05-26', '03:57:54 PM', '25937338421', '95853', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1150.00', '100.00', 'Flat', '1100.00', '1000.00', '50.00', '100.00', '1000.00', '2021-05-26', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('541', '2021-05-26', '04:03:02 PM', '88789204839', '70256', 'diagnosis', 'diagnosis', '3650.00', '0', '0.00', '3600.00', '1650.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('542', '2021-05-26', '04:05:50 PM', '89767915341', '57034', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '850.00', '300.00', 'Flat', '600.00', '600.00', '50.00', '0.00', '600.00', '2021-05-26', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('543', '2021-05-26', '04:13:19 PM', '12531651390', '90501', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-05-26', 'pending', '', '4', 'DR,MD.ASHRAFUL ALAM MBBS(DHAKA)BCS(H)MMCH', 'diagnosis', '08:21'), 
('544', '2021-05-26', '04:20:20 PM', '49307462448', '93227', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '1950.00', '1000.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('545', '2021-05-26', '04:49:06 PM', '16737460386', '18014', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1450.00', '0.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-26', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('546', '2021-05-26', '04:51:31 PM', '68423983123', '86620', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '110.00', 'Flat', '40.00', '40.00', '0.00', '0.00', '40.00', '2021-05-26', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('547', '2021-05-26', '04:59:35 PM', '99857264260', '32835', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3000.00', '850.00', 'Flat', '2200.00', '2000.00', '50.00', '200.00', '2000.00', '2021-05-26', 'pending', '', '4', 'DR.MD.SHAFIQUL RAHMAN MBBSFCPS.(SUR)', 'diagnosis', '08:21'), 
('548', '2021-05-26', '05:03:14 PM', '17218141671', '28419', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '750.00', '200.00', 'Flat', '600.00', '600.00', '50.00', '0.00', '600.00', '2021-05-26', 'pending', '', '4', 'DR.MD.SHAFIQUR RAHMAN MBBS.FCPS(SUR)MMCH', 'diagnosis', '08:21'), 
('549', '2021-05-26', '05:09:06 PM', '49541080536', '51105', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2400.00', '0.00', 'Flat', '2450.00', '2000.00', '50.00', '450.00', '2000.00', '2021-05-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('550', '2021-05-26', '05:29:02 PM', '21340905419', '80856', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-26', 'pending', '', '4', 'DR.MOHAMMAD IBRAHIM ALI MBBS.', 'diagnosis', '08:21'), 
('551', '2021-05-26', '05:32:06 PM', '70589112242', '63988', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-26', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('552', '2021-05-26', '05:34:42 PM', '56600374314', '98087', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '300.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-05-26', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('553', '2021-05-26', '05:42:09 PM', '13028170830', '32649', 'diagnosis', 'diagnosis', '4900.00', '0', '0.00', '4850.00', '1900.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-05-26', 'pending', '', '4', 'DR.MD.ABDUL MUNNAF(TUHIN)MBBS.(DMC)BCS(H)D-ORTHO(BSMMU)MMCH', 'diagnosis', '08:21'), 
('554', '2021-05-26', '05:45:48 PM', '42597905629', '28296', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1500.00', '750.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-26', 'pending', '', '4', 'DR.HAMIDA AKTER MBBS.(DHAKA)MCPS9GYNEE0DGO ASSI.PRO.MMCH', 'diagnosis', '08:21'), 
('555', '2021-05-26', '05:49:02 PM', '39726485229', '58691', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2850.00', '0.00', 'Flat', '2900.00', '1000.00', '50.00', '1900.00', '1000.00', '2021-05-26', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('557', '2021-05-26', '06:46:33 PM', '86004515488', '58379', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '110.00', 'Flat', '40.00', '40.00', '0.00', '0.00', '40.00', '2021-05-26', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('558', '2021-05-26', '07:16:42 PM', '17266224117', '60963', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-26', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('559', '2021-05-26', '07:17:32 PM', '75588727121', '70999', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-26', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('560', '2021-05-26', '07:18:32 PM', '48450424066', '51872', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-26', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('561', '2021-05-26', '08:12:02 PM', '45230788489', '56315', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-26', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('562', '2021-05-27', '12:37:51 PM', '71553162816', '80214', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2450.00', '500.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-27', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('563', '2021-05-27', '01:19:38 PM', '78091070014', '22251', 'diagnosis', 'diagnosis', '5150.00', '0', '0.00', '5100.00', '1650.00', 'Flat', '3500.00', '3500.00', '50.00', '0.00', '3500.00', '2021-05-27', 'pending', '', '8', 'MMCH', 'diagnosis', '08:21'), 
('564', '2021-05-27', '01:53:37 PM', '85304296968', '67873', 'diagnosis', 'diagnosis', '4400.00', '0', '0.00', '4350.00', '1900.00', 'Flat', '2500.00', '2000.00', '50.00', '500.00', '2000.00', '2021-05-27', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('567', '2021-05-27', '02:27:23 PM', '11305605123', '93163', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-05-27', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('568', '2021-05-27', '02:29:34 PM', '12313899604', '99685', 'diagnosis', 'diagnosis', '3300.00', '0', '0.00', '3250.00', '100.00', 'Flat', '3200.00', '3000.00', '50.00', '200.00', '3000.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('569', '2021-05-27', '02:33:31 PM', '99453486667', '54434', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-05-27', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('570', '2021-05-27', '02:48:53 PM', '72473446610', '72446', 'diagnosis', 'diagnosis', '3700.00', '0', '0.00', '3650.00', '0.00', 'Flat', '3700.00', '1000.00', '50.00', '2700.00', '1000.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('571', '2021-05-27', '03:45:27 PM', '91898128224', '85967', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-27', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('572', '2021-05-27', '03:47:26 PM', '62584610117', '11935', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('574', '2021-05-27', '03:52:11 PM', '87853190220', '75593', 'diagnosis', 'diagnosis', '3350.00', '0', '0.00', '3300.00', '0.00', 'Flat', '3350.00', '1000.00', '50.00', '2350.00', '1000.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('575', '2021-05-27', '03:59:00 PM', '21297727897', '52985', 'diagnosis', 'diagnosis', '3900.00', '0', '0.00', '3850.00', '900.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('576', '2021-05-27', '04:07:24 PM', '12415043761', '46615', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1400.00', '0.00', '50.00', '1400.00', '0.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('577', '2021-05-27', '04:10:58 PM', '29115409900', '34219', 'diagnosis', 'diagnosis', '5050.00', '0', '0.00', '5000.00', '50.00', 'Flat', '5000.00', '500.00', '50.00', '4500.00', '500.00', '2021-05-27', 'pending', '', '4', 'DR.BENAZIR AHMED MBBS(DU)BCS(H)DLO ASSI.PRO.MMCH', 'diagnosis', '08:21'), 
('578', '2021-05-27', '04:15:54 PM', '48450029061', '22461', 'diagnosis', 'diagnosis', '4100.00', '0', '0.00', '4050.00', '0.00', 'Flat', '4100.00', '2500.00', '50.00', '1600.00', '2500.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('579', '2021-05-27', '04:21:23 PM', '16286812308', '24174', 'diagnosis', 'diagnosis', '3200.00', '0', '0.00', '3150.00', '0.00', 'Flat', '3200.00', '1500.00', '50.00', '1700.00', '1500.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('580', '2021-05-27', '04:24:47 PM', '30172545048', '58299', 'diagnosis', 'diagnosis', '3000.00', '0', '0.00', '2950.00', '500.00', 'Flat', '2500.00', '1500.00', '50.00', '1000.00', '1500.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('581', '2021-05-27', '04:53:28 PM', '40053384171', '77870', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('583', '2021-05-27', '05:05:59 PM', '85869336128', '28011', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-27', 'pending', '', '4', 'Sristy Hospital', 'diagnosis', '08:21'), 
('585', '2021-05-27', '05:50:17 PM', '72771100948', '68014', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-27', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('586', '2021-05-27', '05:57:04 PM', '47401296885', '94459', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1850.00', '0.00', 'Flat', '1900.00', '1900.00', '50.00', '0.00', '1900.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('587', '2021-05-27', '06:12:14 PM', '91217154678', '19834', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1300.00', '350.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-05-27', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('588', '2021-05-27', '07:18:46 PM', '53835393488', '79858', 'diagnosis', 'diagnosis', '3400.00', '0', '0.00', '3350.00', '900.00', 'Flat', '2500.00', '2500.00', '50.00', '0.00', '2500.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('590', '2021-05-27', '07:25:16 PM', '70720017577', '41856', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2450.00', '1000.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-27', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('592', '2021-05-27', '07:42:48 PM', '49953369920', '12680', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '750.00', '0.00', 'Flat', '800.00', '500.00', '50.00', '300.00', '500.00', '2021-05-27', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('593', '2021-05-27', '07:46:48 PM', '27872231230', '95866', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '0.00', '0.00', '1500.00', '0.00', '2021-05-27', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('594', '2021-05-27', '07:53:32 PM', '33413830564', '77947', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '400.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-05-27', 'pending', '', '4', 'DR.MOHAMMAD RUKUNUZZAMAN MBBS.(MMC)BCS MMCH', 'diagnosis', '08:21'), 
('595', '2021-05-28', '02:02:46 PM', '59748646823', '91490', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('597', '2021-05-28', '02:11:10 PM', '70976614579', '57604', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2050.00', '300.00', 'Flat', '1800.00', '1800.00', '50.00', '0.00', '1800.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('598', '2021-05-28', '02:15:31 PM', '19852061321', '84777', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '400.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('599', '2021-05-28', '02:22:07 PM', '33165344513', '97543', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('600', '2021-05-28', '02:30:34 PM', '68118158479', '82218', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('601', '2021-05-28', '02:32:16 PM', '72036460828', '37458', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('602', '2021-05-28', '03:01:38 PM', '50482562598', '95338', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1050.00', '200.00', 'Flat', '900.00', '600.00', '50.00', '300.00', '600.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('603', '2021-05-28', '03:03:09 PM', '79914812329', '20380', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('604', '2021-05-28', '04:30:17 PM', '44886478947', '30155', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2900.00', '950.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('606', '2021-05-28', '05:16:07 PM', '81492801051', '81176', 'diagnosis', 'diagnosis', '3900.00', '0', '0.00', '3850.00', '2100.00', 'Flat', '1800.00', '1500.00', '50.00', '300.00', '1500.00', '2021-05-28', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('607', '2021-05-28', '05:20:04 PM', '21367274969', '35820', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1850.00', '500.00', 'Flat', '1400.00', '1400.00', '50.00', '0.00', '1400.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('608', '2021-05-28', '06:10:57 PM', '44738643036', '53195', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1300.00', '150.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('609', '2021-05-28', '06:16:45 PM', '90267842138', '82103', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('610', '2021-05-28', '06:17:27 PM', '94902626425', '77516', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-28', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('611', '2021-05-28', '07:41:47 PM', '38045050245', '92672', 'diagnosis', 'diagnosis', '2700.00', '0', '0.00', '2650.00', '0.00', 'Flat', '2700.00', '2000.00', '50.00', '700.00', '2000.00', '2021-05-28', 'pending', '', '8', 'Dr.Ashesh Kumar Roy, MBBS DCH, Consultant (Pediatrics) MMCH.', 'diagnosis', '08:21'), 
('612', '2021-05-28', '08:17:27 PM', '37014389576', '56650', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1950.00', '1000.00', '50.00', '950.00', '1000.00', '2021-05-28', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('613', '2021-05-28', '08:25:31 PM', '73670860711', '57903', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-28', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('614', '2021-05-28', '08:27:41 PM', '84940586777', '55376', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-28', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('615', '2021-05-29', '10:27:32 AM', '94526378396', '85214', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-29', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('616', '2021-05-29', '11:37:32 AM', '15926527894', '46368', 'diagnosis', 'diagnosis', '3450.00', '0', '0.00', '3400.00', '1450.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-29', 'pending', '', '8', 'Gouripur Upozilla Health Complex', 'diagnosis', '08:21'), 
('617', '2021-05-29', '12:25:15 PM', '84668492194', '21334', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2400.00', '0.00', 'Flat', '2450.00', '2450.00', '50.00', '0.00', '2450.00', '2021-05-29', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('618', '2021-05-29', '01:06:53 PM', '73768235825', '13093', 'diagnosis', 'diagnosis', '3650.00', '0', '0.00', '3600.00', '950.00', 'Flat', '2700.00', '2700.00', '50.00', '0.00', '2700.00', '2021-05-29', 'pending', '', '8', 'Dr.Md Akikul ISlam MBBS,BCS (Health), Fcps (Surgery) Register, Depertment of Surgery. MMCH', 'diagnosis', '08:21'), 
('619', '2021-05-29', '01:14:17 PM', '43975293512', '99632', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-05-29', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('620', '2021-05-29', '02:29:01 PM', '40743506823', '25609', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1100.00', '300.00', 'Flat', '850.00', '850.00', '50.00', '0.00', '850.00', '2021-05-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('621', '2021-05-29', '02:57:11 PM', '47433048569', '48498', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2050.00', '100.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('622', '2021-05-29', '02:58:48 PM', '21919860690', '90363', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-29', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('623', '2021-05-29', '02:59:38 PM', '35740334954', '62514', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-29', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('625', '2021-05-29', '03:34:47 PM', '49465983485', '19932', 'diagnosis', 'diagnosis', '3900.00', '0', '0.00', '3850.00', '800.00', 'Flat', '3100.00', '3100.00', '50.00', '0.00', '3100.00', '2021-05-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('626', '2021-05-29', '04:07:47 PM', '81293975892', '41691', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('627', '2021-05-29', '04:17:23 PM', '96534101913', '17305', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-05-29', 'pending', '', '4', 'DR.MD.MOHIUDDIN KHAN MOON MBBS.BCS(H) FCPS', 'diagnosis', '08:21'), 
('628', '2021-05-29', '04:25:13 PM', '76710072076', '88905', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-05-29', 'pending', '', '4', 'Sristy Hospital', 'diagnosis', '08:21'), 
('629', '2021-05-29', '04:26:44 PM', '68697087880', '87066', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-29', 'pending', '', '4', 'Sristy Hospital', 'diagnosis', '08:21'), 
('630', '2021-05-29', '04:46:41 PM', '83170537691', '40081', 'diagnosis', 'diagnosis', '3750.00', '0', '0.00', '3700.00', '0.00', 'Flat', '3750.00', '3000.00', '50.00', '750.00', '3000.00', '2021-05-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('631', '2021-05-29', '04:54:10 PM', '30155436115', '52084', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2050.00', '700.00', 'Flat', '1400.00', '1400.00', '50.00', '0.00', '1400.00', '2021-05-29', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('632', '2021-05-29', '05:12:49 PM', '37691671939', '92331', 'diagnosis', 'diagnosis', '6100.00', '0', '0.00', '6050.00', '0.00', 'Flat', '6100.00', '5000.00', '50.00', '1100.00', '5000.00', '2021-05-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('633', '2021-05-29', '05:41:18 PM', '23744930368', '77854', 'diagnosis', 'diagnosis', '3900.00', '0', '0.00', '3850.00', '1100.00', 'Flat', '2800.00', '2800.00', '50.00', '0.00', '2800.00', '2021-05-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('634', '2021-05-29', '05:43:27 PM', '65127690012', '93790', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '0.00', '0.00', '1000.00', '0.00', '2021-05-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('635', '2021-05-29', '05:45:27 PM', '91157031224', '93038', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('636', '2021-05-29', '05:49:22 PM', '56692849430', '63217', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '750.00', '0.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-05-29', 'pending', '', '4', 'DR.SAMIR KUMAR DAS MBBS.(DU)BCS(H)FCPS(NEP.)ASSI.PRO.MMCH', 'diagnosis', '08:21'), 
('638', '2021-05-29', '05:54:54 PM', '95172993383', '53313', 'diagnosis', 'diagnosis', '3150.00', '0', '0.00', '3100.00', '950.00', 'Flat', '2200.00', '2200.00', '50.00', '0.00', '2200.00', '2021-05-29', 'pending', '', '4', 'DR.LABIB KHAN MBBS.BCSA.MMCH', 'diagnosis', '08:21'), 
('639', '2021-05-29', '06:04:07 PM', '79015246406', '59768', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '800.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-05-29', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('640', '2021-05-29', '06:41:15 PM', '30609044680', '55445', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2750.00', '300.00', 'Flat', '2500.00', '2500.00', '50.00', '0.00', '2500.00', '2021-05-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('641', '2021-05-29', '07:00:11 PM', '87180996810', '32761', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '0.00', '0.00', '200.00', '0.00', '2021-05-29', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('642', '2021-05-29', '07:18:36 PM', '72318741803', '21712', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-29', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('643', '2021-05-29', '07:19:57 PM', '15658720996', '52354', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-05-29', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('645', '2021-05-29', '08:20:00 PM', '74318766925', '47177', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2450.00', '800.00', 'Flat', '1700.00', '1700.00', '50.00', '0.00', '1700.00', '2021-05-29', 'pending', '', '4', 'DR.LABIB KHAN MBBS.BCSA.MMCH', 'diagnosis', '08:21'), 
('646', '2021-05-29', '08:26:34 PM', '90437834627', '99506', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1700.00', '150.00', 'Flat', '1600.00', '1600.00', '50.00', '0.00', '1600.00', '2021-05-29', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('647', '2021-05-29', '08:28:22 PM', '55466357370', '37206', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '350.00', 'Flat', '1700.00', '1700.00', '0.00', '0.00', '1700.00', '2021-05-29', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('648', '2021-05-29', '09:03:05 PM', '93063224148', '22345', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2450.00', '1350.00', 'Flat', '1150.00', '1150.00', '50.00', '0.00', '1150.00', '2021-05-29', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('649', '2021-05-30', '10:21:08 AM', '24692714876', '34396', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2300.00', '1150.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-05-30', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('650', '2021-05-30', '12:21:18 PM', '22530816164', '90903', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2100.00', '550.00', 'Flat', '1600.00', '1600.00', '50.00', '0.00', '1600.00', '2021-05-30', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('651', '2021-05-30', '12:40:05 PM', '86115837924', '93373', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-05-30', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('652', '2021-05-30', '12:45:33 PM', '41200713316', '39972', 'diagnosis', 'diagnosis', '4850.00', '0', '0.00', '4800.00', '850.00', 'Flat', '4000.00', '4000.00', '50.00', '0.00', '4000.00', '2021-05-30', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('654', '2021-05-30', '02:43:55 PM', '71540002980', '48771', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-05-30', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('655', '2021-05-30', '02:59:52 PM', '44614088038', '49071', 'diagnosis', 'diagnosis', '3250.00', '0', '0.00', '3200.00', '250.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-05-30', 'pending', '', '4', 'DR.LABIB KHAN MBBS.BCS.(H)DLO(BSMMU) ENT.MMCH', 'diagnosis', '08:21'), 
('656', '2021-05-30', '03:25:48 PM', '59169214218', '89281', 'diagnosis', 'diagnosis', '4550.00', '0', '0.00', '4500.00', '550.00', 'Flat', '4000.00', '4000.00', '50.00', '0.00', '4000.00', '2021-05-30', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('657', '2021-05-30', '03:37:34 PM', '33376230837', '35906', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1800.00', '50.00', 'Flat', '1800.00', '1800.00', '50.00', '0.00', '1800.00', '2021-05-30', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('658', '2021-05-30', '03:42:15 PM', '39251386870', '68140', 'diagnosis', 'diagnosis', '3400.00', '0', '0.00', '3350.00', '0.00', 'Flat', '3400.00', '1500.00', '50.00', '1900.00', '1500.00', '2021-05-30', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('659', '2021-05-30', '03:43:49 PM', '79129401511', '68544', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1450.00', '300.00', 'Flat', '1200.00', '200.00', '50.00', '1000.00', '200.00', '2021-05-30', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('660', '2021-05-30', '03:49:57 PM', '66789450703', '62462', 'diagnosis', 'diagnosis', '3800.00', '0', '0.00', '3750.00', '0.00', 'Flat', '3800.00', '2500.00', '50.00', '1300.00', '2500.00', '2021-05-30', 'pending', '', '4', 'DR.SAMIR KUMAR DAS MBBS.(DU)BCS(H)FCPS(NEP.)ASSI.PRO.MMCH', 'diagnosis', '08:21'), 
('661', '2021-05-30', '03:52:33 PM', '93202022835', '15935', 'diagnosis', 'diagnosis', '3800.00', '0', '0.00', '3750.00', '700.00', 'Flat', '3100.00', '3100.00', '50.00', '0.00', '3100.00', '2021-05-30', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('663', '2021-05-30', '04:13:11 PM', '97050499667', '92482', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1650.00', '450.00', 'Flat', '1250.00', '1250.00', '50.00', '0.00', '1250.00', '2021-05-30', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('664', '2021-05-30', '04:27:30 PM', '95911456561', '62405', 'diagnosis', 'diagnosis', '7950.00', '0', '0.00', '7900.00', '0.00', 'Flat', '7950.00', '6700.00', '50.00', '1250.00', '6700.00', '2021-05-30', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('665', '2021-05-30', '04:52:45 PM', '65557172687', '22318', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '900.00', '250.00', 'Flat', '700.00', '700.00', '50.00', '0.00', '700.00', '2021-05-30', 'pending', '', '4', 'DR.MOHAMMAD RUKUNUZZAMAN MBBS.(MMC)BCS MMCH', 'diagnosis', '08:21'), 
('666', '2021-05-30', '04:59:34 PM', '24776185096', '62912', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2750.00', '500.00', 'Flat', '2300.00', '1000.00', '50.00', '1300.00', '1000.00', '2021-05-30', 'pending', '', '4', 'DR.GOUTAM SAHA MBBS.(DHAKA)BCS(H)FCPS(MED-FP)MMCH', 'diagnosis', '08:21'), 
('667', '2021-05-30', '05:44:42 PM', '79763428949', '86025', 'diagnosis', 'diagnosis', '4750.00', '0', '0.00', '4700.00', '1750.00', 'Flat', '3000.00', '500.00', '50.00', '2500.00', '500.00', '2021-05-30', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('668', '2021-05-30', '05:46:33 PM', '72142814472', '39446', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3000.00', '50.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-05-30', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('669', '2021-05-30', '06:26:15 PM', '77668442701', '30085', 'diagnosis', 'diagnosis', '3850.00', '0', '0.00', '3800.00', '0.00', 'Flat', '3850.00', '2000.00', '50.00', '1850.00', '2000.00', '2021-05-30', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('670', '2021-05-30', '06:43:02 PM', '66114325655', '42347', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2200.00', '250.00', 'Flat', '2000.00', '500.00', '50.00', '1500.00', '500.00', '2021-05-30', 'pending', '', '4', 'DR.LABIB KHAN MBBS.BCS.(H)DLO(BSMMU) ENT.MMCH', 'diagnosis', '08:21'), 
('671', '2021-05-30', '06:49:52 PM', '62007246621', '21139', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '1950.00', '500.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-30', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('672', '2021-05-30', '06:55:50 PM', '86251823314', '38648', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-05-30', 'pending', '', '4', 'Sristy Hospital', 'diagnosis', '08:21'), 
('673', '2021-05-30', '07:26:36 PM', '52092560256', '80130', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-30', 'pending', '', '4', 'Sristy Hospital', 'diagnosis', '08:21'), 
('674', '2021-05-30', '07:41:01 PM', '98406664157', '19593', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-30', 'pending', '', '4', 'Sristy Hospital', 'diagnosis', '08:21'), 
('676', '2021-05-30', '08:13:20 PM', '69116515417', '48657', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '500.00', '150.00', 'Flat', '400.00', '400.00', '50.00', '0.00', '400.00', '2021-05-30', 'pending', '', '4', 'DR.MOHAMMAD RUKUNUZZAMAN MBBS.(MMC)BCS MMCH', 'diagnosis', '08:21'), 
('677', '2021-05-30', '08:42:45 PM', '27904388763', '82022', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2450.00', '500.00', 'Flat', '2000.00', '1000.00', '50.00', '1000.00', '1000.00', '2021-05-30', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('679', '2021-05-30', '09:05:18 PM', '39993065595', '34386', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-05-30', 'pending', '', '4', 'Sristy Hospital', 'diagnosis', '08:21'), 
('680', '2021-05-31', '10:45:18 AM', '58068411797', '12171', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '700.00', '50.00', 'Flat', '700.00', '700.00', '50.00', '0.00', '700.00', '2021-05-31', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('681', '2021-05-31', '01:19:59 PM', '47630212455', '80067', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-05-31', 'pending', '', '8', 'MMCH', 'diagnosis', '08:21'), 
('682', '2021-05-31', '01:23:10 PM', '75784651852', '62228', 'diagnosis', 'diagnosis', '4550.00', '0', '0.00', '4500.00', '550.00', 'Flat', '4000.00', '4000.00', '50.00', '0.00', '4000.00', '2021-05-31', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('683', '2021-05-31', '01:26:23 PM', '73291770699', '53818', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2450.00', '700.00', 'Flat', '1800.00', '1800.00', '50.00', '0.00', '1800.00', '2021-05-31', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('684', '2021-05-31', '01:43:12 PM', '99290328100', '60974', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-05-31', 'pending', '', '8', 'Sristy Hospital', 'diagnosis', '08:21'), 
('685', '2021-05-31', '03:07:34 PM', '89112275259', '55529', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-05-31', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('686', '2021-05-31', '03:14:58 PM', '99936878184', '82350', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2000.00', '0.00', 'Flat', '2050.00', '1300.00', '50.00', '750.00', '1300.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('687', '2021-05-31', '03:18:00 PM', '55086259378', '68303', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('688', '2021-05-31', '03:40:20 PM', '62642811280', '30993', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2850.00', '0.00', 'Flat', '2900.00', '2900.00', '50.00', '0.00', '2900.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('689', '2021-05-31', '03:44:23 PM', '18889532900', '49104', 'diagnosis', 'diagnosis', '3700.00', '0', '0.00', '3650.00', '500.00', 'Flat', '3200.00', '3200.00', '50.00', '0.00', '3200.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('690', '2021-05-31', '03:45:28 PM', '76813078216', '58024', 'diagnosis', 'diagnosis', '3100.00', '0', '0.00', '3050.00', '0.00', 'Flat', '3100.00', '1500.00', '50.00', '1600.00', '1500.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('691', '2021-05-31', '03:52:57 PM', '95748381771', '98660', 'diagnosis', 'diagnosis', '3600.00', '0', '0.00', '3550.00', '400.00', 'Flat', '3200.00', '3200.00', '50.00', '0.00', '3200.00', '2021-05-31', 'pending', '', '4', 'DR.LABIB KHAN MBBS.BCS.(H)DLO(BSMMU) ENT.MMCH', 'diagnosis', '08:21'), 
('694', '2021-05-31', '04:04:01 PM', '59511124797', '93436', 'diagnosis', 'diagnosis', '2550.00', '0', '0.00', '2500.00', '550.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-05-31', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('695', '2021-05-31', '04:34:39 PM', '89096823789', '51135', 'diagnosis', 'diagnosis', '3850.00', '0', '0.00', '3800.00', '350.00', 'Flat', '3500.00', '3500.00', '50.00', '0.00', '3500.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('696', '2021-05-31', '04:37:30 PM', '59300227752', '19951', 'diagnosis', 'diagnosis', '3850.00', '0', '0.00', '3800.00', '1150.00', 'Flat', '2700.00', '2700.00', '50.00', '0.00', '2700.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('697', '2021-05-31', '04:48:48 PM', '13729541872', '80028', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1450.00', '0.00', 'Flat', '1500.00', '0.00', '50.00', '1500.00', '0.00', '2021-05-31', 'pending', '', '4', 'DR.FARID AL HASAN MBBS.(DU)DLO(DU)MS(ENT)UK.MMCH', 'diagnosis', '08:21'), 
('698', '2021-05-31', '05:12:05 PM', '61174859685', '62157', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('699', '2021-05-31', '05:21:24 PM', '16489091763', '70720', 'diagnosis', 'diagnosis', '3900.00', '0', '0.00', '3850.00', '100.00', 'Flat', '3800.00', '2000.00', '50.00', '1800.00', '2000.00', '2021-05-31', 'pending', '', '4', 'DR.KHALED HASAN MBBS(DHAKA)FCGP(F-MED)MPH.MMCH.', 'diagnosis', '08:21'), 
('700', '2021-05-31', '05:29:35 PM', '60228608093', '28697', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1850.00', '0.00', 'Flat', '1900.00', '700.00', '50.00', '1200.00', '700.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('701', '2021-05-31', '05:38:40 PM', '83689688104', '51603', 'diagnosis', 'diagnosis', '4750.00', '0', '0.00', '4700.00', '0.00', 'Flat', '4750.00', '2000.00', '50.00', '2750.00', '2000.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('702', '2021-05-31', '05:47:39 PM', '90989563448', '56719', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1900.00', '450.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('703', '2021-05-31', '05:53:02 PM', '42333126440', '14019', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-05-31', 'pending', '', '4', 'DR.MD.MOHIUDDIN KHAN MOON MBBS.BCS(H) FCPS', 'diagnosis', '08:21'), 
('704', '2021-05-31', '06:01:03 PM', '32546780961', '67342', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2900.00', '0.00', 'Flat', '2950.00', '2000.00', '50.00', '950.00', '2000.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('706', '2021-05-31', '06:36:35 PM', '77311000641', '39923', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-05-31', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('707', '2021-05-31', '07:34:19 PM', '68266475366', '37261', 'diagnosis', 'diagnosis', '3550.00', '0', '0.00', '3500.00', '0.00', 'Flat', '3550.00', '1000.00', '50.00', '2550.00', '1000.00', '2021-05-31', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('708', '2021-05-31', '08:03:22 PM', '32871336614', '92771', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '700.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-05-31', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('709', '2021-05-31', '08:32:48 PM', '36180612444', '18677', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-05-31', 'pending', '', '4', 'DR.GOUTAM SAHA MBBS.(DHAKA)BCS(H)FCPS(MED-FP)MMCH', 'diagnosis', '08:21'), 
('710', '2021-06-01', '10:26:16 AM', '52700824580', '74752', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1450.00', '300.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-06-01', 'pending', '', '8', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('711', '2021-06-01', '12:08:42 PM', '47747067734', '54416', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-01', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('712', '2021-06-01', '01:53:41 PM', '22991583703', '37382', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1950.00', '500.00', '50.00', '1450.00', '500.00', '2021-06-01', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('713', '2021-06-01', '02:05:40 PM', '34130103265', '59001', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-06-01', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('714', '2021-06-01', '02:43:45 PM', '76413867084', '95863', 'diagnosis', 'diagnosis', '3950.00', '0', '0.00', '3900.00', '750.00', 'Flat', '3200.00', '3200.00', '50.00', '0.00', '3200.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('715', '2021-06-01', '03:16:29 PM', '48403021362', '54657', 'diagnosis', 'diagnosis', '4300.00', '0', '0.00', '4250.00', '1300.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('716', '2021-06-01', '03:23:53 PM', '63393983037', '40815', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('717', '2021-06-01', '03:36:27 PM', '68788399837', '37759', 'diagnosis', 'diagnosis', '4350.00', '0', '0.00', '4300.00', '350.00', 'Flat', '4000.00', '4000.00', '50.00', '0.00', '4000.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('719', '2021-06-01', '04:11:16 PM', '81828695701', '70284', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-06-01', 'pending', '', '4', 'Self', 'diagnosis', '08:21'), 
('720', '2021-06-01', '04:12:22 PM', '94985285773', '55263', 'diagnosis', 'diagnosis', '3950.00', '0', '0.00', '3900.00', '0.00', 'Flat', '3950.00', '1000.00', '50.00', '2950.00', '1000.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('722', '2021-06-01', '04:25:01 PM', '39063297584', '57406', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '150.00', 'Flat', '1750.00', '1750.00', '0.00', '0.00', '1750.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('723', '2021-06-01', '04:33:12 PM', '13087768728', '91904', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3000.00', '0.00', 'Flat', '3050.00', '2000.00', '50.00', '1050.00', '2000.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('725', '2021-06-01', '05:15:08 PM', '95631764208', '98466', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2900.00', '0.00', 'Flat', '2950.00', '1000.00', '50.00', '1950.00', '1000.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('726', '2021-06-01', '05:44:21 PM', '80612431094', '85855', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2150.00', '0.00', 'Flat', '2200.00', '1000.00', '50.00', '1200.00', '1000.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('727', '2021-06-01', '06:11:06 PM', '62437945107', '32998', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '0.00', 'Flat', '200.00', '0.00', '0.00', '200.00', '0.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('728', '2021-06-01', '07:03:45 PM', '60993217966', '24979', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '850.00', 'Flat', '1050.00', '1050.00', '0.00', '0.00', '1050.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('729', '2021-06-01', '07:14:06 PM', '18701912710', '34419', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('730', '2021-06-01', '07:18:18 PM', '20585638243', '46252', 'diagnosis', 'diagnosis', '3900.00', '0', '0.00', '3850.00', '500.00', 'Flat', '3400.00', '3400.00', '50.00', '0.00', '3400.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('731', '2021-06-01', '07:45:36 PM', '53531264265', '29798', 'diagnosis', 'diagnosis', '3650.00', '0', '0.00', '3600.00', '750.00', 'Flat', '2900.00', '2900.00', '50.00', '0.00', '2900.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('732', '2021-06-01', '07:55:11 PM', '80004840344', '20730', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2400.00', '50.00', 'Flat', '2400.00', '2400.00', '50.00', '0.00', '2400.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('733', '2021-06-01', '08:17:08 PM', '85564555186', '84481', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2850.00', '0.00', 'Flat', '2900.00', '500.00', '50.00', '2400.00', '500.00', '2021-06-01', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('734', '2021-06-02', '12:29:05 PM', '95819298840', '42768', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '70.00', 'Flat', '80.00', '80.00', '0.00', '0.00', '80.00', '2021-06-02', 'pending', '', '8', 'Self', 'diagnosis', '08:21'), 
('736', '2021-06-02', '01:39:54 PM', '16282537413', '13034', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-06-02', 'pending', '', '8', 'Dr.Shahadat Hossen Mintu', 'diagnosis', '08:21'), 
('737', '2021-06-02', '02:25:27 PM', '90684601416', '90899', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2850.00', '0.00', 'Flat', '2900.00', '2000.00', '50.00', '900.00', '2000.00', '2021-06-02', 'pending', '', '4', 'DR.LABIB KHAN MBBS.BCS.(H)DLO(BSMMU) ENT.MMCH', 'diagnosis', '08:21'), 
('738', '2021-06-02', '02:32:25 PM', '88406113576', '18155', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-06-02', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('739', '2021-06-02', '02:33:29 PM', '18419039497', '52356', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1450.00', '500.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-06-02', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('740', '2021-06-02', '02:34:40 PM', '22213611379', '70165', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1450.00', '1000.00', 'Flat', '500.00', '500.00', '50.00', '0.00', '500.00', '2021-06-02', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('742', '2021-06-02', '02:55:45 PM', '94662085341', '45508', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2300.00', '150.00', 'Flat', '2200.00', '2200.00', '50.00', '0.00', '2200.00', '2021-06-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('743', '2021-06-02', '02:57:46 PM', '45054551131', '38490', 'diagnosis', 'diagnosis', '5150.00', '0', '0.00', '5100.00', '0.00', 'Flat', '5150.00', '3000.00', '50.00', '2150.00', '3000.00', '2021-06-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('744', '2021-06-02', '03:31:02 PM', '57168454842', '58273', 'diagnosis', 'diagnosis', '3400.00', '0', '0.00', '3350.00', '400.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-06-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('750', '2021-06-02', '04:19:10 PM', '70799840200', '28417', 'diagnosis', 'diagnosis', '3300.00', '0', '0.00', '3250.00', '0.00', 'Flat', '3300.00', '1000.00', '50.00', '2300.00', '1000.00', '2021-06-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('751', '2021-06-02', '04:31:40 PM', '55792197046', '93540', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2100.00', '0.00', 'Flat', '2150.00', '2000.00', '50.00', '150.00', '2000.00', '2021-06-02', 'pending', '', '4', 'DR.MOHAMMAD DELWAR JAHAN KHAN MBBS.BCS(H)DTCD MMCH', 'diagnosis', '08:21'), 
('752', '2021-06-02', '04:51:05 PM', '61308279964', '78396', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2900.00', '850.00', 'Flat', '2100.00', '2000.00', '50.00', '100.00', '2000.00', '2021-06-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('753', '2021-06-02', '04:53:13 PM', '99923379677', '47264', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3000.00', '0.00', 'Flat', '3050.00', '1500.00', '50.00', '1550.00', '1500.00', '2021-06-02', 'pending', '', '4', 'DR.FARID AL HASAN MBBS.(DU)DLO(DU)MS(ENT)UK.MMCH', 'diagnosis', '08:21'), 
('754', '2021-06-02', '04:54:15 PM', '88831438993', '98311', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-06-02', 'pending', '', '4', 'JOYASREE PAUL', 'diagnosis', '08:21'), 
('756', '2021-06-02', '05:16:31 PM', '14797357138', '87197', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '0.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-06-02', 'pending', '', '4', 'DR.MD.SHAFIQUR RAHMAN MBBS.FCPS(SUR)MMCH', 'diagnosis', '08:21'), 
('757', '2021-06-02', '05:18:17 PM', '91261257852', '56187', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-06-02', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('758', '2021-06-02', '05:21:23 PM', '97845079294', '59067', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2000.00', '550.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-06-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('759', '2021-06-02', '05:31:15 PM', '76605795820', '88754', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-06-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('760', '2021-06-02', '05:41:15 PM', '21450249353', '33925', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '50.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-06-02', 'pending', '', '4', 'DR.SHAMIMA HAQUE (KAKON)MBBS.MCPS(GYNAC@OBS)FCPS', 'diagnosis', '08:21'), 
('761', '2021-06-02', '06:12:06 PM', '35286767077', '65044', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '500.00', '0.00', '700.00', '500.00', '2021-06-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('762', '2021-06-02', '07:39:47 PM', '25722018298', '56648', 'diagnosis', 'diagnosis', '3350.00', '0', '0.00', '3300.00', '1650.00', 'Flat', '1700.00', '1700.00', '50.00', '0.00', '1700.00', '2021-06-02', 'pending', '', '4', 'DR.SHAMIMA HAQUE KAKON', 'diagnosis', '08:21'), 
('763', '2021-06-02', '08:03:39 PM', '34947968191', '54916', 'diagnosis', 'diagnosis', '5250.00', '0', '0.00', '5200.00', '1000.00', 'Flat', '4250.00', '4250.00', '50.00', '0.00', '4250.00', '2021-06-02', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('764', '2021-06-02', '08:05:49 PM', '43651046852', '51699', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '650.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-06-02', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('765', '2021-06-03', '10:33:47 AM', '37313332781', '26324', 'diagnosis', 'diagnosis', '3750.00', '0', '0.00', '3700.00', '750.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-06-03', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('767', '2021-06-03', '01:07:17 PM', '29208003398', '23175', 'diagnosis', 'diagnosis', '6700.00', '0', '0.00', '6650.00', '0.00', 'Flat', '6700.00', '1000.00', '50.00', '5700.00', '1000.00', '2021-06-03', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('768', '2021-06-03', '01:11:00 PM', '58898162469', '99387', 'diagnosis', 'diagnosis', '2700.00', '0', '0.00', '2650.00', '0.00', 'Flat', '2700.00', '2700.00', '50.00', '0.00', '2700.00', '2021-06-03', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('769', '2021-06-03', '01:17:30 PM', '50489694293', '90256', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-03', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('770', '2021-06-03', '01:58:45 PM', '61632919270', '75349', 'diagnosis', 'diagnosis', '2650.00', '0', '0.00', '2600.00', '650.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-06-03', 'pending', '', '8', 'A.K Mohiuddin Bavlo', 'diagnosis', '08:21'), 
('771', '2021-06-03', '02:12:55 PM', '36388814532', '19521', 'diagnosis', 'diagnosis', '2550.00', '0', '0.00', '2500.00', '770.00', 'Flat', '1780.00', '1780.00', '50.00', '0.00', '1780.00', '2021-06-03', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('772', '2021-06-03', '02:31:31 PM', '23716809186', '37683', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2250.00', '100.00', 'Flat', '2200.00', '2200.00', '50.00', '0.00', '2200.00', '2021-06-03', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('773', '2021-06-03', '03:06:39 PM', '69413992638', '13023', 'diagnosis', 'diagnosis', '2550.00', '0', '0.00', '2500.00', '550.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-06-03', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('774', '2021-06-03', '03:22:36 PM', '21654035192', '65997', 'diagnosis', 'diagnosis', '4400.00', '0', '0.00', '4350.00', '100.00', 'Flat', '4300.00', '4000.00', '50.00', '300.00', '4000.00', '2021-06-03', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('775', '2021-06-03', '03:24:58 PM', '18946406741', '73088', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2250.00', '0.00', 'Flat', '2300.00', '0.00', '50.00', '2300.00', '0.00', '2021-06-03', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('776', '2021-06-03', '03:45:18 PM', '97299519057', '68727', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-06-03', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('777', '2021-06-03', '03:58:12 PM', '71451841253', '52455', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-06-03', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('778', '2021-06-03', '04:07:46 PM', '44097967114', '49229', 'diagnosis', 'diagnosis', '3400.00', '0', '0.00', '3350.00', '600.00', 'Flat', '2800.00', '2800.00', '50.00', '0.00', '2800.00', '2021-06-03', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('779', '2021-06-03', '04:10:12 PM', '33734826412', '94790', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1700.00', '0.00', 'Flat', '1750.00', '0.00', '50.00', '1750.00', '0.00', '2021-06-03', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('780', '2021-06-03', '04:22:12 PM', '12253863612', '85269', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2250.00', '1300.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-06-03', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('781', '2021-06-03', '04:36:46 PM', '92229199119', '35617', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-06-03', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('782', '2021-06-03', '04:39:33 PM', '75797124041', '90550', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-06-03', 'pending', '', '4', 'DR.MOHAMMAD REAZAUL KARIM  MBBS,BCS(H)FCPS(MED)MD(GESTROLOGY)ASSI.PRO.MMCH', 'diagnosis', '08:21'), 
('783', '2021-06-03', '05:23:12 PM', '86334056779', '22143', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-06-03', 'pending', '', '4', 'DR.MD.SHAFIQUR RAHMAN MBBS.FCPS.(SUR)MMCH', 'diagnosis', '08:21'), 
('784', '2021-06-03', '05:38:02 PM', '74818156659', '67163', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1600.00', '1600.00', '100.00', '0.00', '1600.00', '2021-06-03', 'pending', '', '4', 'DR.SHIMIR KUMAR DASMBBS.BCS.MMCH', 'diagnosis', '08:21'), 
('785', '2021-06-03', '05:39:46 PM', '81699996193', '56943', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3000.00', '550.00', 'Flat', '2500.00', '500.00', '50.00', '2000.00', '500.00', '2021-06-03', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('786', '2021-06-03', '05:41:35 PM', '99765440945', '36072', 'diagnosis', 'diagnosis', '3600.00', '0', '0.00', '3550.00', '100.00', 'Flat', '3500.00', '3500.00', '50.00', '0.00', '3500.00', '2021-06-03', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('787', '2021-06-03', '05:49:22 PM', '77994318761', '22176', 'diagnosis', 'diagnosis', '3550.00', '0', '0.00', '3500.00', '0.00', 'Flat', '3550.00', '1500.00', '50.00', '2050.00', '1500.00', '2021-06-03', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('789', '2021-06-03', '06:24:32 PM', '87567346253', '94709', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1850.00', '200.00', 'Flat', '1700.00', '500.00', '50.00', '1200.00', '500.00', '2021-06-03', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('790', '2021-06-03', '07:24:40 PM', '63369884714', '34738', 'diagnosis', 'diagnosis', '2700.00', '0', '0.00', '2650.00', '100.00', 'Flat', '2600.00', '2600.00', '50.00', '0.00', '2600.00', '2021-06-03', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('791', '2021-06-03', '07:36:38 PM', '67681468071', '25586', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2300.00', '0.00', 'Flat', '2300.00', '1000.00', '0.00', '1300.00', '1000.00', '2021-06-03', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('792', '2021-06-04', '11:07:47 AM', '98045081976', '80515', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1150.00', '200.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-06-04', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('793', '2021-06-04', '12:07:59 PM', '20557664541', '21028', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-04', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('794', '2021-06-04', '12:20:31 PM', '32886411829', '57206', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1050.00', '200.00', 'Flat', '900.00', '900.00', '50.00', '0.00', '900.00', '2021-06-04', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('795', '2021-06-04', '12:37:19 PM', '91068367204', '66472', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '700.00', '450.00', 'Flat', '300.00', '0.00', '50.00', '300.00', '0.00', '2021-06-04', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('796', '2021-06-04', '02:37:39 PM', '66276843514', '66532', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2450.00', '500.00', 'Flat', '2000.00', '1000.00', '50.00', '1000.00', '1000.00', '2021-06-04', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('797', '2021-06-04', '03:43:59 PM', '68747517011', '37885', 'diagnosis', 'diagnosis', '2700.00', '0', '0.00', '2650.00', '0.00', 'Flat', '2700.00', '0.00', '50.00', '2700.00', '0.00', '2021-06-04', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('798', '2021-06-04', '04:04:52 PM', '63476627899', '54902', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-06-04', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('799', '2021-06-04', '07:23:36 PM', '75797214069', '98846', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '0.00', '0.00', '200.00', '0.00', '2021-06-04', 'pending', '', '4', 'DR.SUDHIR CHANDRA PAUL', 'diagnosis', '08:21'), 
('800', '2021-06-05', '11:44:44 AM', '68947820489', '77521', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-06-05', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('801', '2021-06-05', '11:52:31 AM', '51082829054', '81592', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1750.00', '600.00', 'Flat', '1200.00', '1200.00', '50.00', '0.00', '1200.00', '2021-06-05', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('802', '2021-06-05', '12:03:26 PM', '88599709297', '49121', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-06-05', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('803', '2021-06-05', '12:19:00 PM', '35185443941', '96799', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2400.00', '300.00', 'Flat', '2150.00', '0.00', '50.00', '2150.00', '0.00', '2021-06-05', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('804', '2021-06-05', '12:26:24 PM', '42099547303', '35146', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1150.00', '300.00', 'Flat', '900.00', '900.00', '50.00', '0.00', '900.00', '2021-06-05', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('805', '2021-06-05', '12:43:08 PM', '97594119194', '45438', 'diagnosis', 'diagnosis', '3400.00', '0', '0.00', '3350.00', '0.00', 'Flat', '3400.00', '0.00', '50.00', '3400.00', '0.00', '2021-06-05', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('806', '2021-06-05', '01:35:11 PM', '79072639097', '50651', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1900.00', '950.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-06-05', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('807', '2021-06-05', '01:57:04 PM', '85316401720', '15825', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-06-05', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('808', '2021-06-05', '02:06:41 PM', '72906041145', '64787', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2400.00', '0.00', 'Flat', '2450.00', '1500.00', '50.00', '950.00', '1500.00', '2021-06-05', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('809', '2021-06-05', '02:17:06 PM', '66120367455', '69001', 'diagnosis', 'diagnosis', '7150.00', '0', '0.00', '7100.00', '150.00', 'Flat', '7000.00', '6000.00', '50.00', '1000.00', '6000.00', '2021-06-05', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('810', '2021-06-05', '02:21:10 PM', '27361127195', '54965', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-06-05', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('813', '2021-06-05', '03:29:05 PM', '71901329110', '72287', 'diagnosis', 'diagnosis', '3500.00', '0', '0.00', '3450.00', '250.00', 'Flat', '3250.00', '0.00', '50.00', '3250.00', '0.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('814', '2021-06-05', '03:33:57 PM', '75560186886', '59416', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1850.00', '570.00', 'Flat', '1330.00', '1330.00', '50.00', '0.00', '1330.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('815', '2021-06-05', '03:45:19 PM', '62628400284', '77462', 'diagnosis', 'diagnosis', '3350.00', '0', '0.00', '3300.00', '50.00', 'Flat', '3300.00', '3300.00', '50.00', '0.00', '3300.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('816', '2021-06-05', '03:52:02 PM', '14800650833', '14454', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2750.00', '400.00', 'Flat', '2400.00', '2400.00', '50.00', '0.00', '2400.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('817', '2021-06-05', '04:11:19 PM', '99384806346', '59166', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2350.00', '0.00', 'Flat', '2400.00', '2000.00', '50.00', '400.00', '2000.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('818', '2021-06-05', '04:12:06 PM', '50480767008', '88180', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '200.00', '0.00', '200.00', '200.00', '2021-06-05', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('820', '2021-06-05', '04:21:02 PM', '61903970605', '85528', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '0.00', '0.00', '200.00', '0.00', '2021-06-05', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('821', '2021-06-05', '04:23:07 PM', '36858095601', '21243', 'diagnosis', 'diagnosis', '3800.00', '0', '0.00', '3750.00', '100.00', 'Flat', '3700.00', '2000.00', '50.00', '1700.00', '2000.00', '2021-06-05', 'pending', '', '4', 'DR.SHIMIR KUMAR DASMBBS.BCS.MMCH', 'diagnosis', '08:21'), 
('822', '2021-06-05', '04:39:03 PM', '63085227294', '99093', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2750.00', '800.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('823', '2021-06-05', '04:43:02 PM', '54516975043', '93164', 'diagnosis', 'diagnosis', '3700.00', '0', '0.00', '3650.00', '1700.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-06-05', 'pending', '', '4', 'DR.FARID AL HASAN MBBS(DU)DLO(DU)MS-ENT(UK)MMCH', 'diagnosis', '08:21'), 
('824', '2021-06-05', '04:45:46 PM', '65829153979', '37539', 'diagnosis', 'diagnosis', '2550.00', '0', '0.00', '2500.00', '0.00', 'Flat', '2550.00', '1000.00', '50.00', '1550.00', '1000.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('825', '2021-06-05', '04:50:57 PM', '17538727819', '47411', 'diagnosis', 'diagnosis', '2550.00', '0', '0.00', '2500.00', '750.00', 'Flat', '1800.00', '1800.00', '50.00', '0.00', '1800.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('826', '2021-06-05', '04:53:13 PM', '87307005830', '39852', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '1950.00', '0.00', 'Flat', '2000.00', '0.00', '50.00', '2000.00', '0.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('827', '2021-06-05', '04:55:24 PM', '25695273073', '17246', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-06-05', 'pending', '', '4', 'DR.MD.SHAFIQUR RAHMAN MBBS.FCPS.(SUR)MMCH', 'diagnosis', '08:21'), 
('828', '2021-06-05', '05:04:25 PM', '62092495419', '62843', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1100.00', '1100.00', '50.00', '0.00', '1100.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('829', '2021-06-05', '05:08:49 PM', '50565763852', '32040', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '500.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-06-05', 'pending', '', '4', 'PROF.DR.SHILA SEN MBBS.FCPS.PROF.&HESAD CBMC', 'diagnosis', '08:21'), 
('830', '2021-06-05', '05:19:07 PM', '99044420280', '57819', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1700.00', '450.00', 'Flat', '1300.00', '1300.00', '50.00', '0.00', '1300.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('831', '2021-06-05', '05:34:47 PM', '86189681746', '76806', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('833', '2021-06-05', '05:46:44 PM', '29841992921', '83367', 'diagnosis', 'diagnosis', '4050.00', '0', '0.00', '4000.00', '250.00', 'Flat', '3800.00', '3700.00', '50.00', '100.00', '3700.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('834', '2021-06-05', '06:04:50 PM', '27154688412', '21427', 'diagnosis', 'diagnosis', '4500.00', '0', '0.00', '4450.00', '0.00', 'Flat', '4500.00', '1500.00', '50.00', '3000.00', '1500.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('835', '2021-06-05', '06:07:31 PM', '24582722162', '91238', 'diagnosis', 'diagnosis', '3200.00', '0', '0.00', '3150.00', '0.00', 'Flat', '3200.00', '1500.00', '50.00', '1700.00', '1500.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('836', '2021-06-05', '06:35:07 PM', '50473197094', '49879', 'diagnosis', 'diagnosis', '3350.00', '0', '0.00', '3300.00', '0.00', 'Flat', '3350.00', '0.00', '50.00', '3350.00', '0.00', '2021-06-05', 'pending', '', '4', 'DR SHAMIMA HAQUE KAKON', 'diagnosis', '08:21'), 
('837', '2021-06-05', '07:29:01 PM', '97222431086', '81994', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('838', '2021-06-05', '07:46:02 PM', '76042577458', '54610', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '0.00', 'Flat', '1400.00', '300.00', '0.00', '1100.00', '300.00', '2021-06-05', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('839', '2021-06-05', '07:49:30 PM', '70792422816', '46921', 'diagnosis', 'diagnosis', '3000.00', '0', '0.00', '2950.00', '0.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('840', '2021-06-05', '09:18:47 PM', '66392636216', '24053', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-06-05', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('841', '2021-06-05', '09:19:26 PM', '44389736155', '62699', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-06-05', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('842', '2021-06-05', '09:20:03 PM', '80799043344', '95631', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-06-05', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('843', '2021-06-06', '11:18:42 AM', '90102310230', '96715', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-06-06', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('844', '2021-06-06', '12:11:15 PM', '87350643508', '92336', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-06-06', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('845', '2021-06-06', '12:15:49 PM', '45372448406', '24394', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1900.00', '650.00', 'Flat', '1300.00', '1300.00', '50.00', '0.00', '1300.00', '2021-06-06', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('846', '2021-06-06', '12:35:37 PM', '17798397482', '51519', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-06', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('847', '2021-06-06', '12:45:14 PM', '99072803391', '77384', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '100.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-06-06', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('849', '2021-06-06', '01:02:05 PM', '12187671371', '60854', 'diagnosis', 'diagnosis', '2750.00', '0', '0.00', '2700.00', '0.00', 'Flat', '2750.00', '2750.00', '50.00', '0.00', '2750.00', '2021-06-06', 'pending', '', '8', 'Dr.Iftekhar Haidar MBBS,BCS(Health), CCD (Bardem),DMU(Dhaka) MD (Medicine) Register,MMCH ', 'diagnosis', '08:21'), 
('850', '2021-06-06', '01:15:48 PM', '86930012909', '64368', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-06-06', 'pending', '', '8', 'MMCH', 'diagnosis', '08:21'), 
('851', '2021-06-06', '01:59:15 PM', '29230226203', '61838', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1750.00', '400.00', 'Flat', '1400.00', '1400.00', '50.00', '0.00', '1400.00', '2021-06-06', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('852', '2021-06-06', '02:33:05 PM', '55821549354', '68914', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2900.00', '450.00', 'Flat', '2500.00', '2500.00', '50.00', '0.00', '2500.00', '2021-06-06', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('853', '2021-06-06', '03:03:29 PM', '83728205619', '19080', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-06-06', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('854', '2021-06-06', '03:31:41 PM', '89332085723', '49662', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1250.00', '0.00', 'Flat', '1300.00', '0.00', '50.00', '1300.00', '0.00', '2021-06-06', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('856', '2021-06-06', '03:38:11 PM', '60028162515', '81508', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '450.00', 'Flat', '750.00', '750.00', '0.00', '0.00', '750.00', '2021-06-06', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('857', '2021-06-06', '03:43:46 PM', '83885566476', '53875', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-06', 'pending', '', '4', 'DR.FARID AL HASAN MBBS(DU)DLO(DU)MS-ENT(UK)MMCH', 'diagnosis', '08:21'), 
('858', '2021-06-06', '03:44:28 PM', '42470918844', '38809', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-06', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('859', '2021-06-06', '04:14:33 PM', '55169234507', '90467', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1250.00', '300.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-06-06', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('860', '2021-06-06', '04:18:18 PM', '69560713817', '61094', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-06-06', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('861', '2021-06-06', '04:21:26 PM', '92679098952', '99482', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1350.00', '400.00', 'Flat', '1000.00', '0.00', '50.00', '1000.00', '0.00', '2021-06-06', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('862', '2021-06-06', '04:32:57 PM', '53426637293', '13924', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '500.00', '0.00', '300.00', '500.00', '2021-06-06', 'pending', '', '4', 'DR.SAIFUL ABEDIN SHOUROV BDS(MMC)PGT(DENTISTRY)BMDC', 'diagnosis', '08:21'), 
('863', '2021-06-06', '05:08:30 PM', '12282755391', '61418', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '650.00', '350.00', 'Flat', '350.00', '350.00', '50.00', '0.00', '350.00', '2021-06-06', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('864', '2021-06-06', '05:42:26 PM', '37360874315', '62948', 'diagnosis', 'diagnosis', '2700.00', '0', '0.00', '2650.00', '300.00', 'Flat', '2400.00', '2400.00', '50.00', '0.00', '2400.00', '2021-06-06', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('865', '2021-06-06', '05:49:48 PM', '30286332716', '79653', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3000.00', '50.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-06-06', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('866', '2021-06-06', '07:21:49 PM', '23080826633', '99662', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '50.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-06', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('868', '2021-06-06', '08:35:14 PM', '35940168425', '83943', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2850.00', '0.00', 'Flat', '2900.00', '1000.00', '50.00', '1900.00', '1000.00', '2021-06-06', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('869', '2021-06-07', '10:26:44 AM', '96564684559', '26298', 'diagnosis', 'diagnosis', '2650.00', '0', '0.00', '2600.00', '850.00', 'Flat', '1800.00', '1800.00', '50.00', '0.00', '1800.00', '2021-06-07', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('870', '2021-06-07', '10:44:29 AM', '82344786408', '65848', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1350.00', '1350.00', '50.00', '0.00', '1350.00', '2021-06-07', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('871', '2021-06-07', '11:03:40 AM', '89690386669', '71498', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '100.00', '0.00', '300.00', '100.00', '2021-06-07', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('872', '2021-06-07', '11:08:45 AM', '41326546089', '71506', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '1950.00', '0.00', 'Flat', '2000.00', '1000.00', '50.00', '1000.00', '1000.00', '2021-06-07', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('874', '2021-06-07', '11:55:56 AM', '70010808482', '11225', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '90.00', 'Flat', '60.00', '60.00', '0.00', '0.00', '60.00', '2021-06-07', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('876', '2021-06-07', '11:57:06 AM', '66450318735', '69395', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '90.00', 'Flat', '60.00', '60.00', '0.00', '0.00', '60.00', '2021-06-07', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('877', '2021-06-07', '11:58:46 AM', '44507290547', '46968', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '90.00', 'Flat', '60.00', '60.00', '0.00', '0.00', '60.00', '2021-06-07', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('878', '2021-06-07', '11:59:36 AM', '17767293751', '40492', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '90.00', 'Flat', '60.00', '60.00', '0.00', '0.00', '60.00', '2021-06-07', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('879', '2021-06-07', '12:00:37 PM', '40778533493', '60639', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '90.00', 'Flat', '60.00', '60.00', '0.00', '0.00', '60.00', '2021-06-07', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('880', '2021-06-07', '12:01:19 PM', '30466612842', '39326', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '90.00', 'Flat', '60.00', '60.00', '0.00', '0.00', '60.00', '2021-06-07', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('881', '2021-06-07', '12:02:19 PM', '11702467459', '67683', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '90.00', 'Flat', '60.00', '60.00', '0.00', '0.00', '60.00', '2021-06-07', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('883', '2021-06-07', '01:10:08 PM', '72810601029', '76725', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '650.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-06-07', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('885', '2021-06-07', '02:46:56 PM', '79748944358', '81690', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-06-07', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('886', '2021-06-07', '02:51:28 PM', '74335081751', '63291', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2400.00', '450.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-06-07', 'pending', '', '4', 'DR.SOFIQUR RAHMAN MBBS', 'diagnosis', '08:21'), 
('887', '2021-06-07', '03:19:26 PM', '95715559356', '62826', 'diagnosis', 'diagnosis', '2600.00', '0', '0.00', '2550.00', '0.00', 'Flat', '2600.00', '2000.00', '50.00', '600.00', '2000.00', '2021-06-07', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('888', '2021-06-07', '03:22:05 PM', '73465737452', '80641', 'diagnosis', 'diagnosis', '2750.00', '0', '0.00', '2700.00', '550.00', 'Flat', '2200.00', '2200.00', '50.00', '0.00', '2200.00', '2021-06-07', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('889', '2021-06-07', '03:25:37 PM', '95672717193', '92061', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '750.00', '450.00', 'Flat', '350.00', '0.00', '50.00', '350.00', '0.00', '2021-06-07', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('890', '2021-06-07', '03:29:45 PM', '95033759996', '35290', 'diagnosis', 'diagnosis', '4700.00', '0', '0.00', '4650.00', '0.00', 'Flat', '4700.00', '2000.00', '50.00', '2700.00', '2000.00', '2021-06-07', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('891', '2021-06-07', '03:38:32 PM', '25656113194', '61018', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1200.00', '250.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-06-07', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('892', '2021-06-07', '04:06:22 PM', '29852131381', '37014', 'diagnosis', 'diagnosis', '4200.00', '0', '0.00', '4150.00', '0.00', 'Flat', '4200.00', '1000.00', '50.00', '3200.00', '1000.00', '2021-06-07', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('893', '2021-06-07', '04:09:08 PM', '23010239832', '47853', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '400.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-06-07', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('894', '2021-06-07', '04:25:17 PM', '61732335388', '76193', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-06-07', 'pending', '', '4', 'DR,MD.ASHRAFUL ALAM', 'diagnosis', '08:21'), 
('895', '2021-06-07', '04:27:06 PM', '68971434897', '14381', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-06-07', 'pending', '', '4', 'DR.WALID SHARKER (BIDDUT)MBBS.BCS(H)D-CARD(CARDIOLOGY)MD COURS', 'diagnosis', '08:21'), 
('896', '2021-06-07', '04:49:11 PM', '14905701908', '86619', 'diagnosis', 'diagnosis', '4000.00', '0', '0.00', '3950.00', '0.00', 'Flat', '4000.00', '4000.00', '50.00', '0.00', '4000.00', '2021-06-07', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('897', '2021-06-07', '05:22:45 PM', '13897501387', '25515', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-06-07', 'pending', '', '4', 'MD.IMRAN HOSSAIN MBBS.(DU)BCS(H)MMCH', 'diagnosis', '08:21'), 
('898', '2021-06-07', '05:51:12 PM', '31630672804', '33839', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '0.00', 'Flat', '1600.00', '500.00', '0.00', '1100.00', '500.00', '2021-06-07', 'pending', '', '4', 'DR.SK.AHSAN HABIB MHMS GHMC', 'diagnosis', '08:21'), 
('899', '2021-06-07', '06:29:45 PM', '68112607838', '28371', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-06-07', 'pending', '', '4', 'DR.MD.SHAFIQUR RAHMAN MBBS.FCPS.(SUR)MMCH', 'diagnosis', '08:21'), 
('900', '2021-06-07', '06:34:24 PM', '49908580837', '51954', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-06-07', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('901', '2021-06-07', '06:38:32 PM', '46343638085', '30573', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-06-07', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('902', '2021-06-07', '06:43:02 PM', '15326277621', '38257', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-06-07', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('903', '2021-06-07', '08:21:31 PM', '15704805817', '30605', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1350.00', '280.00', 'Flat', '1120.00', '1120.00', '50.00', '0.00', '1120.00', '2021-06-07', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('904', '2021-06-08', '12:01:46 PM', '56854931678', '21630', 'diagnosis', 'diagnosis', '2550.00', '0', '0.00', '2500.00', '0.00', 'Flat', '2550.00', '2000.00', '50.00', '550.00', '2000.00', '2021-06-08', 'pending', '', '8', 'Dr.Md. Sifat Jamil Tarek MBBS (DMC),BCS(Health),Medical Officer Gafargaon Upozilla Health Complex.', 'diagnosis', '08:21'), 
('905', '2021-06-08', '12:24:16 PM', '87820951061', '67680', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '300.00', 'Flat', '1600.00', '1500.00', '0.00', '100.00', '1500.00', '2021-06-08', 'pending', '', '8', 'MMCH', 'diagnosis', '08:21'), 
('906', '2021-06-08', '12:41:31 PM', '33231413778', '71578', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2750.00', '0.00', 'Flat', '2800.00', '1000.00', '50.00', '1800.00', '1000.00', '2021-06-08', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('907', '2021-06-08', '12:45:30 PM', '42287309964', '85031', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '900.00', '0.00', '300.00', '900.00', '2021-06-08', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('908', '2021-06-08', '01:01:47 PM', '74713632340', '29906', 'diagnosis', 'diagnosis', '3500.00', '0', '0.00', '3450.00', '500.00', 'Flat', '3000.00', '3000.00', '50.00', '0.00', '3000.00', '2021-06-08', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('909', '2021-06-08', '01:04:48 PM', '35799040769', '88769', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-08', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('910', '2021-06-08', '01:10:47 PM', '77353988918', '37363', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-08', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('911', '2021-06-08', '01:40:43 PM', '92625357707', '98887', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3000.00', '600.00', 'Flat', '2450.00', '2450.00', '50.00', '0.00', '2450.00', '2021-06-08', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('912', '2021-06-08', '02:42:58 PM', '94247433005', '35476', 'diagnosis', 'diagnosis', '3250.00', '0', '0.00', '3200.00', '0.00', 'Flat', '3250.00', '3250.00', '50.00', '0.00', '3250.00', '2021-06-08', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('913', '2021-06-08', '02:51:43 PM', '83320295562', '52953', 'diagnosis', 'diagnosis', '5450.00', '0', '0.00', '5400.00', '450.00', 'Flat', '5000.00', '2500.00', '50.00', '2500.00', '2500.00', '2021-06-08', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('914', '2021-06-08', '03:22:05 PM', '55929204200', '57620', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-06-08', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('915', '2021-06-08', '03:56:23 PM', '41344191961', '61795', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1600.00', '0.00', 'Flat', '1650.00', '500.00', '50.00', '1150.00', '500.00', '2021-06-08', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '2021-06-08'), 
('916', '2021-06-08', '03:59:53 PM', '46818912774', '70264', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2300.00', '650.00', 'Flat', '1700.00', '1000.00', '50.00', '700.00', '1000.00', '2021-06-08', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('917', '2021-06-08', '04:15:35 PM', '54764552497', '91688', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '600.00', '650.00', 'Flat', '0.00', '0.00', '50.00', '0.00', '0.00', '2021-06-08', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('918', '2021-06-08', '04:21:14 PM', '33234947836', '55947', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3000.00', '50.00', 'Flat', '3000.00', '1000.00', '50.00', '2000.00', '1000.00', '2021-06-08', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('919', '2021-06-08', '04:23:47 PM', '95318669329', '82529', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-06-08', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('920', '2021-06-08', '05:18:21 PM', '83032460262', '62147', 'diagnosis', 'diagnosis', '2600.00', '0', '0.00', '2550.00', '0.00', 'Flat', '2600.00', '2000.00', '50.00', '600.00', '2000.00', '2021-06-08', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('921', '2021-06-08', '05:36:49 PM', '61760254121', '64849', 'diagnosis', 'diagnosis', '3400.00', '0', '0.00', '3350.00', '0.00', 'Flat', '3400.00', '0.00', '50.00', '3400.00', '0.00', '2021-06-08', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('924', '2021-06-08', '07:01:17 PM', '73409735080', '86575', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-06-08', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('925', '2021-06-08', '07:15:05 PM', '43935151977', '25198', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '0.00', '0.00', '1000.00', '0.00', '2021-06-08', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('926', '2021-06-08', '08:17:37 PM', '16483027694', '81963', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1600.00', '150.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-06-08', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('928', '2021-06-09', '09:59:19 AM', '58430153876', '43325', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-06-09', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('929', '2021-06-09', '11:27:43 AM', '89549946991', '35245', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '1000.00', '0.00', '500.00', '1000.00', '2021-06-09', 'pending', '', '8', 'MMCH', 'diagnosis', '08:21'), 
('930', '2021-06-09', '11:33:59 AM', '13322892660', '13835', 'diagnosis', 'diagnosis', '4250.00', '0', '0.00', '4200.00', '0.00', 'Flat', '4250.00', '4250.00', '50.00', '0.00', '4250.00', '2021-06-09', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('931', '2021-06-09', '11:39:22 AM', '40502010368', '65311', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1900.00', '450.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-06-09', 'pending', '', '8', 'SELF', 'diagnosis', '08:21'), 
('932', '2021-06-09', '12:03:13 PM', '42175188081', '23478', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '900.00', '0.00', 'Flat', '950.00', '500.00', '50.00', '450.00', '500.00', '2021-06-09', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('933', '2021-06-09', '12:58:59 PM', '31744698186', '85647', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2850.00', '400.00', 'Flat', '2500.00', '2500.00', '50.00', '0.00', '2500.00', '2021-06-09', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('934', '2021-06-09', '01:27:19 PM', '38338158320', '64071', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-06-09', 'pending', '', '8', 'Life Care Hospital', 'diagnosis', '08:21'), 
('936', '2021-06-09', '02:45:33 PM', '69157824334', '27482', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-06-09', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('937', '2021-06-09', '03:08:14 PM', '30251916953', '93161', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '900.00', '250.00', 'Flat', '700.00', '700.00', '50.00', '0.00', '700.00', '2021-06-09', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('939', '2021-06-09', '03:41:10 PM', '54478239930', '38506', 'diagnosis', 'diagnosis', '5100.00', '0', '0.00', '5050.00', '100.00', 'Flat', '5000.00', '5000.00', '50.00', '0.00', '5000.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('940', '2021-06-09', '03:42:52 PM', '71516114059', '95765', 'diagnosis', 'diagnosis', '4250.00', '0', '0.00', '4200.00', '250.00', 'Flat', '4000.00', '4000.00', '50.00', '0.00', '4000.00', '2021-06-09', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('941', '2021-06-09', '03:44:33 PM', '61607051723', '39535', 'diagnosis', 'diagnosis', '3300.00', '0', '0.00', '3250.00', '0.00', 'Flat', '3300.00', '1000.00', '50.00', '2300.00', '1000.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('942', '2021-06-09', '03:47:54 PM', '78546318494', '34159', 'diagnosis', 'diagnosis', '5800.00', '0', '0.00', '5750.00', '0.00', 'Flat', '5800.00', '1500.00', '50.00', '4300.00', '1500.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('943', '2021-06-09', '03:51:03 PM', '15113539952', '61085', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '500.00', '0.00', '100.00', '500.00', '2021-06-09', 'pending', '', '4', 'SELF', 'diagnosis', '08:21'), 
('944', '2021-06-09', '03:53:43 PM', '59177684328', '95252', 'diagnosis', 'diagnosis', '3300.00', '0', '0.00', '3250.00', '0.00', 'Flat', '3300.00', '1500.00', '50.00', '1800.00', '1500.00', '2021-06-09', 'pending', '', '8', 'DR.FARID AL HASAN MBBS(DU)DLO(DU)MS-ENT(UK)MMCH', 'diagnosis', '08:21'), 
('945', '2021-06-09', '03:59:22 PM', '28922400292', '84055', 'diagnosis', 'diagnosis', '4250.00', '0', '0.00', '4200.00', '250.00', 'Flat', '4000.00', '4000.00', '50.00', '0.00', '4000.00', '2021-06-09', 'pending', '', '8', 'DR.FARID AL HASAN MBBS(DU)DLO(DU)MS-ENT(UK)MMCH', 'diagnosis', '08:21'), 
('946', '2021-06-09', '04:00:18 PM', '19408330528', '99767', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1500.00', '50.00', 'Flat', '1500.00', '1500.00', '50.00', '0.00', '1500.00', '2021-06-09', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('947', '2021-06-09', '04:16:44 PM', '42986626674', '79231', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2750.00', '550.00', 'Flat', '2250.00', '2250.00', '50.00', '0.00', '2250.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('948', '2021-06-09', '04:19:12 PM', '85174980180', '48533', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2450.00', '500.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('949', '2021-06-09', '04:19:36 PM', '69308436372', '84477', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-06-09', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('950', '2021-06-09', '04:30:39 PM', '66276575376', '24906', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3000.00', '350.00', 'Flat', '2700.00', '2700.00', '50.00', '0.00', '2700.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('951', '2021-06-09', '04:33:23 PM', '57043450284', '83290', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-06-09', 'pending', '', '4', 'PROTAP KUMAR PAUL MBBS BCS HEALTH', 'diagnosis', '08:21'), 
('952', '2021-06-09', '04:38:50 PM', '21472837817', '97841', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '1950.00', '400.00', 'Flat', '1600.00', '1600.00', '50.00', '0.00', '1600.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('953', '2021-06-09', '05:02:52 PM', '32266376912', '43979', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2300.00', '450.00', 'Flat', '1900.00', '1000.00', '50.00', '900.00', '1000.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('954', '2021-06-09', '05:20:50 PM', '82170833605', '58397', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-06-09', 'pending', '', '8', 'DR.TOWHIDL AHSAN KHAN MBBS.(DHAKA)BCS(H)D-CARD(DU)ASSI.PRO.MMCH', 'diagnosis', '08:21'), 
('955', '2021-06-09', '05:26:42 PM', '93433537458', '30800', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2900.00', '0.00', 'Flat', '2950.00', '2000.00', '50.00', '950.00', '2000.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('956', '2021-06-09', '05:29:27 PM', '84567495601', '73516', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-06-09', 'pending', '', '8', 'DR.MD.SHAFIQUR RAHMAN MBBS.FCPS.(SUR)MMCH', 'diagnosis', '08:21'), 
('957', '2021-06-09', '05:31:09 PM', '27777798349', '92401', 'diagnosis', 'diagnosis', '3500.00', '0', '0.00', '3450.00', '1500.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-06-09', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('958', '2021-06-09', '05:48:52 PM', '43853202379', '59805', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-06-09', 'pending', '', '4', 'DR.MD.SHOHEL RANA SHOHAG', 'diagnosis', '08:21'), 
('959', '2021-06-09', '06:20:40 PM', '55332766514', '96566', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-09', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('960', '2021-06-09', '06:31:49 PM', '12900000396', '35808', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-06-09', 'pending', '', '4', 'RAJDHANI HOSPITAL', 'diagnosis', '08:21'), 
('961', '2021-06-09', '06:41:11 PM', '28270662161', '79620', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-06-09', 'pending', '', '8', 'DR.MD.SHAFIQUR RAHMAN MBBS.FCPS.(SUR)MMCH', 'diagnosis', '08:21'), 
('962', '2021-06-09', '06:45:22 PM', '98824247924', '59509', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2750.00', '900.00', 'Flat', '1900.00', '1900.00', '50.00', '0.00', '1900.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('963', '2021-06-09', '06:59:05 PM', '12932182848', '54870', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '0.00', '0.00', '700.00', '0.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('964', '2021-06-09', '07:12:29 PM', '15620607013', '98276', 'diagnosis', 'diagnosis', '5650.00', '0', '0.00', '5600.00', '1700.00', 'Flat', '3950.00', '3950.00', '50.00', '0.00', '3950.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('965', '2021-06-09', '07:33:50 PM', '23503105383', '58037', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-06-09', 'pending', '', '8', '', 'diagnosis', '08:21'), 
('966', '2021-06-09', '08:11:04 PM', '16276063231', '83466', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1050.00', '300.00', 'Flat', '800.00', '800.00', '50.00', '0.00', '800.00', '2021-06-09', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('967', '2021-06-09', '08:48:25 PM', '38546429077', '47061', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-06-09', 'pending', '', '4', '', 'diagnosis', '08:21'), 
('968', '2021-06-09', '10:33:25 PM', '83310252717', '67889', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '0.00', 'Flat', '1550.00', '0.00', '0.00', '1550.00', '0.00', '2021-06-09', 'pending', '', '4', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('970', '2021-06-10', '10:19:24 AM', '43766184151', '20334', 'diagnosis', 'diagnosis', '2750.00', '0', '0.00', '2700.00', '1450.00', 'Flat', '1300.00', '1300.00', '50.00', '0.00', '1300.00', '2021-06-10', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('971', '2021-06-10', '10:28:30 AM', '55638226494', '18483', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2400.00', '0.00', 'Flat', '2450.00', '2450.00', '50.00', '0.00', '2450.00', '2021-06-10', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('972', '2021-06-10', '10:30:10 AM', '60329101193', '52772', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1750.00', '0.00', 'Flat', '1800.00', '1800.00', '50.00', '0.00', '1800.00', '2021-06-10', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('973', '2021-06-10', '11:22:37 AM', '19403343895', '56521', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '750.00', '200.00', 'Flat', '600.00', '600.00', '50.00', '0.00', '600.00', '2021-06-10', 'pending', '', '8', 'Rajdhani Hospital', 'diagnosis', '08:21'), 
('974', '2021-06-10', '', '2106100974', '0977', 'consultancy', '', '0.00', '0', '0.00', '600.00', '0.00', '', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-06-10', 'pending', '', '0', '', '', ''), 
('975', '2021-06-10', '03:35:35 PM', '95820241628', '23508', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '700.00', '0.00', 'Flat', '1200.00', '1000.00', '500.00', '200.00', '1200.00', '2021-06-10', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('976', '2021-06-10', '', '2106100976', '99943', 'diagnosis', 'diagnosis', '2060.00', '0', '0.00', '2060.00', '0.00', 'Flat', '2060.00', '2000.00', '0.00', '60.00', '2000.00', '2021-06-10', 'pending', '', '0', '', 'diagnosis', ''), 
('977', '2021-06-10', '04:01:41 PM', '11262717015', '46003', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', '0', '0.00', '0.00', '0.00', '0.00', '0.00', '0000-00-00', 'pending', '', '14', '0', 'diagnosis', '0'), 
('978', '2021-06-10', '04:02:52 PM', '51784366741', '68076', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-10', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('979', '2021-06-10', '06:59:51 PM', '77071880921', '27258', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '0.00', 'Flat', '200.00', '0.00', '0.00', '200.00', '0.00', '2021-06-10', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('980', '2021-06-16', '09:45:10 AM', '41719315863', '32459', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '0.00', 'Flat', '200.00', '0.00', '0.00', '200.00', '0.00', '2021-06-16', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('981', '2021-06-18', '06:09:42 PM', '45685376475', '43512', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-18', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('982', '2021-06-19', '10:44:34 AM', '94824318049', '62574', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '0.00', 'Flat', '200.00', '0.00', '0.00', '200.00', '0.00', '2021-06-19', 'pending', '', '1001', '', 'diagnosis', '08:21'), 
('983', '2021-06-19', '12:41:15 PM', '85019419466', '34889', 'diagnosis', 'diagnosis', '100.00', '0', '0.00', '100.00', '0.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-06-19', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('984', '2021-06-19', '02:02:13 PM', '52979600222', '37249', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-19', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('985', '2021-06-19', '02:14:27 PM', '88892753711', '59492', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-19', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('986', '2021-06-19', '02:23:16 PM', '90202009719', '12159', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-19', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('987', '2021-06-19', '02:35:09 PM', '82218104021', '25550', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '100.00', '0.00', '50.00', '100.00', '2021-06-19', 'pending', '', '1001', '', 'diagnosis', '08:21'), 
('988', '2021-06-19', '04:33:08 PM', '62122391247', '34311', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-06-19', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('989', '2021-06-19', '', '2106190989', '0992', 'consultancy', '', '0.00', '0', '0.00', '0.00', '0.00', '', '0.00', '1.00', '0.00', '-1.00', '1.00', '2021-06-19', 'pending', '', '0', '', '', ''), 
('990', '2021-06-19', '06:09:11 PM', '43920941981', '50243', 'diagnosis', 'diagnosis', '100.00', '0', '0.00', '100.00', '0.00', 'Flat', '100.00', '0.00', '0.00', '100.00', '0.00', '2021-06-19', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('991', '2021-06-20', '12:05:11 PM', '11310231106', '48142', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-20', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('992', '2021-06-21', '11:17:12 AM', '86317763146', '18955', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-06-21', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('993', '2021-06-21', '11:22:27 AM', '98770864928', '25885', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '1.00', '0.00', '149.00', '1.00', '2021-06-21', 'pending', '', '1001', '', 'diagnosis', '08:21'), 
('994', '2021-06-21', '11:23:03 AM', '43019663252', '51269', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-21', 'pending', '', '1001', '', 'diagnosis', '08:21'), 
('995', '2021-06-21', '01:41:17 PM', '96450671843', '43817', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '0.00', 'Flat', '850.00', '0.00', '0.00', '850.00', '0.00', '2021-06-21', 'pending', '', '14', 'Dr.Sowmitro', 'diagnosis', '08:21'), 
('996', '2021-06-21', '02:08:54 PM', '58087581892', '97285', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-06-21', 'pending', '', '14', 's', 'diagnosis', '08:21'), 
('997', '2021-06-21', '03:34:20 PM', '53582349999', '43773', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-21', 'pending', '', '14', 'Dr.Sowmitro', 'diagnosis', '08:21'), 
('999', '2021-06-22', '11:41:37 AM', '47494724517', '17131', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-06-22', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1000', '2021-06-22', '12:12:14 PM', '48205560818', '95041', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-06-22', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1001', '2021-06-22', '12:52:08 PM', '17779807829', '26074', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-22', 'pending', '', '14', 'Dr.Mohiuddin ahmed', 'diagnosis', '08:21'), 
('1002', '2021-06-22', '01:08:20 PM', '88113575345', '94565', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '0.00', 'Flat', '350.00', '0.00', '0.00', '350.00', '0.00', '2021-06-22', 'pending', '', '14', 'Dr.Sowmitro', 'diagnosis', '08:21'), 
('1003', '2021-06-23', '11:37:29 AM', '83451288317', '86763', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '0.00', '0.00', '1000.00', '0.00', '2021-06-23', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1004', '2021-06-23', '11:44:12 AM', '14253144752', '93434', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-06-23', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1005', '2021-06-23', '03:11:58 PM', '48942536736', '78529', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '0.00', 'Flat', '1250.00', '0.00', '0.00', '1250.00', '0.00', '2021-06-23', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1006', '2021-06-23', '05:59:14 PM', '86905251277', '36884', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '200.00', 'Flat', '2050.00', '1000.00', '0.00', '1050.00', '1000.00', '2021-06-23', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1007', '2021-06-23', '08:48:33 PM', '21742519694', '99712', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '50.00', 'Percentage', '575.00', '500.00', '0.00', '75.00', '500.00', '2021-06-23', 'pending', '', '14', 'Dr. Masud Ahmed Sohel', 'diagnosis', '09:00'), 
('1008', '2021-06-24', '11:54:28 AM', '55402182622', '19263', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-06-24', 'pending', '', '14', 'Dr.test', 'diagnosis', '08:21'), 
('1009', '2021-06-26', '11:12:55 AM', '20877861065', '93941', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '0.00', '0.00', '1000.00', '0.00', '2021-06-26', 'pending', '', '14', 'Dr.Sowmitro Shaha MBBS,BCS,FCPS', 'diagnosis', '08:21'), 
('1010', '2021-06-26', '11:21:36 AM', '33827060667', '96097', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-26', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1011', '2021-06-26', '11:22:52 AM', '79454407013', '91067', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-06-26', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1012', '2021-06-26', '11:48:07 AM', '30979107982', '53378', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-26', 'pending', '', '1001', 'qqqqqqqqqqqqqqqqqqqqqqqqqq', 'diagnosis', '08:21'), 
('1013', '2021-06-26', '12:11:19 PM', '12028274188', '57911', 'diagnosis', 'diagnosis', '4950.00', '0', '0.00', '4950.00', '0.00', 'Flat', '4950.00', '0.00', '0.00', '4950.00', '0.00', '2021-06-26', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1014', '2021-06-26', '12:14:51 PM', '68097896542', '43195', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '0.00', 'Flat', '350.00', '0.00', '0.00', '350.00', '0.00', '2021-06-26', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1015', '2021-06-26', '12:18:08 PM', '59621598902', '75252', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-06-26', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1016', '2021-06-26', '12:40:47 PM', '82768408333', '76288', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-06-26', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1017', '2021-06-26', '02:36:35 PM', '87037239347', '35289', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-06-26', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1022', '2021-06-26', '03:53:54 PM', '20210626001', '95564', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-26', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1023', '2021-06-26', '04:21:09 PM', '20210626002', '80044', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-26', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1025', '2021-06-26', '05:07:09 PM', '20210626003', '30714', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-06-26', 'pending', '', '1001', 'qqqqqqqqqqqqqqqqqqqqqqqqqq', 'diagnosis', '08:21'), 
('1026', '2021-06-26', '06:05:15 PM', '20210626004', '46227', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '0.00', 'Flat', '2050.00', '0.00', '0.00', '2050.00', '0.00', '2021-06-26', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1027', '2021-06-27', '10:52:22 AM', '20210627001', '44625', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '0.00', 'Flat', '350.00', '0.00', '0.00', '350.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1028', '2021-06-27', '11:10:42 AM', '20210627002', '75043', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '0.00', 'Flat', '1150.00', '0.00', '0.00', '1150.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '08:21'), 
('1029', '2021-06-27', '11:26:56 AM', '20210627003', '75251', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '0.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-06-27', 'pending', '', '14', 'fd', 'diagnosis', '08:21'), 
('1030', '2021-06-27', '12:02:03 PM', '20210627004', '20362', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-06-27', 'pending', '', '1001', 'Dr.Shamim Haque', 'diagnosis', '2021-06-27 08:00 AM'), 
('1031', '2021-06-27', '12:05:21 PM', '20210627005', '63329', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27  12:00:00 AM'), 
('1032', '2021-06-27', '12:19:22 PM', '20210627006', '18012', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '0.00', 'Flat', '200.00', '0.00', '0.00', '200.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27 08:00 AM'), 
('1033', '2021-06-27', '12:35:30 PM', '20210627007', '30369', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27 08:00 AM'), 
('1034', '2021-06-27', '12:55:02 PM', '20210627008', '38030', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '0.00', 'Flat', '350.00', '0.00', '0.00', '350.00', '0.00', '2021-06-27', 'pending', '', '1001', 'Dr.Shamim Haque', 'diagnosis', '2021-06-27 08:00 AM'), 
('1035', '2021-06-27', '01:23:29 PM', '20210627009', '11880', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27 08:00 AM'), 
('1036', '2021-06-27', '02:17:33 PM', '20210627010', '77760', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27 08:00 PM'), 
('1037', '2021-06-27', '03:26:36 PM', '20210627011', '93620', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27 08:00 PM'), 
('1038', '2021-06-27', '03:31:58 PM', '20210627012', '95486', 'diagnosis', 'diagnosis', '5000.00', '0', '0.00', '5000.00', '0.00', 'Flat', '5000.00', '0.00', '0.00', '5000.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27 08:00 PM'), 
('1039', '2021-06-27', '04:08:37 PM', '20210627013', '93663', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '0.00', 'Flat', '350.00', '0.00', '0.00', '350.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27 08:00 PM'), 
('1040', '2021-06-27', '04:57:41 PM', '20210627014', '25442', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27 08:00 PM'), 
('1041', '2021-06-27', '05:05:04 PM', '20210627015', '19552', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27 08:00 PM'), 
('1042', '2021-06-27', '06:38:14 PM', '20210627016', '51328', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27 08:00 PM'), 
('1043', '2021-06-27', '07:34:29 PM', '20210627017', '87887', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27 08:00 PM'), 
('1044', '2021-06-27', '08:20:02 PM', '20210627018', '26463', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '0.00', 'Flat', '2250.00', '1000.00', '0.00', '1250.00', '1000.00', '2021-06-27', 'pending', '', '14', '', 'diagnosis', '2021-06-27 08:00 PM'), 
('1045', '2021-06-28', '10:23:35 AM', '20210628001', '79246', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '0.00', '0.00', '1000.00', '0.00', '2021-06-28', 'pending', '', '1001', 'Dr.Shamim Haque', 'diagnosis', '2021-06-28 08:00 PM'), 
('1046', '2021-06-28', '10:26:33 AM', '20210628002', '95632', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '100.00', '0.00', '900.00', '100.00', '2021-06-28', 'pending', '', '1001', 'Dr.Shamim Haque', 'diagnosis', '2021-06-28 08:00 PM'), 
('1047', '2021-06-28', '10:31:31 AM', '20210628003', '60316', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-06-28', 'pending', '', '1001', '', 'diagnosis', '2021-06-28 08:00 PM'), 
('1048', '2021-06-28', '11:44:57 AM', '20210628004', '22247', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-06-28', 'pending', '', '14', '', 'diagnosis', '2021-06-28 08:00 PM'), 
('1049', '2021-06-28', '11:45:52 AM', '20210628005', '18965', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-06-28', 'pending', '', '14', '', 'diagnosis', '2021-06-28 08:00 PM'), 
('1050', '2021-06-28', '12:07:35 PM', '20210628006', '36887', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-06-28', 'pending', '', '1001', 'Dr.Shamim Haque', 'diagnosis', '2021-06-28 08:00 PM'), 
('1051', '2021-06-28', '12:50:47 PM', '20210628007', '78841', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-06-28', 'pending', '', '1001', 'Dr.Shamim Haque', 'diagnosis', '2021-06-28 08:00 PM'), 
('1052', '2021-06-28', '02:14:58 PM', '20210628008', '32273', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '0.00', 'Flat', '2250.00', '2250.00', '0.00', '0.00', '2250.00', '2021-06-28', 'pending', '', '14', '', 'diagnosis', '2021-06-28 08:00 PM'), 
('1053', '2021-06-28', '02:47:13 PM', '20210628009', '71511', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '50.00', '0.00', '250.00', '50.00', '2021-06-28', 'pending', '', '1001', 'Dr.Shamim Haque', 'diagnosis', '2021-06-28 08:00 PM'), 
('1054', '2021-06-28', '04:17:14 PM', '20210628010', '84158', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-06-28', 'pending', '', '14', '', 'diagnosis', '2021-06-28 08:00 PM'), 
('1055', '2021-06-29', '07:25:30 PM', '20210629001', '46335', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '0.00', 'Flat', '350.00', '0.00', '0.00', '350.00', '0.00', '2021-06-29', 'pending', '', '14', '', 'diagnosis', '2021-06-29 08:00 PM'), 
('1056', '2021-06-30', '03:38:06 PM', '20210630001', '73021', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '0.00', '0.00', '1000.00', '0.00', '2021-06-30', 'pending', '', '14', '', 'diagnosis', '2021-06-30 08:00 PM'), 
('1057', '2021-07-03', '02:22:11 PM', '20210703001', '25344', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '0.00', 'Flat', '1750.00', '0.00', '0.00', '1750.00', '0.00', '2021-07-03', 'pending', '', '14', '', 'diagnosis', '2021-07-03 08:00 PM'), 
('1058', '2021-07-07', '04:05:53 PM', '20210707001', '92108', 'diagnosis', 'diagnosis', '3100.00', '0', '0.00', '3100.00', '0.00', 'Flat', '3100.00', '0.00', '0.00', '3100.00', '0.00', '2021-07-07', 'pending', '', '14', '', 'diagnosis', '2021-07-07 08:00 PM'), 
('1059', '2021-07-16', '05:38:40 PM', '20210716001', '98976', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '0.00', 'Flat', '1950.00', '0.00', '0.00', '1950.00', '0.00', '2021-07-16', 'pending', '', '14', '', 'diagnosis', '2021-07-16 08:00 PM'), 
('1060', '2021-07-24', '06:52:14 PM', '20210724001', '80904', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '0.00', 'Flat', '2100.00', '0.00', '0.00', '2100.00', '0.00', '2021-07-24', 'pending', '', '14', '', 'diagnosis', '2021-07-24 08:00 PM'), 
('1061', '2021-07-30', '', '2107301061', '0001064', 'consultancy', '', '0.00', '0', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-07-30', 'pending', '', '0', '', '', ''), 
('1062', '2021-07-30', '01:07:20 PM', '20210730001', '11158', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '0.00', 'Flat', '1600.00', '0.00', '0.00', '1600.00', '0.00', '2021-07-30', 'pending', '', '14', '', 'diagnosis', '2021-07-30 08:00 PM'), 
('1063', '2021-08-03', '03:54:06 PM', '20210803001', '89478', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-08-03', 'pending', '', '15', '', 'diagnosis', '2021-08-03 08:00 PM'), 
('1064', '2021-08-03', '04:35:43 PM', '20210803002', '18901', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-08-03', 'pending', '', '15', '', 'diagnosis', '2021-08-03 08:00 PM'), 
('1065', '2021-08-03', '06:27:59 PM', '20210803003', '67800', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1900.00', '0.00', '0.00', '1900.00', '0.00', '2021-08-03', 'pending', '', '15', '', 'diagnosis', '2021-08-03 08:00 PM'), 
('1066', '2021-08-04', '11:17:15 AM', '20210804001', '92745', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-04', 'pending', '', '15', '', 'diagnosis', '2021-08-04 08:00 PM'), 
('1067', '2021-08-04', '12:18:40 PM', '20210804002', '22919', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '0.00', '0.00', '600.00', '0.00', '2021-08-04', 'pending', '', '15', '', 'diagnosis', '2021-08-04 08:00 PM'), 
('1068', '2021-08-04', '02:09:43 PM', '20210804003', '35418', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '0.00', '0.00', '1000.00', '0.00', '2021-08-04', 'pending', '', '15', '', 'diagnosis', '2021-08-04 08:00 PM'), 
('1069', '2021-08-04', '03:10:00 PM', '20210804004', '22083', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '0.00', '0.00', '1300.00', '0.00', '2021-08-04', 'pending', '', '15', '', 'diagnosis', '2021-08-04 08:00 PM'), 
('1070', '2021-08-04', '05:05:06 PM', '20210804005', '28258', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-08-04', 'pending', '', '15', 'Dr.Suayeb Akter MBBS,BCS,FCPS', 'diagnosis', '2021-08-04 08:00 PM'), 
('1071', '2021-08-04', '07:20:18 PM', '20210804006', '38468', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-04', 'pending', '', '15', '', 'diagnosis', '2021-08-04 08:00 PM'), 
('1072', '2021-08-04', '08:47:33 PM', '20210804007', '74695', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-04', 'pending', '', '15', '', 'diagnosis', '2021-08-04 08:00 PM'), 
('1073', '2021-08-05', '11:08:06 AM', '20210805001', '24101', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-05', 'pending', '', '15', 'Self', 'diagnosis', '2021-08-05 08:00 PM'), 
('1074', '2021-08-05', '11:21:00 AM', '20210805002', '68429', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-05', 'pending', '', '15', 'Self', 'diagnosis', '2021-08-05 08:00 PM'), 
('1075', '2021-08-05', '11:21:48 AM', '20210805003', '87671', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-08-05', 'pending', '', '15', 'Self', 'diagnosis', '2021-08-05 08:00 PM'), 
('1076', '2021-08-05', '11:22:28 AM', '20210805004', '26128', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-05', 'pending', '', '15', '', 'diagnosis', '2021-08-05 08:00 PM'), 
('1077', '2021-08-08', '11:53:47 AM', '20210808001', '13056', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '0.00', 'Flat', '1700.00', '0.00', '0.00', '1700.00', '0.00', '2021-08-08', 'pending', '', '15', 'Dr.Suayeb Akter MBBS,BCS,FCPS', 'diagnosis', '2021-08-08 08:00 PM'), 
('1078', '2021-08-08', '12:16:09 PM', '20210808002', '12353', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-08', 'pending', '', '15', 'Self', 'diagnosis', '2021-08-08 08:00 PM'), 
('1079', '2021-08-08', '03:35:42 PM', '20210808003', '80401', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '0.00', '0.00', '950.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1080', '2021-08-08', '03:39:25 PM', '20210808004', '46514', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1050.00', '0.00', '0.00', '1050.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1081', '2021-08-08', '03:45:30 PM', '20210808005', '80492', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1082', '2021-08-08', '03:46:11 PM', '20210808006', '66673', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '0.00', 'Flat', '1150.00', '0.00', '0.00', '1150.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1083', '2021-08-08', '03:46:50 PM', '20210808007', '65055', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1084', '2021-08-08', '03:47:33 PM', '20210808008', '91598', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '0.00', 'Flat', '1100.00', '0.00', '0.00', '1100.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1085', '2021-08-08', '03:48:13 PM', '20210808009', '55517', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1086', '2021-08-08', '03:55:38 PM', '20210808010', '56137', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1087', '2021-08-08', '04:13:27 PM', '20210808011', '17986', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '0.00', 'Flat', '1100.00', '0.00', '0.00', '1100.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1088', '2021-08-08', '04:15:32 PM', '20210808012', '92556', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1089', '2021-08-08', '04:16:01 PM', '20210808013', '20496', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1090', '2021-08-08', '04:17:04 PM', '20210808014', '88070', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1091', '2021-08-08', '04:17:43 PM', '20210808015', '67139', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1092', '2021-08-08', '04:18:17 PM', '20210808016', '53204', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-08', 'pending', '', '15', 'Self', 'diagnosis', '2021-08-08 08:00 PM'), 
('1093', '2021-08-08', '04:57:53 PM', '20210808017', '63524', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-08', 'pending', '', '15', 'Dr.Azharul Korim Akhib MBBS,PGT', 'diagnosis', '2021-08-08 08:00 PM'), 
('1094', '2021-08-08', '04:58:25 PM', '20210808018', '60353', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1095', '2021-08-08', '04:59:22 PM', '20210808019', '40846', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-08-08', 'pending', '', '15', 'Dr.Morzina LMAF', 'diagnosis', '2021-08-08 08:00 PM'), 
('1096', '2021-08-08', '04:59:56 PM', '20210808020', '92952', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-08', 'pending', '', '15', 'Dr.Azharul Korim Akhib MBBS,PGT', 'diagnosis', '2021-08-08 08:00 PM'), 
('1097', '2021-08-08', '05:03:52 PM', '20210808021', '51278', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1050.00', '0.00', '0.00', '1050.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1098', '2021-08-08', '05:05:04 PM', '20210808022', '57387', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '0.00', 'Flat', '750.00', '0.00', '0.00', '750.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1099', '2021-08-08', '05:26:20 PM', '20210808023', '84910', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1100', '2021-08-08', '05:29:59 PM', '20210808024', '19404', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-08-08', 'pending', '', '15', 'Self', 'diagnosis', '2021-08-08 08:00 PM'), 
('1101', '2021-08-08', '05:31:07 PM', '20210808025', '38795', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1102', '2021-08-08', '06:09:29 PM', '20210808026', '26724', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1103', '2021-08-08', '06:10:19 PM', '20210808027', '44737', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1104', '2021-08-08', '06:18:36 PM', '20210808028', '71962', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1050.00', '0.00', '0.00', '1050.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1105', '2021-08-08', '06:19:39 PM', '20210808029', '19685', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1106', '2021-08-08', '06:20:18 PM', '20210808030', '87191', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-08-08', 'pending', '', '15', '', 'diagnosis', '2021-08-08 08:00 PM'), 
('1107', '2021-08-09', '02:14:27 PM', '20210809001', '45531', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-08-09', 'pending', '', '15', '', 'diagnosis', '2021-08-09 08:00 PM'), 
('1108', '2021-08-10', '05:39:37 PM', '20210810001', '12761', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1109', '2021-08-10', '05:57:00 PM', '20210810002', '27939', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1110', '2021-08-10', '05:57:48 PM', '20210810003', '51442', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1111', '2021-08-10', '06:10:55 PM', '20210810004', '23381', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1112', '2021-08-10', '06:14:32 PM', '20210810005', '73086', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1113', '2021-08-10', '06:32:36 PM', '20210810006', '80864', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1114', '2021-08-10', '06:34:10 PM', '20210810007', '39375', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1115', '2021-08-10', '06:36:40 PM', '20210810008', '55727', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1116', '2021-08-10', '07:16:03 PM', '20210810009', '14027', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1117', '2021-08-10', '07:53:56 PM', '20210810010', '98622', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '700.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1118', '2021-08-10', '08:01:32 PM', '20210810011', '89487', 'diagnosis', 'diagnosis', '2750.00', '0', '0.00', '2750.00', '0.00', 'Flat', '2750.00', '0.00', '0.00', '2750.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1119', '2021-08-11', '10:05:02 AM', '20210811001', '72160', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1120', '2021-08-11', '10:32:53 AM', '20210811002', '87927', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1122', '2021-08-11', '11:00:21 AM', '20210811004', '83705', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-11', 'pending', '', '15', 'self', 'diagnosis', '2021-08-11 08:00 PM'), 
('1123', '2021-08-11', '11:01:42 AM', '20210811005', '14836', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-11', 'pending', '', '15', 'self', 'diagnosis', '2021-08-11 08:00 PM'), 
('1124', '2021-08-11', '11:06:40 AM', '20210811006', '51413', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1125', '2021-08-11', '11:13:07 AM', '20210811007', '40360', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '200.00', '0.00', '350.00', '200.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1126', '2021-08-11', '11:19:26 AM', '20210811008', '12007', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1127', '2021-08-11', '11:26:20 AM', '20210811009', '33490', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '400.00', '0.00', '150.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1128', '2021-08-11', '11:30:07 AM', '20210811010', '85397', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1129', '2021-08-11', '11:32:44 AM', '20210811011', '47245', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '350.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1131', '2021-08-11', '11:56:26 AM', '20210811013', '56857', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '5.00', '0.00', '45.00', '5.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1133', '2021-08-11', '11:59:41 AM', '20210811015', '47331', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1135', '2021-08-11', '12:03:58 PM', '20210811017', '51117', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1136', '2021-08-11', '12:09:24 PM', '20210811018', '75723', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1137', '2021-08-11', '12:17:47 PM', '20210811019', '78898', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '200.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1138', '2021-08-11', '12:29:20 PM', '20210811020', '01140', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '600.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1139', '2021-08-11', '12:31:52 PM', '20210811021', '01142', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1140', '2021-08-11', '12:34:27 PM', '20210811012', '01143', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1142', '2021-08-11', '12:35:54 PM', '20210811016', '01145', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1145', '2021-08-11', '12:37:53 PM', '20210811014', '01148', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1146', '2021-08-11', '12:42:09 PM', '20210811022', '01149', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '450.00', 'Flat', '1500.00', '500.00', '0.00', '1000.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1147', '2021-08-11', '12:46:15 PM', '20210811003', '01150', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1148', '2021-08-11', '12:48:15 PM', '20210811023', '01151', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1149', '2021-08-11', '12:52:03 PM', '20210811024', '01152', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '0.00', '790.00', '0.00', '0.00', '790.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1150', '2021-08-11', '12:54:07 PM', '20210811025', '01153', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1151', '2021-08-11', '12:56:26 PM', '20210811026', '01154', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '650.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1152', '2021-08-11', '12:57:23 PM', '20210811027', '01155', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1153', '2021-08-11', '01:57:52 PM', '20210811028', '01156', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '600.00', '0.00', '600.00', '600.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1154', '2021-08-11', '02:11:22 PM', '20210811029', '01157', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1155', '2021-08-11', '02:28:51 PM', '20210811030', '01158', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1156', '2021-08-11', '03:13:18 PM', '20210811031', '01159', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1157', '2021-08-11', '03:37:12 PM', '20210811032', '01160', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1158', '2021-08-11', '03:54:56 PM', '20210811033', '01161', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '0.00', '0.00', '50.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1159', '2021-08-11', '03:56:44 PM', '20210811034', '01162', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1160', '2021-08-11', '03:58:55 PM', '20210811035', '01163', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1161', '2021-08-11', '04:04:03 PM', '20210811036', '01164', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '20.00', 'Flat', '330.00', '0.00', '0.00', '330.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1162', '2021-08-11', '04:08:14 PM', '20210811037', '01165', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '200.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1163', '2021-08-11', '04:15:49 PM', '20210811038', '01166', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1164', '2021-08-11', '04:19:59 PM', '20210811039', '01167', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1165', '2021-08-11', '04:23:59 PM', '20210811040', '01168', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '350.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1166', '2021-08-11', '04:28:10 PM', '20210811041', '01169', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1167', '2021-08-11', '04:30:54 PM', '20210811042', '01170', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '150.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM');  



INSERT INTO `bonus` ( `id`, `created`, `bonus_date`, `emp_id`, `bonus`, `trash`) VALUES 
('1', '2021-06-10', '2021-06-30', '21001', '50.00', '0');  



 



 



 



 



 



 



INSERT INTO `consultancies` ( `id`, `date`, `pid`, `doctor`, `reference_name`, `room`, `notes`, `bill`, `status`) VALUES 
('1', '2021-04-18', '0002', '2', '3', '205', '', '2', 'pending'), 
('2', '2021-04-18', '0004', '2', '3', '205', '', '4', 'pending'), 
('3', '2021-04-20', '0006', '2', '1', '205', '', '6', 'pending'), 
('4', '2021-04-20', '0008', '2', '4', '205', '', '8', 'pending'), 
('5', '2021-06-10', '0977', '42', '110', '106', '', '974', 'pending'), 
('6', '2021-06-19', '0992', '12', '17', '', '', '989', 'pending'), 
('7', '2021-07-30', '0001064', '44', '112', '', '', '1061', 'pending');  



INSERT INTO `cost` ( `id`, `date`, `cost_field`, `description`, `amount`, `spend_by`, `trash`) VALUES 
('1', '2021-04-20', '0001', 'gsd', '100000', 'gdass', '0'), 
('2', '0000-00-00', '0', '0', '0', '0', '0'), 
('3', '2021-06-10', '0002', 'bill', '2500', 'Mamun', '0'), 
('4', '2021-06-10', '0003', 'Bill', '23000', 'Bkbor', '0'), 
('5', '2021-06-23', '0003', 'নাস্তা ', '50', 'হোটেল', '0');  



INSERT INTO `cost_bill` ( `id`, `patient_id`, `voucher`, `bill_by`, `total_qty`, `grand_total`, `trash`, `date`) VALUES 
('1', '1', '000001', 'fff', '1.00', '5000.00', '0', '2021-04-25'), 
('3', '2', '000002', '', '5.00', '25000.00', '0', '2021-06-10');  



INSERT INTO `cost_bill_items` ( `id`, `voucher`, `item_id`, `price`, `quantity`, `total`, `trash`) VALUES 
('1', '000001', '1', '5000.00', '1.00', '5000.00', '0'), 
('3', '000002', '1', '5000.00', '5.00', '25000.00', '0');  



INSERT INTO `cost_field` ( `id`, `code`, `cost_field`, `trash`) VALUES 
('1', '0001', 'Hospital Cost', '0'), 
('2', '0002', 'eletracity ', '0'), 
('3', '0003', 'Doctor Cost', '0');  



 



 



 



INSERT INTO `designations` ( `id`, `created_at`, `designation_name`, `trash`) VALUES 
('1', '2020-11-19', 'Managing Director', '0'), 
('2', '2020-11-07', 'Manager', '1'), 
('3', '2020-11-08', 'Labourer', '1'), 
('4', '2020-11-16', 'operator', '1'), 
('5', '2020-11-19', 'Laboratory Technician ', '0'), 
('6', '2020-11-19', 'Nurse', '0'), 
('7', '2020-11-19', 'O.T. Specialist ', '0'), 
('8', '2020-11-19', 'Nurse Maid', '0'), 
('9', '2020-11-19', 'Night Guard ', '0'), 
('10', '2021-06-24', 'Receptionist', '0');  



INSERT INTO `diagnosis` ( `id`, `date`, `delivery`, `pid`, `name`, `group_id`, `test_id`, `gender`, `reference_name`, `refereed_doctor`, `group`, `room`, `result`, `alt_doctor_id`, `alt_doctor_fee`, `remarks`, `amount`, `cost`, `bill`, `user_id`, `status`) VALUES 
('1', '2021-04-05', '2021-04-05', '00001', '', '35', '72', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '1', '', 'pending'), 
('2', '2021-04-05', '2021-04-05', '00001', '', '36', '76', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '1', '', 'pending'), 
('3', '2021-04-05', '2021-04-05', '00001', '', '45', '101', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '1', '', 'pending'), 
('4', '2021-04-05', '2021-04-05', '00001', '', '92', '153', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '1', '', 'pending'), 
('5', '2021-04-18', '2021-04-18', '0002', '', '35', '75', '', '3', '2', '', '', '', '0', '0.00', '', '0.00', '0.00', '3', '', 'pending'), 
('6', '2021-04-18', '2021-04-18', '0002', '', '35', '75', '', '3', '2', '', '', '', '0', '0.00', '', '0.00', '0.00', '3', '', 'pending'), 
('7', '2021-04-18', '2021-04-18', '0002', '', '35', '75', '', '3', '2', '', '', '', '0', '0.00', '', '0.00', '0.00', '3', '', 'pending'), 
('8', '2021-04-18', '2021-04-18', '0004', '', '35', '73', '', '4', '2', '', '', '', '0', '0.00', '', '0.00', '0.00', '5', '', 'pending'), 
('9', '2021-04-18', '2021-04-18', '0004', '', '35', '74', '', '4', '2', '', '', '', '0', '0.00', '', '0.00', '0.00', '5', '', 'pending'), 
('10', '2021-04-20', '2021-04-20', '0006', '', '35', '107', '', '4', '2', '', '', '', '0', '0.00', '', '0.00', '0.00', '7', '', 'pending'), 
('11', '2021-04-20', '2021-04-20', '0006', '', '35', '73', '', '4', '2', '', '', '', '0', '0.00', '', '0.00', '0.00', '7', '', 'pending'), 
('12', '2021-04-20', '2021-04-20', '0006', '', '35', '75', '', '4', '2', '', '', '', '0', '0.00', '', '0.00', '0.00', '7', '', 'pending'), 
('13', '2021-04-20', '2021-04-20', '00002', '', '36', '76', '', '3', '3', '', '', '', '0', '0.00', '', '0.00', '0.00', '12', '', 'pending'), 
('14', '2021-04-20', '2021-04-20', '00002', '', '35', '72', '', '3', '3', '', '', '', '0', '0.00', '', '0.00', '0.00', '13', '', 'pending'), 
('15', '2021-04-20', '2021-04-20', '00002', '', '36', '76', '', '3', '3', '', '', '', '0', '0.00', '', '0.00', '0.00', '14', '', 'pending'), 
('16', '2021-04-20', '2021-04-20', '00003', '', '36', '77', '', '3', '3', '', '', '', '0', '0.00', '', '0.00', '0.00', '15', '', 'pending'), 
('17', '2021-04-20', '2021-04-20', '00004', '', '36', '78', '', '3', '3', '', '', '', '0', '0.00', '', '0.00', '0.00', '16', '', 'pending'), 
('18', '2021-04-21', '2021-04-21', '00005', '', '39', '87', '', '3', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '19', '', 'pending'), 
('19', '2021-04-22', '2021-04-23', '00006', '', '45', '101', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '23', '', 'pending'), 
('20', '2021-04-22', '2021-04-23', '00006', '', '36', '102', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '23', '', 'pending'), 
('21', '2021-04-22', '2021-04-23', '00006', '', '39', '98', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '23', '', 'pending'), 
('22', '2021-04-22', '2021-04-23', '00006', '', '55', '120', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '23', '', 'pending'), 
('23', '2021-04-22', '2021-04-23', '00006', '', '51', '117', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '23', '', 'pending'), 
('24', '2021-04-22', '2021-04-23', '00006', '', '42', '95', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '23', '', 'pending'), 
('25', '2021-04-22', '2021-04-23', '00006', '', '37', '79', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '23', '', 'pending'), 
('26', '2021-04-22', '2021-04-22', '00007', '', '36', '77', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '24', '', 'pending'), 
('27', '2021-04-22', '2021-04-22', '00007', '', '35', '75', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '24', '', 'pending'), 
('28', '2021-04-22', '2021-04-22', '00007', '', '36', '78', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '24', '', 'pending'), 
('29', '2021-04-22', '2021-04-22', '00008', '', '35', '72', '', '2', '3', '', '', '', '0', '0.00', '', '0.00', '0.00', '25', '', 'pending'), 
('30', '2021-04-22', '2021-04-22', '00008', '', '45', '101', '', '2', '3', '', '', '', '0', '0.00', '', '0.00', '0.00', '25', '', 'pending'), 
('31', '2021-04-22', '2021-04-22', '00008', '', '36', '102', '', '2', '3', '', '', '', '0', '0.00', '', '0.00', '0.00', '25', '', 'pending'), 
('32', '2021-04-22', '2021-04-22', '00008', '', '40', '105', '', '2', '3', '', '', '', '0', '0.00', '', '0.00', '0.00', '25', '', 'pending'), 
('33', '2021-04-22', '2021-04-22', '00009', '', '35', '74', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '26', '', 'pending'), 
('34', '2021-04-22', '2021-04-22', '00009', '', '36', '78', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '26', '', 'pending'), 
('35', '2021-04-22', '2021-04-22', '00010', '', '35', '73', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '27', '', 'pending'), 
('36', '2021-04-22', '2021-04-22', '00010', '', '36', '78', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '27', '', 'pending'), 
('37', '2021-04-22', '2021-04-22', '00010', '', '36', '77', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '27', '', 'pending'), 
('38', '2021-04-22', '2021-04-22', '00010', '', '40', '105', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '27', '', 'pending'), 
('39', '2021-04-22', '2021-04-22', '00010', '', '56', '121', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '27', '', 'pending'), 
('40', '2021-04-22', '2021-04-22', '00010', '', '36', '76', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '28', '', 'pending'), 
('41', '2021-04-22', '2021-04-22', '00010', '', '37', '79', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '28', '', 'pending'), 
('42', '2021-04-22', '2021-04-22', '00010', '', '36', '82', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '28', '', 'pending'), 
('43', '2021-04-22', '2021-04-22', '00010', '', '39', '97', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '28', '', 'pending'), 
('44', '2021-04-22', '2021-04-22', '00011', '', '45', '101', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '29', '', 'pending'), 
('45', '2021-04-22', '2021-04-22', '00012', '', '35', '74', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '30', '', 'pending'), 
('46', '2021-04-22', '2021-04-22', '00012', '', '45', '101', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '31', '', 'pending'), 
('47', '2021-04-22', '2021-04-22', '00012', '', '36', '82', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '31', '', 'pending'), 
('48', '2021-04-22', '2021-04-22', '00012', '', '36', '78', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '31', '', 'pending'), 
('49', '2021-04-22', '2021-04-22', '00012', '', '42', '146', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '31', '', 'pending'), 
('50', '2021-04-22', '2021-04-22', '00012', '', '39', '96', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '31', '', 'pending'), 
('51', '2021-04-22', '2021-04-22', '00012', '', '61', '125', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '31', '', 'pending'), 
('52', '2021-04-22', '2021-04-22', '00012', '', '39', '98', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '31', '', 'pending'), 
('53', '2021-04-22', '2021-04-22', '00013', '', '35', '74', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '32', '', 'pending'), 
('54', '2021-04-22', '2021-04-22', '00014', '', '36', '78', '', '1', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '33', '', 'pending'), 
('55', '2021-04-22', '2021-04-22', '00014', '', '35', '75', '', '1', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '33', '', 'pending'), 
('56', '2021-04-22', '2021-04-22', '00014', '', '36', '80', '', '1', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '33', '', 'pending'), 
('57', '2021-04-22', '2021-04-22', '00014', '', '35', '75', '', '1', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '33', '', 'pending'), 
('58', '2021-04-22', '2021-04-22', '00014', '', '35', '73', '', '1', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '33', '', 'pending'), 
('59', '2021-04-22', '2021-04-22', '00015', '', '45', '101', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '34', '', 'pending'), 
('60', '2021-04-22', '2021-04-22', '00015', '', '36', '78', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '34', '', 'pending'), 
('61', '2021-04-22', '2021-04-22', '00015', '', '42', '146', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '34', '', 'pending'), 
('62', '2021-04-22', '2021-04-22', '00016', '', '35', '73', '', '1', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '35', '', 'pending'), 
('63', '2021-04-24', '2021-04-24', '00017', '', '35', '73', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '36', '', 'pending'), 
('64', '2021-04-24', '2021-04-24', '00017', '', '36', '78', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '36', '', 'pending'), 
('65', '2021-04-24', '2021-04-24', '00017', '', '36', '77', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '36', '', 'pending'), 
('66', '2021-04-24', '2021-04-24', '00017', '', '36', '76', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '36', '', 'pending'), 
('67', '2021-04-24', '2021-04-24', '00017', '', '45', '101', '', '1', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '37', '', 'pending'), 
('68', '2021-04-24', '2021-04-24', '00017', '', '36', '82', '', '1', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '37', '', 'pending'), 
('69', '2021-04-24', '2021-04-24', '00017', '', '41', '90', '', '1', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '37', '', 'pending'), 
('70', '2021-04-24', '2021-04-24', '00021', '', '36', '77', '', '5', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '41', '17', 'pending'), 
('71', '2021-04-24', '2021-04-24', '00021', '', '36', '78', '', '5', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '41', '17', 'pending'), 
('72', '2021-04-24', '2021-04-24', '00021', '', '36', '82', '', '5', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '41', '17', 'pending'), 
('73', '2021-04-24', '2021-04-24', '00021', '', '39', '87', '', '5', '22', '', '', '', '0', '0.00', '', '0.00', '0.00', '42', '17', 'pending'), 
('74', '2021-04-24', '2021-04-24', '00021', '', '39', '91', '', '5', '22', '', '', '', '0', '0.00', '', '0.00', '0.00', '42', '17', 'pending'), 
('75', '2021-04-24', '2021-04-24', '00021', '', '42', '94', '', '5', '22', '', '', '', '0', '0.00', '', '0.00', '0.00', '42', '17', 'pending'), 
('76', '2021-04-24', '2021-04-24', '00021', '', '39', '98', '', '5', '22', '', '', '', '0', '0.00', '', '0.00', '0.00', '42', '17', 'pending'), 
('77', '2021-04-24', '2021-04-24', '00021', '', '36', '102', '', '5', '22', '', '', '', '0', '0.00', '', '0.00', '0.00', '42', '17', 'pending'), 
('78', '2021-04-24', '2021-04-24', '00021', '', '40', '106', '', '5', '22', '', '', '', '0', '0.00', '', '0.00', '0.00', '42', '17', 'pending'), 
('79', '2021-04-24', '2021-04-24', '00021', '', '45', '101', '', '5', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '43', '17', 'pending'), 
('80', '2021-04-24', '2021-04-24', '00021', '', '44', '100', '', '5', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '43', '17', 'pending'), 
('81', '2021-04-24', '2021-04-24', '00021', '', '39', '98', '', '5', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '43', '17', 'pending'), 
('82', '2021-04-24', '2021-04-24', '00021', '', '42', '94', '', '5', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '43', '17', 'pending'), 
('83', '2021-04-24', '2021-04-24', '00021', '', '46', '109', '', '5', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '43', '17', 'pending'), 
('84', '2021-04-24', '2021-04-24', '00021', '', '43', '114', '', '5', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '43', '17', 'pending'), 
('85', '2021-04-24', '2021-04-24', '00022', '', '35', '72', '', '5', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '44', '17', 'pending'), 
('86', '2021-04-24', '2021-04-24', '00022', '', '35', '73', '', '5', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '44', '17', 'pending'), 
('87', '2021-04-24', '2021-04-24', '00022', '', '36', '76', '', '5', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '44', '17', 'pending'), 
('88', '2021-04-24', '2021-04-24', '00022', '', '36', '77', '', '5', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '44', '17', 'pending'), 
('89', '2021-04-24', '2021-04-24', '00023', '', '35', '72', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '45', '17', 'pending'), 
('90', '2021-04-24', '2021-04-24', '00023', '', '35', '74', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '45', '17', 'pending'), 
('91', '2021-04-24', '2021-04-24', '00023', '', '36', '78', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '45', '17', 'pending'), 
('92', '2021-04-24', '2021-04-24', '00024', '', '36', '78', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '46', '17', 'pending'), 
('93', '2021-04-24', '2021-04-24', '00024', '', '36', '77', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '46', '17', 'pending'), 
('94', '2021-04-24', '2021-04-24', '00024', '', '36', '76', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '46', '17', 'pending'), 
('95', '2021-04-24', '2021-04-24', '00024', '', '35', '72', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '46', '17', 'pending'), 
('96', '2021-04-24', '2021-04-24', '00024', '', '36', '82', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '46', '17', 'pending'), 
('97', '2021-04-24', '2021-04-24', '00024', '', '39', '87', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '46', '17', 'pending'), 
('98', '2021-04-24', '2021-04-24', '00024', '', '40', '88', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '46', '17', 'pending'), 
('99', '2021-04-24', '2021-04-24', '00024', '', '39', '91', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '46', '17', 'pending'), 
('100', '2021-04-24', '2021-04-24', '00024', '', '45', '101', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '46', '17', 'pending'), 
('101', '2021-04-24', '2021-04-24', '00024', '', '51', '117', '', '5', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '46', '17', 'pending'), 
('102', '2021-04-24', '2021-04-24', '00025', '', '45', '101', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '47', '3', 'pending'), 
('103', '2021-04-24', '2021-04-24', '00025', '', '36', '102', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '47', '3', 'pending'), 
('104', '2021-04-24', '2021-04-24', '00025', '', '95', '156', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '47', '3', 'pending'), 
('105', '2021-04-24', '2021-04-24', '00025', '', '39', '91', '', '5', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '47', '3', 'pending'), 
('106', '2021-04-24', '2021-04-24', '00026', '', '35', '73', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '48', '3', 'pending'), 
('107', '2021-04-24', '2021-04-24', '00026', '', '36', '102', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '48', '3', 'pending'), 
('108', '2021-04-24', '2021-04-24', '00026', '', '42', '146', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '48', '3', 'pending'), 
('109', '2021-04-24', '2021-04-24', '00026', '', '45', '101', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '48', '3', 'pending'), 
('110', '2021-04-24', '2021-04-24', '00026', '', '95', '156', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '48', '3', 'pending'), 
('111', '2021-04-24', '2021-04-24', '00026', '', '42', '92', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '48', '3', 'pending'), 
('112', '2021-04-24', '2021-04-24', '00026', '', '42', '94', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '48', '3', 'pending'), 
('113', '2021-04-24', '2021-04-24', '00027', '', '38', '85', '', '7', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '49', '', 'pending'), 
('114', '2021-04-24', '2021-04-24', '00027', '', '38', '86', '', '7', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '49', '', 'pending'), 
('115', '2021-04-24', '2021-04-24', '00027', '', '38', '83', '', '7', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '49', '', 'pending'), 
('116', '2021-04-24', '2021-04-24', '00027', '', '38', '84', '', '7', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '49', '', 'pending'), 
('117', '2021-04-25', '2021-04-25', '00028', '', '45', '101', '', '1', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '50', '2', 'pending'), 
('136', '2021-04-25', '0000-00-00', '00037', '', '45', '101', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '61', '3', 'pending'), 
('137', '2021-04-25', '0000-00-00', '00037', '', '42', '146', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '61', '3', 'pending'), 
('138', '2021-04-25', '0000-00-00', '00038', '', '45', '101', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '62', '2', 'pending'), 
('139', '2021-04-25', '0000-00-00', '00038', '', '96', '286', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '62', '2', 'pending'), 
('140', '2021-04-25', '0000-00-00', '00038', '', '42', '339', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '62', '2', 'pending'), 
('141', '2021-04-25', '0000-00-00', '00039', '', '45', '101', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '63', '2', 'pending'), 
('142', '2021-04-25', '0000-00-00', '00040', '', '45', '101', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '64', '1', 'pending'), 
('143', '2021-04-25', '0000-00-00', '00041', '', '45', '101', '', '1', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '65', '4', 'pending'), 
('144', '2021-04-25', '0000-00-00', '00041', '', '40', '111', '', '1', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '65', '4', 'pending'), 
('145', '2021-04-25', '0000-00-00', '00042', '', '45', '101', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '66', '4', 'pending'), 
('146', '2021-04-25', '0000-00-00', '00042', '', '42', '92', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '66', '4', 'pending'), 
('147', '2021-04-25', '0000-00-00', '00042', '', '35', '75', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '66', '4', 'pending'), 
('148', '2021-04-25', '0000-00-00', '00042', '', '35', '73', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '66', '4', 'pending'), 
('149', '2021-04-25', '0000-00-00', '00043', '', '35', '72', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '67', '4', 'pending'), 
('150', '2021-04-25', '0000-00-00', '00043', '', '45', '101', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '67', '4', 'pending'), 
('151', '2021-04-25', '0000-00-00', '00043', '', '42', '338', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '67', '4', 'pending'), 
('152', '2021-04-25', '0000-00-00', '00043', '', '107', '588', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '67', '4', 'pending'), 
('153', '2021-04-25', '0000-00-00', '00043', '', '118', '589', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '67', '4', 'pending'), 
('154', '2021-04-26', '0000-00-00', '00044', '', '45', '101', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '68', '4', 'pending'), 
('155', '2021-04-26', '0000-00-00', '00044', '', '36', '102', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '68', '4', 'pending'), 
('156', '2021-04-26', '0000-00-00', '00044', '', '35', '73', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '68', '4', 'pending'), 
('157', '2021-04-26', '0000-00-00', '00044', '', '98', '297', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '68', '4', 'pending'), 
('158', '2021-04-26', '0000-00-00', '00044', '', '99', '301', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '68', '4', 'pending'), 
('159', '2021-04-26', '0000-00-00', '00044', '', '99', '304', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '68', '4', 'pending'), 
('160', '2021-04-26', '0000-00-00', '00044', '', '104', '309', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '68', '4', 'pending'), 
('161', '2021-04-26', '0000-00-00', '00044', '', '117', '451', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '68', '4', 'pending'), 
('162', '2021-04-26', '0000-00-00', '00044', '', '97', '290', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '68', '4', 'pending'), 
('163', '2021-04-26', '0000-00-00', '00044', '', '103', '329', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '68', '4', 'pending'), 
('164', '2021-04-26', '0000-00-00', '00044', '', '107', '366', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '68', '4', 'pending'), 
('165', '2021-04-26', '0000-00-00', '00044', '', '107', '370', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '68', '4', 'pending'), 
('166', '2021-04-26', '0000-00-00', '00044', '', '45', '101', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('167', '2021-04-26', '0000-00-00', '00044', '', '97', '290', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('168', '2021-04-26', '0000-00-00', '00044', '', '98', '297', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('169', '2021-04-26', '0000-00-00', '00044', '', '103', '329', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('170', '2021-04-26', '0000-00-00', '00044', '', '107', '366', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('171', '2021-04-26', '0000-00-00', '00044', '', '107', '370', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('172', '2021-04-26', '0000-00-00', '00044', '', '117', '451', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('173', '2021-04-26', '0000-00-00', '00044', '', '42', '338', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('174', '2021-04-26', '0000-00-00', '00044', '', '120', '512', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('175', '2021-04-26', '0000-00-00', '00044', '', '107', '374', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('176', '2021-04-26', '0000-00-00', '00044', '', '107', '377', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('177', '2021-04-26', '0000-00-00', '00044', '', '108', '394', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('178', '2021-04-26', '0000-00-00', '00044', '', '118', '589', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '69', '4', 'pending'), 
('179', '2021-04-26', '0000-00-00', '00045', '', '35', '73', '', '8', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '70', '4', 'pending'), 
('180', '2021-04-26', '0000-00-00', '00045', '', '45', '101', '', '8', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '70', '4', 'pending'), 
('181', '2021-04-26', '0000-00-00', '00045', '', '36', '102', '', '8', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '70', '4', 'pending'), 
('182', '2021-04-26', '0000-00-00', '00045', '', '99', '304', '', '8', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '70', '4', 'pending'), 
('183', '2021-04-26', '0000-00-00', '00045', '', '45', '101', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '71', '4', 'pending'), 
('184', '2021-04-26', '0000-00-00', '00045', '', '97', '290', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '71', '4', 'pending'), 
('185', '2021-04-26', '0000-00-00', '00045', '', '98', '297', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '71', '4', 'pending'), 
('186', '2021-04-26', '0000-00-00', '00045', '', '98', '298', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '71', '4', 'pending'), 
('187', '2021-04-26', '0000-00-00', '00045', '', '99', '301', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '71', '4', 'pending'), 
('188', '2021-04-26', '0000-00-00', '00045', '', '120', '512', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '71', '4', 'pending'), 
('189', '2021-04-26', '0000-00-00', '00045', '', '117', '451', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '71', '4', 'pending'), 
('190', '2021-04-26', '0000-00-00', '00046', '', '45', '101', '', '7', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '72', '1', 'pending'), 
('191', '2021-04-26', '0000-00-00', '00047', '', '45', '101', '', '7', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '73', '1', 'pending'), 
('192', '2021-04-26', '0000-00-00', '00047', '', '42', '94', '', '7', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '73', '1', 'pending'), 
('193', '2021-04-26', '0000-00-00', '00047', '', '35', '107', '', '7', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '73', '1', 'pending'), 
('194', '2021-04-26', '0000-00-00', '00047', '', '42', '95', '', '7', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '73', '1', 'pending'), 
('195', '2021-04-26', '0000-00-00', '00047', '', '35', '72', '', '7', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '73', '1', 'pending'), 
('196', '2021-04-26', '0000-00-00', '00047', '', '42', '95', '', '7', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '73', '1', 'pending'), 
('197', '2021-04-26', '0000-00-00', '00047', '', '99', '303', '', '7', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '73', '1', 'pending'), 
('198', '2021-04-26', '0000-00-00', '00048', '', '45', '101', '', '5', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '74', '4', 'pending'), 
('199', '2021-04-26', '0000-00-00', '00048', '', '97', '290', '', '5', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '74', '4', 'pending'), 
('200', '2021-04-26', '0000-00-00', '00048', '', '98', '297', '', '5', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '74', '4', 'pending'), 
('201', '2021-04-26', '0000-00-00', '00048', '', '105', '353', '', '5', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '74', '4', 'pending'), 
('202', '2021-04-26', '0000-00-00', '00048', '', '99', '301', '', '5', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '74', '4', 'pending'), 
('203', '2021-04-26', '0000-00-00', '00048', '', '36', '102', '', '5', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '74', '4', 'pending'), 
('204', '2021-04-26', '0000-00-00', '00048', '', '122', '584', '', '5', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '74', '4', 'pending'), 
('205', '2021-04-26', '0000-00-00', '00049', '', '35', '73', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('206', '2021-04-26', '0000-00-00', '00049', '', '45', '101', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('207', '2021-04-26', '0000-00-00', '00049', '', '35', '72', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('208', '2021-04-26', '0000-00-00', '00049', '', '96', '284', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('209', '2021-04-26', '0000-00-00', '00049', '', '112', '287', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('210', '2021-04-26', '0000-00-00', '00049', '', '96', '591', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('211', '2021-04-26', '0000-00-00', '00049', '', '96', '592', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('212', '2021-04-26', '0000-00-00', '00049', '', '97', '290', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('213', '2021-04-26', '0000-00-00', '00049', '', '97', '295', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('214', '2021-04-26', '0000-00-00', '00049', '', '97', '291', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('215', '2021-04-26', '0000-00-00', '00049', '', '97', '292', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('216', '2021-04-26', '0000-00-00', '00049', '', '97', '293', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('217', '2021-04-26', '0000-00-00', '00049', '', '97', '294', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('218', '2021-04-26', '0000-00-00', '00049', '', '98', '297', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('219', '2021-04-26', '0000-00-00', '00049', '', '98', '299', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('220', '2021-04-26', '0000-00-00', '00049', '', '98', '298', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('221', '2021-04-26', '0000-00-00', '00049', '', '98', '300', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '75', '4', 'pending'), 
('222', '2021-04-26', '0000-00-00', '00050', '', '122', '585', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '76', '4', 'pending'), 
('223', '2021-04-26', '0000-00-00', '00051', '', '45', '101', '', '7', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '77', '4', 'pending'), 
('224', '2021-04-26', '0000-00-00', '00051', '', '97', '290', '', '7', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '77', '4', 'pending'), 
('225', '2021-04-26', '0000-00-00', '00051', '', '120', '512', '', '7', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '77', '4', 'pending'), 
('226', '2021-04-26', '0000-00-00', '00051', '', '122', '584', '', '7', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '77', '4', 'pending'), 
('227', '2021-04-26', '0000-00-00', '00051', '', '117', '595', '', '7', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '77', '4', 'pending'), 
('228', '2021-04-27', '0000-00-00', '00052', '', '35', '73', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '78', '1', 'pending'), 
('229', '2021-04-27', '0000-00-00', '00052', '', '103', '329', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '78', '1', 'pending'), 
('230', '2021-04-27', '0000-00-00', '00052', '', '97', '290', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '78', '1', 'pending'), 
('231', '2021-04-27', '0000-00-00', '00052', '', '107', '370', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '78', '1', 'pending'), 
('232', '2021-04-27', '0000-00-00', '00053', '', '36', '102', '', '10', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '79', '1', 'pending'), 
('233', '2021-04-27', '0000-00-00', '00053', '', '99', '598', '', '10', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '79', '1', 'pending'), 
('234', '2021-04-27', '0000-00-00', '00053', '', '121', '533', '', '10', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '79', '1', 'pending'), 
('235', '2021-04-27', '0000-00-00', '00053', '', '100', '583', '', '10', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '79', '1', 'pending'), 
('236', '2021-04-27', '0000-00-00', '00053', '', '120', '512', '', '10', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '79', '1', 'pending'), 
('237', '2021-04-27', '0000-00-00', '00054', '', '36', '102', '', '10', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '80', '1', 'pending'), 
('238', '2021-04-27', '0000-00-00', '00054', '', '99', '598', '', '10', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '80', '1', 'pending'), 
('239', '2021-04-27', '0000-00-00', '00054', '', '120', '512', '', '10', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '80', '1', 'pending'), 
('240', '2021-04-27', '0000-00-00', '00054', '', '121', '533', '', '10', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '80', '1', 'pending'), 
('241', '2021-04-27', '0000-00-00', '00054', '', '100', '583', '', '10', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '80', '1', 'pending'), 
('250', '2021-04-28', '0000-00-00', '0002', '', '35', '73', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '82', '1', 'pending'), 
('251', '2021-04-28', '0000-00-00', '00056', '', '35', '73', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '83', '1', 'pending'), 
('252', '2021-04-28', '0000-00-00', '00056', '', '97', '290', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '83', '1', 'pending'), 
('253', '2021-04-28', '0000-00-00', '00056', '', '103', '329', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '83', '1', 'pending'), 
('254', '2021-04-28', '0000-00-00', '00056', '', '107', '366', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '83', '1', 'pending'), 
('255', '2021-04-28', '0000-00-00', '00056', '', '103', '328', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '83', '1', 'pending'), 
('256', '2021-04-28', '0000-00-00', '00057', '', '45', '101', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('257', '2021-04-28', '0000-00-00', '00057', '', '97', '290', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('258', '2021-04-28', '0000-00-00', '00057', '', '98', '297', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('259', '2021-04-28', '0000-00-00', '00057', '', '98', '298', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('260', '2021-04-28', '0000-00-00', '00057', '', '99', '301', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('261', '2021-04-28', '0000-00-00', '00057', '', '99', '304', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('262', '2021-04-28', '0000-00-00', '00057', '', '100', '583', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('263', '2021-04-28', '0000-00-00', '00057', '', '36', '102', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('264', '2021-04-28', '0000-00-00', '00057', '', '42', '338', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('265', '2021-04-28', '0000-00-00', '00057', '', '105', '353', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('266', '2021-04-28', '0000-00-00', '00057', '', '110', '420', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('267', '2021-04-28', '0000-00-00', '00057', '', '99', '307', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('268', '2021-04-28', '0000-00-00', '00057', '', '117', '451', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('269', '2021-04-28', '0000-00-00', '00057', '', '122', '512', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('270', '2021-04-28', '0000-00-00', '00057', '', '121', '532', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '84', '1', 'pending'), 
('271', '2021-04-29', '0000-00-00', '00058', '', '45', '101', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '85', '4', 'pending'), 
('272', '2021-04-29', '0000-00-00', '00058', '', '97', '290', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '85', '4', 'pending'), 
('273', '2021-04-29', '0000-00-00', '00058', '', '98', '297', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '85', '4', 'pending'), 
('274', '2021-04-29', '0000-00-00', '00058', '', '42', '338', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '85', '4', 'pending'), 
('275', '2021-04-29', '0000-00-00', '00058', '', '122', '512', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '85', '4', 'pending'), 
('276', '2021-04-29', '0000-00-00', '00058', '', '121', '532', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '85', '4', 'pending'), 
('277', '2021-04-29', '0000-00-00', '00058', '', '100', '583', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '85', '4', 'pending'), 
('278', '2021-04-29', '0000-00-00', '00058', '', '121', '534', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '86', '4', 'pending'), 
('279', '2021-04-29', '0000-00-00', '00058', '', '121', '534', '', '5', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '87', '4', 'pending'), 
('280', '2021-04-29', '2021-04-29', '00059', '', '121', '534', '', '5', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '88', '4', 'pending'), 
('281', '2021-04-29', '0000-00-00', '00060', '', '35', '73', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '89', '4', 'pending'), 
('282', '2021-04-29', '0000-00-00', '00060', '', '99', '304', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '89', '4', 'pending'), 
('283', '2021-04-29', '0000-00-00', '00060', '', '96', '284', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '89', '4', 'pending'), 
('284', '2021-04-29', '0000-00-00', '00060', '', '99', '307', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '89', '4', 'pending'), 
('285', '2021-04-29', '0000-00-00', '00060', '', '123', '514', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '89', '4', 'pending'), 
('286', '2021-04-29', '0000-00-00', '00060', '', '102', '324', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '89', '4', 'pending'), 
('287', '2021-04-29', '0000-00-00', '00061', '', '105', '616', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '90', '4', 'pending'), 
('288', '2021-04-29', '0000-00-00', '00061', '', '121', '532', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '90', '4', 'pending'), 
('289', '2021-04-29', '0000-00-00', '00061', '', '45', '101', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '90', '4', 'pending'), 
('290', '2021-04-29', '0000-00-00', '00061', '', '97', '290', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '90', '4', 'pending'), 
('291', '2021-04-29', '0000-00-00', '00061', '', '117', '461', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '90', '4', 'pending'), 
('292', '2021-04-29', '0000-00-00', '00061', '', '117', '469', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '90', '4', 'pending'), 
('293', '2021-04-29', '0000-00-00', '00062', '', '45', '101', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '91', '4', 'pending'), 
('294', '2021-04-29', '0000-00-00', '00062', '', '97', '290', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '91', '4', 'pending'), 
('295', '2021-04-29', '0000-00-00', '00062', '', '99', '301', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '91', '4', 'pending'), 
('296', '2021-04-29', '0000-00-00', '00062', '', '98', '297', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '91', '4', 'pending'), 
('297', '2021-04-29', '0000-00-00', '00062', '', '107', '370', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '91', '4', 'pending'), 
('298', '2021-04-29', '0000-00-00', '00062', '', '42', '338', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '91', '4', 'pending'), 
('299', '2021-04-29', '0000-00-00', '00062', '', '105', '357', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '91', '4', 'pending'), 
('300', '2021-04-29', '0000-00-00', '00062', '', '117', '463', '', '1', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '91', '4', 'pending'), 
('309', '2021-04-29', '2021-04-29', '00064', '', '120', '516', '', '1', '? string:0 ?', '', '', '', '0', '0.00', '', '0.00', '0.00', '93', '4', 'pending'), 
('310', '2021-04-29', '2021-04-29', '00064', '', '120', '516', '', '1', '? string:0 ?', '', '', '', '0', '0.00', '', '0.00', '0.00', '93', '4', 'pending'), 
('311', '2021-04-29', '2021-04-29', '00064', '', '120', '516', '', '1', '? string:0 ?', '', '', '', '0', '0.00', '', '0.00', '0.00', '93', '4', 'pending'), 
('312', '2021-04-29', '2021-04-29', '00064', '', '120', '516', '', '1', '? string:0 ?', '', '', '', '0', '0.00', '', '0.00', '0.00', '93', '4', 'pending'), 
('313', '2021-04-30', '0000-00-00', '00065', '', '45', '101', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '94', '1', 'pending'), 
('314', '2021-04-30', '0000-00-00', '00065', '', '97', '290', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '94', '1', 'pending'), 
('315', '2021-04-30', '0000-00-00', '00065', '', '98', '297', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '94', '1', 'pending'), 
('316', '2021-04-30', '0000-00-00', '00065', '', '107', '374', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '94', '1', 'pending'), 
('317', '2021-04-30', '0000-00-00', '00065', '', '42', '338', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '94', '1', 'pending'), 
('318', '2021-04-30', '0000-00-00', '00065', '', '114', '611', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '94', '1', 'pending'), 
('319', '2021-04-30', '0000-00-00', '00065', '', '121', '532', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '94', '1', 'pending'), 
('320', '2021-04-30', '0000-00-00', '00065', '', '122', '512', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '94', '1', 'pending'), 
('321', '2021-04-30', '0000-00-00', '00065', '', '117', '451', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '94', '1', 'pending'), 
('339', '2021-05-01', '0000-00-00', '00067', '', '45', '101', '', '1', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '97', '4', 'pending'), 
('340', '2021-05-01', '0000-00-00', '00067', '', '97', '290', '', '1', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '97', '4', 'pending'), 
('341', '2021-05-01', '0000-00-00', '00067', '', '104', '309', '', '1', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '97', '4', 'pending'), 
('342', '2021-05-01', '0000-00-00', '00067', '', '98', '297', '', '1', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '97', '4', 'pending'), 
('343', '2021-05-01', '0000-00-00', '00067', '', '107', '588', '', '1', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '97', '4', 'pending'), 
('344', '2021-05-01', '0000-00-00', '00067', '', '117', '469', '', '1', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '97', '4', 'pending'), 
('351', '2021-05-01', '0000-00-00', '00069', '', '123', '514', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '99', '1', 'pending'), 
('352', '2021-05-01', '0000-00-00', '00069', '', '107', '366', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '99', '1', 'pending'), 
('353', '2021-05-01', '0000-00-00', '00069', '', '45', '101', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '99', '1', 'pending'), 
('354', '2021-05-01', '0000-00-00', '00069', '', '97', '290', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '99', '1', 'pending'), 
('355', '2021-05-01', '0000-00-00', '00069', '', '107', '370', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '99', '1', 'pending'), 
('356', '2021-05-01', '0000-00-00', '00069', '', '103', '329', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '99', '1', 'pending'), 
('357', '2021-05-01', '0000-00-00', '00069', '', '98', '297', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '99', '1', 'pending'), 
('358', '2021-05-01', '0000-00-00', '00069', '', '121', '532', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '99', '1', 'pending'), 
('359', '2021-05-01', '0000-00-00', '00069', '', '42', '338', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '99', '1', 'pending'), 
('360', '2021-05-01', '0000-00-00', '00069', '', '98', '299', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '99', '1', 'pending'), 
('361', '2021-05-01', '0000-00-00', '00070', '', '45', '101', '', '1', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '100', '4', 'pending'), 
('362', '2021-05-01', '0000-00-00', '00070', '', '97', '290', '', '1', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '100', '4', 'pending'), 
('363', '2021-05-01', '0000-00-00', '00070', '', '98', '297', '', '1', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '100', '4', 'pending'), 
('364', '2021-05-01', '0000-00-00', '00070', '', '104', '309', '', '1', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '100', '4', 'pending'), 
('365', '2021-05-01', '0000-00-00', '00070', '', '117', '595', '', '1', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '100', '4', 'pending'), 
('366', '2021-05-01', '0000-00-00', '00070', '', '107', '588', '', '1', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '100', '4', 'pending'), 
('367', '2021-05-01', '0000-00-00', '00071', '', '45', '101', '', '2', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '101', '4', 'pending'), 
('368', '2021-05-01', '0000-00-00', '00071', '', '97', '290', '', '2', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '101', '4', 'pending'), 
('369', '2021-05-01', '0000-00-00', '00071', '', '98', '297', '', '2', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '101', '4', 'pending'), 
('370', '2021-05-01', '0000-00-00', '00071', '', '42', '338', '', '2', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '101', '4', 'pending'), 
('371', '2021-05-01', '0000-00-00', '00071', '', '117', '451', '', '2', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '101', '4', 'pending'), 
('372', '2021-05-01', '0000-00-00', '00071', '', '121', '532', '', '2', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '101', '4', 'pending'), 
('373', '2021-05-01', '0000-00-00', '00071', '', '123', '561', '', '2', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '101', '4', 'pending'), 
('374', '2021-05-01', '0000-00-00', '00072', '', '105', '635', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '102', '4', 'pending'), 
('375', '2021-05-01', '0000-00-00', '00073', '', '35', '73', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '103', '4', 'pending'), 
('376', '2021-05-01', '0000-00-00', '00073', '', '97', '290', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '103', '4', 'pending'), 
('377', '2021-05-01', '0000-00-00', '00073', '', '103', '329', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '103', '4', 'pending'), 
('378', '2021-05-01', '0000-00-00', '00073', '', '107', '366', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '103', '4', 'pending'), 
('381', '2021-05-02', '0000-00-00', '00075', '', '45', '101', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '105', '1', 'pending'), 
('382', '2021-05-02', '0000-00-00', '00075', '', '97', '290', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '105', '1', 'pending'), 
('383', '2021-05-02', '0000-00-00', '00075', '', '98', '297', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '105', '1', 'pending'), 
('384', '2021-05-02', '0000-00-00', '00075', '', '121', '532', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '105', '1', 'pending'), 
('385', '2021-05-02', '0000-00-00', '00075', '', '107', '366', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '105', '1', 'pending'), 
('386', '2021-05-02', '0000-00-00', '00075', '', '117', '451', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '105', '1', 'pending'), 
('387', '2021-05-02', '0000-00-00', '00075', '', '115', '450', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '105', '1', 'pending'), 
('388', '2021-05-02', '0000-00-00', '00076', '', '35', '73', '', '13', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '106', '1', 'pending'), 
('389', '2021-05-02', '0000-00-00', '00076', '', '103', '329', '', '13', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '106', '1', 'pending'), 
('390', '2021-05-02', '0000-00-00', '00076', '', '42', '338', '', '13', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '106', '1', 'pending'), 
('391', '2021-05-02', '0000-00-00', '00077', '', '35', '73', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '107', '1', 'pending'), 
('392', '2021-05-02', '0000-00-00', '00077', '', '97', '290', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '107', '1', 'pending'), 
('393', '2021-05-02', '0000-00-00', '00077', '', '103', '329', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '107', '1', 'pending'), 
('394', '2021-05-02', '0000-00-00', '00077', '', '107', '366', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '107', '1', 'pending'), 
('404', '2021-05-02', '0000-00-00', '00079', '', '45', '101', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '109', '6', 'pending'), 
('405', '2021-05-02', '0000-00-00', '00079', '', '97', '290', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '109', '6', 'pending'), 
('406', '2021-05-02', '0000-00-00', '00079', '', '98', '297', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '109', '6', 'pending'), 
('407', '2021-05-02', '0000-00-00', '00079', '', '42', '338', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '109', '6', 'pending'), 
('408', '2021-05-02', '0000-00-00', '00079', '', '117', '451', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '109', '6', 'pending'), 
('409', '2021-05-02', '0000-00-00', '00079', '', '121', '532', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '109', '6', 'pending'), 
('410', '2021-05-02', '0000-00-00', '00079', '', '123', '561', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '109', '6', 'pending'), 
('411', '2021-05-02', '0000-00-00', '00078', '', '45', '101', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '110', '4', 'pending'), 
('412', '2021-05-02', '0000-00-00', '00078', '', '97', '290', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '110', '4', 'pending'), 
('413', '2021-05-02', '0000-00-00', '00078', '', '107', '370', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '110', '4', 'pending'), 
('414', '2021-05-02', '0000-00-00', '00078', '', '103', '329', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '110', '4', 'pending'), 
('415', '2021-05-02', '0000-00-00', '00078', '', '98', '297', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '110', '4', 'pending'), 
('416', '2021-05-02', '0000-00-00', '00078', '', '98', '299', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '110', '4', 'pending'), 
('417', '2021-05-02', '0000-00-00', '00078', '', '121', '532', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '110', '4', 'pending'), 
('418', '2021-05-02', '0000-00-00', '00078', '', '42', '338', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '110', '4', 'pending'), 
('419', '2021-05-02', '0000-00-00', '00078', '', '107', '366', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '110', '4', 'pending'), 
('420', '2021-05-02', '0000-00-00', '00078', '', '123', '561', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '110', '4', 'pending'), 
('421', '2021-05-02', '0000-00-00', '00078', '', '117', '595', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '110', '4', 'pending'), 
('422', '2021-05-02', '0000-00-00', '00080', '', '45', '101', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '111', '4', 'pending'), 
('423', '2021-05-02', '0000-00-00', '00080', '', '97', '290', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '111', '4', 'pending'), 
('424', '2021-05-02', '0000-00-00', '00080', '', '107', '370', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '111', '4', 'pending'), 
('425', '2021-05-02', '0000-00-00', '00080', '', '103', '329', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '111', '4', 'pending'), 
('426', '2021-05-02', '0000-00-00', '00080', '', '98', '297', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '111', '4', 'pending'), 
('427', '2021-05-02', '0000-00-00', '00080', '', '98', '299', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '111', '4', 'pending'), 
('428', '2021-05-02', '0000-00-00', '00080', '', '121', '532', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '111', '4', 'pending'), 
('429', '2021-05-02', '0000-00-00', '00080', '', '42', '338', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '111', '4', 'pending'), 
('430', '2021-05-02', '0000-00-00', '00080', '', '107', '366', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '111', '4', 'pending'), 
('431', '2021-05-02', '0000-00-00', '00080', '', '123', '561', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '111', '4', 'pending'), 
('432', '2021-05-02', '0000-00-00', '00080', '', '117', '595', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '111', '4', 'pending'), 
('433', '2021-05-02', '0000-00-00', '00081', '', '35', '73', '', '1', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '112', '4', 'pending'), 
('434', '2021-05-02', '0000-00-00', '00081', '', '97', '290', '', '1', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '112', '4', 'pending'), 
('435', '2021-05-02', '0000-00-00', '00081', '', '98', '297', '', '1', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '112', '4', 'pending'), 
('436', '2021-05-02', '0000-00-00', '00081', '', '42', '338', '', '1', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '112', '4', 'pending'), 
('437', '2021-05-02', '0000-00-00', '00081', '', '121', '532', '', '1', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '112', '4', 'pending'), 
('438', '2021-05-02', '0000-00-00', '00081', '', '122', '546', '', '1', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '112', '4', 'pending'), 
('439', '2021-05-02', '0000-00-00', '00081', '', '123', '566', '', '1', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '112', '4', 'pending'), 
('440', '2021-05-02', '0000-00-00', '00081', '', '45', '101', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '113', '6', 'pending'), 
('441', '2021-05-02', '0000-00-00', '00081', '', '97', '290', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '113', '6', 'pending'), 
('442', '2021-05-02', '0000-00-00', '00081', '', '98', '298', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '113', '6', 'pending'), 
('443', '2021-05-02', '0000-00-00', '00081', '', '98', '299', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '113', '6', 'pending'), 
('444', '2021-05-02', '0000-00-00', '00081', '', '99', '301', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '113', '6', 'pending'), 
('445', '2021-05-02', '0000-00-00', '00081', '', '99', '303', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '113', '6', 'pending'), 
('446', '2021-05-02', '0000-00-00', '00081', '', '42', '338', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '113', '6', 'pending'), 
('447', '2021-05-02', '0000-00-00', '00081', '', '105', '353', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '113', '6', 'pending'), 
('448', '2021-05-02', '0000-00-00', '00081', '', '123', '561', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '113', '6', 'pending'), 
('458', '2021-05-02', '0000-00-00', '00083', '', '45', '101', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '115', '4', 'pending'), 
('459', '2021-05-02', '0000-00-00', '00083', '', '97', '290', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '115', '4', 'pending'), 
('460', '2021-05-02', '0000-00-00', '00083', '', '98', '298', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '115', '4', 'pending'), 
('461', '2021-05-02', '0000-00-00', '00083', '', '98', '299', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '115', '4', 'pending'), 
('462', '2021-05-02', '0000-00-00', '00083', '', '42', '338', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '115', '4', 'pending'), 
('463', '2021-05-02', '0000-00-00', '00083', '', '99', '301', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '115', '4', 'pending'), 
('464', '2021-05-02', '0000-00-00', '00083', '', '99', '303', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '115', '4', 'pending'), 
('465', '2021-05-02', '0000-00-00', '00083', '', '105', '353', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '115', '4', 'pending'), 
('466', '2021-05-02', '0000-00-00', '00083', '', '123', '561', '', '1', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '115', '4', 'pending'), 
('467', '2021-05-02', '0000-00-00', '00084', '', '35', '73', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '116', '4', 'pending'), 
('468', '2021-05-02', '0000-00-00', '00084', '', '97', '290', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '116', '4', 'pending'), 
('469', '2021-05-02', '0000-00-00', '00084', '', '103', '329', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '116', '4', 'pending'), 
('470', '2021-05-02', '0000-00-00', '00084', '', '107', '366', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '116', '4', 'pending'), 
('477', '2021-05-02', '0000-00-00', '00086', '', '45', '101', '', '1', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '118', '4', 'pending'), 
('478', '2021-05-02', '0000-00-00', '00086', '', '97', '290', '', '1', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '118', '4', 'pending'), 
('479', '2021-05-02', '0000-00-00', '00086', '', '98', '297', '', '1', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '118', '4', 'pending'), 
('480', '2021-05-02', '0000-00-00', '00086', '', '42', '338', '', '1', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '118', '4', 'pending'), 
('481', '2021-05-02', '0000-00-00', '00086', '', '117', '593', '', '1', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '118', '4', 'pending'), 
('482', '2021-05-02', '0000-00-00', '00086', '', '117', '624', '', '1', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '118', '4', 'pending'), 
('485', '2021-05-02', '0000-00-00', '00088', '', '117', '465', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '120', '4', 'pending'), 
('486', '2021-05-02', '0000-00-00', '00088', '', '117', '636', '', '1', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '120', '4', 'pending'), 
('487', '2021-05-03', '0000-00-00', '00089', '', '123', '519', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '121', '6', 'pending'), 
('488', '2021-05-03', '0000-00-00', '00090', '', '45', '101', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '122', '6', 'pending'), 
('489', '2021-05-03', '0000-00-00', '00090', '', '97', '290', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '122', '6', 'pending'), 
('490', '2021-05-03', '0000-00-00', '00090', '', '98', '297', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '122', '6', 'pending'), 
('491', '2021-05-03', '0000-00-00', '00090', '', '42', '338', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '122', '6', 'pending'), 
('492', '2021-05-03', '0000-00-00', '00090', '', '107', '366', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '122', '6', 'pending'), 
('493', '2021-05-03', '0000-00-00', '00090', '', '121', '532', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '122', '6', 'pending'), 
('494', '2021-05-03', '0000-00-00', '00090', '', '117', '451', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '122', '6', 'pending'), 
('495', '2021-05-03', '0000-00-00', '00090', '', '123', '561', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '122', '6', 'pending'), 
('496', '2021-05-03', '0000-00-00', '00091', '', '45', '101', '', '15', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '123', '4', 'pending'), 
('497', '2021-05-03', '0000-00-00', '00091', '', '97', '290', '', '15', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '123', '4', 'pending'), 
('498', '2021-05-03', '0000-00-00', '00091', '', '98', '297', '', '15', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '123', '4', 'pending'), 
('499', '2021-05-03', '0000-00-00', '00091', '', '99', '301', '', '15', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '123', '4', 'pending'), 
('500', '2021-05-03', '0000-00-00', '00091', '', '103', '329', '', '15', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '123', '4', 'pending'), 
('501', '2021-05-03', '0000-00-00', '00091', '', '107', '366', '', '15', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '123', '4', 'pending'), 
('502', '2021-05-03', '0000-00-00', '00091', '', '42', '338', '', '15', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '123', '4', 'pending'), 
('503', '2021-05-03', '0000-00-00', '00091', '', '117', '451', '', '15', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '123', '4', 'pending'), 
('504', '2021-05-03', '0000-00-00', '00091', '', '117', '622', '', '15', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '123', '4', 'pending'), 
('505', '2021-05-03', '0000-00-00', '00091', '', '121', '532', '', '15', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '123', '4', 'pending'), 
('506', '2021-05-03', '0000-00-00', '00091', '', '123', '561', '', '15', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '123', '4', 'pending'), 
('507', '2021-05-03', '0000-00-00', '00092', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '124', '4', 'pending'), 
('512', '2021-05-03', '0000-00-00', '00095', '', '105', '362', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '127', '4', 'pending'), 
('520', '2021-05-03', '0000-00-00', '00099', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '131', '4', 'pending'), 
('521', '2021-05-03', '0000-00-00', '00099', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '131', '4', 'pending'), 
('522', '2021-05-03', '0000-00-00', '00099', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '131', '4', 'pending'), 
('523', '2021-05-03', '0000-00-00', '00099', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '131', '4', 'pending'), 
('524', '2021-05-03', '0000-00-00', '00100', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '132', '4', 'pending'), 
('525', '2021-05-03', '0000-00-00', '00100', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '132', '4', 'pending'), 
('526', '2021-05-03', '0000-00-00', '00100', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '132', '4', 'pending'), 
('527', '2021-05-03', '0000-00-00', '00100', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '132', '4', 'pending'), 
('528', '2021-05-03', '0000-00-00', '00101', '', '45', '101', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '133', '4', 'pending'), 
('529', '2021-05-03', '0000-00-00', '00101', '', '97', '290', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '133', '4', 'pending'), 
('530', '2021-05-03', '0000-00-00', '00101', '', '121', '532', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '133', '4', 'pending'), 
('531', '2021-05-03', '0000-00-00', '00101', '', '123', '561', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '133', '4', 'pending'), 
('532', '2021-05-03', '0000-00-00', '00101', '', '117', '451', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '133', '4', 'pending'), 
('533', '2021-05-03', '0000-00-00', '00102', '', '45', '101', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '134', '4', 'pending'), 
('534', '2021-05-03', '0000-00-00', '00102', '', '42', '338', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '134', '4', 'pending'), 
('535', '2021-05-03', '0000-00-00', '00102', '', '117', '473', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '134', '4', 'pending'), 
('536', '2021-05-03', '0000-00-00', '00102', '', '123', '561', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '134', '4', 'pending'), 
('539', '2021-05-04', '0000-00-00', '00104', '', '96', '284', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '136', '6', 'pending'), 
('540', '2021-05-04', '0000-00-00', '00104', '', '112', '287', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '136', '6', 'pending'), 
('543', '2021-05-04', '0000-00-00', '00106', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '138', '6', 'pending'), 
('544', '2021-05-04', '0000-00-00', '00106', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '138', '6', 'pending'), 
('545', '2021-05-04', '0000-00-00', '00106', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '138', '6', 'pending'), 
('546', '2021-05-04', '0000-00-00', '00106', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '138', '6', 'pending'), 
('547', '2021-05-04', '0000-00-00', '00107', '', '45', '101', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '139', '6', 'pending'), 
('548', '2021-05-04', '0000-00-00', '00107', '', '97', '290', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '139', '6', 'pending'), 
('549', '2021-05-04', '0000-00-00', '00107', '', '98', '297', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '139', '6', 'pending'), 
('550', '2021-05-04', '0000-00-00', '00107', '', '107', '366', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '139', '6', 'pending'), 
('551', '2021-05-04', '0000-00-00', '00107', '', '42', '338', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '139', '6', 'pending'), 
('552', '2021-05-04', '0000-00-00', '00107', '', '123', '561', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '139', '6', 'pending'), 
('553', '2021-05-04', '0000-00-00', '00107', '', '121', '532', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '139', '6', 'pending'), 
('554', '2021-05-04', '0000-00-00', '00107', '', '117', '622', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '139', '6', 'pending'), 
('557', '2021-05-04', '0000-00-00', '00109', '', '45', '101', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '141', '4', 'pending'), 
('558', '2021-05-04', '0000-00-00', '00109', '', '97', '290', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '141', '4', 'pending'), 
('559', '2021-05-04', '0000-00-00', '00109', '', '98', '297', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '141', '4', 'pending'), 
('560', '2021-05-04', '0000-00-00', '00109', '', '42', '338', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '141', '4', 'pending'), 
('561', '2021-05-04', '0000-00-00', '00109', '', '107', '366', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '141', '4', 'pending'), 
('562', '2021-05-04', '0000-00-00', '00109', '', '123', '514', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '141', '4', 'pending'), 
('584', '2021-05-04', '0000-00-00', '00115', '', '45', '101', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '147', '4', 'pending'), 
('585', '2021-05-04', '0000-00-00', '00115', '', '98', '297', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '147', '4', 'pending'), 
('586', '2021-05-04', '0000-00-00', '00115', '', '123', '561', '', '6', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '147', '4', 'pending'), 
('587', '2021-05-04', '0000-00-00', '00116', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '148', '4', 'pending'), 
('588', '2021-05-04', '0000-00-00', '00116', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '148', '4', 'pending'), 
('589', '2021-05-04', '0000-00-00', '00116', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '148', '4', 'pending'), 
('590', '2021-05-04', '0000-00-00', '00116', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '148', '4', 'pending'), 
('591', '2021-05-04', '0000-00-00', '00116', '', '99', '301', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '148', '4', 'pending'), 
('592', '2021-05-04', '0000-00-00', '00116', '', '108', '407', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '148', '4', 'pending'), 
('593', '2021-05-05', '0000-00-00', '00117', '', '35', '73', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '149', '8', 'pending'), 
('594', '2021-05-05', '0000-00-00', '00117', '', '97', '290', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '149', '8', 'pending'), 
('595', '2021-05-05', '0000-00-00', '00117', '', '98', '297', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '149', '8', 'pending'), 
('596', '2021-05-05', '0000-00-00', '00117', '', '103', '328', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '149', '8', 'pending'), 
('597', '2021-05-05', '0000-00-00', '00117', '', '123', '561', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '149', '8', 'pending'), 
('600', '2021-05-05', '0000-00-00', '00119', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '151', '4', 'pending'), 
('601', '2021-05-05', '0000-00-00', '00119', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '151', '4', 'pending'), 
('602', '2021-05-05', '0000-00-00', '00119', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '151', '4', 'pending'), 
('603', '2021-05-05', '0000-00-00', '00119', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '151', '4', 'pending'), 
('604', '2021-05-05', '0000-00-00', '00120', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '152', '4', 'pending'), 
('605', '2021-05-05', '0000-00-00', '00120', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '152', '4', 'pending'), 
('606', '2021-05-05', '0000-00-00', '00120', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '152', '4', 'pending'), 
('607', '2021-05-05', '0000-00-00', '00120', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '152', '4', 'pending'), 
('608', '2021-05-05', '0000-00-00', '00121', '', '45', '101', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '153', '4', 'pending'), 
('609', '2021-05-05', '0000-00-00', '00121', '', '112', '287', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '153', '4', 'pending'), 
('610', '2021-05-05', '0000-00-00', '00121', '', '107', '366', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '153', '4', 'pending'), 
('611', '2021-05-05', '0000-00-00', '00121', '', '103', '329', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '153', '4', 'pending'), 
('612', '2021-05-05', '0000-00-00', '00121', '', '121', '532', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '153', '4', 'pending'), 
('613', '2021-05-05', '0000-00-00', '00121', '', '107', '374', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '153', '4', 'pending'), 
('614', '2021-05-05', '0000-00-00', '00121', '', '117', '451', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '153', '4', 'pending'), 
('615', '2021-05-05', '0000-00-00', '00121', '', '117', '478', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '153', '4', 'pending'), 
('616', '2021-05-05', '0000-00-00', '00121', '', '97', '290', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '153', '4', 'pending'), 
('617', '2021-05-05', '0000-00-00', '00121', '', '98', '297', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '153', '4', 'pending'), 
('619', '2021-05-05', '0000-00-00', '00121', '', '123', '561', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '155', '4', 'pending'), 
('620', '2021-05-05', '0000-00-00', '00122', '', '123', '561', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '156', '4', 'pending'), 
('621', '2021-05-05', '0000-00-00', '0020', '', '35', '72', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '157', '9', 'pending'), 
('622', '2021-05-05', '0000-00-00', '00122', '', '35', '73', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '158', '9', 'pending'), 
('623', '2021-05-05', '0000-00-00', '00118', '', '45', '101', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '159', '9', 'pending'), 
('624', '2021-05-05', '0000-00-00', '00118', '', '45', '101', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '160', '9', 'pending'), 
('631', '2021-05-05', '0000-00-00', '00125', '', '117', '473', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '165', '4', 'pending'), 
('632', '2021-05-05', '0000-00-00', '00125', '', '120', '638', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '165', '4', 'pending'), 
('634', '2021-05-05', '0000-00-00', '62781', '', '45', '101', '', '6', '25', '', '', '', '0', '0.00', '', '0.00', '0.00', '167', '9', 'pending'), 
('643', '2021-05-05', '0000-00-00', '52475', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '172', '4', 'pending'), 
('644', '2021-05-05', '0000-00-00', '52475', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '172', '4', 'pending'), 
('645', '2021-05-05', '0000-00-00', '52475', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '172', '4', 'pending'), 
('646', '2021-05-05', '0000-00-00', '52475', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '172', '4', 'pending'), 
('647', '2021-05-05', '0000-00-00', '52475', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '172', '4', 'pending'), 
('670', '2021-05-06', '0000-00-00', '62116', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '175', '4', 'pending'), 
('671', '2021-05-06', '0000-00-00', '62116', '', '96', '282', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '175', '4', 'pending'), 
('672', '2021-05-06', '0000-00-00', '62116', '', '105', '616', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '175', '4', 'pending'), 
('673', '2021-05-06', '0000-00-00', '62116', '', '35', '72', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '175', '4', 'pending'), 
('674', '2021-05-06', '0000-00-00', '33150', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '176', '4', 'pending'), 
('675', '2021-05-06', '0000-00-00', '33150', '', '112', '287', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '176', '4', 'pending'), 
('676', '2021-05-06', '0000-00-00', '33150', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '176', '4', 'pending'), 
('677', '2021-05-06', '0000-00-00', '33150', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '176', '4', 'pending'), 
('678', '2021-05-06', '0000-00-00', '33150', '', '98', '299', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '176', '4', 'pending'), 
('679', '2021-05-06', '0000-00-00', '33150', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '176', '4', 'pending'), 
('680', '2021-05-06', '0000-00-00', '33150', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '176', '4', 'pending'), 
('681', '2021-05-06', '0000-00-00', '33150', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '176', '4', 'pending'), 
('682', '2021-05-06', '0000-00-00', '33150', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '176', '4', 'pending'), 
('683', '2021-05-06', '0000-00-00', '33150', '', '123', '561', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '176', '4', 'pending'), 
('684', '2021-05-06', '0000-00-00', '33150', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '176', '4', 'pending'), 
('694', '2021-05-06', '0000-00-00', '79338', '', '123', '561', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '180', '4', 'pending'), 
('695', '2021-05-06', '0000-00-00', '41306', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '181', '4', 'pending'), 
('696', '2021-05-06', '0000-00-00', '41306', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '181', '4', 'pending'), 
('697', '2021-05-06', '0000-00-00', '41306', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '181', '4', 'pending'), 
('698', '2021-05-06', '0000-00-00', '41306', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '181', '4', 'pending'), 
('699', '2021-05-06', '0000-00-00', '41306', '', '123', '519', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '181', '4', 'pending'), 
('700', '2021-05-07', '0000-00-00', '95174', '', '45', '101', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '182', '4', 'pending'), 
('701', '2021-05-07', '0000-00-00', '95174', '', '97', '290', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '182', '4', 'pending'), 
('702', '2021-05-07', '0000-00-00', '95174', '', '98', '297', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '182', '4', 'pending'), 
('703', '2021-05-07', '0000-00-00', '95174', '', '121', '532', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '182', '4', 'pending'), 
('704', '2021-05-07', '0000-00-00', '95174', '', '117', '593', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '182', '4', 'pending'), 
('705', '2021-05-07', '0000-00-00', '95174', '', '117', '451', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '182', '4', 'pending'), 
('706', '2021-05-07', '0000-00-00', '79472', '', '123', '519', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '183', '4', 'pending'), 
('708', '2021-05-07', '0000-00-00', '44364', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '185', '4', 'pending'), 
('709', '2021-05-07', '0000-00-00', '44364', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '185', '4', 'pending'), 
('710', '2021-05-07', '0000-00-00', '44364', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '185', '4', 'pending'), 
('711', '2021-05-07', '0000-00-00', '44364', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '185', '4', 'pending'), 
('712', '2021-05-07', '0000-00-00', '44364', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '185', '4', 'pending'), 
('713', '2021-05-07', '0000-00-00', '44364', '', '117', '467', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '185', '4', 'pending'), 
('714', '2021-05-07', '0000-00-00', '63094', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '186', '4', 'pending'), 
('715', '2021-05-07', '0000-00-00', '63094', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '186', '4', 'pending'), 
('716', '2021-05-07', '0000-00-00', '63094', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '186', '4', 'pending'), 
('717', '2021-05-07', '0000-00-00', '63094', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '186', '4', 'pending'), 
('718', '2021-05-07', '0000-00-00', '63094', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '186', '4', 'pending'), 
('719', '2021-05-07', '0000-00-00', '76494', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '187', '4', 'pending'), 
('720', '2021-05-07', '0000-00-00', '76494', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '187', '4', 'pending'), 
('721', '2021-05-07', '0000-00-00', '21157', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '188', '4', 'pending'), 
('722', '2021-05-07', '0000-00-00', '21157', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '188', '4', 'pending'), 
('723', '2021-05-07', '0000-00-00', '21157', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '188', '4', 'pending'), 
('724', '2021-05-07', '0000-00-00', '21157', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '188', '4', 'pending'), 
('725', '2021-05-07', '0000-00-00', '21157', '', '120', '519', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '188', '4', 'pending'), 
('742', '2021-05-08', '0000-00-00', '45503', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '191', '4', 'pending'), 
('743', '2021-05-08', '0000-00-00', '45503', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '191', '4', 'pending'), 
('744', '2021-05-08', '0000-00-00', '45503', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '191', '4', 'pending'), 
('745', '2021-05-08', '0000-00-00', '45503', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '191', '4', 'pending'), 
('746', '2021-05-08', '0000-00-00', '45503', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '191', '4', 'pending'), 
('747', '2021-05-08', '0000-00-00', '41701', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '192', '4', 'pending'), 
('748', '2021-05-08', '0000-00-00', '41701', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '192', '4', 'pending'), 
('749', '2021-05-08', '0000-00-00', '41701', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '192', '4', 'pending'), 
('750', '2021-05-08', '0000-00-00', '41701', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '192', '4', 'pending'), 
('751', '2021-05-08', '0000-00-00', '18880', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '193', '4', 'pending'), 
('752', '2021-05-08', '0000-00-00', '36810', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '194', '4', 'pending'), 
('766', '2021-05-08', '0000-00-00', '63037', '', '45', '101', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '197', '8', 'pending'), 
('767', '2021-05-08', '0000-00-00', '63037', '', '97', '290', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '197', '8', 'pending'), 
('768', '2021-05-08', '0000-00-00', '63037', '', '98', '297', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '197', '8', 'pending'), 
('769', '2021-05-08', '0000-00-00', '63037', '', '42', '338', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '197', '8', 'pending'), 
('770', '2021-05-08', '0000-00-00', '63037', '', '121', '532', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '197', '8', 'pending'), 
('771', '2021-05-08', '0000-00-00', '63037', '', '117', '451', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '197', '8', 'pending'), 
('772', '2021-05-08', '0000-00-00', '92806', '', '35', '73', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '198', '8', 'pending'), 
('773', '2021-05-08', '0000-00-00', '92806', '', '97', '290', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '198', '8', 'pending'), 
('774', '2021-05-08', '0000-00-00', '92806', '', '98', '299', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '198', '8', 'pending'), 
('775', '2021-05-08', '0000-00-00', '92806', '', '103', '329', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '198', '8', 'pending'), 
('776', '2021-05-08', '0000-00-00', '92806', '', '42', '338', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '198', '8', 'pending'), 
('777', '2021-05-08', '0000-00-00', '92806', '', '105', '353', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '198', '8', 'pending'), 
('778', '2021-05-08', '0000-00-00', '92806', '', '120', '527', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '198', '8', 'pending'), 
('779', '2021-05-08', '0000-00-00', '76543', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '199', '8', 'pending'), 
('780', '2021-05-08', '0000-00-00', '76543', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '199', '8', 'pending'), 
('781', '2021-05-08', '0000-00-00', '76543', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '199', '8', 'pending'), 
('782', '2021-05-08', '0000-00-00', '76543', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '199', '8', 'pending'), 
('783', '2021-05-08', '0000-00-00', '76543', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '199', '8', 'pending'), 
('784', '2021-05-08', '0000-00-00', '76543', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '199', '8', 'pending'), 
('785', '2021-05-08', '0000-00-00', '76543', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '199', '8', 'pending'), 
('787', '2021-05-08', '0000-00-00', '73841', '', '97', '290', '', '17', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '201', '8', 'pending'), 
('788', '2021-05-08', '0000-00-00', '73841', '', '121', '532', '', '17', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '201', '8', 'pending'), 
('789', '2021-05-08', '0000-00-00', '73841', '', '121', '534', '', '17', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '201', '8', 'pending'), 
('793', '2021-05-08', '0000-00-00', '52844', '', '42', '338', '', '17', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '203', '8', 'pending'), 
('794', '2021-05-08', '0000-00-00', '52844', '', '123', '561', '', '17', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '203', '8', 'pending'), 
('795', '2021-05-08', '0000-00-00', '52844', '', '117', '622', '', '17', '19', '', '', '', '0', '0.00', '', '0.00', '0.00', '203', '8', 'pending'), 
('801', '2021-05-08', '0000-00-00', '72000', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '205', '8', 'pending'), 
('802', '2021-05-08', '0000-00-00', '72000', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '205', '8', 'pending'), 
('803', '2021-05-08', '0000-00-00', '72000', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '205', '8', 'pending'), 
('804', '2021-05-08', '0000-00-00', '72000', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '205', '8', 'pending'), 
('805', '2021-05-08', '0000-00-00', '12268', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '206', '8', 'pending'), 
('806', '2021-05-08', '0000-00-00', '12268', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '206', '8', 'pending'), 
('807', '2021-05-08', '0000-00-00', '12268', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '206', '8', 'pending'), 
('808', '2021-05-08', '0000-00-00', '12268', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '206', '8', 'pending'), 
('809', '2021-05-08', '0000-00-00', '12268', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '206', '8', 'pending'), 
('810', '2021-05-09', '0000-00-00', '22404', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '207', '4', 'pending'), 
('811', '2021-05-09', '0000-00-00', '22404', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '207', '4', 'pending'), 
('812', '2021-05-09', '0000-00-00', '22404', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '207', '4', 'pending'), 
('813', '2021-05-09', '0000-00-00', '22404', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '207', '4', 'pending'), 
('814', '2021-05-09', '0000-00-00', '22404', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '207', '4', 'pending'), 
('815', '2021-05-09', '0000-00-00', '22404', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '207', '4', 'pending'), 
('816', '2021-05-09', '0000-00-00', '22404', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '207', '4', 'pending'), 
('817', '2021-05-09', '0000-00-00', '22404', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '207', '4', 'pending'), 
('818', '2021-05-09', '0000-00-00', '22404', '', '112', '287', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '207', '4', 'pending'), 
('819', '2021-05-09', '0000-00-00', '23296', '', '45', '101', '', '6', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '208', '4', 'pending'), 
('820', '2021-05-09', '0000-00-00', '23296', '', '42', '338', '', '6', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '208', '4', 'pending'), 
('821', '2021-05-09', '0000-00-00', '23296', '', '98', '297', '', '6', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '208', '4', 'pending'), 
('822', '2021-05-09', '0000-00-00', '23296', '', '107', '366', '', '6', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '208', '4', 'pending'), 
('823', '2021-05-09', '0000-00-00', '23296', '', '107', '374', '', '6', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '208', '4', 'pending'), 
('824', '2021-05-09', '0000-00-00', '23296', '', '117', '451', '', '6', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '208', '4', 'pending'), 
('825', '2021-05-09', '0000-00-00', '23296', '', '117', '473', '', '6', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '208', '4', 'pending'), 
('826', '2021-05-09', '0000-00-00', '23296', '', '123', '561', '', '6', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '208', '4', 'pending'), 
('827', '2021-05-09', '2021-05-09', '21079', '', '123', '561', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '209', '8', 'pending'), 
('828', '2021-05-09', '2021-05-09', '21079', '', '123', '561', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '209', '8', 'pending'), 
('829', '2021-05-09', '2021-05-09', '21079', '', '123', '561', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '209', '8', 'pending'), 
('830', '2021-05-09', '2021-05-09', '21079', '', '123', '561', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '209', '8', 'pending'), 
('831', '2021-05-09', '0000-00-00', '44218', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '210', '8', 'pending'), 
('832', '2021-05-09', '0000-00-00', '44218', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '210', '8', 'pending'), 
('833', '2021-05-09', '0000-00-00', '44218', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '210', '8', 'pending'), 
('834', '2021-05-09', '0000-00-00', '44218', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '210', '8', 'pending'), 
('835', '2021-05-09', '0000-00-00', '26344', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '211', '8', 'pending'), 
('836', '2021-05-09', '0000-00-00', '26344', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '211', '8', 'pending'), 
('837', '2021-05-09', '0000-00-00', '26344', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '211', '8', 'pending'), 
('838', '2021-05-09', '0000-00-00', '26344', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '211', '8', 'pending'), 
('839', '2021-05-09', '0000-00-00', '26344', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '211', '8', 'pending'), 
('840', '2021-05-09', '0000-00-00', '71439', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '212', '8', 'pending'), 
('841', '2021-05-09', '0000-00-00', '71439', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '212', '8', 'pending'), 
('842', '2021-05-09', '0000-00-00', '71439', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '212', '8', 'pending'), 
('843', '2021-05-09', '0000-00-00', '71439', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '212', '8', 'pending'), 
('850', '2021-05-09', '0000-00-00', '19350', '', '45', '101', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '214', '8', 'pending'), 
('851', '2021-05-09', '0000-00-00', '19350', '', '97', '290', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '214', '8', 'pending'), 
('852', '2021-05-09', '0000-00-00', '19350', '', '98', '297', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '214', '8', 'pending'), 
('853', '2021-05-09', '0000-00-00', '19350', '', '104', '309', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '214', '8', 'pending'), 
('854', '2021-05-09', '0000-00-00', '19350', '', '42', '338', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '214', '8', 'pending'), 
('855', '2021-05-09', '0000-00-00', '19350', '', '123', '561', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '214', '8', 'pending'), 
('856', '2021-05-09', '0000-00-00', '77908', '', '42', '338', '', '17', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '215', '8', 'pending'), 
('857', '2021-05-09', '0000-00-00', '77908', '', '121', '532', '', '17', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '215', '8', 'pending'), 
('858', '2021-05-09', '0000-00-00', '77908', '', '117', '451', '', '17', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '215', '8', 'pending'), 
('860', '2021-05-09', '0000-00-00', '85079', '', '117', '593', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '217', '8', 'pending'), 
('861', '2021-05-10', '0000-00-00', '68407', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '218', '8', 'pending'), 
('862', '2021-05-10', '0000-00-00', '68407', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '218', '8', 'pending'), 
('863', '2021-05-10', '0000-00-00', '68407', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '218', '8', 'pending'), 
('864', '2021-05-10', '0000-00-00', '68407', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '218', '8', 'pending'), 
('865', '2021-05-10', '0000-00-00', '68407', '', '120', '519', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '218', '8', 'pending'), 
('866', '2021-05-10', '0000-00-00', '12586', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '219', '8', 'pending'), 
('867', '2021-05-10', '0000-00-00', '12586', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '219', '8', 'pending'), 
('868', '2021-05-10', '0000-00-00', '12586', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '219', '8', 'pending'), 
('869', '2021-05-10', '0000-00-00', '12586', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '219', '8', 'pending'), 
('870', '2021-05-10', '0000-00-00', '38952', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '220', '8', 'pending'), 
('871', '2021-05-10', '0000-00-00', '38952', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '220', '8', 'pending'), 
('872', '2021-05-10', '0000-00-00', '38952', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '220', '8', 'pending'), 
('873', '2021-05-10', '0000-00-00', '38952', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '220', '8', 'pending'), 
('874', '2021-05-10', '0000-00-00', '38952', '', '120', '519', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '220', '8', 'pending'), 
('879', '2021-05-10', '0000-00-00', '33525', '', '45', '101', '', '17', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '222', '8', 'pending'), 
('880', '2021-05-10', '0000-00-00', '33525', '', '107', '377', '', '17', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '222', '8', 'pending'), 
('881', '2021-05-10', '0000-00-00', '33525', '', '107', '366', '', '17', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '222', '8', 'pending'), 
('882', '2021-05-10', '0000-00-00', '33525', '', '42', '338', '', '17', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '222', '8', 'pending'), 
('892', '2021-05-10', '0000-00-00', '53828', '', '45', '101', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '224', '8', 'pending'), 
('893', '2021-05-10', '0000-00-00', '53828', '', '97', '290', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '224', '8', 'pending'), 
('894', '2021-05-10', '0000-00-00', '53828', '', '98', '297', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '224', '8', 'pending'), 
('895', '2021-05-10', '0000-00-00', '53828', '', '112', '287', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '224', '8', 'pending'), 
('896', '2021-05-10', '0000-00-00', '53828', '', '96', '284', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '224', '8', 'pending'), 
('897', '2021-05-10', '0000-00-00', '53828', '', '107', '366', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '224', '8', 'pending'), 
('898', '2021-05-10', '0000-00-00', '53828', '', '103', '329', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '224', '8', 'pending'), 
('899', '2021-05-10', '0000-00-00', '53828', '', '107', '374', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '224', '8', 'pending'), 
('900', '2021-05-10', '0000-00-00', '53828', '', '105', '616', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '224', '8', 'pending'), 
('901', '2021-05-10', '0000-00-00', '53828', '', '121', '532', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '224', '8', 'pending'), 
('902', '2021-05-10', '0000-00-00', '53828', '', '117', '451', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '224', '8', 'pending'), 
('903', '2021-05-10', '0000-00-00', '20165', '', '45', '101', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '225', '8', 'pending'), 
('904', '2021-05-10', '0000-00-00', '20165', '', '107', '374', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '225', '8', 'pending'), 
('905', '2021-05-10', '0000-00-00', '20165', '', '117', '629', '', '17', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '225', '8', 'pending'), 
('906', '2021-05-11', '0000-00-00', '70010', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '226', '8', 'pending'), 
('907', '2021-05-11', '0000-00-00', '70010', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '226', '8', 'pending'), 
('908', '2021-05-11', '0000-00-00', '70010', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '226', '8', 'pending'), 
('909', '2021-05-11', '0000-00-00', '70010', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '226', '8', 'pending'), 
('910', '2021-05-11', '0000-00-00', '72443', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '227', '8', 'pending'), 
('911', '2021-05-11', '0000-00-00', '72443', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '227', '8', 'pending'), 
('912', '2021-05-11', '0000-00-00', '72443', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '227', '8', 'pending'), 
('913', '2021-05-11', '0000-00-00', '72443', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '227', '8', 'pending'), 
('914', '2021-05-11', '0000-00-00', '72443', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '227', '8', 'pending'), 
('915', '2021-05-11', '0000-00-00', '72443', '', '120', '519', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '227', '8', 'pending'), 
('918', '2021-05-11', '0000-00-00', '12202', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '229', '8', 'pending'), 
('919', '2021-05-11', '0000-00-00', '12202', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '229', '8', 'pending'), 
('920', '2021-05-11', '0000-00-00', '12202', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '229', '8', 'pending'), 
('921', '2021-05-11', '0000-00-00', '12202', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '229', '8', 'pending'), 
('922', '2021-05-11', '0000-00-00', '12202', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '229', '8', 'pending'), 
('931', '2021-05-12', '2021-05-12', '49163', '', '121', '532', '', '31', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '231', '4', 'pending'), 
('932', '2021-05-12', '2021-05-12', '49163', '', '121', '532', '', '31', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '231', '4', 'pending'), 
('933', '2021-05-12', '2021-05-12', '49163', '', '121', '532', '', '31', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '231', '4', 'pending'), 
('934', '2021-05-12', '2021-05-12', '49163', '', '121', '532', '', '31', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '231', '4', 'pending'), 
('935', '2021-05-12', '2021-05-12', '49163', '', '121', '532', '', '31', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '231', '4', 'pending'), 
('936', '2021-05-12', '2021-05-12', '49163', '', '121', '532', '', '31', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '231', '4', 'pending'), 
('937', '2021-05-12', '2021-05-12', '49163', '', '121', '532', '', '31', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '231', '4', 'pending'), 
('938', '2021-05-12', '2021-05-12', '49163', '', '121', '532', '', '31', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '231', '4', 'pending'), 
('939', '2021-05-12', '0000-00-00', '39501', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '232', '4', 'pending'), 
('940', '2021-05-12', '0000-00-00', '39501', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '232', '4', 'pending'), 
('941', '2021-05-12', '0000-00-00', '39501', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '232', '4', 'pending'), 
('942', '2021-05-12', '0000-00-00', '39501', '', '107', '377', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '232', '4', 'pending'), 
('943', '2021-05-12', '0000-00-00', '39501', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '232', '4', 'pending'), 
('944', '2021-05-12', '0000-00-00', '39501', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '232', '4', 'pending'), 
('945', '2021-05-12', '0000-00-00', '39501', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '232', '4', 'pending'), 
('946', '2021-05-12', '0000-00-00', '39501', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '232', '4', 'pending'), 
('947', '2021-05-12', '0000-00-00', '39501', '', '123', '561', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '232', '4', 'pending'), 
('948', '2021-05-12', '0000-00-00', '39501', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '232', '4', 'pending'), 
('949', '2021-05-12', '0000-00-00', '54442', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '233', '4', 'pending'), 
('950', '2021-05-12', '0000-00-00', '54442', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '233', '4', 'pending'), 
('977', '2021-05-12', '0000-00-00', '63420', '', '99', '304', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '239', '8', 'pending'), 
('978', '2021-05-12', '0000-00-00', '54070', '', '35', '73', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '240', '8', 'pending'), 
('979', '2021-05-12', '0000-00-00', '54070', '', '97', '290', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '240', '8', 'pending'), 
('980', '2021-05-12', '0000-00-00', '54070', '', '98', '299', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '240', '8', 'pending'), 
('981', '2021-05-12', '0000-00-00', '54070', '', '120', '634', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '240', '8', 'pending'), 
('982', '2021-05-12', '0000-00-00', '46291', '', '45', '101', '', '17', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '241', '8', 'pending'), 
('983', '2021-05-12', '0000-00-00', '46291', '', '97', '290', '', '17', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '241', '8', 'pending'), 
('984', '2021-05-12', '0000-00-00', '46291', '', '98', '297', '', '17', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '241', '8', 'pending'), 
('985', '2021-05-12', '0000-00-00', '46291', '', '103', '329', '', '17', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '241', '8', 'pending'), 
('986', '2021-05-12', '0000-00-00', '46291', '', '107', '366', '', '17', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '241', '8', 'pending'), 
('987', '2021-05-12', '0000-00-00', '46291', '', '117', '451', '', '17', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '241', '8', 'pending'), 
('988', '2021-05-12', '0000-00-00', '46291', '', '121', '532', '', '17', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '241', '8', 'pending'), 
('989', '2021-05-12', '0000-00-00', '46291', '', '117', '472', '', '17', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '241', '8', 'pending'), 
('990', '2021-05-16', '0000-00-00', '20448', '', '45', '101', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '242', '8', 'pending'), 
('991', '2021-05-16', '0000-00-00', '20448', '', '97', '290', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '242', '8', 'pending'), 
('992', '2021-05-16', '0000-00-00', '20448', '', '98', '297', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '242', '8', 'pending'), 
('993', '2021-05-16', '0000-00-00', '20448', '', '121', '532', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '242', '8', 'pending'), 
('994', '2021-05-16', '0000-00-00', '20448', '', '123', '561', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '242', '8', 'pending'), 
('995', '2021-05-16', '0000-00-00', '20448', '', '117', '451', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '242', '8', 'pending'), 
('996', '2021-05-16', '0000-00-00', '20448', '', '117', '469', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '242', '8', 'pending'), 
('997', '2021-05-16', '0000-00-00', '20448', '', '99', '598', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '242', '8', 'pending'), 
('998', '2021-05-16', '0000-00-00', '89737', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '243', '8', 'pending'), 
('999', '2021-05-16', '0000-00-00', '89737', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '243', '8', 'pending'), 
('1000', '2021-05-16', '0000-00-00', '89737', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '243', '8', 'pending'), 
('1001', '2021-05-16', '0000-00-00', '89737', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '243', '8', 'pending'), 
('1002', '2021-05-16', '0000-00-00', '89737', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '243', '8', 'pending'), 
('1003', '2021-05-16', '0000-00-00', '54550', '', '45', '101', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '244', '8', 'pending'), 
('1004', '2021-05-16', '0000-00-00', '54550', '', '97', '290', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '244', '8', 'pending'), 
('1005', '2021-05-16', '0000-00-00', '54550', '', '98', '297', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '244', '8', 'pending'), 
('1006', '2021-05-16', '0000-00-00', '54550', '', '107', '366', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '244', '8', 'pending'), 
('1007', '2021-05-16', '0000-00-00', '54550', '', '42', '338', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '244', '8', 'pending'), 
('1008', '2021-05-16', '0000-00-00', '54550', '', '121', '532', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '244', '8', 'pending'), 
('1009', '2021-05-16', '0000-00-00', '54550', '', '123', '561', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '244', '8', 'pending'), 
('1010', '2021-05-16', '2021-05-16', '68073', '', '105', '357', '', '17', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '245', '8', 'pending'), 
('1011', '2021-05-16', '2021-05-16', '68073', '', '105', '357', '', '17', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '245', '8', 'pending'), 
('1012', '2021-05-16', '2021-05-16', '68073', '', '105', '357', '', '17', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '245', '8', 'pending'), 
('1013', '2021-05-16', '2021-05-16', '68073', '', '105', '357', '', '17', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '245', '8', 'pending'), 
('1014', '2021-05-16', '2021-05-16', '68073', '', '105', '357', '', '17', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '245', '8', 'pending'), 
('1015', '2021-05-16', '2021-05-16', '68073', '', '105', '357', '', '17', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '245', '8', 'pending'), 
('1023', '2021-05-16', '0000-00-00', '77250', '', '45', '101', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '247', '8', 'pending'), 
('1024', '2021-05-16', '0000-00-00', '77250', '', '97', '290', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '247', '8', 'pending'), 
('1025', '2021-05-16', '0000-00-00', '77250', '', '98', '297', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '247', '8', 'pending'), 
('1026', '2021-05-16', '0000-00-00', '77250', '', '107', '366', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '247', '8', 'pending'), 
('1027', '2021-05-16', '0000-00-00', '77250', '', '121', '532', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '247', '8', 'pending'), 
('1028', '2021-05-16', '0000-00-00', '77250', '', '117', '451', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '247', '8', 'pending'), 
('1029', '2021-05-16', '0000-00-00', '77250', '', '115', '446', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '247', '8', 'pending'), 
('1030', '2021-05-16', '0000-00-00', '77250', '', '42', '338', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '247', '8', 'pending'), 
('1031', '2021-05-16', '0000-00-00', '77250', '', '36', '102', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '247', '8', 'pending'), 
('1032', '2021-05-16', '0000-00-00', '13235', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '248', '8', 'pending'), 
('1033', '2021-05-16', '0000-00-00', '13235', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '248', '8', 'pending'), 
('1034', '2021-05-16', '0000-00-00', '13235', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '248', '8', 'pending'), 
('1035', '2021-05-16', '0000-00-00', '13235', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '248', '8', 'pending'), 
('1036', '2021-05-16', '0000-00-00', '13235', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '248', '8', 'pending'), 
('1037', '2021-05-16', '0000-00-00', '94901', '', '97', '290', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '249', '8', 'pending'), 
('1038', '2021-05-16', '0000-00-00', '94901', '', '42', '338', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '249', '8', 'pending'), 
('1039', '2021-05-16', '0000-00-00', '94901', '', '117', '467', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '249', '8', 'pending'), 
('1040', '2021-05-16', '0000-00-00', '28951', '', '45', '101', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '250', '8', 'pending'), 
('1041', '2021-05-16', '0000-00-00', '28951', '', '97', '290', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '250', '8', 'pending'), 
('1042', '2021-05-16', '0000-00-00', '28951', '', '98', '297', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '250', '8', 'pending'), 
('1043', '2021-05-16', '0000-00-00', '28951', '', '42', '338', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '250', '8', 'pending'), 
('1044', '2021-05-16', '0000-00-00', '28951', '', '121', '532', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '250', '8', 'pending'), 
('1045', '2021-05-16', '0000-00-00', '28951', '', '117', '451', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '250', '8', 'pending'), 
('1046', '2021-05-16', '0000-00-00', '28951', '', '115', '446', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '250', '8', 'pending'), 
('1047', '2021-05-16', '2021-05-16', '37551', '', '123', '561', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '251', '8', 'pending'), 
('1048', '2021-05-16', '2021-05-16', '37551', '', '123', '561', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '251', '8', 'pending'), 
('1049', '2021-05-16', '2021-05-16', '37551', '', '123', '561', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '251', '8', 'pending'), 
('1050', '2021-05-16', '2021-05-16', '37551', '', '123', '561', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '251', '8', 'pending'), 
('1051', '2021-05-16', '2021-05-16', '37551', '', '123', '561', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '251', '8', 'pending'), 
('1052', '2021-05-16', '2021-05-16', '37551', '', '123', '561', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '251', '8', 'pending'), 
('1053', '2021-05-16', '2021-05-16', '37551', '', '123', '561', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '251', '8', 'pending'), 
('1054', '2021-05-16', '2021-05-16', '47130', '', '100', '583', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '252', '8', 'pending'), 
('1055', '2021-05-16', '2021-05-16', '47130', '', '100', '583', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '252', '8', 'pending'), 
('1056', '2021-05-16', '2021-05-16', '47130', '', '100', '583', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '252', '8', 'pending'), 
('1057', '2021-05-16', '2021-05-16', '47130', '', '100', '583', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '252', '8', 'pending'), 
('1058', '2021-05-16', '2021-05-16', '47130', '', '100', '583', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '252', '8', 'pending'), 
('1059', '2021-05-16', '2021-05-16', '47130', '', '100', '583', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '252', '8', 'pending'), 
('1060', '2021-05-16', '2021-05-16', '47130', '', '100', '583', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '252', '8', 'pending'), 
('1061', '2021-05-16', '0000-00-00', '15821', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '253', '8', 'pending'), 
('1062', '2021-05-16', '0000-00-00', '15821', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '253', '8', 'pending'), 
('1063', '2021-05-16', '0000-00-00', '15821', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '253', '8', 'pending'), 
('1064', '2021-05-16', '0000-00-00', '15821', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '253', '8', 'pending'), 
('1065', '2021-05-16', '0000-00-00', '15821', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '253', '8', 'pending'), 
('1066', '2021-05-16', '0000-00-00', '71844', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '254', '8', 'pending'), 
('1067', '2021-05-16', '0000-00-00', '71844', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '254', '8', 'pending'), 
('1068', '2021-05-16', '0000-00-00', '71844', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '254', '8', 'pending'), 
('1069', '2021-05-16', '0000-00-00', '71844', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '254', '8', 'pending'), 
('1092', '2021-05-17', '2021-05-17', '13740', '', '121', '532', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '257', '8', 'pending'), 
('1093', '2021-05-17', '2021-05-17', '13740', '', '121', '532', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '257', '8', 'pending'), 
('1094', '2021-05-17', '2021-05-17', '13740', '', '121', '532', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '257', '8', 'pending'), 
('1095', '2021-05-17', '2021-05-17', '13740', '', '121', '532', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '257', '8', 'pending'), 
('1096', '2021-05-17', '2021-05-17', '13740', '', '121', '532', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '257', '8', 'pending'), 
('1097', '2021-05-17', '2021-05-17', '13740', '', '121', '532', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '257', '8', 'pending'), 
('1098', '2021-05-17', '2021-05-17', '13740', '', '121', '532', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '257', '8', 'pending'), 
('1099', '2021-05-17', '2021-05-17', '37939', '', '123', '561', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '258', '8', 'pending'), 
('1100', '2021-05-17', '2021-05-17', '37939', '', '123', '561', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '258', '8', 'pending'), 
('1101', '2021-05-17', '2021-05-17', '37939', '', '123', '561', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '258', '8', 'pending'), 
('1102', '2021-05-17', '2021-05-17', '37939', '', '123', '561', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '258', '8', 'pending'), 
('1103', '2021-05-17', '2021-05-17', '37939', '', '123', '561', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '258', '8', 'pending'), 
('1104', '2021-05-17', '2021-05-17', '37939', '', '123', '561', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '258', '8', 'pending'), 
('1105', '2021-05-17', '2021-05-17', '37939', '', '123', '561', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '258', '8', 'pending'), 
('1106', '2021-05-17', '2021-05-17', '37939', '', '123', '561', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '258', '8', 'pending'), 
('1107', '2021-05-17', '0000-00-00', '15896', '', '98', '299', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '259', '8', 'pending'), 
('1108', '2021-05-17', '0000-00-00', '15896', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '259', '8', 'pending'), 
('1109', '2021-05-17', '0000-00-00', '15896', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '259', '8', 'pending'), 
('1110', '2021-05-17', '0000-00-00', '28489', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '260', '8', 'pending'), 
('1111', '2021-05-17', '0000-00-00', '28489', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '260', '8', 'pending'), 
('1112', '2021-05-17', '0000-00-00', '28489', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '260', '8', 'pending'), 
('1113', '2021-05-17', '0000-00-00', '28489', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '260', '8', 'pending'), 
('1114', '2021-05-17', '0000-00-00', '28489', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '260', '8', 'pending'), 
('1115', '2021-05-17', '2021-05-17', '56309', '', '120', '634', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '261', '8', 'pending'), 
('1116', '2021-05-17', '2021-05-17', '56309', '', '120', '634', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '261', '8', 'pending'), 
('1117', '2021-05-17', '2021-05-17', '56309', '', '120', '634', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '261', '8', 'pending'), 
('1118', '2021-05-17', '2021-05-17', '56309', '', '120', '634', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '261', '8', 'pending'), 
('1119', '2021-05-17', '2021-05-17', '56309', '', '120', '634', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '261', '8', 'pending'), 
('1120', '2021-05-17', '0000-00-00', '87537', '', '45', '101', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '262', '8', 'pending'), 
('1121', '2021-05-17', '0000-00-00', '87537', '', '97', '290', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '262', '8', 'pending'), 
('1122', '2021-05-17', '0000-00-00', '87537', '', '107', '366', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '262', '8', 'pending'), 
('1123', '2021-05-17', '0000-00-00', '87537', '', '42', '338', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '262', '8', 'pending'), 
('1124', '2021-05-17', '0000-00-00', '87537', '', '117', '451', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '262', '8', 'pending'), 
('1125', '2021-05-17', '0000-00-00', '87537', '', '121', '532', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '262', '8', 'pending'), 
('1126', '2021-05-17', '0000-00-00', '87537', '', '123', '561', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '262', '8', 'pending'), 
('1127', '2021-05-17', '0000-00-00', '69099', '', '45', '101', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '263', '8', 'pending'), 
('1128', '2021-05-17', '0000-00-00', '69099', '', '97', '290', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '263', '8', 'pending'), 
('1129', '2021-05-17', '0000-00-00', '69099', '', '98', '297', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '263', '8', 'pending'), 
('1130', '2021-05-17', '0000-00-00', '69099', '', '103', '329', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '263', '8', 'pending'), 
('1131', '2021-05-17', '0000-00-00', '69099', '', '107', '366', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '263', '8', 'pending'), 
('1132', '2021-05-17', '0000-00-00', '69099', '', '117', '451', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '263', '8', 'pending'), 
('1133', '2021-05-17', '0000-00-00', '69099', '', '121', '532', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '263', '8', 'pending'), 
('1134', '2021-05-17', '0000-00-00', '69099', '', '123', '561', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '263', '8', 'pending'), 
('1135', '2021-05-17', '0000-00-00', '17844', '', '114', '445', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '264', '8', 'pending'), 
('1136', '2021-05-17', '2021-05-17', '62965', '', '117', '624', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '265', '8', 'pending'), 
('1137', '2021-05-17', '2021-05-17', '62965', '', '117', '624', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '265', '8', 'pending'), 
('1138', '2021-05-17', '2021-05-17', '62965', '', '117', '624', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '265', '8', 'pending'), 
('1139', '2021-05-17', '2021-05-17', '62965', '', '117', '624', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '265', '8', 'pending'), 
('1140', '2021-05-17', '2021-05-17', '62965', '', '117', '624', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '265', '8', 'pending'), 
('1141', '2021-05-17', '2021-05-17', '62965', '', '117', '624', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '265', '8', 'pending'), 
('1142', '2021-05-17', '2021-05-17', '62965', '', '117', '624', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '265', '8', 'pending'), 
('1143', '2021-05-17', '0000-00-00', '15460', '', '35', '73', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '266', '8', 'pending'), 
('1144', '2021-05-17', '0000-00-00', '15460', '', '97', '290', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '266', '8', 'pending'), 
('1145', '2021-05-17', '0000-00-00', '15460', '', '98', '297', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '266', '8', 'pending'), 
('1146', '2021-05-17', '0000-00-00', '15460', '', '99', '302', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '266', '8', 'pending'), 
('1147', '2021-05-17', '0000-00-00', '15460', '', '42', '338', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '266', '8', 'pending'), 
('1148', '2021-05-17', '0000-00-00', '15460', '', '107', '366', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '266', '8', 'pending'), 
('1149', '2021-05-17', '0000-00-00', '15460', '', '123', '561', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '266', '8', 'pending'), 
('1150', '2021-05-17', '0000-00-00', '15460', '', '105', '616', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '266', '8', 'pending'), 
('1151', '2021-05-17', '0000-00-00', '53543', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '267', '8', 'pending'), 
('1152', '2021-05-17', '0000-00-00', '53543', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '267', '8', 'pending'), 
('1153', '2021-05-17', '0000-00-00', '53543', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '267', '8', 'pending'), 
('1154', '2021-05-17', '0000-00-00', '53543', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '267', '8', 'pending'), 
('1155', '2021-05-17', '0000-00-00', '53543', '', '99', '598', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '267', '8', 'pending'), 
('1156', '2021-05-17', '0000-00-00', '52496', '', '120', '519', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '268', '8', 'pending'), 
('1157', '2021-05-17', '0000-00-00', '78159', '', '45', '101', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '269', '8', 'pending'), 
('1158', '2021-05-17', '0000-00-00', '78159', '', '97', '290', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '269', '8', 'pending'), 
('1159', '2021-05-17', '0000-00-00', '78159', '', '98', '297', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '269', '8', 'pending'), 
('1160', '2021-05-17', '0000-00-00', '78159', '', '102', '319', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '269', '8', 'pending'), 
('1161', '2021-05-17', '0000-00-00', '78159', '', '42', '338', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '269', '8', 'pending'), 
('1162', '2021-05-17', '0000-00-00', '78159', '', '117', '451', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '269', '8', 'pending'), 
('1163', '2021-05-17', '0000-00-00', '78159', '', '121', '532', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '269', '8', 'pending'), 
('1164', '2021-05-17', '0000-00-00', '78159', '', '123', '561', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '269', '8', 'pending'), 
('1165', '2021-05-17', '0000-00-00', '78159', '', '117', '623', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '269', '8', 'pending'), 
('1166', '2021-05-17', '0000-00-00', '37901', '', '45', '101', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '270', '8', 'pending'), 
('1167', '2021-05-17', '0000-00-00', '37901', '', '98', '297', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '270', '8', 'pending'), 
('1168', '2021-05-17', '0000-00-00', '41432', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '271', '8', 'pending'), 
('1169', '2021-05-17', '0000-00-00', '41432', '', '112', '287', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '271', '8', 'pending'), 
('1170', '2021-05-17', '0000-00-00', '41432', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '271', '8', 'pending'), 
('1171', '2021-05-17', '0000-00-00', '41432', '', '98', '299', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '271', '8', 'pending'), 
('1185', '2021-05-17', '2021-05-17', '71298', '', '105', '616', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '274', '8', 'pending'), 
('1186', '2021-05-17', '2021-05-17', '71298', '', '105', '616', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '274', '8', 'pending'), 
('1187', '2021-05-17', '2021-05-17', '71298', '', '105', '616', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '274', '8', 'pending'), 
('1188', '2021-05-17', '2021-05-17', '71298', '', '105', '616', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '274', '8', 'pending'), 
('1189', '2021-05-17', '2021-05-17', '71298', '', '105', '616', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '274', '8', 'pending'), 
('1190', '2021-05-17', '2021-05-17', '71298', '', '105', '616', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '274', '8', 'pending'), 
('1191', '2021-05-17', '2021-05-17', '71298', '', '105', '616', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '274', '8', 'pending'), 
('1192', '2021-05-17', '2021-05-17', '71298', '', '105', '616', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '274', '8', 'pending'), 
('1193', '2021-05-17', '0000-00-00', '28475', '', '45', '101', '', '17', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '275', '8', 'pending'), 
('1194', '2021-05-17', '0000-00-00', '28475', '', '107', '366', '', '17', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '275', '8', 'pending'), 
('1195', '2021-05-17', '0000-00-00', '28475', '', '98', '297', '', '17', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '275', '8', 'pending'), 
('1196', '2021-05-17', '0000-00-00', '22785', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '276', '8', 'pending'), 
('1197', '2021-05-17', '0000-00-00', '22785', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '276', '8', 'pending'), 
('1198', '2021-05-17', '0000-00-00', '22785', '', '112', '287', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '276', '8', 'pending'), 
('1199', '2021-05-17', '0000-00-00', '85023', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '277', '8', 'pending'), 
('1200', '2021-05-17', '0000-00-00', '85023', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '277', '8', 'pending'), 
('1201', '2021-05-17', '0000-00-00', '85023', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '277', '8', 'pending'), 
('1202', '2021-05-17', '0000-00-00', '14129', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '278', '8', 'pending'), 
('1203', '2021-05-17', '0000-00-00', '14129', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '278', '8', 'pending'), 
('1204', '2021-05-17', '0000-00-00', '14129', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '278', '8', 'pending'), 
('1205', '2021-05-17', '0000-00-00', '14129', '', '104', '309', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '278', '8', 'pending'), 
('1206', '2021-05-17', '0000-00-00', '14129', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '278', '8', 'pending'), 
('1207', '2021-05-17', '0000-00-00', '14129', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '278', '8', 'pending'), 
('1208', '2021-05-17', '0000-00-00', '30571', '', '125', '643', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '279', '8', 'pending'), 
('1213', '2021-05-17', '0000-00-00', '48858', '', '35', '73', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '281', '8', 'pending'), 
('1214', '2021-05-17', '0000-00-00', '48858', '', '45', '101', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '281', '8', 'pending'), 
('1215', '2021-05-17', '0000-00-00', '48858', '', '107', '366', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '281', '8', 'pending'), 
('1216', '2021-05-17', '0000-00-00', '48858', '', '42', '338', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '281', '8', 'pending'), 
('1217', '2021-05-17', '0000-00-00', '48858', '', '97', '290', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '281', '8', 'pending'), 
('1218', '2021-05-17', '0000-00-00', '48858', '', '98', '297', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '281', '8', 'pending'), 
('1219', '2021-05-17', '0000-00-00', '48858', '', '107', '370', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '281', '8', 'pending'), 
('1220', '2021-05-17', '0000-00-00', '48858', '', '103', '329', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '281', '8', 'pending'), 
('1221', '2021-05-17', '0000-00-00', '48858', '', '105', '616', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '281', '8', 'pending'), 
('1222', '2021-05-17', '0000-00-00', '48858', '', '120', '527', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '281', '8', 'pending'), 
('1223', '2021-05-17', '0000-00-00', '59824', '', '112', '287', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '282', '8', 'pending'), 
('1224', '2021-05-17', '0000-00-00', '59824', '', '99', '307', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '282', '8', 'pending'), 
('1225', '2021-05-17', '0000-00-00', '59824', '', '104', '309', '', '17', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '282', '8', 'pending'), 
('1226', '2021-05-17', '0000-00-00', '73114', '', '121', '533', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '283', '8', 'pending'), 
('1227', '2021-05-18', '0000-00-00', '76754', '', '45', '101', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '284', '8', 'pending'), 
('1228', '2021-05-18', '0000-00-00', '76754', '', '97', '290', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '284', '8', 'pending'), 
('1229', '2021-05-18', '0000-00-00', '76754', '', '121', '532', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '284', '8', 'pending'), 
('1230', '2021-05-18', '0000-00-00', '76754', '', '107', '366', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '284', '8', 'pending'), 
('1231', '2021-05-18', '0000-00-00', '76754', '', '98', '297', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '284', '8', 'pending'), 
('1232', '2021-05-18', '0000-00-00', '76754', '', '112', '287', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '284', '8', 'pending'), 
('1233', '2021-05-18', '0000-00-00', '76754', '', '103', '329', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '284', '8', 'pending'), 
('1234', '2021-05-18', '0000-00-00', '76754', '', '98', '299', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '284', '8', 'pending'), 
('1235', '2021-05-18', '0000-00-00', '76754', '', '107', '370', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '284', '8', 'pending'), 
('1236', '2021-05-18', '0000-00-00', '76754', '', '99', '304', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '284', '8', 'pending'), 
('1237', '2021-05-18', '0000-00-00', '76754', '', '42', '338', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '284', '8', 'pending'), 
('1238', '2021-05-18', '0000-00-00', '76754', '', '120', '634', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '284', '8', 'pending'), 
('1239', '2021-05-18', '0000-00-00', '87053', '', '45', '101', '', '34', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '285', '8', 'pending'), 
('1240', '2021-05-18', '0000-00-00', '87053', '', '97', '290', '', '34', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '285', '8', 'pending'), 
('1241', '2021-05-18', '0000-00-00', '87053', '', '98', '297', '', '34', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '285', '8', 'pending'), 
('1242', '2021-05-18', '0000-00-00', '87053', '', '107', '366', '', '34', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '285', '8', 'pending'), 
('1243', '2021-05-18', '0000-00-00', '87053', '', '98', '299', '', '34', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '285', '8', 'pending'), 
('1244', '2021-05-18', '0000-00-00', '87053', '', '112', '287', '', '34', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '285', '8', 'pending'), 
('1245', '2021-05-18', '0000-00-00', '87053', '', '103', '329', '', '34', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '285', '8', 'pending'), 
('1246', '2021-05-18', '0000-00-00', '87053', '', '99', '304', '', '34', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '285', '8', 'pending'), 
('1247', '2021-05-18', '0000-00-00', '87053', '', '121', '532', '', '34', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '285', '8', 'pending'), 
('1248', '2021-05-18', '0000-00-00', '87053', '', '42', '338', '', '34', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '285', '8', 'pending'), 
('1249', '2021-05-18', '0000-00-00', '87053', '', '120', '634', '', '34', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '285', '8', 'pending'), 
('1250', '2021-05-18', '0000-00-00', '36967', '', '35', '73', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '286', '8', 'pending'), 
('1251', '2021-05-18', '0000-00-00', '36967', '', '97', '290', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '286', '8', 'pending'), 
('1252', '2021-05-18', '0000-00-00', '36967', '', '98', '297', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '286', '8', 'pending'), 
('1253', '2021-05-18', '0000-00-00', '36967', '', '117', '451', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '286', '8', 'pending'), 
('1254', '2021-05-18', '0000-00-00', '36967', '', '121', '532', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '286', '8', 'pending'), 
('1255', '2021-05-18', '0000-00-00', '63930', '', '123', '561', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '287', '8', 'pending'), 
('1256', '2021-05-18', '0000-00-00', '22023', '', '120', '634', '', '35', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '288', '4', 'pending'), 
('1257', '2021-05-18', '0000-00-00', '69334', '', '120', '634', '', '35', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '289', '4', 'pending'), 
('1258', '2021-05-18', '0000-00-00', '25217', '', '45', '101', '', '10', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '290', '4', 'pending'), 
('1259', '2021-05-18', '0000-00-00', '25217', '', '98', '297', '', '10', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '290', '4', 'pending'), 
('1260', '2021-05-18', '0000-00-00', '25217', '', '97', '290', '', '10', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '290', '4', 'pending'), 
('1261', '2021-05-18', '0000-00-00', '25217', '', '107', '374', '', '10', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '290', '4', 'pending'), 
('1262', '2021-05-18', '0000-00-00', '25217', '', '117', '462', '', '10', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '290', '4', 'pending'), 
('1263', '2021-05-18', '0000-00-00', '25217', '', '117', '461', '', '10', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '290', '4', 'pending'), 
('1272', '2021-05-18', '0000-00-00', '85742', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '292', '4', 'pending'), 
('1273', '2021-05-18', '0000-00-00', '85742', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '292', '4', 'pending'), 
('1274', '2021-05-18', '0000-00-00', '85742', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '292', '4', 'pending'), 
('1275', '2021-05-18', '0000-00-00', '85742', '', '42', '338', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '292', '4', 'pending'), 
('1276', '2021-05-18', '0000-00-00', '85742', '', '117', '593', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '292', '4', 'pending'), 
('1277', '2021-05-18', '0000-00-00', '85742', '', '117', '460', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '292', '4', 'pending'), 
('1278', '2021-05-18', '0000-00-00', '85742', '', '117', '461', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '292', '4', 'pending'), 
('1279', '2021-05-18', '0000-00-00', '85742', '', '123', '561', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '292', '4', 'pending'), 
('1280', '2021-05-18', '0000-00-00', '85392', '', '45', '101', '', '32', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '293', '4', 'pending'), 
('1281', '2021-05-18', '0000-00-00', '85392', '', '112', '287', '', '32', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '293', '4', 'pending'), 
('1282', '2021-05-18', '0000-00-00', '85392', '', '96', '284', '', '32', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '293', '4', 'pending'), 
('1283', '2021-05-18', '0000-00-00', '85392', '', '107', '366', '', '32', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '293', '4', 'pending'), 
('1284', '2021-05-18', '0000-00-00', '85392', '', '103', '329', '', '32', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '293', '4', 'pending'), 
('1285', '2021-05-18', '0000-00-00', '85392', '', '98', '297', '', '32', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '293', '4', 'pending'), 
('1286', '2021-05-18', '0000-00-00', '85392', '', '97', '290', '', '32', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '293', '4', 'pending'), 
('1287', '2021-05-18', '0000-00-00', '85392', '', '121', '532', '', '32', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '293', '4', 'pending'), 
('1288', '2021-05-18', '0000-00-00', '85392', '', '107', '374', '', '32', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '293', '4', 'pending'), 
('1289', '2021-05-18', '0000-00-00', '85392', '', '117', '451', '', '32', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '293', '4', 'pending'), 
('1290', '2021-05-18', '0000-00-00', '36201', '', '99', '598', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '294', '4', 'pending'), 
('1291', '2021-05-18', '0000-00-00', '19633', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '295', '4', 'pending'), 
('1292', '2021-05-18', '0000-00-00', '19633', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '295', '4', 'pending'), 
('1293', '2021-05-18', '0000-00-00', '19633', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '295', '4', 'pending'), 
('1294', '2021-05-18', '0000-00-00', '19633', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '295', '4', 'pending'), 
('1295', '2021-05-18', '0000-00-00', '19633', '', '117', '622', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '295', '4', 'pending'), 
('1296', '2021-05-18', '0000-00-00', '19633', '', '123', '561', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '295', '4', 'pending'), 
('1297', '2021-05-18', '0000-00-00', '58317', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '296', '4', 'pending'), 
('1298', '2021-05-18', '0000-00-00', '58317', '', '107', '370', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '296', '4', 'pending'), 
('1299', '2021-05-18', '0000-00-00', '58317', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '296', '4', 'pending'), 
('1300', '2021-05-18', '0000-00-00', '58317', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '296', '4', 'pending'), 
('1301', '2021-05-18', '0000-00-00', '84156', '', '45', '101', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '297', '4', 'pending'), 
('1302', '2021-05-18', '0000-00-00', '84156', '', '97', '290', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '297', '4', 'pending'), 
('1303', '2021-05-18', '0000-00-00', '84156', '', '98', '297', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '297', '4', 'pending'), 
('1304', '2021-05-18', '0000-00-00', '84156', '', '112', '287', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '297', '4', 'pending'), 
('1305', '2021-05-18', '0000-00-00', '84156', '', '96', '284', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '297', '4', 'pending'), 
('1306', '2021-05-18', '0000-00-00', '84156', '', '107', '366', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '297', '4', 'pending'), 
('1307', '2021-05-18', '0000-00-00', '84156', '', '121', '532', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '297', '4', 'pending'), 
('1308', '2021-05-18', '0000-00-00', '84156', '', '107', '374', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '297', '4', 'pending'), 
('1309', '2021-05-18', '0000-00-00', '84156', '', '117', '451', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '297', '4', 'pending'), 
('1310', '2021-05-18', '0000-00-00', '84156', '', '103', '329', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '297', '4', 'pending'), 
('1314', '2021-05-18', '0000-00-00', '37073', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '299', '4', 'pending'), 
('1315', '2021-05-18', '0000-00-00', '37073', '', '98', '297', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '299', '4', 'pending'), 
('1316', '2021-05-18', '0000-00-00', '37073', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '299', '4', 'pending'), 
('1317', '2021-05-18', '0000-00-00', '34991', '', '45', '101', '', '36', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '300', '8', 'pending'), 
('1318', '2021-05-18', '0000-00-00', '34991', '', '97', '290', '', '36', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '300', '8', 'pending'), 
('1319', '2021-05-18', '0000-00-00', '34991', '', '99', '301', '', '36', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '300', '8', 'pending'), 
('1320', '2021-05-18', '0000-00-00', '34991', '', '42', '338', '', '36', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '300', '8', 'pending'), 
('1321', '2021-05-18', '0000-00-00', '71319', '', '115', '446', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '301', '4', 'pending'), 
('1322', '2021-05-18', '0000-00-00', '28365', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '302', '4', 'pending'), 
('1323', '2021-05-18', '0000-00-00', '28365', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '302', '4', 'pending'), 
('1324', '2021-05-18', '0000-00-00', '28365', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '302', '4', 'pending'), 
('1325', '2021-05-18', '0000-00-00', '28365', '', '122', '514', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '302', '4', 'pending'), 
('1326', '2021-05-18', '0000-00-00', '37853', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '303', '4', 'pending'), 
('1327', '2021-05-18', '0000-00-00', '37853', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '303', '4', 'pending'), 
('1328', '2021-05-18', '0000-00-00', '37853', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '303', '4', 'pending'), 
('1329', '2021-05-18', '0000-00-00', '37853', '', '121', '532', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '303', '4', 'pending'), 
('1330', '2021-05-18', '0000-00-00', '37853', '', '117', '596', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '303', '4', 'pending'), 
('1331', '2021-05-18', '0000-00-00', '37853', '', '117', '594', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '303', '4', 'pending'), 
('1332', '2021-05-18', '0000-00-00', '37853', '', '117', '451', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '303', '4', 'pending'), 
('1333', '2021-05-18', '0000-00-00', '98072', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '304', '4', 'pending'), 
('1334', '2021-05-18', '0000-00-00', '98072', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '304', '4', 'pending'), 
('1335', '2021-05-18', '0000-00-00', '98072', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '304', '4', 'pending'), 
('1336', '2021-05-18', '0000-00-00', '98072', '', '117', '451', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '304', '4', 'pending'), 
('1337', '2021-05-18', '0000-00-00', '98072', '', '121', '532', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '304', '4', 'pending'), 
('1338', '2021-05-18', '0000-00-00', '70076', '', '117', '630', '', '6', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '305', '4', 'pending'), 
('1339', '2021-05-19', '0000-00-00', '35733', '', '121', '533', '', '14', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '306', '8', 'pending'), 
('1350', '2021-05-19', '0000-00-00', '76302', '', '117', '649', '', '23', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '308', '8', 'pending'), 
('1351', '2021-05-19', '0000-00-00', '76302', '', '45', '101', '', '23', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '308', '8', 'pending'), 
('1352', '2021-05-19', '0000-00-00', '76302', '', '97', '290', '', '23', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '308', '8', 'pending'), 
('1353', '2021-05-19', '0000-00-00', '76302', '', '98', '297', '', '23', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '308', '8', 'pending'), 
('1354', '2021-05-19', '0000-00-00', '76302', '', '107', '366', '', '23', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '308', '8', 'pending'), 
('1355', '2021-05-19', '0000-00-00', '76302', '', '112', '287', '', '23', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '308', '8', 'pending'), 
('1356', '2021-05-19', '0000-00-00', '76302', '', '103', '329', '', '23', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '308', '8', 'pending'), 
('1357', '2021-05-19', '0000-00-00', '76302', '', '121', '532', '', '23', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '308', '8', 'pending'), 
('1358', '2021-05-19', '2021-05-19', '98696', '', '123', '561', '', '38', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '309', '8', 'pending'), 
('1359', '2021-05-19', '2021-05-19', '98696', '', '123', '561', '', '38', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '309', '8', 'pending'), 
('1360', '2021-05-19', '2021-05-19', '98696', '', '123', '561', '', '38', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '309', '8', 'pending'), 
('1361', '2021-05-19', '2021-05-19', '98696', '', '123', '561', '', '38', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '309', '8', 'pending'), 
('1362', '2021-05-19', '2021-05-19', '98696', '', '123', '561', '', '38', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '309', '8', 'pending'), 
('1363', '2021-05-19', '0000-00-00', '34874', '', '45', '101', '', '39', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '310', '8', 'pending'), 
('1364', '2021-05-19', '0000-00-00', '34874', '', '42', '338', '', '39', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '310', '8', 'pending'), 
('1365', '2021-05-19', '0000-00-00', '34874', '', '123', '561', '', '39', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '310', '8', 'pending'), 
('1366', '2021-05-19', '0000-00-00', '34874', '', '117', '595', '', '39', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '310', '8', 'pending'), 
('1369', '2021-05-19', '0000-00-00', '47103', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '312', '8', 'pending'), 
('1370', '2021-05-19', '0000-00-00', '47103', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '312', '8', 'pending'), 
('1371', '2021-05-19', '0000-00-00', '87464', '', '121', '532', '', '39', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '313', '8', 'pending'), 
('1372', '2021-05-19', '0000-00-00', '55532', '', '117', '622', '', '38', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '314', '4', 'pending'), 
('1373', '2021-05-19', '0000-00-00', '47966', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '315', '4', 'pending'), 
('1374', '2021-05-19', '0000-00-00', '47966', '', '123', '561', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '315', '4', 'pending'), 
('1375', '2021-05-19', '0000-00-00', '47966', '', '117', '593', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '315', '4', 'pending'), 
('1376', '2021-05-19', '0000-00-00', '53965', '', '123', '519', '', '40', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '316', '4', 'pending'), 
('1377', '2021-05-19', '0000-00-00', '60291', '', '45', '101', '', '41', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '317', '4', 'pending'), 
('1378', '2021-05-19', '0000-00-00', '60291', '', '98', '297', '', '41', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '317', '4', 'pending'), 
('1379', '2021-05-19', '0000-00-00', '60291', '', '97', '290', '', '41', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '317', '4', 'pending'), 
('1380', '2021-05-19', '0000-00-00', '60291', '', '42', '338', '', '41', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '317', '4', 'pending'), 
('1381', '2021-05-19', '0000-00-00', '60291', '', '117', '622', '', '41', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '317', '4', 'pending'), 
('1385', '2021-05-19', '2021-05-19', '34085', '', '117', '451', '', '41', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '321', '4', 'pending'), 
('1386', '2021-05-19', '2021-05-19', '95326', '', '100', '583', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '322', '4', 'pending'), 
('1387', '2021-05-19', '2021-05-19', '95326', '', '100', '583', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '322', '4', 'pending'), 
('1388', '2021-05-19', '2021-05-19', '95326', '', '100', '583', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '322', '4', 'pending'), 
('1389', '2021-05-19', '2021-05-19', '95326', '', '100', '583', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '322', '4', 'pending'), 
('1390', '2021-05-19', '2021-05-19', '95326', '', '100', '583', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '322', '4', 'pending'), 
('1391', '2021-05-19', '2021-05-19', '95326', '', '100', '583', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '322', '4', 'pending'), 
('1392', '2021-05-19', '2021-05-19', '95326', '', '100', '583', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '322', '4', 'pending'), 
('1393', '2021-05-19', '2021-05-19', '95326', '', '100', '583', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '322', '4', 'pending'), 
('1394', '2021-05-19', '2021-05-19', '95326', '', '100', '583', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '322', '4', 'pending'), 
('1395', '2021-05-19', '2021-05-19', '95326', '', '100', '583', '', '17', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '322', '4', 'pending'), 
('1399', '2021-05-19', '2021-05-19', '18111', '', '121', '533', '', '47', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '325', '4', 'pending'), 
('1400', '2021-05-19', '2021-05-19', '18111', '', '121', '533', '', '47', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '325', '4', 'pending'), 
('1401', '2021-05-19', '2021-05-19', '18111', '', '121', '533', '', '47', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '325', '4', 'pending'), 
('1402', '2021-05-19', '2021-05-19', '18111', '', '121', '533', '', '47', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '325', '4', 'pending'), 
('1403', '2021-05-19', '2021-05-19', '31081', '', '120', '634', '', '48', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '326', '4', 'pending'), 
('1404', '2021-05-19', '2021-05-19', '31081', '', '120', '634', '', '48', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '326', '4', 'pending'), 
('1405', '2021-05-19', '2021-05-19', '31081', '', '120', '634', '', '48', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '326', '4', 'pending'), 
('1406', '2021-05-19', '2021-05-19', '31081', '', '120', '634', '', '48', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '326', '4', 'pending'), 
('1407', '2021-05-19', '2021-05-19', '31081', '', '120', '634', '', '48', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '326', '4', 'pending'), 
('1408', '2021-05-19', '2021-05-19', '31081', '', '120', '634', '', '48', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '326', '4', 'pending'), 
('1411', '2021-05-19', '0000-00-00', '46818', '', '117', '451', '', '44', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '328', '4', 'pending'), 
('1412', '2021-05-19', '0000-00-00', '77296', '', '117', '451', '', '39', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '329', '4', 'pending'), 
('1413', '2021-05-19', '0000-00-00', '77296', '', '107', '588', '', '39', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '329', '4', 'pending'), 
('1414', '2021-05-19', '0000-00-00', '93507', '', '35', '73', '', '43', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '330', '4', 'pending'), 
('1415', '2021-05-19', '0000-00-00', '93507', '', '97', '290', '', '43', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '330', '4', 'pending'), 
('1416', '2021-05-19', '0000-00-00', '93507', '', '98', '299', '', '43', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '330', '4', 'pending'), 
('1417', '2021-05-19', '0000-00-00', '93507', '', '108', '394', '', '43', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '330', '4', 'pending'), 
('1418', '2021-05-19', '0000-00-00', '93507', '', '107', '366', '', '43', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '330', '4', 'pending'), 
('1419', '2021-05-19', '0000-00-00', '93507', '', '117', '451', '', '43', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '330', '4', 'pending'), 
('1420', '2021-05-19', '0000-00-00', '93507', '', '117', '464', '', '43', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '330', '4', 'pending'), 
('1421', '2021-05-19', '0000-00-00', '93507', '', '123', '561', '', '43', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '330', '4', 'pending'), 
('1424', '2021-05-19', '0000-00-00', '43255', '', '45', '101', '', '45', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '332', '4', 'pending'), 
('1425', '2021-05-19', '0000-00-00', '43255', '', '112', '287', '', '45', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '332', '4', 'pending'), 
('1426', '2021-05-19', '0000-00-00', '43255', '', '107', '366', '', '45', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '332', '4', 'pending'), 
('1427', '2021-05-19', '0000-00-00', '43255', '', '103', '329', '', '45', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '332', '4', 'pending'), 
('1428', '2021-05-19', '0000-00-00', '43255', '', '98', '297', '', '45', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '332', '4', 'pending'), 
('1429', '2021-05-19', '0000-00-00', '43255', '', '97', '290', '', '45', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '332', '4', 'pending'), 
('1430', '2021-05-19', '0000-00-00', '43255', '', '107', '374', '', '45', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '332', '4', 'pending'), 
('1431', '2021-05-19', '0000-00-00', '43255', '', '121', '532', '', '45', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '332', '4', 'pending'), 
('1432', '2021-05-19', '0000-00-00', '43255', '', '117', '451', '', '45', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '332', '4', 'pending'), 
('1433', '2021-05-19', '0000-00-00', '43255', '', '117', '463', '', '45', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '332', '4', 'pending'), 
('1436', '2021-05-19', '0000-00-00', '19284', '', '117', '622', '', '46', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '334', '4', 'pending'), 
('1437', '2021-05-19', '0000-00-00', '74822', '', '45', '101', '', '49', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '335', '4', 'pending'), 
('1438', '2021-05-19', '0000-00-00', '74822', '', '97', '290', '', '49', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '335', '4', 'pending'), 
('1439', '2021-05-19', '0000-00-00', '74822', '', '42', '338', '', '49', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '335', '4', 'pending'), 
('1440', '2021-05-19', '0000-00-00', '72920', '', '45', '101', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '336', '4', 'pending'), 
('1441', '2021-05-19', '0000-00-00', '72920', '', '97', '290', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '336', '4', 'pending'), 
('1442', '2021-05-19', '0000-00-00', '72920', '', '112', '287', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '336', '4', 'pending'), 
('1443', '2021-05-19', '0000-00-00', '72920', '', '103', '329', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '336', '4', 'pending'), 
('1444', '2021-05-19', '0000-00-00', '72920', '', '120', '634', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '336', '4', 'pending'), 
('1445', '2021-05-19', '0000-00-00', '72920', '', '121', '532', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '336', '4', 'pending'), 
('1446', '2021-05-19', '0000-00-00', '72920', '', '107', '366', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '336', '4', 'pending'), 
('1447', '2021-05-19', '0000-00-00', '72920', '', '98', '297', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '336', '4', 'pending'), 
('1450', '2021-05-20', '0000-00-00', '72686', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '338', '8', 'pending'), 
('1451', '2021-05-20', '0000-00-00', '18263', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '339', '8', 'pending'), 
('1452', '2021-05-20', '0000-00-00', '54120', '', '107', '366', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '340', '8', 'pending'), 
('1453', '2021-05-20', '0000-00-00', '78645', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '341', '8', 'pending'), 
('1454', '2021-05-20', '0000-00-00', '78645', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '341', '8', 'pending'), 
('1455', '2021-05-20', '0000-00-00', '78645', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '341', '8', 'pending'), 
('1456', '2021-05-20', '0000-00-00', '78645', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '341', '8', 'pending'), 
('1457', '2021-05-20', '0000-00-00', '66813', '', '35', '73', '', '21', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '342', '8', 'pending'), 
('1458', '2021-05-20', '0000-00-00', '66813', '', '97', '290', '', '21', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '342', '8', 'pending'), 
('1459', '2021-05-20', '0000-00-00', '66813', '', '103', '329', '', '21', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '342', '8', 'pending'), 
('1460', '2021-05-20', '0000-00-00', '66813', '', '107', '366', '', '21', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '342', '8', 'pending'), 
('1461', '2021-05-20', '0000-00-00', '66813', '', '120', '634', '', '21', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '342', '8', 'pending'), 
('1462', '2021-05-20', '0000-00-00', '13276', '', '45', '101', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '343', '8', 'pending'), 
('1463', '2021-05-20', '0000-00-00', '13276', '', '97', '290', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '343', '8', 'pending'), 
('1464', '2021-05-20', '0000-00-00', '13276', '', '98', '297', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '343', '8', 'pending'), 
('1465', '2021-05-20', '0000-00-00', '13276', '', '112', '287', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '343', '8', 'pending'), 
('1466', '2021-05-20', '0000-00-00', '13276', '', '107', '366', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '343', '8', 'pending'), 
('1467', '2021-05-20', '0000-00-00', '13276', '', '103', '329', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '343', '8', 'pending'), 
('1468', '2021-05-20', '0000-00-00', '13276', '', '42', '338', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '343', '8', 'pending'), 
('1469', '2021-05-20', '0000-00-00', '13276', '', '121', '532', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '343', '8', 'pending'), 
('1470', '2021-05-20', '0000-00-00', '13276', '', '120', '634', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '343', '8', 'pending'), 
('1471', '2021-05-20', '0000-00-00', '28562', '', '45', '101', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '344', '8', 'pending'), 
('1472', '2021-05-20', '0000-00-00', '28562', '', '97', '290', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '344', '8', 'pending'), 
('1473', '2021-05-20', '0000-00-00', '28562', '', '98', '297', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '344', '8', 'pending'), 
('1474', '2021-05-20', '0000-00-00', '28562', '', '107', '366', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '344', '8', 'pending'), 
('1475', '2021-05-20', '0000-00-00', '28562', '', '98', '299', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '344', '8', 'pending'), 
('1476', '2021-05-20', '0000-00-00', '28562', '', '112', '287', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '344', '8', 'pending'), 
('1477', '2021-05-20', '0000-00-00', '28562', '', '103', '329', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '344', '8', 'pending'), 
('1478', '2021-05-20', '0000-00-00', '28562', '', '101', '314', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '344', '8', 'pending'), 
('1479', '2021-05-20', '0000-00-00', '28562', '', '121', '532', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '344', '8', 'pending'), 
('1480', '2021-05-20', '0000-00-00', '28562', '', '123', '561', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '344', '8', 'pending'), 
('1481', '2021-05-20', '0000-00-00', '28562', '', '42', '338', '', '51', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '344', '8', 'pending'), 
('1483', '2021-05-20', '0000-00-00', '36861', '', '117', '451', '', '54', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '346', '8', 'pending'), 
('1484', '2021-05-20', '0000-00-00', '21900', '', '45', '101', '', '53', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '347', '8', 'pending'), 
('1485', '2021-05-20', '0000-00-00', '21900', '', '117', '466', '', '53', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '347', '8', 'pending'), 
('1486', '2021-05-20', '0000-00-00', '21900', '', '117', '650', '', '53', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '347', '8', 'pending'), 
('1487', '2021-05-20', '0000-00-00', '98039', '', '123', '561', '', '43', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '348', '8', 'pending'), 
('1488', '2021-05-20', '0000-00-00', '91230', '', '45', '101', '', '55', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '349', '4', 'pending'), 
('1489', '2021-05-20', '0000-00-00', '91230', '', '97', '290', '', '55', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '349', '4', 'pending'), 
('1490', '2021-05-20', '0000-00-00', '91230', '', '98', '297', '', '55', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '349', '4', 'pending'), 
('1491', '2021-05-20', '0000-00-00', '91230', '', '103', '329', '', '55', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '349', '4', 'pending'), 
('1492', '2021-05-20', '0000-00-00', '91230', '', '107', '366', '', '55', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '349', '4', 'pending'), 
('1493', '2021-05-20', '0000-00-00', '91230', '', '117', '451', '', '55', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '349', '4', 'pending'), 
('1494', '2021-05-20', '0000-00-00', '91230', '', '121', '532', '', '55', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '349', '4', 'pending'), 
('1495', '2021-05-20', '0000-00-00', '52459', '', '97', '290', '', '56', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '350', '4', 'pending'), 
('1496', '2021-05-20', '0000-00-00', '52459', '', '103', '329', '', '56', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '350', '4', 'pending'), 
('1497', '2021-05-20', '0000-00-00', '52459', '', '117', '629', '', '56', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '350', '4', 'pending'), 
('1498', '2021-05-20', '0000-00-00', '68524', '', '98', '297', '', '42', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '351', '4', 'pending'), 
('1499', '2021-05-20', '0000-00-00', '68524', '', '42', '338', '', '42', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '351', '4', 'pending'), 
('1500', '2021-05-20', '0000-00-00', '68524', '', '105', '616', '', '42', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '351', '4', 'pending'), 
('1502', '2021-05-20', '0000-00-00', '65826', '', '118', '590', '', '57', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '353', '4', 'pending'), 
('1503', '2021-05-20', '0000-00-00', '23337', '', '117', '451', '', '46', '33', '', '', '', '0', '0.00', '', '0.00', '0.00', '354', '4', 'pending'), 
('1504', '2021-05-20', '0000-00-00', '86266', '', '45', '101', '', '55', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '355', '4', 'pending'), 
('1505', '2021-05-20', '0000-00-00', '86266', '', '97', '290', '', '55', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '355', '4', 'pending'), 
('1506', '2021-05-20', '0000-00-00', '86266', '', '98', '297', '', '55', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '355', '4', 'pending'), 
('1507', '2021-05-20', '0000-00-00', '86266', '', '42', '338', '', '55', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '355', '4', 'pending'), 
('1508', '2021-05-20', '0000-00-00', '86266', '', '123', '561', '', '55', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '355', '4', 'pending'), 
('1509', '2021-05-20', '0000-00-00', '86266', '', '117', '593', '', '55', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '355', '4', 'pending'), 
('1510', '2021-05-20', '0000-00-00', '55788', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '356', '4', 'pending'), 
('1511', '2021-05-20', '0000-00-00', '55788', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '356', '4', 'pending'), 
('1512', '2021-05-20', '0000-00-00', '55788', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '356', '4', 'pending'), 
('1513', '2021-05-20', '0000-00-00', '55788', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '356', '4', 'pending'), 
('1514', '2021-05-20', '0000-00-00', '15110', '', '45', '101', '', '17', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '357', '4', 'pending'), 
('1515', '2021-05-20', '0000-00-00', '15110', '', '98', '297', '', '17', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '357', '4', 'pending'), 
('1516', '2021-05-20', '0000-00-00', '15110', '', '112', '287', '', '17', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '357', '4', 'pending'), 
('1517', '2021-05-20', '0000-00-00', '15110', '', '107', '366', '', '17', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '357', '4', 'pending'), 
('1518', '2021-05-20', '0000-00-00', '15110', '', '42', '338', '', '17', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '357', '4', 'pending'), 
('1519', '2021-05-20', '0000-00-00', '15110', '', '117', '451', '', '17', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '357', '4', 'pending'), 
('1520', '2021-05-20', '0000-00-00', '19495', '', '117', '622', '', '46', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '358', '4', 'pending'), 
('1521', '2021-05-20', '0000-00-00', '89595', '', '117', '456', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '359', '4', 'pending'), 
('1522', '2021-05-20', '0000-00-00', '66626', '', '35', '73', '', '61', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '360', '4', 'pending'), 
('1523', '2021-05-20', '0000-00-00', '66626', '', '42', '338', '', '61', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '360', '4', 'pending'), 
('1524', '2021-05-20', '0000-00-00', '66626', '', '97', '290', '', '61', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '360', '4', 'pending'), 
('1525', '2021-05-20', '0000-00-00', '66626', '', '98', '297', '', '61', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '360', '4', 'pending'), 
('1526', '2021-05-20', '0000-00-00', '66626', '', '107', '370', '', '61', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '360', '4', 'pending'), 
('1527', '2021-05-20', '0000-00-00', '66626', '', '103', '329', '', '61', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '360', '4', 'pending'), 
('1528', '2021-05-20', '0000-00-00', '66626', '', '105', '616', '', '61', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '360', '4', 'pending'), 
('1529', '2021-05-20', '0000-00-00', '66626', '', '123', '519', '', '61', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '360', '4', 'pending'), 
('1530', '2021-05-20', '0000-00-00', '19770', '', '117', '451', '', '46', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '361', '4', 'pending'), 
('1537', '2021-05-20', '0000-00-00', '74853', '', '121', '532', '', '64', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '363', '4', 'pending'), 
('1538', '2021-05-20', '0000-00-00', '74853', '', '121', '533', '', '64', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '363', '4', 'pending'), 
('1539', '2021-05-20', '0000-00-00', '74853', '', '117', '451', '', '64', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '363', '4', 'pending'), 
('1540', '2021-05-20', '0000-00-00', '74853', '', '45', '101', '', '64', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '363', '4', 'pending'), 
('1541', '2021-05-20', '0000-00-00', '74853', '', '107', '374', '', '64', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '363', '4', 'pending'), 
('1542', '2021-05-20', '0000-00-00', '74853', '', '42', '338', '', '64', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '363', '4', 'pending'), 
('1543', '2021-05-20', '0000-00-00', '80875', '', '98', '297', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '364', '4', 'pending'), 
('1544', '2021-05-20', '0000-00-00', '56056', '', '117', '463', '', '46', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '365', '4', 'pending'), 
('1545', '2021-05-20', '0000-00-00', '28135', '', '45', '101', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '366', '4', 'pending'), 
('1546', '2021-05-20', '0000-00-00', '28135', '', '97', '290', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '366', '4', 'pending'), 
('1547', '2021-05-20', '0000-00-00', '28135', '', '98', '297', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '366', '4', 'pending'), 
('1548', '2021-05-20', '0000-00-00', '28135', '', '99', '301', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '366', '4', 'pending'), 
('1549', '2021-05-20', '0000-00-00', '28135', '', '103', '329', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '366', '4', 'pending'), 
('1550', '2021-05-20', '0000-00-00', '28135', '', '105', '357', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '366', '4', 'pending'), 
('1551', '2021-05-20', '0000-00-00', '28135', '', '121', '532', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '366', '4', 'pending'), 
('1552', '2021-05-20', '0000-00-00', '28135', '', '117', '451', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '366', '4', 'pending'), 
('1553', '2021-05-20', '0000-00-00', '21017', '', '45', '101', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '367', '4', 'pending'), 
('1554', '2021-05-20', '0000-00-00', '21017', '', '97', '290', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '367', '4', 'pending'), 
('1555', '2021-05-20', '0000-00-00', '21017', '', '42', '338', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '367', '4', 'pending'), 
('1556', '2021-05-20', '0000-00-00', '21017', '', '42', '346', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '367', '4', 'pending'), 
('1557', '2021-05-20', '0000-00-00', '21017', '', '123', '561', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '367', '4', 'pending'), 
('1558', '2021-05-21', '0000-00-00', '97116', '', '117', '636', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '368', '4', 'pending'), 
('1559', '2021-05-21', '0000-00-00', '61190', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '369', '4', 'pending'), 
('1560', '2021-05-21', '0000-00-00', '61190', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '369', '4', 'pending'), 
('1565', '2021-05-21', '0000-00-00', '93344', '', '35', '73', '', '67', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '371', '4', 'pending'), 
('1566', '2021-05-21', '0000-00-00', '93344', '', '97', '290', '', '67', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '371', '4', 'pending'), 
('1567', '2021-05-21', '0000-00-00', '93344', '', '103', '329', '', '67', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '371', '4', 'pending'), 
('1568', '2021-05-21', '0000-00-00', '93344', '', '107', '366', '', '67', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '371', '4', 'pending'), 
('1569', '2021-05-21', '0000-00-00', '93811', '', '122', '546', '', '69', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '372', '4', 'pending'), 
('1570', '2021-05-21', '0000-00-00', '80497', '', '107', '366', '', '60', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '373', '4', 'pending'), 
('1571', '2021-05-21', '0000-00-00', '80497', '', '97', '290', '', '60', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '373', '4', 'pending'), 
('1572', '2021-05-21', '0000-00-00', '80497', '', '35', '73', '', '60', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '373', '4', 'pending'), 
('1573', '2021-05-21', '0000-00-00', '80497', '', '103', '329', '', '60', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '373', '4', 'pending'), 
('1574', '2021-05-21', '0000-00-00', '32591', '', '107', '366', '', '60', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '374', '4', 'pending'), 
('1575', '2021-05-21', '0000-00-00', '11887', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '375', '4', 'pending'), 
('1576', '2021-05-21', '0000-00-00', '35640', '', '117', '622', '', '69', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '376', '4', 'pending'), 
('1577', '2021-05-21', '0000-00-00', '70308', '', '122', '549', '', '69', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '377', '4', 'pending'), 
('1578', '2021-05-21', '0000-00-00', '70308', '', '122', '546', '', '69', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '377', '4', 'pending'), 
('1579', '2021-05-21', '0000-00-00', '78690', '', '117', '593', '', '69', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '378', '4', 'pending'), 
('1580', '2021-05-21', '0000-00-00', '78690', '', '117', '452', '', '69', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '378', '4', 'pending'), 
('1581', '2021-05-21', '0000-00-00', '80049', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '379', '4', 'pending'), 
('1582', '2021-05-21', '0000-00-00', '80049', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '379', '4', 'pending'), 
('1583', '2021-05-21', '0000-00-00', '80049', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '379', '4', 'pending'), 
('1584', '2021-05-21', '0000-00-00', '80049', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '379', '4', 'pending'), 
('1585', '2021-05-21', '0000-00-00', '44014', '', '35', '73', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '380', '4', 'pending'), 
('1586', '2021-05-21', '0000-00-00', '44014', '', '42', '338', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '380', '4', 'pending'), 
('1587', '2021-05-21', '0000-00-00', '44014', '', '97', '290', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '380', '4', 'pending'), 
('1588', '2021-05-21', '0000-00-00', '44014', '', '98', '297', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '380', '4', 'pending'), 
('1589', '2021-05-21', '0000-00-00', '44014', '', '107', '370', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '380', '4', 'pending'), 
('1590', '2021-05-21', '0000-00-00', '44014', '', '103', '329', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '380', '4', 'pending'), 
('1591', '2021-05-21', '0000-00-00', '44014', '', '105', '616', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '380', '4', 'pending'), 
('1592', '2021-05-21', '0000-00-00', '44014', '', '123', '519', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '380', '4', 'pending'), 
('1593', '2021-05-21', '0000-00-00', '34394', '', '35', '73', '', '70', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '381', '4', 'pending'), 
('1594', '2021-05-21', '0000-00-00', '34394', '', '97', '290', '', '70', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '381', '4', 'pending'), 
('1595', '2021-05-21', '0000-00-00', '34394', '', '103', '329', '', '70', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '381', '4', 'pending'), 
('1596', '2021-05-21', '0000-00-00', '34394', '', '107', '366', '', '70', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '381', '4', 'pending'), 
('1597', '2021-05-21', '0000-00-00', '34394', '', '123', '519', '', '70', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '381', '4', 'pending'), 
('1598', '2021-05-21', '0000-00-00', '27831', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '382', '4', 'pending'), 
('1599', '2021-05-21', '0000-00-00', '87211', '', '123', '519', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '383', '4', 'pending'), 
('1600', '2021-05-21', '0000-00-00', '92437', '', '123', '561', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '384', '4', 'pending'), 
('1601', '2021-05-21', '0000-00-00', '41460', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '385', '4', 'pending'), 
('1602', '2021-05-21', '0000-00-00', '63185', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '386', '4', 'pending'), 
('1603', '2021-05-22', '0000-00-00', '85217', '', '120', '531', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '387', '8', 'pending'), 
('1604', '2021-05-22', '0000-00-00', '48982', '', '98', '297', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '388', '8', 'pending'), 
('1605', '2021-05-22', '0000-00-00', '48982', '', '100', '583', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '388', '8', 'pending'), 
('1610', '2021-05-22', '0000-00-00', '61170', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '391', '8', 'pending'), 
('1611', '2021-05-22', '0000-00-00', '61170', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '391', '8', 'pending'), 
('1612', '2021-05-22', '0000-00-00', '61170', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '391', '8', 'pending'), 
('1613', '2021-05-22', '0000-00-00', '61170', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '391', '8', 'pending'), 
('1614', '2021-05-22', '0000-00-00', '61170', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '391', '8', 'pending'), 
('1615', '2021-05-22', '0000-00-00', '61170', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '391', '8', 'pending'), 
('1618', '2021-05-22', '0000-00-00', '17161', '', '123', '519', '', '71', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '393', '8', 'pending'), 
('1619', '2021-05-22', '0000-00-00', '78456', '', '117', '622', '', '72', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '394', '8', 'pending'), 
('1621', '2021-05-22', '0000-00-00', '82613', '', '118', '589', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '396', '8', 'pending'), 
('1622', '2021-05-22', '0000-00-00', '49594', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '397', '8', 'pending'), 
('1624', '2021-05-22', '0000-00-00', '75859', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '399', '8', 'pending'), 
('1625', '2021-05-22', '0000-00-00', '75859', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '399', '8', 'pending'), 
('1626', '2021-05-22', '0000-00-00', '75859', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '399', '8', 'pending'), 
('1627', '2021-05-22', '0000-00-00', '75859', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '399', '8', 'pending'), 
('1628', '2021-05-22', '0000-00-00', '75859', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '399', '8', 'pending'), 
('1629', '2021-05-22', '0000-00-00', '76006', '', '121', '533', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '400', '8', 'pending'), 
('1630', '2021-05-22', '0000-00-00', '72953', '', '117', '595', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '401', '4', 'pending'), 
('1631', '2021-05-22', '0000-00-00', '12405', '', '117', '463', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '402', '4', 'pending'), 
('1632', '2021-05-22', '0000-00-00', '17959', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '403', '4', 'pending'), 
('1633', '2021-05-22', '0000-00-00', '17959', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '403', '4', 'pending'), 
('1634', '2021-05-22', '0000-00-00', '17959', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '403', '4', 'pending'), 
('1635', '2021-05-22', '0000-00-00', '17959', '', '98', '299', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '403', '4', 'pending'), 
('1636', '2021-05-22', '0000-00-00', '17959', '', '100', '583', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '403', '4', 'pending'), 
('1637', '2021-05-22', '0000-00-00', '17959', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '403', '4', 'pending'), 
('1638', '2021-05-22', '0000-00-00', '17959', '', '42', '341', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '403', '4', 'pending'), 
('1639', '2021-05-22', '0000-00-00', '17959', '', '117', '451', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '403', '4', 'pending'), 
('1640', '2021-05-22', '0000-00-00', '17959', '', '123', '561', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '403', '4', 'pending'), 
('1641', '2021-05-22', '0000-00-00', '17959', '', '121', '532', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '403', '4', 'pending'), 
('1642', '2021-05-22', '0000-00-00', '17162', '', '105', '362', '', '59', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '404', '4', 'pending'), 
('1643', '2021-05-22', '0000-00-00', '17162', '', '123', '561', '', '59', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '404', '4', 'pending'), 
('1644', '2021-05-22', '0000-00-00', '37165', '', '97', '290', '', '44', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '405', '4', 'pending'), 
('1645', '2021-05-22', '0000-00-00', '37165', '', '121', '532', '', '44', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '405', '4', 'pending'), 
('1646', '2021-05-22', '0000-00-00', '37165', '', '45', '101', '', '44', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '405', '4', 'pending'), 
('1647', '2021-05-22', '0000-00-00', '37165', '', '107', '370', '', '44', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '405', '4', 'pending'), 
('1648', '2021-05-22', '0000-00-00', '37165', '', '103', '329', '', '44', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '405', '4', 'pending'), 
('1649', '2021-05-22', '0000-00-00', '37165', '', '98', '297', '', '44', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '405', '4', 'pending'), 
('1650', '2021-05-22', '0000-00-00', '37165', '', '98', '299', '', '44', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '405', '4', 'pending'), 
('1651', '2021-05-22', '0000-00-00', '37165', '', '42', '338', '', '44', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '405', '4', 'pending'), 
('1652', '2021-05-22', '0000-00-00', '37165', '', '123', '519', '', '44', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '405', '4', 'pending'), 
('1653', '2021-05-22', '0000-00-00', '58739', '', '45', '101', '', '59', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '406', '4', 'pending'), 
('1654', '2021-05-22', '0000-00-00', '58739', '', '97', '290', '', '59', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '406', '4', 'pending'), 
('1655', '2021-05-22', '0000-00-00', '58739', '', '42', '338', '', '59', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '406', '4', 'pending'), 
('1656', '2021-05-22', '0000-00-00', '58739', '', '108', '407', '', '59', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '406', '4', 'pending'), 
('1662', '2021-05-22', '0000-00-00', '96444', '', '117', '622', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '408', '4', 'pending'), 
('1663', '2021-05-22', '0000-00-00', '88120', '', '123', '561', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '409', '4', 'pending'), 
('1664', '2021-05-22', '0000-00-00', '88120', '', '110', '414', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '409', '4', 'pending'), 
('1665', '2021-05-22', '0000-00-00', '66577', '', '45', '101', '', '76', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '410', '4', 'pending'), 
('1666', '2021-05-22', '0000-00-00', '66577', '', '96', '282', '', '76', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '410', '4', 'pending'), 
('1667', '2021-05-22', '0000-00-00', '66577', '', '107', '632', '', '76', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '410', '4', 'pending'), 
('1668', '2021-05-22', '0000-00-00', '66577', '', '107', '374', '', '76', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '410', '4', 'pending'), 
('1669', '2021-05-22', '0000-00-00', '66577', '', '117', '451', '', '76', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '410', '4', 'pending'), 
('1670', '2021-05-22', '0000-00-00', '85643', '', '123', '561', '', '75', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '411', '4', 'pending'), 
('1675', '2021-05-22', '0000-00-00', '28593', '', '35', '73', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '413', '4', 'pending'), 
('1676', '2021-05-22', '0000-00-00', '28593', '', '97', '290', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '413', '4', 'pending'), 
('1677', '2021-05-22', '0000-00-00', '28593', '', '103', '329', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '413', '4', 'pending'), 
('1678', '2021-05-22', '0000-00-00', '28593', '', '120', '634', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '413', '4', 'pending'), 
('1693', '2021-05-22', '0000-00-00', '48465', '', '117', '463', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '416', '4', 'pending'), 
('1694', '2021-05-22', '0000-00-00', '48465', '', '97', '290', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '416', '4', 'pending'), 
('1695', '2021-05-22', '0000-00-00', '48465', '', '45', '101', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '416', '4', 'pending'), 
('1696', '2021-05-22', '0000-00-00', '48465', '', '36', '102', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '416', '4', 'pending'), 
('1697', '2021-05-22', '0000-00-00', '48465', '', '98', '297', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '416', '4', 'pending'), 
('1698', '2021-05-22', '0000-00-00', '48465', '', '42', '338', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '416', '4', 'pending'), 
('1699', '2021-05-22', '0000-00-00', '48465', '', '123', '467', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '416', '4', 'pending'), 
('1700', '2021-05-22', '0000-00-00', '24339', '', '45', '101', '', '77', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '417', '4', 'pending'), 
('1701', '2021-05-22', '0000-00-00', '24339', '', '97', '290', '', '77', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '417', '4', 'pending'), 
('1702', '2021-05-22', '0000-00-00', '24339', '', '103', '329', '', '77', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '417', '4', 'pending'), 
('1703', '2021-05-22', '0000-00-00', '24339', '', '42', '338', '', '77', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '417', '4', 'pending'), 
('1704', '2021-05-22', '0000-00-00', '24339', '', '120', '531', '', '77', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '417', '4', 'pending'), 
('1705', '2021-05-22', '0000-00-00', '88628', '', '45', '101', '', '78', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '418', '4', 'pending'), 
('1706', '2021-05-22', '0000-00-00', '88628', '', '97', '290', '', '78', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '418', '4', 'pending'), 
('1707', '2021-05-22', '0000-00-00', '88628', '', '98', '297', '', '78', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '418', '4', 'pending'), 
('1708', '2021-05-22', '0000-00-00', '88628', '', '103', '329', '', '78', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '418', '4', 'pending'), 
('1709', '2021-05-22', '0000-00-00', '88628', '', '107', '366', '', '78', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '418', '4', 'pending'), 
('1710', '2021-05-22', '0000-00-00', '88628', '', '121', '532', '', '78', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '418', '4', 'pending'), 
('1711', '2021-05-22', '0000-00-00', '88628', '', '123', '561', '', '78', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '418', '4', 'pending'), 
('1712', '2021-05-22', '0000-00-00', '15143', '', '45', '101', '', '39', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '419', '4', 'pending'), 
('1713', '2021-05-22', '0000-00-00', '15143', '', '96', '284', '', '39', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '419', '4', 'pending'), 
('1714', '2021-05-22', '0000-00-00', '15143', '', '112', '287', '', '39', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '419', '4', 'pending'), 
('1715', '2021-05-22', '0000-00-00', '15143', '', '97', '290', '', '39', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '419', '4', 'pending'), 
('1716', '2021-05-22', '0000-00-00', '15143', '', '98', '297', '', '39', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '419', '4', 'pending'), 
('1717', '2021-05-22', '0000-00-00', '15143', '', '103', '329', '', '39', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '419', '4', 'pending'), 
('1718', '2021-05-22', '0000-00-00', '15143', '', '107', '366', '', '39', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '419', '4', 'pending'), 
('1719', '2021-05-22', '0000-00-00', '15143', '', '117', '451', '', '39', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '419', '4', 'pending'), 
('1720', '2021-05-22', '0000-00-00', '15143', '', '121', '532', '', '39', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '419', '4', 'pending'), 
('1721', '2021-05-22', '0000-00-00', '31448', '', '45', '101', '', '75', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '420', '4', 'pending'), 
('1722', '2021-05-22', '0000-00-00', '31448', '', '112', '287', '', '75', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '420', '4', 'pending'), 
('1723', '2021-05-22', '0000-00-00', '31448', '', '96', '284', '', '75', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '420', '4', 'pending'), 
('1724', '2021-05-22', '0000-00-00', '31448', '', '107', '366', '', '75', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '420', '4', 'pending'), 
('1725', '2021-05-22', '0000-00-00', '31448', '', '103', '329', '', '75', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '420', '4', 'pending'), 
('1726', '2021-05-22', '0000-00-00', '31448', '', '98', '297', '', '75', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '420', '4', 'pending'), 
('1727', '2021-05-22', '0000-00-00', '31448', '', '117', '451', '', '75', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '420', '4', 'pending'), 
('1728', '2021-05-22', '0000-00-00', '31448', '', '114', '445', '', '75', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '420', '4', 'pending'), 
('1729', '2021-05-22', '0000-00-00', '92858', '', '45', '101', '', '79', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '421', '4', 'pending'), 
('1730', '2021-05-22', '0000-00-00', '92858', '', '107', '366', '', '79', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '421', '4', 'pending'), 
('1731', '2021-05-22', '0000-00-00', '92858', '', '103', '329', '', '79', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '421', '4', 'pending'), 
('1732', '2021-05-22', '0000-00-00', '92858', '', '98', '297', '', '79', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '421', '4', 'pending'), 
('1733', '2021-05-22', '0000-00-00', '92858', '', '97', '290', '', '79', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '421', '4', 'pending'), 
('1734', '2021-05-22', '0000-00-00', '92858', '', '121', '532', '', '79', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '421', '4', 'pending'), 
('1735', '2021-05-22', '0000-00-00', '25895', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '422', '4', 'pending'), 
('1736', '2021-05-22', '0000-00-00', '25895', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '422', '4', 'pending'), 
('1737', '2021-05-22', '0000-00-00', '25895', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '422', '4', 'pending'), 
('1738', '2021-05-22', '0000-00-00', '25895', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '422', '4', 'pending'), 
('1739', '2021-05-22', '0000-00-00', '25895', '', '123', '561', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '422', '4', 'pending'), 
('1740', '2021-05-22', '0000-00-00', '12432', '', '97', '290', '', '14', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '423', '4', 'pending'), 
('1741', '2021-05-22', '0000-00-00', '12432', '', '123', '561', '', '14', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '423', '4', 'pending'), 
('1742', '2021-05-22', '0000-00-00', '15621', '', '115', '446', '', '75', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '424', '4', 'pending'), 
('1743', '2021-05-22', '0000-00-00', '49623', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '425', '4', 'pending'), 
('1744', '2021-05-22', '0000-00-00', '49623', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '425', '4', 'pending'), 
('1745', '2021-05-22', '0000-00-00', '49623', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '425', '4', 'pending'), 
('1746', '2021-05-22', '0000-00-00', '49623', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '425', '4', 'pending'), 
('1747', '2021-05-22', '0000-00-00', '49623', '', '107', '588', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '425', '4', 'pending'), 
('1748', '2021-05-22', '0000-00-00', '49623', '', '107', '374', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '425', '4', 'pending'), 
('1749', '2021-05-22', '0000-00-00', '49623', '', '117', '451', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '425', '4', 'pending'), 
('1750', '2021-05-22', '0000-00-00', '49623', '', '123', '561', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '425', '4', 'pending'), 
('1751', '2021-05-22', '0000-00-00', '21752', '', '123', '561', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '426', '4', 'pending'), 
('1752', '2021-05-22', '0000-00-00', '41561', '', '123', '561', '', '80', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '427', '4', 'pending'), 
('1753', '2021-05-22', '0000-00-00', '41561', '', '97', '290', '', '80', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '427', '4', 'pending'), 
('1754', '2021-05-22', '0000-00-00', '41561', '', '98', '297', '', '80', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '427', '4', 'pending'), 
('1755', '2021-05-22', '0000-00-00', '41561', '', '42', '338', '', '80', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '427', '4', 'pending'), 
('1756', '2021-05-22', '0000-00-00', '56394', '', '111', '656', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '428', '4', 'pending'), 
('1757', '2021-05-23', '0000-00-00', '87225', '', '45', '101', '', '81', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '429', '8', 'pending'), 
('1758', '2021-05-23', '0000-00-00', '87225', '', '97', '295', '', '81', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '429', '8', 'pending'), 
('1764', '2021-05-23', '0000-00-00', '88171', '', '117', '622', '', '72', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '431', '8', 'pending'), 
('1765', '2021-05-23', '0000-00-00', '99867', '', '123', '561', '', '82', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '432', '8', 'pending'), 
('1766', '2021-05-23', '0000-00-00', '26538', '', '120', '634', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '433', '8', 'pending'), 
('1769', '2021-05-23', '0000-00-00', '48572', '', '97', '290', '', '29', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '435', '8', 'pending'), 
('1770', '2021-05-23', '0000-00-00', '48572', '', '121', '532', '', '29', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '435', '8', 'pending'), 
('1771', '2021-05-23', '0000-00-00', '48572', '', '117', '657', '', '29', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '435', '8', 'pending'), 
('1777', '2021-05-23', '0000-00-00', '30360', '', '117', '653', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '437', '4', 'pending'), 
('1778', '2021-05-23', '0000-00-00', '73847', '', '117', '451', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '438', '4', 'pending'), 
('1779', '2021-05-23', '0000-00-00', '99942', '', '45', '101', '', '83', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '439', '4', 'pending'), 
('1780', '2021-05-23', '0000-00-00', '99942', '', '98', '297', '', '83', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '439', '4', 'pending'), 
('1781', '2021-05-23', '0000-00-00', '99942', '', '103', '329', '', '83', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '439', '4', 'pending'), 
('1782', '2021-05-23', '0000-00-00', '99942', '', '42', '338', '', '83', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '439', '4', 'pending'), 
('1783', '2021-05-23', '0000-00-00', '99942', '', '107', '366', '', '83', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '439', '4', 'pending'), 
('1784', '2021-05-23', '0000-00-00', '99942', '', '97', '290', '', '83', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '439', '4', 'pending'), 
('1785', '2021-05-23', '0000-00-00', '99942', '', '117', '451', '', '83', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '439', '4', 'pending'), 
('1786', '2021-05-23', '0000-00-00', '99942', '', '121', '532', '', '83', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '439', '4', 'pending'), 
('1789', '2021-05-23', '0000-00-00', '39553', '', '117', '594', '', '73', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '441', '4', 'pending'), 
('1790', '2021-05-23', '0000-00-00', '20305', '', '117', '593', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '442', '4', 'pending'), 
('1791', '2021-05-23', '0000-00-00', '20305', '', '118', '589', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '442', '4', 'pending'), 
('1792', '2021-05-23', '0000-00-00', '20305', '', '97', '290', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '442', '4', 'pending'), 
('1793', '2021-05-23', '0000-00-00', '20305', '', '98', '297', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '442', '4', 'pending'), 
('1794', '2021-05-23', '0000-00-00', '20305', '', '45', '101', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '442', '4', 'pending'), 
('1795', '2021-05-23', '0000-00-00', '20305', '', '42', '338', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '442', '4', 'pending'), 
('1796', '2021-05-23', '0000-00-00', '20305', '', '123', '561', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '442', '4', 'pending'), 
('1797', '2021-05-23', '0000-00-00', '32344', '', '118', '589', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '443', '4', 'pending'), 
('1798', '2021-05-23', '0000-00-00', '32344', '', '117', '593', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '443', '4', 'pending'), 
('1799', '2021-05-23', '0000-00-00', '32344', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '443', '4', 'pending'), 
('1800', '2021-05-23', '0000-00-00', '32344', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '443', '4', 'pending'), 
('1801', '2021-05-23', '0000-00-00', '32344', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '443', '4', 'pending'), 
('1802', '2021-05-23', '0000-00-00', '32344', '', '123', '561', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '443', '4', 'pending'), 
('1803', '2021-05-23', '0000-00-00', '59074', '', '117', '464', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '444', '4', 'pending'), 
('1804', '2021-05-23', '0000-00-00', '68690', '', '117', '451', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '445', '4', 'pending'), 
('1807', '2021-05-23', '0000-00-00', '65266', '', '117', '463', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '447', '4', 'pending'), 
('1808', '2021-05-23', '0000-00-00', '99236', '', '45', '101', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '448', '4', 'pending'), 
('1809', '2021-05-23', '0000-00-00', '99236', '', '107', '370', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '448', '4', 'pending'), 
('1810', '2021-05-23', '0000-00-00', '99236', '', '107', '366', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '448', '4', 'pending'), 
('1811', '2021-05-23', '0000-00-00', '99236', '', '97', '290', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '448', '4', 'pending'), 
('1812', '2021-05-23', '0000-00-00', '99236', '', '98', '299', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '448', '4', 'pending'), 
('1813', '2021-05-23', '0000-00-00', '99236', '', '98', '298', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '448', '4', 'pending'), 
('1814', '2021-05-23', '0000-00-00', '99236', '', '105', '353', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '448', '4', 'pending'), 
('1815', '2021-05-23', '0000-00-00', '99236', '', '123', '561', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '448', '4', 'pending'), 
('1816', '2021-05-23', '0000-00-00', '99236', '', '42', '338', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '448', '4', 'pending'), 
('1817', '2021-05-23', '0000-00-00', '14412', '', '45', '101', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '449', '4', 'pending'), 
('1818', '2021-05-23', '0000-00-00', '14412', '', '97', '290', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '449', '4', 'pending'), 
('1819', '2021-05-23', '0000-00-00', '14412', '', '110', '414', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '449', '4', 'pending'), 
('1820', '2021-05-23', '0000-00-00', '14412', '', '42', '338', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '449', '4', 'pending'), 
('1821', '2021-05-23', '0000-00-00', '14412', '', '117', '451', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '449', '4', 'pending'), 
('1822', '2021-05-23', '0000-00-00', '14412', '', '123', '561', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '449', '4', 'pending'), 
('1823', '2021-05-23', '0000-00-00', '54422', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '450', '4', 'pending'), 
('1824', '2021-05-23', '0000-00-00', '53002', '', '45', '101', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '451', '4', 'pending'), 
('1825', '2021-05-23', '0000-00-00', '53002', '', '97', '290', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '451', '4', 'pending'), 
('1826', '2021-05-23', '0000-00-00', '53002', '', '98', '297', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '451', '4', 'pending'), 
('1827', '2021-05-23', '0000-00-00', '53002', '', '103', '329', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '451', '4', 'pending'), 
('1828', '2021-05-23', '0000-00-00', '53002', '', '107', '366', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '451', '4', 'pending'), 
('1829', '2021-05-23', '0000-00-00', '53002', '', '42', '338', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '451', '4', 'pending'), 
('1830', '2021-05-23', '0000-00-00', '53002', '', '121', '533', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '451', '4', 'pending'), 
('1831', '2021-05-23', '0000-00-00', '53002', '', '121', '532', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '451', '4', 'pending'), 
('1832', '2021-05-23', '0000-00-00', '22204', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '452', '4', 'pending'), 
('1833', '2021-05-23', '0000-00-00', '22204', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '452', '4', 'pending'), 
('1834', '2021-05-23', '0000-00-00', '22204', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '452', '4', 'pending'), 
('1835', '2021-05-23', '0000-00-00', '22204', '', '98', '297', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '452', '4', 'pending'), 
('1836', '2021-05-23', '0000-00-00', '22204', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '452', '4', 'pending'), 
('1837', '2021-05-23', '0000-00-00', '22204', '', '121', '532', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '452', '4', 'pending'), 
('1838', '2021-05-23', '0000-00-00', '47452', '', '45', '101', '', '14', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '453', '4', 'pending'), 
('1839', '2021-05-23', '0000-00-00', '47452', '', '105', '617', '', '14', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '453', '4', 'pending'), 
('1840', '2021-05-23', '0000-00-00', '47452', '', '97', '290', '', '14', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '453', '4', 'pending'), 
('1841', '2021-05-23', '0000-00-00', '47452', '', '98', '297', '', '14', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '453', '4', 'pending'), 
('1842', '2021-05-23', '0000-00-00', '47452', '', '42', '338', '', '14', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '453', '4', 'pending'), 
('1843', '2021-05-23', '0000-00-00', '47452', '', '121', '534', '', '14', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '453', '4', 'pending'), 
('1844', '2021-05-23', '0000-00-00', '34915', '', '42', '338', '', '49', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '454', '4', 'pending'), 
('1845', '2021-05-23', '0000-00-00', '34915', '', '123', '519', '', '49', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '454', '4', 'pending'), 
('1846', '2021-05-23', '0000-00-00', '14284', '', '45', '101', '', '49', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '455', '4', 'pending'), 
('1847', '2021-05-23', '0000-00-00', '14284', '', '97', '290', '', '49', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '455', '4', 'pending'), 
('1848', '2021-05-23', '0000-00-00', '14284', '', '42', '338', '', '49', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '455', '4', 'pending'), 
('1849', '2021-05-23', '0000-00-00', '86967', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '456', '4', 'pending'), 
('1850', '2021-05-23', '0000-00-00', '86967', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '456', '4', 'pending'), 
('1851', '2021-05-23', '0000-00-00', '86967', '', '105', '616', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '456', '4', 'pending'), 
('1852', '2021-05-23', '0000-00-00', '86967', '', '105', '355', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '456', '4', 'pending'), 
('1853', '2021-05-23', '0000-00-00', '93978', '', '45', '101', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '457', '4', 'pending'), 
('1854', '2021-05-23', '0000-00-00', '93978', '', '99', '301', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '457', '4', 'pending'), 
('1855', '2021-05-23', '0000-00-00', '93978', '', '98', '297', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '457', '4', 'pending'), 
('1856', '2021-05-23', '0000-00-00', '93978', '', '97', '290', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '457', '4', 'pending'), 
('1857', '2021-05-23', '0000-00-00', '93978', '', '100', '583', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '457', '4', 'pending'), 
('1858', '2021-05-23', '0000-00-00', '93978', '', '120', '521', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '457', '4', 'pending'), 
('1859', '2021-05-23', '0000-00-00', '93978', '', '117', '451', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '457', '4', 'pending'), 
('1860', '2021-05-23', '0000-00-00', '93978', '', '105', '616', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '457', '4', 'pending'), 
('1861', '2021-05-23', '0000-00-00', '93978', '', '105', '355', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '457', '4', 'pending'), 
('1862', '2021-05-23', '0000-00-00', '93978', '', '105', '354', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '457', '4', 'pending'), 
('1863', '2021-05-23', '0000-00-00', '93978', '', '121', '532', '', '66', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '457', '4', 'pending'), 
('1864', '2021-05-24', '0000-00-00', '53899', '', '35', '73', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '458', '8', 'pending'), 
('1865', '2021-05-24', '0000-00-00', '53899', '', '97', '290', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '458', '8', 'pending'), 
('1866', '2021-05-24', '0000-00-00', '53899', '', '107', '366', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '458', '8', 'pending'), 
('1867', '2021-05-24', '0000-00-00', '53899', '', '103', '329', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '458', '8', 'pending'), 
('1868', '2021-05-24', '0000-00-00', '53899', '', '120', '634', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '458', '8', 'pending'), 
('1869', '2021-05-24', '0000-00-00', '90516', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '459', '8', 'pending'), 
('1870', '2021-05-24', '0000-00-00', '90516', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '459', '8', 'pending'), 
('1871', '2021-05-24', '0000-00-00', '90516', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '459', '8', 'pending'), 
('1872', '2021-05-24', '0000-00-00', '90516', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '459', '8', 'pending'), 
('1873', '2021-05-24', '0000-00-00', '90516', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '459', '8', 'pending'), 
('1874', '2021-05-24', '0000-00-00', '23313', '', '107', '366', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '460', '8', 'pending'), 
('1875', '2021-05-24', '0000-00-00', '82494', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '461', '8', 'pending'), 
('1876', '2021-05-24', '0000-00-00', '17727', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '462', '8', 'pending'), 
('1877', '2021-05-24', '0000-00-00', '82018', '', '45', '101', '', '85', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '463', '8', 'pending'), 
('1878', '2021-05-24', '0000-00-00', '82018', '', '96', '282', '', '85', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '463', '8', 'pending'), 
('1879', '2021-05-24', '0000-00-00', '82018', '', '122', '584', '', '85', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '463', '8', 'pending'), 
('1880', '2021-05-24', '0000-00-00', '33186', '', '45', '101', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '464', '8', 'pending'), 
('1881', '2021-05-24', '0000-00-00', '33186', '', '97', '290', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '464', '8', 'pending'), 
('1882', '2021-05-24', '0000-00-00', '33186', '', '98', '297', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '464', '8', 'pending'), 
('1883', '2021-05-24', '0000-00-00', '33186', '', '117', '451', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '464', '8', 'pending'), 
('1884', '2021-05-24', '0000-00-00', '33186', '', '121', '532', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '464', '8', 'pending'), 
('1885', '2021-05-24', '0000-00-00', '33186', '', '122', '585', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '464', '8', 'pending'), 
('1886', '2021-05-24', '0000-00-00', '29240', '', '97', '290', '', '34', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '465', '8', 'pending'), 
('1887', '2021-05-24', '0000-00-00', '29240', '', '100', '583', '', '34', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '465', '8', 'pending'), 
('1888', '2021-05-24', '0000-00-00', '29240', '', '104', '309', '', '34', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '465', '8', 'pending'), 
('1889', '2021-05-24', '0000-00-00', '44420', '', '120', '634', '', '32', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '466', '8', 'pending'), 
('1890', '2021-05-24', '0000-00-00', '84626', '', '99', '301', '', '32', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '467', '4', 'pending'), 
('1891', '2021-05-24', '0000-00-00', '84626', '', '103', '329', '', '32', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '467', '4', 'pending'), 
('1892', '2021-05-24', '0000-00-00', '64639', '', '117', '451', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '468', '4', 'pending'), 
('1893', '2021-05-24', '0000-00-00', '64639', '', '117', '595', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '468', '4', 'pending'), 
('1894', '2021-05-24', '0000-00-00', '92117', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '469', '4', 'pending'), 
('1895', '2021-05-24', '0000-00-00', '92117', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '469', '4', 'pending'), 
('1896', '2021-05-24', '0000-00-00', '92117', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '469', '4', 'pending'), 
('1897', '2021-05-24', '0000-00-00', '92117', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '469', '4', 'pending'), 
('1898', '2021-05-24', '0000-00-00', '71318', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '470', '4', 'pending'), 
('1899', '2021-05-24', '0000-00-00', '71318', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '470', '4', 'pending'), 
('1900', '2021-05-24', '0000-00-00', '71318', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '470', '4', 'pending'), 
('1901', '2021-05-24', '0000-00-00', '71318', '', '42', '338', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '470', '4', 'pending'), 
('1902', '2021-05-24', '0000-00-00', '71318', '', '123', '561', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '470', '4', 'pending'), 
('1903', '2021-05-24', '0000-00-00', '71318', '', '117', '593', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '470', '4', 'pending'), 
('1904', '2021-05-24', '0000-00-00', '62263', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '471', '4', 'pending'), 
('1905', '2021-05-24', '0000-00-00', '62263', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '471', '4', 'pending'), 
('1906', '2021-05-24', '0000-00-00', '62263', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '471', '4', 'pending'), 
('1907', '2021-05-24', '0000-00-00', '62263', '', '107', '370', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '471', '4', 'pending'), 
('1908', '2021-05-24', '0000-00-00', '62263', '', '103', '329', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '471', '4', 'pending'), 
('1909', '2021-05-24', '0000-00-00', '62263', '', '107', '371', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '471', '4', 'pending'), 
('1910', '2021-05-24', '0000-00-00', '62263', '', '108', '659', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '471', '4', 'pending'), 
('1911', '2021-05-24', '0000-00-00', '62263', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '471', '4', 'pending'), 
('1912', '2021-05-24', '0000-00-00', '62263', '', '107', '366', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '471', '4', 'pending'), 
('1913', '2021-05-24', '0000-00-00', '62263', '', '108', '639', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '471', '4', 'pending'), 
('1914', '2021-05-24', '0000-00-00', '29229', '', '120', '531', '', '86', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '472', '4', 'pending'), 
('1915', '2021-05-24', '0000-00-00', '29229', '', '45', '101', '', '86', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '472', '4', 'pending'), 
('1916', '2021-05-24', '0000-00-00', '29229', '', '97', '290', '', '86', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '472', '4', 'pending'), 
('1917', '2021-05-24', '0000-00-00', '29229', '', '107', '370', '', '86', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '472', '4', 'pending'), 
('1918', '2021-05-24', '0000-00-00', '29229', '', '103', '329', '', '86', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '472', '4', 'pending'), 
('1919', '2021-05-24', '0000-00-00', '29229', '', '98', '297', '', '86', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '472', '4', 'pending'), 
('1920', '2021-05-24', '0000-00-00', '29229', '', '98', '299', '', '86', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '472', '4', 'pending'), 
('1921', '2021-05-24', '0000-00-00', '29229', '', '121', '532', '', '86', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '472', '4', 'pending'), 
('1922', '2021-05-24', '0000-00-00', '29229', '', '42', '338', '', '86', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '472', '4', 'pending'), 
('1923', '2021-05-24', '0000-00-00', '29229', '', '116', '660', '', '86', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '472', '4', 'pending'), 
('1924', '2021-05-24', '0000-00-00', '51570', '', '120', '638', '', '32', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '473', '4', 'pending'), 
('1925', '2021-05-24', '0000-00-00', '86041', '', '117', '451', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '474', '4', 'pending'), 
('1926', '2021-05-24', '0000-00-00', '52304', '', '107', '366', '', '18', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '475', '4', 'pending'), 
('1927', '2021-05-24', '0000-00-00', '36145', '', '35', '73', '', '18', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '476', '4', 'pending'), 
('1928', '2021-05-24', '0000-00-00', '36145', '', '107', '366', '', '18', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '476', '4', 'pending'), 
('1929', '2021-05-24', '0000-00-00', '36145', '', '42', '338', '', '18', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '476', '4', 'pending'), 
('1930', '2021-05-24', '0000-00-00', '36145', '', '97', '290', '', '18', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '476', '4', 'pending'), 
('1931', '2021-05-24', '0000-00-00', '36145', '', '98', '297', '', '18', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '476', '4', 'pending'), 
('1932', '2021-05-24', '0000-00-00', '36145', '', '107', '370', '', '18', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '476', '4', 'pending'), 
('1933', '2021-05-24', '0000-00-00', '36145', '', '103', '329', '', '18', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '476', '4', 'pending'), 
('1934', '2021-05-24', '0000-00-00', '36145', '', '105', '616', '', '18', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '476', '4', 'pending'), 
('1935', '2021-05-24', '0000-00-00', '36145', '', '123', '519', '', '18', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '476', '4', 'pending'), 
('1936', '2021-05-24', '0000-00-00', '57983', '', '117', '636', '', '26', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '477', '4', 'pending'), 
('1937', '2021-05-25', '0000-00-00', '82980', '', '35', '73', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '478', '8', 'pending'), 
('1938', '2021-05-25', '0000-00-00', '82980', '', '97', '290', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '478', '8', 'pending'), 
('1939', '2021-05-25', '0000-00-00', '82980', '', '98', '297', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '478', '8', 'pending'), 
('1940', '2021-05-25', '0000-00-00', '82980', '', '107', '366', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '478', '8', 'pending'), 
('1941', '2021-05-25', '0000-00-00', '82980', '', '117', '451', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '478', '8', 'pending'), 
('1942', '2021-05-25', '0000-00-00', '61999', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '479', '8', 'pending'), 
('1943', '2021-05-25', '0000-00-00', '71845', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '480', '8', 'pending'), 
('1944', '2021-05-25', '0000-00-00', '71845', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '480', '8', 'pending'), 
('1945', '2021-05-25', '0000-00-00', '71845', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '480', '8', 'pending'), 
('1946', '2021-05-25', '0000-00-00', '71845', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '480', '8', 'pending'), 
('1947', '2021-05-25', '0000-00-00', '71845', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '480', '8', 'pending'), 
('1948', '2021-05-25', '0000-00-00', '98409', '', '97', '295', '', '66', '37', '', '', '', '0', '0.00', '', '0.00', '0.00', '481', '8', 'pending'), 
('1949', '2021-05-25', '0000-00-00', '98409', '', '97', '291', '', '66', '37', '', '', '', '0', '0.00', '', '0.00', '0.00', '481', '8', 'pending'), 
('1950', '2021-05-25', '0000-00-00', '98409', '', '105', '616', '', '66', '37', '', '', '', '0', '0.00', '', '0.00', '0.00', '481', '8', 'pending'), 
('1951', '2021-05-25', '0000-00-00', '98409', '', '105', '355', '', '66', '37', '', '', '', '0', '0.00', '', '0.00', '0.00', '481', '8', 'pending'), 
('1952', '2021-05-25', '0000-00-00', '98409', '', '110', '633', '', '66', '37', '', '', '', '0', '0.00', '', '0.00', '0.00', '481', '8', 'pending'), 
('1953', '2021-05-25', '0000-00-00', '18572', '', '117', '451', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '482', '8', 'pending'), 
('1954', '2021-05-25', '0000-00-00', '80029', '', '107', '366', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '483', '8', 'pending'), 
('1955', '2021-05-25', '0000-00-00', '37589', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '484', '8', 'pending'), 
('1956', '2021-05-25', '0000-00-00', '37589', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '484', '8', 'pending'), 
('1957', '2021-05-25', '0000-00-00', '37589', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '484', '8', 'pending'), 
('1958', '2021-05-25', '0000-00-00', '37589', '', '122', '584', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '484', '8', 'pending'), 
('1959', '2021-05-25', '0000-00-00', '65178', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '485', '8', 'pending'), 
('1960', '2021-05-25', '0000-00-00', '65178', '', '96', '284', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '485', '8', 'pending'), 
('1961', '2021-05-25', '0000-00-00', '65178', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '485', '8', 'pending'), 
('1962', '2021-05-25', '0000-00-00', '65178', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '485', '8', 'pending'), 
('1963', '2021-05-25', '0000-00-00', '65178', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '485', '8', 'pending'), 
('1964', '2021-05-25', '0000-00-00', '65178', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '485', '8', 'pending'), 
('1965', '2021-05-25', '0000-00-00', '97080', '', '117', '463', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '486', '8', 'pending'), 
('1966', '2021-05-25', '0000-00-00', '81318', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '487', '8', 'pending'), 
('1967', '2021-05-25', '0000-00-00', '81318', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '487', '8', 'pending'), 
('1968', '2021-05-25', '0000-00-00', '81318', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '487', '8', 'pending'), 
('1969', '2021-05-25', '0000-00-00', '81318', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '487', '8', 'pending'), 
('1970', '2021-05-25', '0000-00-00', '18456', '', '117', '451', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '488', '4', 'pending'), 
('1976', '2021-05-25', '0000-00-00', '35593', '', '45', '101', '', '88', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '490', '4', 'pending'), 
('1977', '2021-05-25', '0000-00-00', '35593', '', '97', '290', '', '88', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '490', '4', 'pending'), 
('1978', '2021-05-25', '0000-00-00', '35593', '', '98', '297', '', '88', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '490', '4', 'pending'), 
('1979', '2021-05-25', '0000-00-00', '35593', '', '117', '451', '', '88', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '490', '4', 'pending'), 
('1980', '2021-05-25', '0000-00-00', '35593', '', '117', '594', '', '88', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '490', '4', 'pending'), 
('1981', '2021-05-25', '0000-00-00', '99159', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '491', '4', 'pending'), 
('1982', '2021-05-25', '0000-00-00', '77080', '', '117', '461', '', '73', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '492', '4', 'pending'), 
('1983', '2021-05-25', '0000-00-00', '38601', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '493', '4', 'pending'), 
('1984', '2021-05-25', '0000-00-00', '32586', '', '117', '465', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '494', '4', 'pending'), 
('1992', '2021-05-25', '0000-00-00', '87046', '', '45', '101', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '496', '4', 'pending'), 
('1993', '2021-05-25', '0000-00-00', '87046', '', '97', '290', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '496', '4', 'pending'), 
('1994', '2021-05-25', '0000-00-00', '87046', '', '98', '297', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '496', '4', 'pending'), 
('1995', '2021-05-25', '0000-00-00', '87046', '', '107', '366', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '496', '4', 'pending'), 
('1996', '2021-05-25', '0000-00-00', '87046', '', '117', '451', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '496', '4', 'pending'), 
('1997', '2021-05-25', '0000-00-00', '87046', '', '121', '532', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '496', '4', 'pending'), 
('1998', '2021-05-25', '0000-00-00', '87046', '', '123', '561', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '496', '4', 'pending'), 
('1999', '2021-05-25', '0000-00-00', '81454', '', '121', '533', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '497', '4', 'pending'), 
('2009', '2021-05-25', '0000-00-00', '51871', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '499', '4', 'pending'), 
('2010', '2021-05-25', '0000-00-00', '51871', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '499', '4', 'pending'), 
('2011', '2021-05-25', '0000-00-00', '51871', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '499', '4', 'pending'), 
('2012', '2021-05-25', '0000-00-00', '51871', '', '98', '297', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '499', '4', 'pending'), 
('2013', '2021-05-25', '0000-00-00', '51871', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '499', '4', 'pending'), 
('2014', '2021-05-25', '0000-00-00', '51871', '', '108', '407', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '499', '4', 'pending'), 
('2015', '2021-05-25', '0000-00-00', '51871', '', '108', '639', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '499', '4', 'pending'), 
('2016', '2021-05-25', '0000-00-00', '38436', '', '45', '101', '', '40', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '500', '4', 'pending'), 
('2017', '2021-05-25', '0000-00-00', '38436', '', '98', '297', '', '40', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '500', '4', 'pending'), 
('2018', '2021-05-25', '0000-00-00', '38436', '', '97', '290', '', '40', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '500', '4', 'pending'), 
('2019', '2021-05-25', '0000-00-00', '38436', '', '117', '622', '', '40', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '500', '4', 'pending'), 
('2020', '2021-05-25', '0000-00-00', '38436', '', '123', '561', '', '40', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '500', '4', 'pending'), 
('2021', '2021-05-25', '0000-00-00', '54445', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '501', '4', 'pending'), 
('2022', '2021-05-25', '0000-00-00', '54445', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '501', '4', 'pending'), 
('2023', '2021-05-25', '0000-00-00', '54445', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '501', '4', 'pending'), 
('2024', '2021-05-25', '0000-00-00', '54445', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '501', '4', 'pending'), 
('2025', '2021-05-25', '0000-00-00', '54445', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '501', '4', 'pending'), 
('2026', '2021-05-25', '0000-00-00', '54445', '', '117', '472', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '501', '4', 'pending'), 
('2027', '2021-05-25', '0000-00-00', '54445', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '501', '4', 'pending'), 
('2028', '2021-05-25', '0000-00-00', '85771', '', '123', '561', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '502', '4', 'pending'), 
('2029', '2021-05-25', '0000-00-00', '91336', '', '105', '635', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '503', '4', 'pending'), 
('2030', '2021-05-25', '0000-00-00', '91336', '', '105', '615', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '503', '4', 'pending'), 
('2031', '2021-05-25', '0000-00-00', '27588', '', '45', '101', '', '14', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '504', '4', 'pending'), 
('2032', '2021-05-25', '0000-00-00', '27588', '', '112', '287', '', '14', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '504', '4', 'pending'), 
('2033', '2021-05-25', '0000-00-00', '27588', '', '96', '284', '', '14', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '504', '4', 'pending'), 
('2034', '2021-05-25', '0000-00-00', '27588', '', '107', '366', '', '14', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '504', '4', 'pending'), 
('2035', '2021-05-25', '0000-00-00', '27588', '', '103', '329', '', '14', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '504', '4', 'pending'), 
('2036', '2021-05-25', '0000-00-00', '27588', '', '98', '297', '', '14', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '504', '4', 'pending'), 
('2037', '2021-05-25', '0000-00-00', '27588', '', '97', '290', '', '14', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '504', '4', 'pending'), 
('2038', '2021-05-25', '0000-00-00', '27588', '', '117', '451', '', '14', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '504', '4', 'pending'), 
('2039', '2021-05-25', '0000-00-00', '17107', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '505', '4', 'pending'), 
('2040', '2021-05-25', '0000-00-00', '17107', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '505', '4', 'pending'), 
('2041', '2021-05-25', '0000-00-00', '17107', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '505', '4', 'pending'), 
('2042', '2021-05-25', '0000-00-00', '17107', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '505', '4', 'pending'), 
('2043', '2021-05-25', '0000-00-00', '17107', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '505', '4', 'pending'), 
('2044', '2021-05-25', '0000-00-00', '17107', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '505', '4', 'pending'), 
('2045', '2021-05-25', '0000-00-00', '17107', '', '117', '593', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '505', '4', 'pending'), 
('2046', '2021-05-25', '0000-00-00', '39804', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '506', '4', 'pending'), 
('2047', '2021-05-25', '0000-00-00', '39804', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '506', '4', 'pending'), 
('2048', '2021-05-25', '0000-00-00', '39804', '', '98', '297', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '506', '4', 'pending'), 
('2049', '2021-05-25', '0000-00-00', '39804', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '506', '4', 'pending'), 
('2050', '2021-05-25', '0000-00-00', '89656', '', '45', '101', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '507', '4', 'pending'), 
('2051', '2021-05-25', '0000-00-00', '89656', '', '97', '290', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '507', '4', 'pending'), 
('2052', '2021-05-25', '0000-00-00', '89656', '', '98', '297', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '507', '4', 'pending'), 
('2053', '2021-05-25', '0000-00-00', '89656', '', '103', '329', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '507', '4', 'pending'), 
('2054', '2021-05-25', '0000-00-00', '89656', '', '107', '366', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '507', '4', 'pending'), 
('2055', '2021-05-25', '0000-00-00', '89656', '', '117', '451', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '507', '4', 'pending'), 
('2056', '2021-05-25', '0000-00-00', '89656', '', '121', '532', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '507', '4', 'pending'), 
('2057', '2021-05-25', '0000-00-00', '89656', '', '117', '622', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '507', '4', 'pending'), 
('2058', '2021-05-25', '0000-00-00', '89656', '', '120', '638', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '507', '4', 'pending'), 
('2059', '2021-05-25', '0000-00-00', '79656', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '508', '4', 'pending'), 
('2060', '2021-05-25', '0000-00-00', '27030', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '509', '4', 'pending'), 
('2061', '2021-05-25', '0000-00-00', '66487', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '510', '4', 'pending'), 
('2062', '2021-05-25', '0000-00-00', '22839', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '511', '4', 'pending'), 
('2063', '2021-05-25', '0000-00-00', '22839', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '511', '4', 'pending'), 
('2064', '2021-05-25', '0000-00-00', '22839', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '511', '4', 'pending'), 
('2065', '2021-05-25', '0000-00-00', '22839', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '511', '4', 'pending'), 
('2066', '2021-05-25', '0000-00-00', '22839', '', '123', '519', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '511', '4', 'pending'), 
('2067', '2021-05-25', '0000-00-00', '55889', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '512', '4', 'pending'), 
('2068', '2021-05-25', '0000-00-00', '48653', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '513', '4', 'pending'), 
('2069', '2021-05-25', '0000-00-00', '48653', '', '99', '301', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '513', '4', 'pending'), 
('2070', '2021-05-25', '0000-00-00', '63038', '', '123', '561', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '514', '4', 'pending'), 
('2071', '2021-05-25', '0000-00-00', '16942', '', '45', '101', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '515', '4', 'pending'), 
('2072', '2021-05-25', '0000-00-00', '16942', '', '98', '297', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '515', '4', 'pending'), 
('2073', '2021-05-25', '0000-00-00', '16942', '', '117', '472', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '515', '4', 'pending'), 
('2074', '2021-05-25', '0000-00-00', '22109', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '516', '4', 'pending'), 
('2075', '2021-05-25', '0000-00-00', '22109', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '516', '4', 'pending'), 
('2076', '2021-05-25', '0000-00-00', '22109', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '516', '4', 'pending'), 
('2077', '2021-05-25', '0000-00-00', '22109', '', '42', '338', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '516', '4', 'pending'), 
('2078', '2021-05-25', '0000-00-00', '22109', '', '123', '561', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '516', '4', 'pending'), 
('2079', '2021-05-25', '0000-00-00', '22109', '', '117', '593', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '516', '4', 'pending'), 
('2080', '2021-05-25', '0000-00-00', '87027', '', '45', '101', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '517', '4', 'pending'), 
('2081', '2021-05-25', '0000-00-00', '87027', '', '97', '290', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '517', '4', 'pending'), 
('2082', '2021-05-25', '0000-00-00', '87027', '', '98', '297', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '517', '4', 'pending'), 
('2083', '2021-05-25', '0000-00-00', '87027', '', '107', '370', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '517', '4', 'pending'), 
('2084', '2021-05-25', '0000-00-00', '87027', '', '103', '329', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '517', '4', 'pending'), 
('2085', '2021-05-25', '0000-00-00', '87027', '', '107', '366', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '517', '4', 'pending'), 
('2086', '2021-05-25', '0000-00-00', '87027', '', '42', '338', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '517', '4', 'pending'), 
('2087', '2021-05-25', '0000-00-00', '87027', '', '98', '299', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '517', '4', 'pending'), 
('2088', '2021-05-25', '0000-00-00', '87027', '', '105', '616', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '517', '4', 'pending'), 
('2089', '2021-05-25', '0000-00-00', '87027', '', '120', '531', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '517', '4', 'pending'), 
('2090', '2021-05-25', '0000-00-00', '87027', '', '121', '532', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '517', '4', 'pending'), 
('2091', '2021-05-25', '0000-00-00', '36232', '', '123', '561', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '518', '4', 'pending'), 
('2092', '2021-05-25', '0000-00-00', '51533', '', '117', '451', '', '57', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '519', '4', 'pending'), 
('2093', '2021-05-26', '0000-00-00', '20752', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '520', '8', 'pending'), 
('2094', '2021-05-26', '0000-00-00', '20752', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '520', '8', 'pending'), 
('2095', '2021-05-26', '0000-00-00', '20752', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '520', '8', 'pending'), 
('2096', '2021-05-26', '0000-00-00', '20752', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '520', '8', 'pending'), 
('2097', '2021-05-26', '0000-00-00', '20752', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '520', '8', 'pending'), 
('2098', '2021-05-26', '0000-00-00', '14788', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '521', '8', 'pending'), 
('2099', '2021-05-26', '0000-00-00', '14788', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '521', '8', 'pending'), 
('2100', '2021-05-26', '0000-00-00', '14788', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '521', '8', 'pending'), 
('2101', '2021-05-26', '0000-00-00', '14788', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '521', '8', 'pending'), 
('2102', '2021-05-26', '0000-00-00', '62378', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '522', '8', 'pending'), 
('2103', '2021-05-26', '0000-00-00', '62378', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '522', '8', 'pending'), 
('2104', '2021-05-26', '0000-00-00', '62378', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '522', '8', 'pending'), 
('2105', '2021-05-26', '0000-00-00', '62378', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '522', '8', 'pending'), 
('2106', '2021-05-26', '0000-00-00', '62378', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '522', '8', 'pending'), 
('2107', '2021-05-26', '0000-00-00', '37060', '', '123', '519', '', '89', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '523', '8', 'pending'), 
('2108', '2021-05-26', '0000-00-00', '83551', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '524', '8', 'pending'), 
('2109', '2021-05-26', '0000-00-00', '83551', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '524', '8', 'pending'), 
('2110', '2021-05-26', '0000-00-00', '83551', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '524', '8', 'pending'), 
('2111', '2021-05-26', '0000-00-00', '83551', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '524', '8', 'pending'), 
('2112', '2021-05-26', '0000-00-00', '42603', '', '117', '451', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '525', '8', 'pending'), 
('2113', '2021-05-26', '0000-00-00', '69907', '', '45', '101', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '526', '8', 'pending'), 
('2114', '2021-05-26', '0000-00-00', '69907', '', '97', '290', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '526', '8', 'pending'), 
('2115', '2021-05-26', '0000-00-00', '69907', '', '99', '304', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '526', '8', 'pending'), 
('2116', '2021-05-26', '0000-00-00', '69907', '', '98', '297', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '526', '8', 'pending'), 
('2117', '2021-05-26', '0000-00-00', '69907', '', '103', '329', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '526', '8', 'pending'), 
('2118', '2021-05-26', '0000-00-00', '69907', '', '107', '366', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '526', '8', 'pending'), 
('2119', '2021-05-26', '0000-00-00', '69907', '', '42', '338', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '526', '8', 'pending'), 
('2120', '2021-05-26', '0000-00-00', '69907', '', '121', '532', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '526', '8', 'pending'), 
('2121', '2021-05-26', '0000-00-00', '69907', '', '123', '561', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '526', '8', 'pending'), 
('2122', '2021-05-26', '0000-00-00', '69907', '', '117', '451', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '526', '8', 'pending'), 
('2123', '2021-05-26', '0000-00-00', '69907', '', '112', '287', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '526', '8', 'pending'), 
('2124', '2021-05-26', '0000-00-00', '52285', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '527', '8', 'pending'), 
('2125', '2021-05-26', '0000-00-00', '92320', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '528', '8', 'pending'), 
('2126', '2021-05-26', '0000-00-00', '60201', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '529', '8', 'pending'), 
('2132', '2021-05-26', '0000-00-00', '99130', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '531', '8', 'pending'), 
('2133', '2021-05-26', '0000-00-00', '99130', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '531', '8', 'pending'), 
('2134', '2021-05-26', '0000-00-00', '99130', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '531', '8', 'pending'), 
('2135', '2021-05-26', '0000-00-00', '99130', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '531', '8', 'pending'), 
('2136', '2021-05-26', '0000-00-00', '45297', '', '123', '561', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '532', '4', 'pending'), 
('2137', '2021-05-26', '0000-00-00', '98467', '', '45', '101', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '533', '4', 'pending'), 
('2138', '2021-05-26', '0000-00-00', '98467', '', '97', '290', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '533', '4', 'pending'), 
('2139', '2021-05-26', '0000-00-00', '98467', '', '98', '297', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '533', '4', 'pending'), 
('2140', '2021-05-26', '0000-00-00', '98467', '', '104', '309', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '533', '4', 'pending'), 
('2141', '2021-05-26', '0000-00-00', '98467', '', '105', '353', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '533', '4', 'pending'), 
('2142', '2021-05-26', '0000-00-00', '98467', '', '108', '394', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '533', '4', 'pending'), 
('2143', '2021-05-26', '0000-00-00', '98467', '', '122', '513', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '533', '4', 'pending'), 
('2148', '2021-05-26', '0000-00-00', '25056', '', '35', '73', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '535', '4', 'pending'), 
('2149', '2021-05-26', '0000-00-00', '25056', '', '97', '290', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '535', '4', 'pending'), 
('2150', '2021-05-26', '0000-00-00', '25056', '', '103', '329', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '535', '4', 'pending'), 
('2151', '2021-05-26', '0000-00-00', '25056', '', '123', '519', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '535', '4', 'pending'), 
('2152', '2021-05-26', '0000-00-00', '17429', '', '107', '366', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '536', '4', 'pending'), 
('2153', '2021-05-26', '0000-00-00', '17429', '', '117', '451', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '536', '4', 'pending'), 
('2154', '2021-05-26', '0000-00-00', '17429', '', '121', '532', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '536', '4', 'pending'), 
('2155', '2021-05-26', '0000-00-00', '72323', '', '35', '73', '', '87', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '537', '4', 'pending'), 
('2156', '2021-05-26', '0000-00-00', '72323', '', '107', '366', '', '87', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '537', '4', 'pending'), 
('2157', '2021-05-26', '0000-00-00', '72323', '', '103', '329', '', '87', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '537', '4', 'pending'), 
('2158', '2021-05-26', '0000-00-00', '12189', '', '45', '101', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '538', '4', 'pending'), 
('2159', '2021-05-26', '0000-00-00', '12189', '', '96', '282', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '538', '4', 'pending'), 
('2160', '2021-05-26', '0000-00-00', '12189', '', '96', '284', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '538', '4', 'pending'), 
('2161', '2021-05-26', '0000-00-00', '12189', '', '42', '338', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '538', '4', 'pending'), 
('2162', '2021-05-26', '0000-00-00', '12189', '', '99', '305', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '538', '4', 'pending'), 
('2163', '2021-05-26', '0000-00-00', '12189', '', '107', '377', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '538', '4', 'pending'), 
('2164', '2021-05-26', '0000-00-00', '12189', '', '99', '301', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '538', '4', 'pending'), 
('2165', '2021-05-26', '0000-00-00', '12189', '', '123', '561', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '538', '4', 'pending'), 
('2167', '2021-05-26', '0000-00-00', '95853', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '540', '4', 'pending'), 
('2168', '2021-05-26', '0000-00-00', '95853', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '540', '4', 'pending'), 
('2169', '2021-05-26', '0000-00-00', '70256', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '541', '4', 'pending'), 
('2170', '2021-05-26', '0000-00-00', '70256', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '541', '4', 'pending'), 
('2171', '2021-05-26', '0000-00-00', '70256', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '541', '4', 'pending'), 
('2172', '2021-05-26', '0000-00-00', '70256', '', '107', '366', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '541', '4', 'pending'), 
('2173', '2021-05-26', '0000-00-00', '70256', '', '42', '338', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '541', '4', 'pending'), 
('2174', '2021-05-26', '0000-00-00', '70256', '', '117', '451', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '541', '4', 'pending'), 
('2175', '2021-05-26', '0000-00-00', '70256', '', '121', '533', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '541', '4', 'pending'), 
('2176', '2021-05-26', '0000-00-00', '70256', '', '121', '532', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '541', '4', 'pending'), 
('2177', '2021-05-26', '0000-00-00', '57034', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '542', '4', 'pending'), 
('2178', '2021-05-26', '0000-00-00', '57034', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '542', '4', 'pending'), 
('2179', '2021-05-26', '0000-00-00', '57034', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '542', '4', 'pending'), 
('2180', '2021-05-26', '0000-00-00', '57034', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '542', '4', 'pending'), 
('2181', '2021-05-26', '0000-00-00', '90501', '', '117', '594', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '543', '4', 'pending'), 
('2182', '2021-05-26', '0000-00-00', '93227', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '544', '4', 'pending'), 
('2183', '2021-05-26', '0000-00-00', '93227', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '544', '4', 'pending'), 
('2184', '2021-05-26', '0000-00-00', '93227', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '544', '4', 'pending'), 
('2185', '2021-05-26', '0000-00-00', '93227', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '544', '4', 'pending'), 
('2186', '2021-05-26', '0000-00-00', '93227', '', '117', '451', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '544', '4', 'pending'), 
('2187', '2021-05-26', '0000-00-00', '93227', '', '121', '532', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '544', '4', 'pending'), 
('2188', '2021-05-26', '0000-00-00', '18014', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '545', '4', 'pending'), 
('2189', '2021-05-26', '0000-00-00', '18014', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '545', '4', 'pending'), 
('2190', '2021-05-26', '0000-00-00', '18014', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '545', '4', 'pending'), 
('2191', '2021-05-26', '0000-00-00', '18014', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '545', '4', 'pending'), 
('2192', '2021-05-26', '0000-00-00', '18014', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '545', '4', 'pending'), 
('2193', '2021-05-26', '0000-00-00', '86620', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '546', '4', 'pending'), 
('2194', '2021-05-26', '0000-00-00', '32835', '', '35', '73', '', '49', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '547', '4', 'pending'), 
('2195', '2021-05-26', '0000-00-00', '32835', '', '35', '72', '', '49', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '547', '4', 'pending'), 
('2196', '2021-05-26', '0000-00-00', '32835', '', '97', '290', '', '49', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '547', '4', 'pending'), 
('2197', '2021-05-26', '0000-00-00', '32835', '', '98', '297', '', '49', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '547', '4', 'pending'), 
('2198', '2021-05-26', '0000-00-00', '32835', '', '42', '338', '', '49', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '547', '4', 'pending'), 
('2199', '2021-05-26', '0000-00-00', '32835', '', '123', '561', '', '49', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '547', '4', 'pending'), 
('2200', '2021-05-26', '0000-00-00', '32835', '', '117', '595', '', '49', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '547', '4', 'pending'), 
('2201', '2021-05-26', '0000-00-00', '28419', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '548', '4', 'pending'), 
('2202', '2021-05-26', '0000-00-00', '28419', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '548', '4', 'pending'), 
('2203', '2021-05-26', '0000-00-00', '51105', '', '35', '73', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '549', '4', 'pending'), 
('2204', '2021-05-26', '0000-00-00', '51105', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '549', '4', 'pending'), 
('2205', '2021-05-26', '0000-00-00', '51105', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '549', '4', 'pending'), 
('2206', '2021-05-26', '0000-00-00', '51105', '', '100', '583', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '549', '4', 'pending'), 
('2207', '2021-05-26', '0000-00-00', '51105', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '549', '4', 'pending'), 
('2208', '2021-05-26', '0000-00-00', '51105', '', '117', '451', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '549', '4', 'pending'), 
('2209', '2021-05-26', '0000-00-00', '51105', '', '121', '532', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '549', '4', 'pending'), 
('2210', '2021-05-26', '0000-00-00', '80856', '', '117', '622', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '550', '4', 'pending'), 
('2211', '2021-05-26', '0000-00-00', '63988', '', '117', '451', '', '91', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '551', '4', 'pending'), 
('2212', '2021-05-26', '0000-00-00', '98087', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '552', '4', 'pending'), 
('2213', '2021-05-26', '0000-00-00', '32649', '', '120', '665', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '553', '4', 'pending'), 
('2214', '2021-05-26', '0000-00-00', '32649', '', '117', '593', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '553', '4', 'pending'), 
('2215', '2021-05-26', '0000-00-00', '32649', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '553', '4', 'pending'), 
('2216', '2021-05-26', '0000-00-00', '32649', '', '107', '374', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '553', '4', 'pending'), 
('2217', '2021-05-26', '0000-00-00', '32649', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '553', '4', 'pending'), 
('2218', '2021-05-26', '0000-00-00', '32649', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '553', '4', 'pending'), 
('2219', '2021-05-26', '0000-00-00', '28296', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '554', '4', 'pending'), 
('2220', '2021-05-26', '0000-00-00', '28296', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '554', '4', 'pending'), 
('2221', '2021-05-26', '0000-00-00', '28296', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '554', '4', 'pending'), 
('2222', '2021-05-26', '0000-00-00', '28296', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '554', '4', 'pending'), 
('2223', '2021-05-26', '0000-00-00', '58691', '', '36', '102', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '555', '4', 'pending'), 
('2224', '2021-05-26', '0000-00-00', '58691', '', '97', '290', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '555', '4', 'pending'), 
('2225', '2021-05-26', '0000-00-00', '58691', '', '98', '297', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '555', '4', 'pending'), 
('2226', '2021-05-26', '0000-00-00', '58691', '', '100', '583', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '555', '4', 'pending'), 
('2227', '2021-05-26', '0000-00-00', '58691', '', '42', '338', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '555', '4', 'pending'), 
('2228', '2021-05-26', '0000-00-00', '58691', '', '121', '532', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '555', '4', 'pending'), 
('2230', '2021-05-26', '0000-00-00', '58379', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '557', '4', 'pending'), 
('2231', '2021-05-26', '0000-00-00', '60963', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '558', '4', 'pending'), 
('2232', '2021-05-26', '0000-00-00', '70999', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '559', '4', 'pending'), 
('2233', '2021-05-26', '0000-00-00', '51872', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '560', '4', 'pending'), 
('2234', '2021-05-26', '0000-00-00', '56315', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '561', '4', 'pending'), 
('2235', '2021-05-27', '0000-00-00', '80214', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '562', '8', 'pending'), 
('2236', '2021-05-27', '0000-00-00', '80214', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '562', '8', 'pending'), 
('2237', '2021-05-27', '0000-00-00', '80214', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '562', '8', 'pending'), 
('2238', '2021-05-27', '0000-00-00', '80214', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '562', '8', 'pending'), 
('2239', '2021-05-27', '0000-00-00', '80214', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '562', '8', 'pending'), 
('2240', '2021-05-27', '0000-00-00', '80214', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '562', '8', 'pending'), 
('2241', '2021-05-27', '0000-00-00', '22251', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '563', '8', 'pending'), 
('2242', '2021-05-27', '0000-00-00', '22251', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '563', '8', 'pending'), 
('2243', '2021-05-27', '0000-00-00', '22251', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '563', '8', 'pending'), 
('2244', '2021-05-27', '0000-00-00', '22251', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '563', '8', 'pending'), 
('2245', '2021-05-27', '0000-00-00', '22251', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '563', '8', 'pending'), 
('2246', '2021-05-27', '0000-00-00', '22251', '', '103', '335', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '563', '8', 'pending'), 
('2247', '2021-05-27', '0000-00-00', '22251', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '563', '8', 'pending'), 
('2248', '2021-05-27', '0000-00-00', '22251', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '563', '8', 'pending'), 
('2249', '2021-05-27', '0000-00-00', '22251', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '563', '8', 'pending'), 
('2250', '2021-05-27', '0000-00-00', '22251', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '563', '8', 'pending'), 
('2251', '2021-05-27', '0000-00-00', '67873', '', '35', '73', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '564', '8', 'pending'), 
('2252', '2021-05-27', '0000-00-00', '67873', '', '97', '290', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '564', '8', 'pending'), 
('2253', '2021-05-27', '0000-00-00', '67873', '', '98', '297', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '564', '8', 'pending'), 
('2254', '2021-05-27', '0000-00-00', '67873', '', '98', '299', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '564', '8', 'pending'), 
('2255', '2021-05-27', '0000-00-00', '67873', '', '99', '301', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '564', '8', 'pending'), 
('2256', '2021-05-27', '0000-00-00', '67873', '', '99', '302', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '564', '8', 'pending'), 
('2257', '2021-05-27', '0000-00-00', '67873', '', '42', '338', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '564', '8', 'pending'), 
('2258', '2021-05-27', '0000-00-00', '67873', '', '107', '366', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '564', '8', 'pending'), 
('2259', '2021-05-27', '0000-00-00', '67873', '', '123', '561', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '564', '8', 'pending'), 
('2260', '2021-05-27', '0000-00-00', '67873', '', '121', '532', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '564', '8', 'pending'), 
('2270', '2021-05-27', '0000-00-00', '93163', '', '107', '366', '', '92', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '567', '4', 'pending'), 
('2271', '2021-05-27', '0000-00-00', '99685', '', '35', '73', '', '59', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '568', '4', 'pending'), 
('2272', '2021-05-27', '0000-00-00', '99685', '', '97', '290', '', '59', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '568', '4', 'pending'), 
('2273', '2021-05-27', '0000-00-00', '99685', '', '98', '297', '', '59', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '568', '4', 'pending'), 
('2274', '2021-05-27', '0000-00-00', '99685', '', '99', '301', '', '59', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '568', '4', 'pending'), 
('2275', '2021-05-27', '0000-00-00', '99685', '', '42', '338', '', '59', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '568', '4', 'pending'), 
('2276', '2021-05-27', '0000-00-00', '99685', '', '107', '366', '', '59', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '568', '4', 'pending'), 
('2277', '2021-05-27', '0000-00-00', '99685', '', '117', '451', '', '59', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '568', '4', 'pending'), 
('2278', '2021-05-27', '0000-00-00', '99685', '', '123', '561', '', '59', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '568', '4', 'pending'), 
('2279', '2021-05-27', '0000-00-00', '54434', '', '117', '451', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '569', '4', 'pending'), 
('2280', '2021-05-27', '0000-00-00', '54434', '', '117', '644', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '569', '4', 'pending'), 
('2281', '2021-05-27', '0000-00-00', '72446', '', '45', '101', '', '42', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '570', '4', 'pending'), 
('2282', '2021-05-27', '0000-00-00', '72446', '', '97', '290', '', '42', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '570', '4', 'pending'), 
('2283', '2021-05-27', '0000-00-00', '72446', '', '98', '297', '', '42', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '570', '4', 'pending'), 
('2284', '2021-05-27', '0000-00-00', '72446', '', '42', '338', '', '42', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '570', '4', 'pending'), 
('2285', '2021-05-27', '0000-00-00', '72446', '', '117', '451', '', '42', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '570', '4', 'pending'), 
('2286', '2021-05-27', '0000-00-00', '72446', '', '117', '473', '', '42', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '570', '4', 'pending'), 
('2287', '2021-05-27', '0000-00-00', '72446', '', '114', '445', '', '42', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '570', '4', 'pending'), 
('2288', '2021-05-27', '0000-00-00', '72446', '', '123', '561', '', '42', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '570', '4', 'pending'), 
('2289', '2021-05-27', '0000-00-00', '85967', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '571', '4', 'pending'), 
('2290', '2021-05-27', '0000-00-00', '11935', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '572', '4', 'pending'), 
('2295', '2021-05-27', '0000-00-00', '75593', '', '117', '451', '', '92', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '574', '4', 'pending'), 
('2296', '2021-05-27', '0000-00-00', '75593', '', '118', '589', '', '92', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '574', '4', 'pending'), 
('2297', '2021-05-27', '0000-00-00', '75593', '', '123', '561', '', '92', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '574', '4', 'pending'), 
('2298', '2021-05-27', '0000-00-00', '75593', '', '98', '297', '', '92', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '574', '4', 'pending'), 
('2299', '2021-05-27', '0000-00-00', '75593', '', '45', '101', '', '92', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '574', '4', 'pending'), 
('2300', '2021-05-27', '0000-00-00', '52985', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '575', '4', 'pending'), 
('2301', '2021-05-27', '0000-00-00', '52985', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '575', '4', 'pending'), 
('2302', '2021-05-27', '0000-00-00', '52985', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '575', '4', 'pending'), 
('2303', '2021-05-27', '0000-00-00', '52985', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '575', '4', 'pending'), 
('2304', '2021-05-27', '0000-00-00', '52985', '', '105', '616', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '575', '4', 'pending'), 
('2305', '2021-05-27', '0000-00-00', '52985', '', '117', '463', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '575', '4', 'pending'), 
('2306', '2021-05-27', '0000-00-00', '52985', '', '121', '532', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '575', '4', 'pending'), 
('2307', '2021-05-27', '0000-00-00', '52985', '', '123', '561', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '575', '4', 'pending'), 
('2308', '2021-05-27', '0000-00-00', '46615', '', '117', '644', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '576', '4', 'pending'), 
('2309', '2021-05-27', '0000-00-00', '46615', '', '117', '462', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '576', '4', 'pending'), 
('2310', '2021-05-27', '0000-00-00', '46615', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '576', '4', 'pending'), 
('2311', '2021-05-27', '0000-00-00', '46615', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '576', '4', 'pending'), 
('2312', '2021-05-27', '0000-00-00', '34219', '', '110', '666', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '577', '4', 'pending'), 
('2313', '2021-05-27', '0000-00-00', '34219', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '577', '4', 'pending'), 
('2314', '2021-05-27', '0000-00-00', '34219', '', '112', '287', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '577', '4', 'pending'), 
('2315', '2021-05-27', '0000-00-00', '34219', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '577', '4', 'pending'), 
('2316', '2021-05-27', '0000-00-00', '34219', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '577', '4', 'pending'), 
('2317', '2021-05-27', '0000-00-00', '34219', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '577', '4', 'pending'), 
('2318', '2021-05-27', '0000-00-00', '34219', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '577', '4', 'pending'), 
('2319', '2021-05-27', '0000-00-00', '34219', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '577', '4', 'pending'), 
('2320', '2021-05-27', '0000-00-00', '34219', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '577', '4', 'pending'), 
('2321', '2021-05-27', '0000-00-00', '34219', '', '117', '463', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '577', '4', 'pending'), 
('2322', '2021-05-27', '0000-00-00', '34219', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '577', '4', 'pending'), 
('2323', '2021-05-27', '0000-00-00', '22461', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '578', '4', 'pending'), 
('2324', '2021-05-27', '0000-00-00', '22461', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '578', '4', 'pending'), 
('2325', '2021-05-27', '0000-00-00', '22461', '', '105', '616', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '578', '4', 'pending'), 
('2326', '2021-05-27', '0000-00-00', '22461', '', '123', '561', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '578', '4', 'pending'), 
('2327', '2021-05-27', '0000-00-00', '22461', '', '99', '598', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '578', '4', 'pending'), 
('2328', '2021-05-27', '0000-00-00', '24174', '', '45', '101', '', '27', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '579', '4', 'pending'), 
('2329', '2021-05-27', '0000-00-00', '24174', '', '97', '290', '', '27', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '579', '4', 'pending'), 
('2330', '2021-05-27', '0000-00-00', '24174', '', '98', '297', '', '27', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '579', '4', 'pending'), 
('2331', '2021-05-27', '0000-00-00', '24174', '', '42', '338', '', '27', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '579', '4', 'pending'), 
('2332', '2021-05-27', '0000-00-00', '24174', '', '117', '451', '', '27', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '579', '4', 'pending'), 
('2333', '2021-05-27', '0000-00-00', '24174', '', '123', '561', '', '27', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '579', '4', 'pending'), 
('2334', '2021-05-27', '0000-00-00', '24174', '', '121', '532', '', '27', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '579', '4', 'pending'), 
('2335', '2021-05-27', '0000-00-00', '58299', '', '35', '73', '', '28', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '580', '4', 'pending'), 
('2336', '2021-05-27', '0000-00-00', '58299', '', '97', '290', '', '28', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '580', '4', 'pending'), 
('2337', '2021-05-27', '0000-00-00', '58299', '', '98', '297', '', '28', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '580', '4', 'pending'), 
('2338', '2021-05-27', '0000-00-00', '58299', '', '42', '338', '', '28', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '580', '4', 'pending'), 
('2339', '2021-05-27', '0000-00-00', '58299', '', '107', '366', '', '28', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '580', '4', 'pending'), 
('2340', '2021-05-27', '0000-00-00', '58299', '', '117', '451', '', '28', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '580', '4', 'pending'), 
('2341', '2021-05-27', '0000-00-00', '58299', '', '123', '561', '', '28', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '580', '4', 'pending'), 
('2342', '2021-05-27', '0000-00-00', '58299', '', '121', '532', '', '28', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '580', '4', 'pending'), 
('2343', '2021-05-27', '0000-00-00', '77870', '', '117', '593', '', '91', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '581', '4', 'pending'), 
('2345', '2021-05-27', '0000-00-00', '28011', '', '117', '593', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '583', '4', 'pending'), 
('2350', '2021-05-27', '0000-00-00', '68014', '', '117', '622', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '585', '4', 'pending'), 
('2351', '2021-05-27', '0000-00-00', '94459', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '586', '4', 'pending'), 
('2352', '2021-05-27', '0000-00-00', '94459', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '586', '4', 'pending'), 
('2353', '2021-05-27', '0000-00-00', '94459', '', '107', '632', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '586', '4', 'pending'), 
('2354', '2021-05-27', '0000-00-00', '94459', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '586', '4', 'pending'), 
('2355', '2021-05-27', '0000-00-00', '19834', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '587', '4', 'pending'), 
('2356', '2021-05-27', '0000-00-00', '19834', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '587', '4', 'pending'), 
('2357', '2021-05-27', '0000-00-00', '19834', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '587', '4', 'pending'), 
('2358', '2021-05-27', '0000-00-00', '19834', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '587', '4', 'pending'), 
('2359', '2021-05-27', '0000-00-00', '79858', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '588', '4', 'pending'), 
('2360', '2021-05-27', '0000-00-00', '79858', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '588', '4', 'pending'), 
('2361', '2021-05-27', '0000-00-00', '79858', '', '123', '561', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '588', '4', 'pending'), 
('2362', '2021-05-27', '0000-00-00', '79858', '', '118', '589', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '588', '4', 'pending'), 
('2363', '2021-05-27', '0000-00-00', '79858', '', '117', '593', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '588', '4', 'pending'), 
('2366', '2021-05-27', '0000-00-00', '41856', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '590', '4', 'pending'), 
('2367', '2021-05-27', '0000-00-00', '41856', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '590', '4', 'pending'), 
('2368', '2021-05-27', '0000-00-00', '41856', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '590', '4', 'pending'), 
('2369', '2021-05-27', '0000-00-00', '41856', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '590', '4', 'pending'), 
('2370', '2021-05-27', '0000-00-00', '41856', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '590', '4', 'pending'), 
('2371', '2021-05-27', '0000-00-00', '41856', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '590', '4', 'pending'), 
('2373', '2021-05-27', '0000-00-00', '12680', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '592', '4', 'pending'), 
('2374', '2021-05-27', '0000-00-00', '12680', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '592', '4', 'pending'), 
('2375', '2021-05-27', '0000-00-00', '95866', '', '120', '638', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '593', '4', 'pending'), 
('2376', '2021-05-27', '0000-00-00', '77947', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '594', '4', 'pending'), 
('2377', '2021-05-27', '0000-00-00', '77947', '', '117', '472', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '594', '4', 'pending'), 
('2378', '2021-05-28', '0000-00-00', '91490', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '595', '8', 'pending'), 
('2381', '2021-05-28', '0000-00-00', '57604', '', '35', '73', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '597', '8', 'pending'), 
('2382', '2021-05-28', '0000-00-00', '57604', '', '97', '290', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '597', '8', 'pending'), 
('2383', '2021-05-28', '0000-00-00', '57604', '', '103', '329', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '597', '8', 'pending'), 
('2384', '2021-05-28', '0000-00-00', '57604', '', '107', '366', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '597', '8', 'pending'), 
('2385', '2021-05-28', '0000-00-00', '57604', '', '120', '634', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '597', '8', 'pending'), 
('2386', '2021-05-28', '0000-00-00', '84777', '', '120', '634', '', '28', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '598', '8', 'pending'), 
('2387', '2021-05-28', '0000-00-00', '97543', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '599', '8', 'pending'), 
('2388', '2021-05-28', '0000-00-00', '82218', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '600', '8', 'pending'), 
('2389', '2021-05-28', '0000-00-00', '37458', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '601', '8', 'pending'), 
('2390', '2021-05-28', '0000-00-00', '95338', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '602', '8', 'pending'), 
('2391', '2021-05-28', '0000-00-00', '95338', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '602', '8', 'pending'), 
('2392', '2021-05-28', '0000-00-00', '95338', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '602', '8', 'pending'), 
('2393', '2021-05-28', '0000-00-00', '95338', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '602', '8', 'pending'), 
('2394', '2021-05-28', '0000-00-00', '20380', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '603', '8', 'pending'), 
('2395', '2021-05-28', '0000-00-00', '30155', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '604', '8', 'pending'), 
('2396', '2021-05-28', '0000-00-00', '30155', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '604', '8', 'pending'), 
('2397', '2021-05-28', '0000-00-00', '30155', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '604', '8', 'pending'), 
('2398', '2021-05-28', '0000-00-00', '30155', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '604', '8', 'pending'), 
('2399', '2021-05-28', '0000-00-00', '30155', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '604', '8', 'pending'), 
('2400', '2021-05-28', '0000-00-00', '30155', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '604', '8', 'pending'), 
('2401', '2021-05-28', '0000-00-00', '30155', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '604', '8', 'pending'), 
('2402', '2021-05-28', '0000-00-00', '30155', '', '112', '287', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '604', '8', 'pending'), 
('2407', '2021-05-28', '0000-00-00', '81176', '', '45', '101', '', '17', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '606', '8', 'pending'), 
('2408', '2021-05-28', '0000-00-00', '81176', '', '97', '290', '', '17', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '606', '8', 'pending'), 
('2409', '2021-05-28', '0000-00-00', '81176', '', '98', '297', '', '17', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '606', '8', 'pending'), 
('2410', '2021-05-28', '0000-00-00', '81176', '', '121', '532', '', '17', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '606', '8', 'pending'), 
('2411', '2021-05-28', '0000-00-00', '81176', '', '103', '329', '', '17', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '606', '8', 'pending'), 
('2412', '2021-05-28', '0000-00-00', '81176', '', '117', '451', '', '17', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '606', '8', 'pending'), 
('2413', '2021-05-28', '0000-00-00', '81176', '', '115', '450', '', '17', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '606', '8', 'pending'), 
('2414', '2021-05-28', '0000-00-00', '35820', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '607', '8', 'pending'), 
('2415', '2021-05-28', '0000-00-00', '35820', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '607', '8', 'pending'), 
('2416', '2021-05-28', '0000-00-00', '35820', '', '99', '304', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '607', '8', 'pending'), 
('2417', '2021-05-28', '0000-00-00', '35820', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '607', '8', 'pending'), 
('2418', '2021-05-28', '0000-00-00', '35820', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '607', '8', 'pending'), 
('2419', '2021-05-28', '0000-00-00', '35820', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '607', '8', 'pending'), 
('2420', '2021-05-28', '0000-00-00', '53195', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '608', '8', 'pending'), 
('2421', '2021-05-28', '0000-00-00', '53195', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '608', '8', 'pending'), 
('2422', '2021-05-28', '0000-00-00', '53195', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '608', '8', 'pending'), 
('2423', '2021-05-28', '0000-00-00', '53195', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '608', '8', 'pending'), 
('2424', '2021-05-28', '0000-00-00', '82103', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '609', '8', 'pending'), 
('2425', '2021-05-28', '0000-00-00', '77516', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '610', '8', 'pending'), 
('2426', '2021-05-28', '0000-00-00', '92672', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '611', '8', 'pending'), 
('2427', '2021-05-28', '0000-00-00', '92672', '', '96', '282', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '611', '8', 'pending'), 
('2428', '2021-05-28', '0000-00-00', '92672', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '611', '8', 'pending'), 
('2429', '2021-05-28', '0000-00-00', '92672', '', '96', '668', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '611', '8', 'pending'), 
('2430', '2021-05-28', '0000-00-00', '56650', '', '97', '290', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '612', '8', 'pending'), 
('2431', '2021-05-28', '0000-00-00', '56650', '', '107', '366', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '612', '8', 'pending'), 
('2432', '2021-05-28', '0000-00-00', '56650', '', '98', '297', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '612', '8', 'pending'), 
('2433', '2021-05-28', '0000-00-00', '56650', '', '117', '451', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '612', '8', 'pending'), 
('2434', '2021-05-28', '0000-00-00', '56650', '', '117', '669', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '612', '8', 'pending'), 
('2435', '2021-05-28', '0000-00-00', '57903', '', '117', '647', '', '91', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '613', '8', 'pending'), 
('2436', '2021-05-28', '0000-00-00', '55376', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '614', '8', 'pending'), 
('2437', '2021-05-29', '0000-00-00', '85214', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '615', '8', 'pending'), 
('2438', '2021-05-29', '0000-00-00', '46368', '', '96', '661', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '616', '8', 'pending'), 
('2439', '2021-05-29', '0000-00-00', '46368', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '616', '8', 'pending'), 
('2440', '2021-05-29', '0000-00-00', '46368', '', '36', '102', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '616', '8', 'pending'), 
('2441', '2021-05-29', '0000-00-00', '46368', '', '97', '294', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '616', '8', 'pending'), 
('2442', '2021-05-29', '0000-00-00', '46368', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '616', '8', 'pending'), 
('2443', '2021-05-29', '0000-00-00', '21334', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '617', '8', 'pending'), 
('2444', '2021-05-29', '0000-00-00', '21334', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '617', '8', 'pending'), 
('2445', '2021-05-29', '0000-00-00', '21334', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '617', '8', 'pending'), 
('2446', '2021-05-29', '0000-00-00', '21334', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '617', '8', 'pending'), 
('2447', '2021-05-29', '0000-00-00', '21334', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '617', '8', 'pending'), 
('2448', '2021-05-29', '0000-00-00', '21334', '', '117', '463', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '617', '8', 'pending'), 
('2449', '2021-05-29', '0000-00-00', '21334', '', '112', '287', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '617', '8', 'pending'), 
('2450', '2021-05-29', '0000-00-00', '13093', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '618', '8', 'pending'), 
('2451', '2021-05-29', '0000-00-00', '13093', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '618', '8', 'pending'), 
('2452', '2021-05-29', '0000-00-00', '13093', '', '117', '622', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '618', '8', 'pending'), 
('2453', '2021-05-29', '0000-00-00', '13093', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '618', '8', 'pending'), 
('2454', '2021-05-29', '0000-00-00', '13093', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '618', '8', 'pending'), 
('2455', '2021-05-29', '0000-00-00', '13093', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '618', '8', 'pending'), 
('2456', '2021-05-29', '0000-00-00', '13093', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '618', '8', 'pending'), 
('2457', '2021-05-29', '0000-00-00', '13093', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '618', '8', 'pending'), 
('2458', '2021-05-29', '0000-00-00', '99632', '', '120', '531', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '619', '8', 'pending'), 
('2459', '2021-05-29', '0000-00-00', '25609', '', '97', '290', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '620', '4', 'pending'), 
('2460', '2021-05-29', '0000-00-00', '25609', '', '98', '297', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '620', '4', 'pending'), 
('2461', '2021-05-29', '0000-00-00', '25609', '', '107', '366', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '620', '4', 'pending'), 
('2462', '2021-05-29', '0000-00-00', '25609', '', '117', '451', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '620', '4', 'pending'), 
('2463', '2021-05-29', '0000-00-00', '48498', '', '97', '290', '', '90', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '621', '4', 'pending'), 
('2464', '2021-05-29', '0000-00-00', '48498', '', '98', '297', '', '90', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '621', '4', 'pending'), 
('2465', '2021-05-29', '0000-00-00', '48498', '', '36', '102', '', '90', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '621', '4', 'pending'), 
('2466', '2021-05-29', '0000-00-00', '48498', '', '42', '338', '', '90', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '621', '4', 'pending'), 
('2467', '2021-05-29', '0000-00-00', '48498', '', '121', '532', '', '90', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '621', '4', 'pending'), 
('2468', '2021-05-29', '0000-00-00', '90363', '', '117', '451', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '622', '4', 'pending'), 
('2469', '2021-05-29', '0000-00-00', '62514', '', '117', '451', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '623', '4', 'pending'), 
('2471', '2021-05-29', '0000-00-00', '19932', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '625', '4', 'pending'), 
('2472', '2021-05-29', '0000-00-00', '19932', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '625', '4', 'pending'), 
('2473', '2021-05-29', '0000-00-00', '19932', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '625', '4', 'pending'), 
('2474', '2021-05-29', '0000-00-00', '19932', '', '98', '297', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '625', '4', 'pending'), 
('2475', '2021-05-29', '0000-00-00', '19932', '', '123', '561', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '625', '4', 'pending'), 
('2476', '2021-05-29', '0000-00-00', '19932', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '625', '4', 'pending'), 
('2477', '2021-05-29', '0000-00-00', '19932', '', '118', '589', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '625', '4', 'pending'), 
('2478', '2021-05-29', '0000-00-00', '41691', '', '117', '451', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '626', '4', 'pending'), 
('2479', '2021-05-29', '0000-00-00', '17305', '', '117', '451', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '627', '4', 'pending'), 
('2480', '2021-05-29', '0000-00-00', '88905', '', '117', '451', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '628', '4', 'pending'), 
('2481', '2021-05-29', '0000-00-00', '87066', '', '117', '451', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '629', '4', 'pending'), 
('2482', '2021-05-29', '0000-00-00', '40081', '', '45', '101', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '630', '4', 'pending'), 
('2483', '2021-05-29', '0000-00-00', '40081', '', '97', '290', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '630', '4', 'pending'), 
('2484', '2021-05-29', '0000-00-00', '40081', '', '98', '297', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '630', '4', 'pending'), 
('2485', '2021-05-29', '0000-00-00', '40081', '', '103', '329', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '630', '4', 'pending'), 
('2486', '2021-05-29', '0000-00-00', '40081', '', '42', '338', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '630', '4', 'pending'), 
('2487', '2021-05-29', '0000-00-00', '40081', '', '107', '366', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '630', '4', 'pending'), 
('2488', '2021-05-29', '0000-00-00', '40081', '', '117', '451', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '630', '4', 'pending'), 
('2489', '2021-05-29', '0000-00-00', '40081', '', '121', '532', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '630', '4', 'pending'), 
('2490', '2021-05-29', '0000-00-00', '40081', '', '123', '467', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '630', '4', 'pending'), 
('2491', '2021-05-29', '0000-00-00', '52084', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '631', '4', 'pending'), 
('2492', '2021-05-29', '0000-00-00', '52084', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '631', '4', 'pending'), 
('2493', '2021-05-29', '0000-00-00', '52084', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '631', '4', 'pending'), 
('2494', '2021-05-29', '0000-00-00', '52084', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '631', '4', 'pending'), 
('2495', '2021-05-29', '0000-00-00', '52084', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '631', '4', 'pending'), 
('2496', '2021-05-29', '0000-00-00', '92331', '', '45', '101', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '632', '4', 'pending'), 
('2497', '2021-05-29', '0000-00-00', '92331', '', '35', '73', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '632', '4', 'pending'), 
('2498', '2021-05-29', '0000-00-00', '92331', '', '98', '297', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '632', '4', 'pending'), 
('2499', '2021-05-29', '0000-00-00', '92331', '', '98', '299', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '632', '4', 'pending'), 
('2500', '2021-05-29', '0000-00-00', '92331', '', '99', '301', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '632', '4', 'pending'), 
('2501', '2021-05-29', '0000-00-00', '92331', '', '99', '302', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '632', '4', 'pending'), 
('2502', '2021-05-29', '0000-00-00', '92331', '', '42', '338', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '632', '4', 'pending'), 
('2503', '2021-05-29', '0000-00-00', '92331', '', '107', '366', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '632', '4', 'pending'), 
('2504', '2021-05-29', '0000-00-00', '92331', '', '123', '561', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '632', '4', 'pending'), 
('2505', '2021-05-29', '0000-00-00', '92331', '', '116', '660', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '632', '4', 'pending'), 
('2506', '2021-05-29', '0000-00-00', '92331', '', '97', '290', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '632', '4', 'pending'), 
('2507', '2021-05-29', '0000-00-00', '77854', '', '35', '73', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '633', '4', 'pending'), 
('2508', '2021-05-29', '0000-00-00', '77854', '', '107', '366', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '633', '4', 'pending'), 
('2509', '2021-05-29', '0000-00-00', '77854', '', '42', '338', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '633', '4', 'pending'), 
('2510', '2021-05-29', '0000-00-00', '77854', '', '97', '290', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '633', '4', 'pending'), 
('2511', '2021-05-29', '0000-00-00', '77854', '', '98', '297', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '633', '4', 'pending'), 
('2512', '2021-05-29', '0000-00-00', '77854', '', '103', '329', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '633', '4', 'pending'), 
('2513', '2021-05-29', '0000-00-00', '77854', '', '105', '616', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '633', '4', 'pending'), 
('2514', '2021-05-29', '0000-00-00', '77854', '', '121', '532', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '633', '4', 'pending'), 
('2515', '2021-05-29', '0000-00-00', '77854', '', '123', '561', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '633', '4', 'pending'), 
('2516', '2021-05-29', '0000-00-00', '93790', '', '123', '519', '', '18', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '634', '4', 'pending'), 
('2517', '2021-05-29', '0000-00-00', '93038', '', '117', '451', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '635', '4', 'pending'), 
('2518', '2021-05-29', '0000-00-00', '63217', '', '42', '338', '', '92', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '636', '4', 'pending'), 
('2519', '2021-05-29', '0000-00-00', '63217', '', '97', '290', '', '92', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '636', '4', 'pending'), 
('2520', '2021-05-29', '0000-00-00', '63217', '', '98', '297', '', '92', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '636', '4', 'pending'), 
('2529', '2021-05-29', '0000-00-00', '53313', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '638', '4', 'pending'), 
('2530', '2021-05-29', '0000-00-00', '53313', '', '112', '287', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '638', '4', 'pending'), 
('2531', '2021-05-29', '0000-00-00', '53313', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '638', '4', 'pending'), 
('2532', '2021-05-29', '0000-00-00', '53313', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '638', '4', 'pending'), 
('2533', '2021-05-29', '0000-00-00', '53313', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '638', '4', 'pending'), 
('2534', '2021-05-29', '0000-00-00', '53313', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '638', '4', 'pending'), 
('2535', '2021-05-29', '0000-00-00', '53313', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '638', '4', 'pending'), 
('2536', '2021-05-29', '0000-00-00', '53313', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '638', '4', 'pending'), 
('2537', '2021-05-29', '0000-00-00', '53313', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '638', '4', 'pending'), 
('2538', '2021-05-29', '0000-00-00', '59768', '', '117', '593', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '639', '4', 'pending'), 
('2539', '2021-05-29', '0000-00-00', '55445', '', '35', '73', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '640', '4', 'pending'), 
('2540', '2021-05-29', '0000-00-00', '55445', '', '107', '366', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '640', '4', 'pending'), 
('2541', '2021-05-29', '0000-00-00', '55445', '', '42', '338', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '640', '4', 'pending'), 
('2542', '2021-05-29', '0000-00-00', '55445', '', '97', '290', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '640', '4', 'pending'), 
('2543', '2021-05-29', '0000-00-00', '55445', '', '98', '297', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '640', '4', 'pending'), 
('2544', '2021-05-29', '0000-00-00', '55445', '', '107', '370', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '640', '4', 'pending'), 
('2545', '2021-05-29', '0000-00-00', '55445', '', '103', '329', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '640', '4', 'pending'), 
('2546', '2021-05-29', '0000-00-00', '55445', '', '105', '616', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '640', '4', 'pending'), 
('2547', '2021-05-29', '0000-00-00', '32761', '', '117', '473', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '641', '4', 'pending'), 
('2548', '2021-05-29', '0000-00-00', '21712', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '642', '4', 'pending'), 
('2549', '2021-05-29', '0000-00-00', '52354', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '643', '4', 'pending'), 
('2555', '2021-05-29', '0000-00-00', '47177', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '645', '4', 'pending'), 
('2556', '2021-05-29', '0000-00-00', '47177', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '645', '4', 'pending'), 
('2557', '2021-05-29', '0000-00-00', '47177', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '645', '4', 'pending'), 
('2558', '2021-05-29', '0000-00-00', '47177', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '645', '4', 'pending'), 
('2559', '2021-05-29', '0000-00-00', '47177', '', '107', '374', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '645', '4', 'pending'), 
('2560', '2021-05-29', '0000-00-00', '47177', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '645', '4', 'pending'), 
('2561', '2021-05-29', '0000-00-00', '47177', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '645', '4', 'pending'), 
('2562', '2021-05-29', '0000-00-00', '99506', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '646', '4', 'pending'), 
('2563', '2021-05-29', '0000-00-00', '99506', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '646', '4', 'pending'), 
('2564', '2021-05-29', '0000-00-00', '99506', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '646', '4', 'pending'), 
('2565', '2021-05-29', '0000-00-00', '99506', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '646', '4', 'pending'), 
('2566', '2021-05-29', '0000-00-00', '37206', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '647', '4', 'pending'), 
('2567', '2021-05-29', '0000-00-00', '37206', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '647', '4', 'pending'), 
('2568', '2021-05-29', '0000-00-00', '37206', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '647', '4', 'pending'), 
('2569', '2021-05-29', '0000-00-00', '37206', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '647', '4', 'pending'), 
('2570', '2021-05-29', '0000-00-00', '37206', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '647', '4', 'pending'), 
('2571', '2021-05-29', '0000-00-00', '22345', '', '45', '101', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '648', '4', 'pending'), 
('2572', '2021-05-29', '0000-00-00', '22345', '', '97', '290', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '648', '4', 'pending'), 
('2573', '2021-05-29', '0000-00-00', '22345', '', '98', '297', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '648', '4', 'pending'), 
('2574', '2021-05-29', '0000-00-00', '22345', '', '42', '338', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '648', '4', 'pending'), 
('2575', '2021-05-29', '0000-00-00', '22345', '', '123', '561', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '648', '4', 'pending'), 
('2576', '2021-05-30', '0000-00-00', '34396', '', '97', '291', '', '17', '17', '', '', '', '0', '0.00', '', '0.00', '0.00', '649', '8', 'pending'), 
('2577', '2021-05-30', '0000-00-00', '34396', '', '97', '670', '', '17', '17', '', '', '', '0', '0.00', '', '0.00', '0.00', '649', '8', 'pending'), 
('2578', '2021-05-30', '0000-00-00', '34396', '', '98', '297', '', '17', '17', '', '', '', '0', '0.00', '', '0.00', '0.00', '649', '8', 'pending'), 
('2579', '2021-05-30', '0000-00-00', '34396', '', '99', '301', '', '17', '17', '', '', '', '0', '0.00', '', '0.00', '0.00', '649', '8', 'pending'), 
('2580', '2021-05-30', '0000-00-00', '34396', '', '36', '102', '', '17', '17', '', '', '', '0', '0.00', '', '0.00', '0.00', '649', '8', 'pending'), 
('2581', '2021-05-30', '0000-00-00', '90903', '', '35', '73', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '650', '8', 'pending'), 
('2582', '2021-05-30', '0000-00-00', '90903', '', '97', '290', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '650', '8', 'pending'), 
('2583', '2021-05-30', '0000-00-00', '90903', '', '103', '329', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '650', '8', 'pending'), 
('2584', '2021-05-30', '0000-00-00', '90903', '', '42', '338', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '650', '8', 'pending'), 
('2585', '2021-05-30', '0000-00-00', '90903', '', '120', '634', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '650', '8', 'pending'), 
('2586', '2021-05-30', '0000-00-00', '93373', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '651', '8', 'pending'), 
('2587', '2021-05-30', '0000-00-00', '39972', '', '45', '101', '', '22', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '652', '8', 'pending'), 
('2588', '2021-05-30', '0000-00-00', '39972', '', '97', '290', '', '22', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '652', '8', 'pending'), 
('2589', '2021-05-30', '0000-00-00', '39972', '', '99', '304', '', '22', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '652', '8', 'pending'), 
('2590', '2021-05-30', '0000-00-00', '39972', '', '98', '297', '', '22', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '652', '8', 'pending'), 
('2591', '2021-05-30', '0000-00-00', '39972', '', '107', '377', '', '22', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '652', '8', 'pending'), 
('2592', '2021-05-30', '0000-00-00', '39972', '', '103', '329', '', '22', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '652', '8', 'pending'), 
('2593', '2021-05-30', '0000-00-00', '39972', '', '107', '366', '', '22', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '652', '8', 'pending'), 
('2594', '2021-05-30', '0000-00-00', '39972', '', '42', '338', '', '22', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '652', '8', 'pending'), 
('2595', '2021-05-30', '0000-00-00', '39972', '', '121', '532', '', '22', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '652', '8', 'pending'), 
('2596', '2021-05-30', '0000-00-00', '39972', '', '123', '561', '', '22', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '652', '8', 'pending'), 
('2597', '2021-05-30', '0000-00-00', '39972', '', '117', '451', '', '22', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '652', '8', 'pending'), 
('2599', '2021-05-30', '0000-00-00', '48771', '', '117', '654', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '654', '4', 'pending'), 
('2600', '2021-05-30', '0000-00-00', '48771', '', '117', '624', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '654', '4', 'pending'), 
('2601', '2021-05-30', '0000-00-00', '49071', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '655', '4', 'pending'), 
('2602', '2021-05-30', '0000-00-00', '49071', '', '112', '287', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '655', '4', 'pending'), 
('2603', '2021-05-30', '0000-00-00', '49071', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '655', '4', 'pending'), 
('2604', '2021-05-30', '0000-00-00', '49071', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '655', '4', 'pending'), 
('2605', '2021-05-30', '0000-00-00', '49071', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '655', '4', 'pending'), 
('2606', '2021-05-30', '0000-00-00', '49071', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '655', '4', 'pending'), 
('2607', '2021-05-30', '0000-00-00', '49071', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '655', '4', 'pending'), 
('2608', '2021-05-30', '0000-00-00', '49071', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '655', '4', 'pending'), 
('2609', '2021-05-30', '0000-00-00', '49071', '', '117', '464', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '655', '4', 'pending'), 
('2610', '2021-05-30', '0000-00-00', '89281', '', '97', '290', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '656', '4', 'pending'), 
('2611', '2021-05-30', '0000-00-00', '89281', '', '98', '297', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '656', '4', 'pending'), 
('2612', '2021-05-30', '0000-00-00', '89281', '', '98', '299', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '656', '4', 'pending'), 
('2613', '2021-05-30', '0000-00-00', '89281', '', '99', '301', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '656', '4', 'pending'), 
('2614', '2021-05-30', '0000-00-00', '89281', '', '108', '394', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '656', '4', 'pending'), 
('2615', '2021-05-30', '0000-00-00', '89281', '', '107', '366', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '656', '4', 'pending'), 
('2616', '2021-05-30', '0000-00-00', '89281', '', '117', '451', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '656', '4', 'pending'), 
('2617', '2021-05-30', '0000-00-00', '89281', '', '123', '561', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '656', '4', 'pending'), 
('2618', '2021-05-30', '0000-00-00', '89281', '', '45', '101', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '656', '4', 'pending'), 
('2619', '2021-05-30', '0000-00-00', '35906', '', '42', '338', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '657', '4', 'pending'), 
('2620', '2021-05-30', '0000-00-00', '35906', '', '42', '346', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '657', '4', 'pending'), 
('2621', '2021-05-30', '0000-00-00', '35906', '', '123', '467', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '657', '4', 'pending'), 
('2622', '2021-05-30', '0000-00-00', '35906', '', '117', '622', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '657', '4', 'pending'), 
('2623', '2021-05-30', '0000-00-00', '68140', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '658', '4', 'pending'), 
('2624', '2021-05-30', '0000-00-00', '68140', '', '42', '338', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '658', '4', 'pending'), 
('2625', '2021-05-30', '0000-00-00', '68140', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '658', '4', 'pending'), 
('2626', '2021-05-30', '0000-00-00', '68140', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '658', '4', 'pending'), 
('2627', '2021-05-30', '0000-00-00', '68140', '', '107', '374', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '658', '4', 'pending'), 
('2628', '2021-05-30', '0000-00-00', '68140', '', '117', '460', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '658', '4', 'pending'), 
('2629', '2021-05-30', '0000-00-00', '68140', '', '117', '593', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '658', '4', 'pending'), 
('2630', '2021-05-30', '0000-00-00', '68544', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '659', '4', 'pending'), 
('2631', '2021-05-30', '0000-00-00', '68544', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '659', '4', 'pending'), 
('2632', '2021-05-30', '0000-00-00', '68544', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '659', '4', 'pending'), 
('2633', '2021-05-30', '0000-00-00', '68544', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '659', '4', 'pending'), 
('2634', '2021-05-30', '0000-00-00', '68544', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '659', '4', 'pending'), 
('2635', '2021-05-30', '0000-00-00', '62462', '', '45', '101', '', '26', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '660', '4', 'pending'), 
('2636', '2021-05-30', '0000-00-00', '62462', '', '97', '290', '', '26', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '660', '4', 'pending'), 
('2637', '2021-05-30', '0000-00-00', '62462', '', '98', '297', '', '26', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '660', '4', 'pending'), 
('2638', '2021-05-30', '0000-00-00', '62462', '', '42', '338', '', '26', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '660', '4', 'pending'), 
('2639', '2021-05-30', '0000-00-00', '62462', '', '99', '301', '', '26', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '660', '4', 'pending'), 
('2640', '2021-05-30', '0000-00-00', '62462', '', '121', '532', '', '26', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '660', '4', 'pending'), 
('2641', '2021-05-30', '0000-00-00', '62462', '', '117', '622', '', '26', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '660', '4', 'pending'), 
('2642', '2021-05-30', '0000-00-00', '62462', '', '123', '561', '', '26', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '660', '4', 'pending'), 
('2643', '2021-05-30', '0000-00-00', '15935', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '661', '4', 'pending'), 
('2644', '2021-05-30', '0000-00-00', '15935', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '661', '4', 'pending'), 
('2645', '2021-05-30', '0000-00-00', '15935', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '661', '4', 'pending'), 
('2646', '2021-05-30', '0000-00-00', '15935', '', '107', '374', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '661', '4', 'pending'), 
('2647', '2021-05-30', '0000-00-00', '15935', '', '123', '561', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '661', '4', 'pending'), 
('2648', '2021-05-30', '0000-00-00', '15935', '', '117', '593', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '661', '4', 'pending'), 
('2649', '2021-05-30', '0000-00-00', '15935', '', '42', '338', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '661', '4', 'pending'), 
('2665', '2021-05-30', '0000-00-00', '92482', '', '45', '101', '', '6', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '663', '4', 'pending'), 
('2666', '2021-05-30', '0000-00-00', '92482', '', '97', '290', '', '6', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '663', '4', 'pending'), 
('2667', '2021-05-30', '0000-00-00', '92482', '', '103', '329', '', '6', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '663', '4', 'pending'), 
('2668', '2021-05-30', '0000-00-00', '92482', '', '98', '297', '', '6', '24', '', '', '', '0', '0.00', '', '0.00', '0.00', '663', '4', 'pending'), 
('2669', '2021-05-30', '0000-00-00', '62405', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2670', '2021-05-30', '0000-00-00', '62405', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2671', '2021-05-30', '0000-00-00', '62405', '', '99', '301', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2672', '2021-05-30', '0000-00-00', '62405', '', '99', '304', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2673', '2021-05-30', '0000-00-00', '62405', '', '104', '309', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2674', '2021-05-30', '0000-00-00', '62405', '', '103', '329', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2675', '2021-05-30', '0000-00-00', '62405', '', '42', '338', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2676', '2021-05-30', '0000-00-00', '62405', '', '107', '366', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2677', '2021-05-30', '0000-00-00', '62405', '', '107', '377', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2678', '2021-05-30', '0000-00-00', '62405', '', '117', '461', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2679', '2021-05-30', '0000-00-00', '62405', '', '117', '644', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2680', '2021-05-30', '0000-00-00', '62405', '', '121', '532', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2681', '2021-05-30', '0000-00-00', '62405', '', '123', '561', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2682', '2021-05-30', '0000-00-00', '62405', '', '117', '593', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2683', '2021-05-30', '0000-00-00', '62405', '', '117', '596', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2684', '2021-05-30', '0000-00-00', '62405', '', '117', '456', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '664', '4', 'pending'), 
('2685', '2021-05-30', '0000-00-00', '22318', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '665', '4', 'pending'), 
('2686', '2021-05-30', '0000-00-00', '22318', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '665', '4', 'pending'), 
('2687', '2021-05-30', '0000-00-00', '62912', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '666', '4', 'pending'), 
('2688', '2021-05-30', '0000-00-00', '62912', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '666', '4', 'pending'), 
('2689', '2021-05-30', '0000-00-00', '62912', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '666', '4', 'pending'), 
('2690', '2021-05-30', '0000-00-00', '62912', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '666', '4', 'pending'), 
('2691', '2021-05-30', '0000-00-00', '62912', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '666', '4', 'pending'), 
('2692', '2021-05-30', '0000-00-00', '62912', '', '123', '561', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '666', '4', 'pending'), 
('2693', '2021-05-30', '0000-00-00', '86025', '', '45', '101', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '667', '4', 'pending'), 
('2694', '2021-05-30', '0000-00-00', '86025', '', '97', '290', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '667', '4', 'pending'), 
('2695', '2021-05-30', '0000-00-00', '86025', '', '99', '301', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '667', '4', 'pending'), 
('2696', '2021-05-30', '0000-00-00', '86025', '', '99', '302', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '667', '4', 'pending'), 
('2697', '2021-05-30', '0000-00-00', '86025', '', '42', '338', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '667', '4', 'pending'), 
('2698', '2021-05-30', '0000-00-00', '86025', '', '105', '353', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '667', '4', 'pending'), 
('2699', '2021-05-30', '0000-00-00', '86025', '', '107', '366', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '667', '4', 'pending'), 
('2700', '2021-05-30', '0000-00-00', '86025', '', '117', '451', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '667', '4', 'pending'), 
('2701', '2021-05-30', '0000-00-00', '39446', '', '45', '101', '', '76', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '668', '4', 'pending'), 
('2702', '2021-05-30', '0000-00-00', '39446', '', '97', '290', '', '76', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '668', '4', 'pending'), 
('2703', '2021-05-30', '0000-00-00', '39446', '', '98', '297', '', '76', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '668', '4', 'pending'), 
('2704', '2021-05-30', '0000-00-00', '39446', '', '42', '338', '', '76', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '668', '4', 'pending'), 
('2705', '2021-05-30', '0000-00-00', '39446', '', '107', '366', '', '76', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '668', '4', 'pending'), 
('2706', '2021-05-30', '0000-00-00', '39446', '', '122', '513', '', '76', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '668', '4', 'pending'), 
('2707', '2021-05-30', '0000-00-00', '39446', '', '103', '329', '', '76', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '668', '4', 'pending'), 
('2708', '2021-05-30', '0000-00-00', '30085', '', '35', '73', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '669', '4', 'pending'), 
('2709', '2021-05-30', '0000-00-00', '30085', '', '97', '290', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '669', '4', 'pending'), 
('2710', '2021-05-30', '0000-00-00', '30085', '', '98', '297', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '669', '4', 'pending'), 
('2711', '2021-05-30', '0000-00-00', '30085', '', '98', '299', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '669', '4', 'pending'), 
('2712', '2021-05-30', '0000-00-00', '30085', '', '99', '301', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '669', '4', 'pending'), 
('2713', '2021-05-30', '0000-00-00', '30085', '', '42', '338', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '669', '4', 'pending'), 
('2714', '2021-05-30', '0000-00-00', '30085', '', '122', '513', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '669', '4', 'pending'), 
('2715', '2021-05-30', '0000-00-00', '30085', '', '105', '616', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '669', '4', 'pending'), 
('2716', '2021-05-30', '0000-00-00', '42347', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '670', '4', 'pending'), 
('2717', '2021-05-30', '0000-00-00', '42347', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '670', '4', 'pending'), 
('2718', '2021-05-30', '0000-00-00', '42347', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '670', '4', 'pending'), 
('2719', '2021-05-30', '0000-00-00', '42347', '', '117', '463', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '670', '4', 'pending'), 
('2720', '2021-05-30', '0000-00-00', '42347', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '670', '4', 'pending'), 
('2721', '2021-05-30', '0000-00-00', '42347', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '670', '4', 'pending'), 
('2722', '2021-05-30', '0000-00-00', '21139', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '671', '4', 'pending'), 
('2723', '2021-05-30', '0000-00-00', '21139', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '671', '4', 'pending'), 
('2724', '2021-05-30', '0000-00-00', '21139', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '671', '4', 'pending'), 
('2725', '2021-05-30', '0000-00-00', '21139', '', '110', '633', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '671', '4', 'pending'), 
('2726', '2021-05-30', '0000-00-00', '21139', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '671', '4', 'pending'), 
('2727', '2021-05-30', '0000-00-00', '21139', '', '108', '639', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '671', '4', 'pending'), 
('2728', '2021-05-30', '0000-00-00', '38648', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '672', '4', 'pending'), 
('2729', '2021-05-30', '0000-00-00', '80130', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '673', '4', 'pending'), 
('2730', '2021-05-30', '0000-00-00', '19593', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '674', '4', 'pending'), 
('2735', '2021-05-30', '0000-00-00', '48657', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '676', '4', 'pending'), 
('2736', '2021-05-30', '0000-00-00', '48657', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '676', '4', 'pending'), 
('2737', '2021-05-30', '0000-00-00', '48657', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '676', '4', 'pending'), 
('2738', '2021-05-30', '0000-00-00', '82022', '', '45', '101', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '677', '4', 'pending'), 
('2739', '2021-05-30', '0000-00-00', '82022', '', '107', '374', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '677', '4', 'pending'), 
('2740', '2021-05-30', '0000-00-00', '82022', '', '97', '290', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '677', '4', 'pending'), 
('2741', '2021-05-30', '0000-00-00', '82022', '', '96', '642', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '677', '4', 'pending'), 
('2742', '2021-05-30', '0000-00-00', '82022', '', '42', '338', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '677', '4', 'pending'), 
('2743', '2021-05-30', '0000-00-00', '82022', '', '121', '532', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '677', '4', 'pending'), 
('2744', '2021-05-30', '0000-00-00', '82022', '', '117', '451', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '677', '4', 'pending'), 
('2746', '2021-05-30', '0000-00-00', '34386', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '679', '4', 'pending'), 
('2747', '2021-05-31', '0000-00-00', '12171', '', '107', '377', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '680', '8', 'pending'), 
('2748', '2021-05-31', '0000-00-00', '12171', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '680', '8', 'pending'), 
('2749', '2021-05-31', '0000-00-00', '80067', '', '121', '532', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '681', '8', 'pending'), 
('2750', '2021-05-31', '0000-00-00', '62228', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '682', '8', 'pending'), 
('2751', '2021-05-31', '0000-00-00', '62228', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '682', '8', 'pending'), 
('2752', '2021-05-31', '0000-00-00', '62228', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '682', '8', 'pending'), 
('2753', '2021-05-31', '0000-00-00', '62228', '', '99', '301', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '682', '8', 'pending'), 
('2754', '2021-05-31', '0000-00-00', '62228', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '682', '8', 'pending'), 
('2755', '2021-05-31', '0000-00-00', '62228', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '682', '8', 'pending'), 
('2756', '2021-05-31', '0000-00-00', '62228', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '682', '8', 'pending'), 
('2757', '2021-05-31', '0000-00-00', '62228', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '682', '8', 'pending'), 
('2758', '2021-05-31', '0000-00-00', '62228', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '682', '8', 'pending'), 
('2759', '2021-05-31', '0000-00-00', '62228', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '682', '8', 'pending'), 
('2760', '2021-05-31', '0000-00-00', '53818', '', '45', '101', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '683', '8', 'pending'), 
('2761', '2021-05-31', '0000-00-00', '53818', '', '97', '290', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '683', '8', 'pending'), 
('2762', '2021-05-31', '0000-00-00', '53818', '', '98', '297', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '683', '8', 'pending'), 
('2763', '2021-05-31', '0000-00-00', '53818', '', '42', '338', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '683', '8', 'pending'), 
('2764', '2021-05-31', '0000-00-00', '53818', '', '123', '561', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '683', '8', 'pending'), 
('2765', '2021-05-31', '0000-00-00', '60974', '', '117', '451', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '684', '8', 'pending'), 
('2766', '2021-05-31', '0000-00-00', '55529', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '685', '4', 'pending'), 
('2767', '2021-05-31', '0000-00-00', '82350', '', '45', '101', '', '18', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '686', '4', 'pending'), 
('2768', '2021-05-31', '0000-00-00', '82350', '', '97', '290', '', '18', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '686', '4', 'pending'), 
('2769', '2021-05-31', '0000-00-00', '82350', '', '107', '366', '', '18', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '686', '4', 'pending'), 
('2770', '2021-05-31', '0000-00-00', '82350', '', '123', '561', '', '18', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '686', '4', 'pending'), 
('2771', '2021-05-31', '0000-00-00', '68303', '', '123', '561', '', '38', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '687', '4', 'pending'), 
('2772', '2021-05-31', '0000-00-00', '30993', '', '117', '654', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '688', '4', 'pending'), 
('2773', '2021-05-31', '0000-00-00', '30993', '', '117', '461', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '688', '4', 'pending'), 
('2774', '2021-05-31', '0000-00-00', '30993', '', '117', '593', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '688', '4', 'pending'), 
('2775', '2021-05-31', '0000-00-00', '30993', '', '97', '290', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '688', '4', 'pending'), 
('2776', '2021-05-31', '0000-00-00', '30993', '', '98', '297', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '688', '4', 'pending'), 
('2777', '2021-05-31', '0000-00-00', '30993', '', '45', '101', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '688', '4', 'pending'), 
('2778', '2021-05-31', '0000-00-00', '30993', '', '42', '338', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '688', '4', 'pending'), 
('2779', '2021-05-31', '0000-00-00', '49104', '', '35', '73', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '689', '4', 'pending'), 
('2780', '2021-05-31', '0000-00-00', '49104', '', '97', '290', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '689', '4', 'pending'), 
('2781', '2021-05-31', '0000-00-00', '49104', '', '98', '297', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '689', '4', 'pending'), 
('2782', '2021-05-31', '0000-00-00', '49104', '', '99', '301', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '689', '4', 'pending'), 
('2783', '2021-05-31', '0000-00-00', '49104', '', '103', '329', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '689', '4', 'pending'), 
('2784', '2021-05-31', '0000-00-00', '49104', '', '107', '366', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '689', '4', 'pending'), 
('2785', '2021-05-31', '0000-00-00', '49104', '', '117', '451', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '689', '4', 'pending'), 
('2786', '2021-05-31', '0000-00-00', '49104', '', '123', '561', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '689', '4', 'pending'), 
('2787', '2021-05-31', '0000-00-00', '58024', '', '45', '101', '', '18', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '690', '4', 'pending'), 
('2788', '2021-05-31', '0000-00-00', '58024', '', '97', '290', '', '18', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '690', '4', 'pending'), 
('2789', '2021-05-31', '0000-00-00', '58024', '', '98', '297', '', '18', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '690', '4', 'pending'), 
('2790', '2021-05-31', '0000-00-00', '58024', '', '101', '314', '', '18', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '690', '4', 'pending'), 
('2791', '2021-05-31', '0000-00-00', '58024', '', '42', '338', '', '18', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '690', '4', 'pending'), 
('2792', '2021-05-31', '0000-00-00', '58024', '', '123', '561', '', '18', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '690', '4', 'pending'), 
('2793', '2021-05-31', '0000-00-00', '58024', '', '121', '532', '', '18', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '690', '4', 'pending'), 
('2794', '2021-05-31', '0000-00-00', '98660', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '691', '4', 'pending'), 
('2795', '2021-05-31', '0000-00-00', '98660', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '691', '4', 'pending'), 
('2796', '2021-05-31', '0000-00-00', '98660', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '691', '4', 'pending'), 
('2797', '2021-05-31', '0000-00-00', '98660', '', '112', '287', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '691', '4', 'pending'), 
('2798', '2021-05-31', '0000-00-00', '98660', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '691', '4', 'pending'), 
('2799', '2021-05-31', '0000-00-00', '98660', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '691', '4', 'pending'), 
('2800', '2021-05-31', '0000-00-00', '98660', '', '110', '666', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '691', '4', 'pending'), 
('2817', '2021-05-31', '0000-00-00', '93436', '', '45', '101', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '694', '4', 'pending'), 
('2818', '2021-05-31', '0000-00-00', '93436', '', '97', '290', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '694', '4', 'pending'), 
('2819', '2021-05-31', '0000-00-00', '93436', '', '98', '297', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '694', '4', 'pending'), 
('2820', '2021-05-31', '0000-00-00', '93436', '', '121', '532', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '694', '4', 'pending'), 
('2821', '2021-05-31', '0000-00-00', '93436', '', '117', '451', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '694', '4', 'pending'), 
('2822', '2021-05-31', '0000-00-00', '93436', '', '103', '329', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '694', '4', 'pending'), 
('2823', '2021-05-31', '0000-00-00', '93436', '', '107', '366', '', '8', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '694', '4', 'pending'), 
('2824', '2021-05-31', '0000-00-00', '51135', '', '45', '101', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '695', '4', 'pending'), 
('2825', '2021-05-31', '0000-00-00', '51135', '', '103', '329', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '695', '4', 'pending'), 
('2826', '2021-05-31', '0000-00-00', '51135', '', '107', '366', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '695', '4', 'pending'), 
('2827', '2021-05-31', '0000-00-00', '51135', '', '97', '290', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '695', '4', 'pending'), 
('2828', '2021-05-31', '0000-00-00', '51135', '', '98', '297', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '695', '4', 'pending'), 
('2829', '2021-05-31', '0000-00-00', '51135', '', '120', '531', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '695', '4', 'pending'), 
('2830', '2021-05-31', '0000-00-00', '51135', '', '42', '338', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '695', '4', 'pending'), 
('2831', '2021-05-31', '0000-00-00', '51135', '', '117', '595', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '695', '4', 'pending'), 
('2832', '2021-05-31', '0000-00-00', '19951', '', '45', '101', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '696', '4', 'pending'), 
('2833', '2021-05-31', '0000-00-00', '19951', '', '97', '290', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '696', '4', 'pending'), 
('2834', '2021-05-31', '0000-00-00', '19951', '', '98', '297', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '696', '4', 'pending'), 
('2835', '2021-05-31', '0000-00-00', '19951', '', '42', '338', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '696', '4', 'pending'), 
('2836', '2021-05-31', '0000-00-00', '19951', '', '107', '366', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '696', '4', 'pending'), 
('2837', '2021-05-31', '0000-00-00', '19951', '', '117', '451', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '696', '4', 'pending'), 
('2838', '2021-05-31', '0000-00-00', '19951', '', '118', '589', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '696', '4', 'pending'), 
('2839', '2021-05-31', '0000-00-00', '19951', '', '123', '561', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '696', '4', 'pending'), 
('2840', '2021-05-31', '0000-00-00', '80028', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '697', '4', 'pending'), 
('2841', '2021-05-31', '0000-00-00', '80028', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '697', '4', 'pending'), 
('2842', '2021-05-31', '0000-00-00', '80028', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '697', '4', 'pending'), 
('2843', '2021-05-31', '0000-00-00', '80028', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '697', '4', 'pending'), 
('2844', '2021-05-31', '0000-00-00', '62157', '', '117', '451', '', '6', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '698', '4', 'pending'), 
('2845', '2021-05-31', '0000-00-00', '70720', '', '45', '101', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '699', '4', 'pending'), 
('2846', '2021-05-31', '0000-00-00', '70720', '', '99', '301', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '699', '4', 'pending'), 
('2847', '2021-05-31', '0000-00-00', '70720', '', '98', '297', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '699', '4', 'pending'), 
('2848', '2021-05-31', '0000-00-00', '70720', '', '42', '338', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '699', '4', 'pending'), 
('2849', '2021-05-31', '0000-00-00', '70720', '', '121', '532', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '699', '4', 'pending'), 
('2850', '2021-05-31', '0000-00-00', '70720', '', '117', '463', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '699', '4', 'pending'), 
('2851', '2021-05-31', '0000-00-00', '70720', '', '117', '593', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '699', '4', 'pending'), 
('2852', '2021-05-31', '0000-00-00', '70720', '', '96', '282', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '699', '4', 'pending'), 
('2853', '2021-05-31', '0000-00-00', '70720', '', '97', '290', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '699', '4', 'pending'), 
('2854', '2021-05-31', '0000-00-00', '28697', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '700', '4', 'pending'), 
('2855', '2021-05-31', '0000-00-00', '28697', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '700', '4', 'pending'), 
('2856', '2021-05-31', '0000-00-00', '28697', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '700', '4', 'pending'), 
('2857', '2021-05-31', '0000-00-00', '28697', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '700', '4', 'pending'), 
('2858', '2021-05-31', '0000-00-00', '28697', '', '108', '407', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '700', '4', 'pending'), 
('2859', '2021-05-31', '0000-00-00', '51603', '', '114', '445', '', '14', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '701', '4', 'pending'), 
('2860', '2021-05-31', '0000-00-00', '51603', '', '45', '101', '', '14', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '701', '4', 'pending'), 
('2861', '2021-05-31', '0000-00-00', '51603', '', '114', '611', '', '14', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '701', '4', 'pending'), 
('2862', '2021-05-31', '0000-00-00', '51603', '', '118', '671', '', '14', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '701', '4', 'pending'), 
('2863', '2021-05-31', '0000-00-00', '51603', '', '121', '532', '', '14', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '701', '4', 'pending'), 
('2864', '2021-05-31', '0000-00-00', '51603', '', '118', '672', '', '14', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '701', '4', 'pending'), 
('2865', '2021-05-31', '0000-00-00', '56719', '', '35', '73', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '702', '4', 'pending'), 
('2866', '2021-05-31', '0000-00-00', '56719', '', '97', '290', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '702', '4', 'pending'), 
('2867', '2021-05-31', '0000-00-00', '56719', '', '103', '329', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '702', '4', 'pending'), 
('2868', '2021-05-31', '0000-00-00', '56719', '', '123', '519', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '702', '4', 'pending'), 
('2869', '2021-05-31', '0000-00-00', '14019', '', '117', '593', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '703', '4', 'pending'), 
('2870', '2021-05-31', '0000-00-00', '67342', '', '45', '101', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '704', '4', 'pending'), 
('2871', '2021-05-31', '0000-00-00', '67342', '', '103', '329', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '704', '4', 'pending'), 
('2872', '2021-05-31', '0000-00-00', '67342', '', '117', '451', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '704', '4', 'pending'), 
('2873', '2021-05-31', '0000-00-00', '67342', '', '42', '338', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '704', '4', 'pending'), 
('2874', '2021-05-31', '0000-00-00', '67342', '', '123', '561', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '704', '4', 'pending'), 
('2876', '2021-05-31', '0000-00-00', '39923', '', '117', '589', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '706', '4', 'pending'), 
('2877', '2021-05-31', '0000-00-00', '37261', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '707', '4', 'pending'), 
('2878', '2021-05-31', '0000-00-00', '37261', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '707', '4', 'pending'), 
('2879', '2021-05-31', '0000-00-00', '37261', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '707', '4', 'pending'), 
('2880', '2021-05-31', '0000-00-00', '37261', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '707', '4', 'pending'), 
('2881', '2021-05-31', '0000-00-00', '37261', '', '112', '287', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '707', '4', 'pending'), 
('2882', '2021-05-31', '0000-00-00', '37261', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '707', '4', 'pending'), 
('2883', '2021-05-31', '0000-00-00', '37261', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '707', '4', 'pending'), 
('2884', '2021-05-31', '0000-00-00', '37261', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '707', '4', 'pending'), 
('2885', '2021-05-31', '0000-00-00', '92771', '', '123', '524', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '708', '4', 'pending'), 
('2886', '2021-05-31', '0000-00-00', '18677', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '709', '4', 'pending'), 
('2887', '2021-06-01', '0000-00-00', '74752', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '710', '8', 'pending'), 
('2888', '2021-06-01', '0000-00-00', '74752', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '710', '8', 'pending'), 
('2889', '2021-06-01', '0000-00-00', '74752', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '710', '8', 'pending'), 
('2890', '2021-06-01', '0000-00-00', '74752', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '710', '8', 'pending'), 
('2891', '2021-06-01', '0000-00-00', '74752', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '710', '8', 'pending'), 
('2892', '2021-06-01', '0000-00-00', '54416', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '711', '8', 'pending'), 
('2893', '2021-06-01', '0000-00-00', '37382', '', '35', '73', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '712', '8', 'pending'), 
('2894', '2021-06-01', '0000-00-00', '37382', '', '97', '290', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '712', '8', 'pending'), 
('2895', '2021-06-01', '0000-00-00', '37382', '', '103', '329', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '712', '8', 'pending'), 
('2896', '2021-06-01', '0000-00-00', '37382', '', '123', '519', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '712', '8', 'pending'), 
('2897', '2021-06-01', '0000-00-00', '59001', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '713', '4', 'pending'), 
('2898', '2021-06-01', '0000-00-00', '95863', '', '45', '101', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '714', '4', 'pending'), 
('2899', '2021-06-01', '0000-00-00', '95863', '', '97', '290', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '714', '4', 'pending'), 
('2900', '2021-06-01', '0000-00-00', '95863', '', '98', '297', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '714', '4', 'pending'), 
('2901', '2021-06-01', '0000-00-00', '95863', '', '103', '329', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '714', '4', 'pending'), 
('2902', '2021-06-01', '0000-00-00', '95863', '', '42', '338', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '714', '4', 'pending'), 
('2903', '2021-06-01', '0000-00-00', '95863', '', '117', '451', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '714', '4', 'pending'), 
('2904', '2021-06-01', '0000-00-00', '95863', '', '123', '561', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '714', '4', 'pending'), 
('2905', '2021-06-01', '0000-00-00', '95863', '', '121', '532', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '714', '4', 'pending'), 
('2906', '2021-06-01', '0000-00-00', '95863', '', '107', '366', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '714', '4', 'pending'), 
('2907', '2021-06-01', '0000-00-00', '54657', '', '45', '101', '', '96', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '715', '4', 'pending'), 
('2908', '2021-06-01', '0000-00-00', '54657', '', '97', '290', '', '96', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '715', '4', 'pending'), 
('2909', '2021-06-01', '0000-00-00', '54657', '', '107', '370', '', '96', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '715', '4', 'pending'), 
('2910', '2021-06-01', '0000-00-00', '54657', '', '99', '301', '', '96', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '715', '4', 'pending'), 
('2911', '2021-06-01', '0000-00-00', '54657', '', '42', '338', '', '96', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '715', '4', 'pending'), 
('2912', '2021-06-01', '0000-00-00', '54657', '', '105', '357', '', '96', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '715', '4', 'pending'), 
('2913', '2021-06-01', '0000-00-00', '54657', '', '105', '356', '', '96', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '715', '4', 'pending'), 
('2914', '2021-06-01', '0000-00-00', '40815', '', '121', '532', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '716', '4', 'pending'), 
('2915', '2021-06-01', '0000-00-00', '40815', '', '117', '451', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '716', '4', 'pending'), 
('2916', '2021-06-01', '0000-00-00', '37759', '', '45', '101', '', '97', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '717', '4', 'pending'), 
('2917', '2021-06-01', '0000-00-00', '37759', '', '97', '290', '', '97', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '717', '4', 'pending'), 
('2918', '2021-06-01', '0000-00-00', '37759', '', '98', '297', '', '97', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '717', '4', 'pending'), 
('2919', '2021-06-01', '0000-00-00', '37759', '', '98', '299', '', '97', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '717', '4', 'pending'), 
('2920', '2021-06-01', '0000-00-00', '37759', '', '42', '338', '', '97', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '717', '4', 'pending'), 
('2921', '2021-06-01', '0000-00-00', '37759', '', '107', '366', '', '97', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '717', '4', 'pending'), 
('2922', '2021-06-01', '0000-00-00', '37759', '', '117', '451', '', '97', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '717', '4', 'pending'), 
('2923', '2021-06-01', '0000-00-00', '37759', '', '123', '561', '', '97', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '717', '4', 'pending'), 
('2924', '2021-06-01', '0000-00-00', '37759', '', '105', '616', '', '97', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '717', '4', 'pending'), 
('2926', '2021-06-01', '0000-00-00', '70284', '', '117', '644', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '719', '4', 'pending'), 
('2927', '2021-06-01', '0000-00-00', '55263', '', '45', '101', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '720', '4', 'pending'), 
('2928', '2021-06-01', '0000-00-00', '55263', '', '98', '297', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '720', '4', 'pending'), 
('2929', '2021-06-01', '0000-00-00', '55263', '', '99', '307', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '720', '4', 'pending'), 
('2930', '2021-06-01', '0000-00-00', '55263', '', '103', '329', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '720', '4', 'pending'), 
('2931', '2021-06-01', '0000-00-00', '55263', '', '117', '451', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '720', '4', 'pending'), 
('2932', '2021-06-01', '0000-00-00', '55263', '', '121', '532', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '720', '4', 'pending'), 
('2933', '2021-06-01', '0000-00-00', '55263', '', '123', '561', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '720', '4', 'pending'), 
('2940', '2021-06-01', '0000-00-00', '57406', '', '98', '297', '', '18', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '722', '4', 'pending'), 
('2941', '2021-06-01', '0000-00-00', '57406', '', '117', '451', '', '18', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '722', '4', 'pending'), 
('2942', '2021-06-01', '0000-00-00', '57406', '', '121', '532', '', '18', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '722', '4', 'pending'), 
('2943', '2021-06-01', '0000-00-00', '57406', '', '99', '304', '', '18', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '722', '4', 'pending'), 
('2944', '2021-06-01', '0000-00-00', '57406', '', '99', '303', '', '18', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '722', '4', 'pending'), 
('2945', '2021-06-01', '0000-00-00', '91904', '', '45', '101', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '723', '4', 'pending'), 
('2946', '2021-06-01', '0000-00-00', '91904', '', '97', '290', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '723', '4', 'pending'), 
('2947', '2021-06-01', '0000-00-00', '91904', '', '98', '297', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '723', '4', 'pending'), 
('2948', '2021-06-01', '0000-00-00', '91904', '', '103', '329', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '723', '4', 'pending'), 
('2949', '2021-06-01', '0000-00-00', '91904', '', '107', '366', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '723', '4', 'pending'), 
('2950', '2021-06-01', '0000-00-00', '91904', '', '123', '561', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '723', '4', 'pending'), 
('2956', '2021-06-01', '0000-00-00', '98466', '', '45', '101', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '725', '4', 'pending'), 
('2957', '2021-06-01', '0000-00-00', '98466', '', '117', '451', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '725', '4', 'pending'), 
('2958', '2021-06-01', '0000-00-00', '98466', '', '121', '532', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '725', '4', 'pending'), 
('2959', '2021-06-01', '0000-00-00', '98466', '', '123', '561', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '725', '4', 'pending'), 
('2960', '2021-06-01', '0000-00-00', '98466', '', '114', '611', '', '6', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '725', '4', 'pending'), 
('2961', '2021-06-01', '0000-00-00', '85855', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '726', '4', 'pending'), 
('2962', '2021-06-01', '0000-00-00', '85855', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '726', '4', 'pending'), 
('2963', '2021-06-01', '0000-00-00', '85855', '', '98', '297', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '726', '4', 'pending'), 
('2964', '2021-06-01', '0000-00-00', '85855', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '726', '4', 'pending'), 
('2965', '2021-06-01', '0000-00-00', '85855', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '726', '4', 'pending'), 
('2966', '2021-06-01', '0000-00-00', '85855', '', '121', '532', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '726', '4', 'pending'), 
('2967', '2021-06-01', '0000-00-00', '32998', '', '42', '338', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '727', '4', 'pending'), 
('2968', '2021-06-01', '0000-00-00', '24979', '', '120', '638', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '728', '4', 'pending'), 
('2969', '2021-06-01', '0000-00-00', '24979', '', '99', '304', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '728', '4', 'pending'), 
('2970', '2021-06-01', '0000-00-00', '34419', '', '123', '561', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '729', '4', 'pending'), 
('2971', '2021-06-01', '0000-00-00', '46252', '', '117', '593', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '730', '4', 'pending'), 
('2972', '2021-06-01', '0000-00-00', '46252', '', '117', '461', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '730', '4', 'pending'), 
('2973', '2021-06-01', '0000-00-00', '46252', '', '117', '644', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '730', '4', 'pending'), 
('2974', '2021-06-01', '0000-00-00', '46252', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '730', '4', 'pending'), 
('2975', '2021-06-01', '0000-00-00', '46252', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '730', '4', 'pending'), 
('2976', '2021-06-01', '0000-00-00', '46252', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '730', '4', 'pending'), 
('2977', '2021-06-01', '0000-00-00', '46252', '', '123', '561', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '730', '4', 'pending'), 
('2978', '2021-06-01', '0000-00-00', '29798', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '731', '4', 'pending'), 
('2979', '2021-06-01', '0000-00-00', '29798', '', '107', '374', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '731', '4', 'pending'), 
('2980', '2021-06-01', '0000-00-00', '29798', '', '42', '338', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '731', '4', 'pending'), 
('2981', '2021-06-01', '0000-00-00', '29798', '', '123', '561', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '731', '4', 'pending'), 
('2982', '2021-06-01', '0000-00-00', '29798', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '731', '4', 'pending'), 
('2983', '2021-06-01', '0000-00-00', '29798', '', '117', '593', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '731', '4', 'pending'), 
('2984', '2021-06-01', '0000-00-00', '20730', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '732', '4', 'pending'), 
('2985', '2021-06-01', '0000-00-00', '20730', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '732', '4', 'pending'), 
('2986', '2021-06-01', '0000-00-00', '20730', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '732', '4', 'pending'), 
('2987', '2021-06-01', '0000-00-00', '20730', '', '107', '366', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '732', '4', 'pending'), 
('2988', '2021-06-01', '0000-00-00', '20730', '', '117', '461', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '732', '4', 'pending'), 
('2989', '2021-06-01', '0000-00-00', '20730', '', '117', '593', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '732', '4', 'pending'), 
('2990', '2021-06-01', '0000-00-00', '84481', '', '45', '101', '', '26', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '733', '4', 'pending'), 
('2991', '2021-06-01', '0000-00-00', '84481', '', '97', '290', '', '26', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '733', '4', 'pending'), 
('2992', '2021-06-01', '0000-00-00', '84481', '', '98', '297', '', '26', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '733', '4', 'pending'), 
('2993', '2021-06-01', '0000-00-00', '84481', '', '42', '338', '', '26', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '733', '4', 'pending'), 
('2994', '2021-06-01', '0000-00-00', '84481', '', '117', '622', '', '26', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '733', '4', 'pending'), 
('2995', '2021-06-01', '0000-00-00', '84481', '', '123', '561', '', '26', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '733', '4', 'pending'), 
('2996', '2021-06-02', '0000-00-00', '42768', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '734', '8', 'pending'), 
('2998', '2021-06-02', '0000-00-00', '13034', '', '117', '451', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '736', '8', 'pending'), 
('2999', '2021-06-02', '0000-00-00', '90899', '', '45', '101', '', '95', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '737', '4', 'pending'), 
('3000', '2021-06-02', '0000-00-00', '90899', '', '112', '287', '', '95', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '737', '4', 'pending'), 
('3001', '2021-06-02', '0000-00-00', '90899', '', '97', '290', '', '95', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '737', '4', 'pending'), 
('3002', '2021-06-02', '0000-00-00', '90899', '', '98', '297', '', '95', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '737', '4', 'pending'), 
('3003', '2021-06-02', '0000-00-00', '90899', '', '103', '329', '', '95', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '737', '4', 'pending'), 
('3004', '2021-06-02', '0000-00-00', '90899', '', '117', '464', '', '95', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '737', '4', 'pending'), 
('3005', '2021-06-02', '0000-00-00', '90899', '', '117', '451', '', '95', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '737', '4', 'pending'), 
('3006', '2021-06-02', '0000-00-00', '18155', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '738', '4', 'pending'), 
('3007', '2021-06-02', '0000-00-00', '52356', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '739', '4', 'pending'), 
('3008', '2021-06-02', '0000-00-00', '52356', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '739', '4', 'pending'), 
('3009', '2021-06-02', '0000-00-00', '52356', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '739', '4', 'pending'), 
('3010', '2021-06-02', '0000-00-00', '52356', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '739', '4', 'pending'), 
('3011', '2021-06-02', '0000-00-00', '52356', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '739', '4', 'pending'), 
('3012', '2021-06-02', '0000-00-00', '70165', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '740', '4', 'pending'), 
('3013', '2021-06-02', '0000-00-00', '70165', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '740', '4', 'pending'), 
('3014', '2021-06-02', '0000-00-00', '70165', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '740', '4', 'pending'), 
('3015', '2021-06-02', '0000-00-00', '70165', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '740', '4', 'pending'), 
('3016', '2021-06-02', '0000-00-00', '70165', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '740', '4', 'pending'), 
('3018', '2021-06-02', '0000-00-00', '45508', '', '115', '446', '', '39', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '742', '4', 'pending'), 
('3019', '2021-06-02', '0000-00-00', '45508', '', '117', '476', '', '39', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '742', '4', 'pending'), 
('3020', '2021-06-02', '0000-00-00', '38490', '', '45', '101', '', '100', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '743', '4', 'pending'), 
('3021', '2021-06-02', '0000-00-00', '38490', '', '97', '290', '', '100', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '743', '4', 'pending'), 
('3022', '2021-06-02', '0000-00-00', '38490', '', '98', '297', '', '100', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '743', '4', 'pending'), 
('3023', '2021-06-02', '0000-00-00', '38490', '', '100', '583', '', '100', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '743', '4', 'pending'), 
('3024', '2021-06-02', '0000-00-00', '38490', '', '107', '366', '', '100', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '743', '4', 'pending'), 
('3025', '2021-06-02', '0000-00-00', '38490', '', '121', '532', '', '100', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '743', '4', 'pending'), 
('3026', '2021-06-02', '0000-00-00', '38490', '', '117', '451', '', '100', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '743', '4', 'pending'), 
('3027', '2021-06-02', '0000-00-00', '38490', '', '123', '561', '', '100', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '743', '4', 'pending'), 
('3028', '2021-06-02', '0000-00-00', '38490', '', '97', '294', '', '100', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '743', '4', 'pending'), 
('3029', '2021-06-02', '0000-00-00', '58273', '', '35', '73', '', '26', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '744', '4', 'pending'), 
('3030', '2021-06-02', '0000-00-00', '58273', '', '107', '366', '', '26', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '744', '4', 'pending'), 
('3031', '2021-06-02', '0000-00-00', '58273', '', '42', '338', '', '26', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '744', '4', 'pending'), 
('3032', '2021-06-02', '0000-00-00', '58273', '', '97', '290', '', '26', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '744', '4', 'pending'), 
('3033', '2021-06-02', '0000-00-00', '58273', '', '98', '297', '', '26', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '744', '4', 'pending'), 
('3034', '2021-06-02', '0000-00-00', '58273', '', '103', '329', '', '26', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '744', '4', 'pending'), 
('3035', '2021-06-02', '0000-00-00', '58273', '', '105', '616', '', '26', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '744', '4', 'pending'), 
('3036', '2021-06-02', '0000-00-00', '58273', '', '123', '519', '', '26', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '744', '4', 'pending'), 
('3048', '2021-06-02', '0000-00-00', '28417', '', '45', '101', '', '58', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '750', '4', 'pending'), 
('3049', '2021-06-02', '0000-00-00', '28417', '', '97', '290', '', '58', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '750', '4', 'pending'), 
('3050', '2021-06-02', '0000-00-00', '28417', '', '98', '297', '', '58', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '750', '4', 'pending'), 
('3051', '2021-06-02', '0000-00-00', '28417', '', '42', '338', '', '58', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '750', '4', 'pending'), 
('3052', '2021-06-02', '0000-00-00', '28417', '', '123', '561', '', '58', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '750', '4', 'pending'), 
('3053', '2021-06-02', '0000-00-00', '28417', '', '117', '593', '', '58', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '750', '4', 'pending'), 
('3054', '2021-06-02', '0000-00-00', '93540', '', '107', '374', '', '92', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '751', '4', 'pending'), 
('3055', '2021-06-02', '0000-00-00', '93540', '', '105', '617', '', '92', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '751', '4', 'pending'), 
('3056', '2021-06-02', '0000-00-00', '93540', '', '117', '463', '', '92', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '751', '4', 'pending'), 
('3057', '2021-06-02', '0000-00-00', '78396', '', '45', '101', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '752', '4', 'pending'), 
('3058', '2021-06-02', '0000-00-00', '78396', '', '96', '282', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '752', '4', 'pending'), 
('3059', '2021-06-02', '0000-00-00', '78396', '', '114', '611', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '752', '4', 'pending'), 
('3060', '2021-06-02', '0000-00-00', '78396', '', '123', '561', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '752', '4', 'pending'), 
('3061', '2021-06-02', '0000-00-00', '78396', '', '42', '338', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '752', '4', 'pending'), 
('3062', '2021-06-02', '0000-00-00', '47264', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '753', '4', 'pending'), 
('3063', '2021-06-02', '0000-00-00', '47264', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '753', '4', 'pending'), 
('3064', '2021-06-02', '0000-00-00', '47264', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '753', '4', 'pending'), 
('3065', '2021-06-02', '0000-00-00', '47264', '', '105', '617', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '753', '4', 'pending'), 
('3066', '2021-06-02', '0000-00-00', '47264', '', '123', '519', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '753', '4', 'pending'), 
('3067', '2021-06-02', '0000-00-00', '98311', '', '117', '451', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '754', '4', 'pending'), 
('3069', '2021-06-02', '0000-00-00', '87197', '', '118', '492', '', '91', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '756', '4', 'pending'), 
('3070', '2021-06-02', '0000-00-00', '87197', '', '118', '672', '', '91', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '756', '4', 'pending'), 
('3071', '2021-06-02', '0000-00-00', '56187', '', '35', '73', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '757', '4', 'pending'), 
('3072', '2021-06-02', '0000-00-00', '59067', '', '45', '101', '', '26', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '758', '4', 'pending'), 
('3073', '2021-06-02', '0000-00-00', '59067', '', '96', '642', '', '26', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '758', '4', 'pending'), 
('3074', '2021-06-02', '0000-00-00', '59067', '', '96', '282', '', '26', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '758', '4', 'pending'), 
('3075', '2021-06-02', '0000-00-00', '59067', '', '98', '297', '', '26', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '758', '4', 'pending'), 
('3076', '2021-06-02', '0000-00-00', '59067', '', '42', '338', '', '26', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '758', '4', 'pending'), 
('3077', '2021-06-02', '0000-00-00', '88754', '', '117', '451', '', '73', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '759', '4', 'pending'), 
('3078', '2021-06-02', '0000-00-00', '33925', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '760', '4', 'pending'), 
('3079', '2021-06-02', '0000-00-00', '33925', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '760', '4', 'pending'), 
('3080', '2021-06-02', '0000-00-00', '65044', '', '123', '561', '', '74', '41', '', '', '', '0', '0.00', '', '0.00', '0.00', '761', '4', 'pending'), 
('3081', '2021-06-02', '0000-00-00', '56648', '', '45', '101', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '762', '4', 'pending'), 
('3082', '2021-06-02', '0000-00-00', '56648', '', '97', '290', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '762', '4', 'pending'), 
('3083', '2021-06-02', '0000-00-00', '56648', '', '103', '329', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '762', '4', 'pending'), 
('3084', '2021-06-02', '0000-00-00', '56648', '', '105', '616', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '762', '4', 'pending'), 
('3085', '2021-06-02', '0000-00-00', '56648', '', '107', '366', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '762', '4', 'pending'), 
('3086', '2021-06-02', '0000-00-00', '56648', '', '42', '338', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '762', '4', 'pending'), 
('3087', '2021-06-02', '0000-00-00', '56648', '', '120', '531', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '762', '4', 'pending'), 
('3088', '2021-06-02', '0000-00-00', '54916', '', '97', '290', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '763', '4', 'pending'), 
('3089', '2021-06-02', '0000-00-00', '54916', '', '107', '366', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '763', '4', 'pending'), 
('3090', '2021-06-02', '0000-00-00', '54916', '', '117', '451', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '763', '4', 'pending'), 
('3091', '2021-06-02', '0000-00-00', '54916', '', '121', '532', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '763', '4', 'pending'), 
('3092', '2021-06-02', '0000-00-00', '54916', '', '123', '561', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '763', '4', 'pending'), 
('3093', '2021-06-02', '0000-00-00', '54916', '', '115', '673', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '763', '4', 'pending'), 
('3094', '2021-06-02', '0000-00-00', '54916', '', '115', '674', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '763', '4', 'pending'), 
('3095', '2021-06-02', '0000-00-00', '51699', '', '120', '531', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '764', '4', 'pending'), 
('3096', '2021-06-03', '0000-00-00', '26324', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '765', '8', 'pending'), 
('3097', '2021-06-03', '0000-00-00', '26324', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '765', '8', 'pending'), 
('3098', '2021-06-03', '0000-00-00', '26324', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '765', '8', 'pending'), 
('3099', '2021-06-03', '0000-00-00', '26324', '', '107', '370', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '765', '8', 'pending'), 
('3100', '2021-06-03', '0000-00-00', '26324', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '765', '8', 'pending'), 
('3101', '2021-06-03', '0000-00-00', '26324', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '765', '8', 'pending'), 
('3102', '2021-06-03', '0000-00-00', '26324', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '765', '8', 'pending'), 
('3103', '2021-06-03', '0000-00-00', '26324', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '765', '8', 'pending'), 
('3104', '2021-06-03', '0000-00-00', '26324', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '765', '8', 'pending'), 
('3115', '2021-06-03', '0000-00-00', '23175', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '767', '8', 'pending'), 
('3116', '2021-06-03', '0000-00-00', '23175', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '767', '8', 'pending'), 
('3117', '2021-06-03', '0000-00-00', '23175', '', '99', '304', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '767', '8', 'pending'), 
('3118', '2021-06-03', '0000-00-00', '23175', '', '99', '301', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '767', '8', 'pending'), 
('3119', '2021-06-03', '0000-00-00', '23175', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '767', '8', 'pending'), 
('3120', '2021-06-03', '0000-00-00', '23175', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '767', '8', 'pending'), 
('3121', '2021-06-03', '0000-00-00', '23175', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '767', '8', 'pending'), 
('3122', '2021-06-03', '0000-00-00', '23175', '', '121', '533', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '767', '8', 'pending'), 
('3123', '2021-06-03', '0000-00-00', '23175', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '767', '8', 'pending'), 
('3124', '2021-06-03', '0000-00-00', '23175', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '767', '8', 'pending'), 
('3125', '2021-06-03', '0000-00-00', '23175', '', '109', '410', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '767', '8', 'pending'), 
('3126', '2021-06-03', '0000-00-00', '99387', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '768', '8', 'pending'), 
('3127', '2021-06-03', '0000-00-00', '99387', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '768', '8', 'pending'), 
('3128', '2021-06-03', '0000-00-00', '99387', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '768', '8', 'pending'), 
('3129', '2021-06-03', '0000-00-00', '99387', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '768', '8', 'pending'), 
('3130', '2021-06-03', '0000-00-00', '99387', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '768', '8', 'pending'), 
('3131', '2021-06-03', '0000-00-00', '99387', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '768', '8', 'pending'), 
('3132', '2021-06-03', '0000-00-00', '99387', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '768', '8', 'pending'), 
('3133', '2021-06-03', '0000-00-00', '90256', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '769', '8', 'pending'), 
('3134', '2021-06-03', '0000-00-00', '75349', '', '99', '304', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '770', '8', 'pending'), 
('3135', '2021-06-03', '0000-00-00', '75349', '', '99', '301', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '770', '8', 'pending'), 
('3136', '2021-06-03', '0000-00-00', '75349', '', '107', '378', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '770', '8', 'pending'), 
('3137', '2021-06-03', '0000-00-00', '75349', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '770', '8', 'pending'), 
('3138', '2021-06-03', '0000-00-00', '75349', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '770', '8', 'pending'), 
('3139', '2021-06-03', '0000-00-00', '19521', '', '35', '73', '', '94', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '771', '8', 'pending'), 
('3140', '2021-06-03', '0000-00-00', '19521', '', '97', '290', '', '94', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '771', '8', 'pending'), 
('3141', '2021-06-03', '0000-00-00', '19521', '', '98', '297', '', '94', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '771', '8', 'pending'), 
('3142', '2021-06-03', '0000-00-00', '19521', '', '98', '299', '', '94', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '771', '8', 'pending'), 
('3143', '2021-06-03', '0000-00-00', '19521', '', '42', '338', '', '94', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '771', '8', 'pending'), 
('3144', '2021-06-03', '0000-00-00', '19521', '', '120', '531', '', '94', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '771', '8', 'pending'), 
('3145', '2021-06-03', '0000-00-00', '37683', '', '98', '297', '', '103', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '772', '8', 'pending'), 
('3146', '2021-06-03', '0000-00-00', '37683', '', '42', '338', '', '103', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '772', '8', 'pending'), 
('3147', '2021-06-03', '0000-00-00', '37683', '', '107', '366', '', '103', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '772', '8', 'pending'), 
('3148', '2021-06-03', '0000-00-00', '37683', '', '120', '531', '', '103', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '772', '8', 'pending'), 
('3149', '2021-06-03', '0000-00-00', '37683', '', '45', '101', '', '103', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '772', '8', 'pending'), 
('3150', '2021-06-03', '0000-00-00', '13023', '', '42', '338', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '773', '8', 'pending'), 
('3151', '2021-06-03', '0000-00-00', '13023', '', '117', '622', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '773', '8', 'pending'), 
('3152', '2021-06-03', '0000-00-00', '13023', '', '123', '561', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '773', '8', 'pending'), 
('3153', '2021-06-03', '0000-00-00', '13023', '', '45', '101', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '773', '8', 'pending'), 
('3154', '2021-06-03', '0000-00-00', '13023', '', '42', '346', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '773', '8', 'pending'), 
('3155', '2021-06-03', '0000-00-00', '65997', '', '35', '73', '', '104', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '774', '8', 'pending'), 
('3156', '2021-06-03', '0000-00-00', '65997', '', '97', '290', '', '104', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '774', '8', 'pending'), 
('3157', '2021-06-03', '0000-00-00', '65997', '', '99', '301', '', '104', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '774', '8', 'pending'), 
('3158', '2021-06-03', '0000-00-00', '65997', '', '42', '338', '', '104', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '774', '8', 'pending'), 
('3159', '2021-06-03', '0000-00-00', '65997', '', '105', '353', '', '104', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '774', '8', 'pending'), 
('3160', '2021-06-03', '0000-00-00', '65997', '', '122', '513', '', '104', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '774', '8', 'pending'), 
('3161', '2021-06-03', '0000-00-00', '65997', '', '107', '366', '', '104', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '774', '8', 'pending'), 
('3162', '2021-06-03', '0000-00-00', '73088', '', '45', '101', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '775', '8', 'pending'), 
('3163', '2021-06-03', '0000-00-00', '73088', '', '96', '642', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '775', '8', 'pending'), 
('3164', '2021-06-03', '0000-00-00', '73088', '', '97', '290', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '775', '8', 'pending'), 
('3165', '2021-06-03', '0000-00-00', '73088', '', '99', '301', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '775', '8', 'pending'), 
('3166', '2021-06-03', '0000-00-00', '73088', '', '98', '297', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '775', '8', 'pending'), 
('3167', '2021-06-03', '0000-00-00', '73088', '', '42', '338', '', '66', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '775', '8', 'pending'), 
('3168', '2021-06-03', '0000-00-00', '68727', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '776', '8', 'pending'), 
('3169', '2021-06-03', '0000-00-00', '68727', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '776', '8', 'pending'), 
('3170', '2021-06-03', '0000-00-00', '52455', '', '121', '532', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '777', '8', 'pending'), 
('3171', '2021-06-03', '0000-00-00', '49229', '', '97', '290', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '778', '8', 'pending'), 
('3172', '2021-06-03', '0000-00-00', '49229', '', '98', '297', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '778', '8', 'pending'), 
('3173', '2021-06-03', '0000-00-00', '49229', '', '45', '101', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '778', '8', 'pending'), 
('3174', '2021-06-03', '0000-00-00', '49229', '', '42', '338', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '778', '8', 'pending'), 
('3175', '2021-06-03', '0000-00-00', '49229', '', '107', '374', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '778', '8', 'pending'), 
('3176', '2021-06-03', '0000-00-00', '49229', '', '117', '593', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '778', '8', 'pending'), 
('3177', '2021-06-03', '0000-00-00', '49229', '', '117', '461', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '778', '8', 'pending'), 
('3178', '2021-06-03', '0000-00-00', '49229', '', '117', '644', '', '39', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '778', '8', 'pending'), 
('3179', '2021-06-03', '0000-00-00', '94790', '', '45', '101', '', '39', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '779', '8', 'pending'), 
('3180', '2021-06-03', '0000-00-00', '94790', '', '99', '301', '', '39', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '779', '8', 'pending'), 
('3181', '2021-06-03', '0000-00-00', '94790', '', '98', '297', '', '39', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '779', '8', 'pending'), 
('3182', '2021-06-03', '0000-00-00', '94790', '', '42', '338', '', '39', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '779', '8', 'pending'), 
('3183', '2021-06-03', '0000-00-00', '85269', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '780', '8', 'pending'), 
('3184', '2021-06-03', '0000-00-00', '85269', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '780', '8', 'pending'), 
('3185', '2021-06-03', '0000-00-00', '85269', '', '98', '297', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '780', '8', 'pending'), 
('3186', '2021-06-03', '0000-00-00', '85269', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '780', '8', 'pending'), 
('3187', '2021-06-03', '0000-00-00', '85269', '', '107', '370', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '780', '8', 'pending'), 
('3188', '2021-06-03', '0000-00-00', '85269', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '780', '8', 'pending'), 
('3189', '2021-06-03', '0000-00-00', '35617', '', '117', '451', '', '73', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '781', '4', 'pending'), 
('3190', '2021-06-03', '0000-00-00', '90550', '', '117', '451', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '782', '4', 'pending'), 
('3191', '2021-06-03', '0000-00-00', '22143', '', '117', '622', '', '91', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '783', '4', 'pending'), 
('3192', '2021-06-03', '0000-00-00', '67163', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '784', '4', 'pending'), 
('3193', '2021-06-03', '0000-00-00', '67163', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '784', '4', 'pending'), 
('3194', '2021-06-03', '0000-00-00', '67163', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '784', '4', 'pending'), 
('3195', '2021-06-03', '0000-00-00', '67163', '', '117', '622', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '784', '4', 'pending'), 
('3196', '2021-06-03', '0000-00-00', '56943', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '785', '4', 'pending'), 
('3197', '2021-06-03', '0000-00-00', '56943', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '785', '4', 'pending'), 
('3198', '2021-06-03', '0000-00-00', '56943', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '785', '4', 'pending'), 
('3199', '2021-06-03', '0000-00-00', '56943', '', '123', '561', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '785', '4', 'pending'), 
('3200', '2021-06-03', '0000-00-00', '56943', '', '117', '451', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '785', '4', 'pending'), 
('3201', '2021-06-03', '0000-00-00', '56943', '', '121', '532', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '785', '4', 'pending'), 
('3202', '2021-06-03', '0000-00-00', '36072', '', '35', '73', '', '105', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '786', '4', 'pending'), 
('3203', '2021-06-03', '0000-00-00', '36072', '', '97', '290', '', '105', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '786', '4', 'pending'), 
('3204', '2021-06-03', '0000-00-00', '36072', '', '98', '297', '', '105', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '786', '4', 'pending'), 
('3205', '2021-06-03', '0000-00-00', '36072', '', '99', '301', '', '105', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '786', '4', 'pending'), 
('3206', '2021-06-03', '0000-00-00', '36072', '', '42', '338', '', '105', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '786', '4', 'pending'), 
('3207', '2021-06-03', '0000-00-00', '36072', '', '105', '616', '', '105', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '786', '4', 'pending'), 
('3208', '2021-06-03', '0000-00-00', '36072', '', '107', '366', '', '105', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '786', '4', 'pending'), 
('3209', '2021-06-03', '0000-00-00', '36072', '', '123', '561', '', '105', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '786', '4', 'pending'), 
('3210', '2021-06-03', '0000-00-00', '22176', '', '45', '101', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '787', '4', 'pending'), 
('3211', '2021-06-03', '0000-00-00', '22176', '', '97', '290', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '787', '4', 'pending'), 
('3212', '2021-06-03', '0000-00-00', '22176', '', '107', '366', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '787', '4', 'pending'), 
('3213', '2021-06-03', '0000-00-00', '22176', '', '98', '297', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '787', '4', 'pending'), 
('3214', '2021-06-03', '0000-00-00', '22176', '', '112', '287', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '787', '4', 'pending'), 
('3215', '2021-06-03', '0000-00-00', '22176', '', '103', '329', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '787', '4', 'pending'), 
('3216', '2021-06-03', '0000-00-00', '22176', '', '120', '634', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '787', '4', 'pending'), 
('3217', '2021-06-03', '0000-00-00', '22176', '', '121', '532', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '787', '4', 'pending'), 
('3223', '2021-06-03', '0000-00-00', '94709', '', '45', '101', '', '90', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '789', '4', 'pending'), 
('3224', '2021-06-03', '0000-00-00', '94709', '', '97', '290', '', '90', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '789', '4', 'pending'), 
('3225', '2021-06-03', '0000-00-00', '94709', '', '98', '297', '', '90', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '789', '4', 'pending'), 
('3226', '2021-06-03', '0000-00-00', '94709', '', '99', '301', '', '90', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '789', '4', 'pending'), 
('3227', '2021-06-03', '0000-00-00', '94709', '', '42', '338', '', '90', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '789', '4', 'pending'), 
('3228', '2021-06-03', '0000-00-00', '34738', '', '45', '101', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '790', '4', 'pending'), 
('3229', '2021-06-03', '0000-00-00', '34738', '', '97', '290', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '790', '4', 'pending'), 
('3230', '2021-06-03', '0000-00-00', '34738', '', '98', '297', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '790', '4', 'pending'), 
('3231', '2021-06-03', '0000-00-00', '34738', '', '99', '301', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '790', '4', 'pending'), 
('3232', '2021-06-03', '0000-00-00', '34738', '', '103', '333', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '790', '4', 'pending'), 
('3233', '2021-06-03', '0000-00-00', '25586', '', '115', '674', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '791', '4', 'pending'), 
('3234', '2021-06-03', '0000-00-00', '25586', '', '117', '476', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '791', '4', 'pending'), 
('3235', '2021-06-04', '0000-00-00', '80515', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '792', '4', 'pending'), 
('3236', '2021-06-04', '0000-00-00', '80515', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '792', '4', 'pending'), 
('3237', '2021-06-04', '0000-00-00', '21028', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '793', '4', 'pending'), 
('3238', '2021-06-04', '0000-00-00', '57206', '', '35', '73', '', '24', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '794', '4', 'pending'), 
('3239', '2021-06-04', '0000-00-00', '57206', '', '97', '290', '', '24', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '794', '4', 'pending'), 
('3240', '2021-06-04', '0000-00-00', '57206', '', '103', '329', '', '24', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '794', '4', 'pending'), 
('3241', '2021-06-04', '0000-00-00', '57206', '', '107', '366', '', '24', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '794', '4', 'pending'), 
('3242', '2021-06-04', '0000-00-00', '66472', '', '107', '377', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '795', '4', 'pending'), 
('3243', '2021-06-04', '0000-00-00', '66472', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '795', '4', 'pending'), 
('3244', '2021-06-04', '0000-00-00', '66532', '', '35', '73', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '796', '4', 'pending'), 
('3245', '2021-06-04', '0000-00-00', '66532', '', '97', '290', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '796', '4', 'pending'), 
('3246', '2021-06-04', '0000-00-00', '66532', '', '98', '297', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '796', '4', 'pending'), 
('3247', '2021-06-04', '0000-00-00', '66532', '', '103', '329', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '796', '4', 'pending'), 
('3248', '2021-06-04', '0000-00-00', '66532', '', '107', '366', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '796', '4', 'pending'), 
('3249', '2021-06-04', '0000-00-00', '66532', '', '120', '634', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '796', '4', 'pending'), 
('3250', '2021-06-04', '0000-00-00', '37885', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '797', '4', 'pending'), 
('3251', '2021-06-04', '0000-00-00', '37885', '', '96', '642', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '797', '4', 'pending'), 
('3252', '2021-06-04', '0000-00-00', '37885', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '797', '4', 'pending'), 
('3253', '2021-06-04', '0000-00-00', '37885', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '797', '4', 'pending'), 
('3254', '2021-06-04', '0000-00-00', '37885', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '797', '4', 'pending'), 
('3255', '2021-06-04', '0000-00-00', '37885', '', '117', '472', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '797', '4', 'pending'), 
('3256', '2021-06-04', '0000-00-00', '54902', '', '117', '451', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '798', '4', 'pending'), 
('3257', '2021-06-04', '0000-00-00', '98846', '', '117', '452', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '799', '4', 'pending'), 
('3258', '2021-06-05', '0000-00-00', '77521', '', '117', '451', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '800', '4', 'pending'), 
('3259', '2021-06-05', '0000-00-00', '81592', '', '103', '329', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '801', '4', 'pending'), 
('3260', '2021-06-05', '0000-00-00', '81592', '', '107', '366', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '801', '4', 'pending'), 
('3261', '2021-06-05', '0000-00-00', '81592', '', '120', '634', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '801', '4', 'pending'), 
('3262', '2021-06-05', '0000-00-00', '49121', '', '117', '451', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '802', '4', 'pending'), 
('3263', '2021-06-05', '0000-00-00', '96799', '', '45', '101', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '803', '4', 'pending'), 
('3264', '2021-06-05', '0000-00-00', '96799', '', '107', '377', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '803', '4', 'pending'), 
('3265', '2021-06-05', '0000-00-00', '96799', '', '42', '338', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '803', '4', 'pending'), 
('3266', '2021-06-05', '0000-00-00', '96799', '', '123', '561', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '803', '4', 'pending'), 
('3267', '2021-06-05', '0000-00-00', '35146', '', '35', '73', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '804', '4', 'pending'), 
('3268', '2021-06-05', '0000-00-00', '35146', '', '120', '634', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '804', '4', 'pending'), 
('3269', '2021-06-05', '0000-00-00', '45438', '', '35', '73', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '805', '4', 'pending'), 
('3270', '2021-06-05', '0000-00-00', '45438', '', '97', '290', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '805', '4', 'pending'), 
('3271', '2021-06-05', '0000-00-00', '45438', '', '98', '297', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '805', '4', 'pending'), 
('3272', '2021-06-05', '0000-00-00', '45438', '', '103', '329', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '805', '4', 'pending'), 
('3273', '2021-06-05', '0000-00-00', '45438', '', '107', '366', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '805', '4', 'pending'), 
('3274', '2021-06-05', '0000-00-00', '45438', '', '121', '532', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '805', '4', 'pending'), 
('3275', '2021-06-05', '0000-00-00', '45438', '', '117', '451', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '805', '4', 'pending'), 
('3276', '2021-06-05', '0000-00-00', '45438', '', '123', '561', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '805', '4', 'pending'), 
('3277', '2021-06-05', '0000-00-00', '50651', '', '35', '73', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '806', '4', 'pending'), 
('3278', '2021-06-05', '0000-00-00', '50651', '', '103', '329', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '806', '4', 'pending'), 
('3279', '2021-06-05', '0000-00-00', '50651', '', '107', '366', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '806', '4', 'pending'), 
('3280', '2021-06-05', '0000-00-00', '50651', '', '123', '519', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '806', '4', 'pending'), 
('3281', '2021-06-05', '0000-00-00', '15825', '', '117', '595', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '807', '4', 'pending'), 
('3282', '2021-06-05', '0000-00-00', '64787', '', '45', '101', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '808', '4', 'pending'), 
('3283', '2021-06-05', '0000-00-00', '64787', '', '97', '290', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '808', '4', 'pending'), 
('3284', '2021-06-05', '0000-00-00', '64787', '', '107', '366', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '808', '4', 'pending'), 
('3285', '2021-06-05', '0000-00-00', '64787', '', '117', '622', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '808', '4', 'pending'), 
('3286', '2021-06-05', '0000-00-00', '64787', '', '123', '561', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '808', '4', 'pending'), 
('3287', '2021-06-05', '0000-00-00', '69001', '', '45', '101', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '809', '4', 'pending'), 
('3288', '2021-06-05', '0000-00-00', '69001', '', '97', '290', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '809', '4', 'pending'), 
('3289', '2021-06-05', '0000-00-00', '69001', '', '98', '297', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '809', '4', 'pending'), 
('3290', '2021-06-05', '0000-00-00', '69001', '', '103', '329', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '809', '4', 'pending'), 
('3291', '2021-06-05', '0000-00-00', '69001', '', '107', '366', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '809', '4', 'pending'), 
('3292', '2021-06-05', '0000-00-00', '69001', '', '42', '338', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '809', '4', 'pending'), 
('3293', '2021-06-05', '0000-00-00', '69001', '', '117', '451', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '809', '4', 'pending'), 
('3294', '2021-06-05', '0000-00-00', '69001', '', '123', '561', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '809', '4', 'pending'), 
('3295', '2021-06-05', '0000-00-00', '69001', '', '122', '584', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '809', '4', 'pending'), 
('3296', '2021-06-05', '0000-00-00', '54965', '', '117', '456', '', '59', '11', '', '', '', '0', '0.00', '', '0.00', '0.00', '810', '4', 'pending'), 
('3303', '2021-06-05', '0000-00-00', '72287', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '813', '4', 'pending'), 
('3304', '2021-06-05', '0000-00-00', '72287', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '813', '4', 'pending'), 
('3305', '2021-06-05', '0000-00-00', '72287', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '813', '4', 'pending'), 
('3306', '2021-06-05', '0000-00-00', '72287', '', '98', '297', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '813', '4', 'pending'), 
('3307', '2021-06-05', '0000-00-00', '72287', '', '105', '357', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '813', '4', 'pending'), 
('3308', '2021-06-05', '0000-00-00', '72287', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '813', '4', 'pending'), 
('3309', '2021-06-05', '0000-00-00', '72287', '', '110', '633', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '813', '4', 'pending'), 
('3310', '2021-06-05', '0000-00-00', '59416', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '814', '4', 'pending'), 
('3311', '2021-06-05', '0000-00-00', '59416', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '814', '4', 'pending'), 
('3312', '2021-06-05', '0000-00-00', '59416', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '814', '4', 'pending'), 
('3313', '2021-06-05', '0000-00-00', '59416', '', '98', '297', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '814', '4', 'pending'), 
('3314', '2021-06-05', '0000-00-00', '59416', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '814', '4', 'pending'), 
('3315', '2021-06-05', '0000-00-00', '77462', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '815', '4', 'pending'), 
('3316', '2021-06-05', '0000-00-00', '77462', '', '96', '642', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '815', '4', 'pending'), 
('3317', '2021-06-05', '0000-00-00', '77462', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '815', '4', 'pending'), 
('3318', '2021-06-05', '0000-00-00', '77462', '', '108', '408', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '815', '4', 'pending'), 
('3319', '2021-06-05', '0000-00-00', '77462', '', '105', '617', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '815', '4', 'pending'), 
('3320', '2021-06-05', '0000-00-00', '77462', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '815', '4', 'pending'), 
('3321', '2021-06-05', '0000-00-00', '14454', '', '45', '101', '', '28', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '816', '4', 'pending'), 
('3322', '2021-06-05', '0000-00-00', '14454', '', '97', '290', '', '28', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '816', '4', 'pending'), 
('3323', '2021-06-05', '0000-00-00', '14454', '', '98', '297', '', '28', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '816', '4', 'pending'), 
('3324', '2021-06-05', '0000-00-00', '14454', '', '42', '338', '', '28', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '816', '4', 'pending'), 
('3325', '2021-06-05', '0000-00-00', '14454', '', '121', '532', '', '28', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '816', '4', 'pending'), 
('3326', '2021-06-05', '0000-00-00', '14454', '', '117', '463', '', '28', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '816', '4', 'pending'), 
('3327', '2021-06-05', '0000-00-00', '14454', '', '118', '655', '', '28', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '816', '4', 'pending'), 
('3328', '2021-06-05', '0000-00-00', '59166', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '817', '4', 'pending'), 
('3329', '2021-06-05', '0000-00-00', '59166', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '817', '4', 'pending'), 
('3330', '2021-06-05', '0000-00-00', '59166', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '817', '4', 'pending'), 
('3331', '2021-06-05', '0000-00-00', '59166', '', '104', '309', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '817', '4', 'pending'), 
('3332', '2021-06-05', '0000-00-00', '59166', '', '117', '593', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '817', '4', 'pending'), 
('3333', '2021-06-05', '0000-00-00', '88180', '', '117', '630', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '818', '4', 'pending'), 
('3342', '2021-06-05', '0000-00-00', '85528', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '820', '4', 'pending'), 
('3343', '2021-06-05', '0000-00-00', '21243', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '821', '4', 'pending'), 
('3344', '2021-06-05', '0000-00-00', '21243', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '821', '4', 'pending'), 
('3345', '2021-06-05', '0000-00-00', '21243', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '821', '4', 'pending'), 
('3346', '2021-06-05', '0000-00-00', '21243', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '821', '4', 'pending'), 
('3347', '2021-06-05', '0000-00-00', '21243', '', '99', '301', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '821', '4', 'pending'), 
('3348', '2021-06-05', '0000-00-00', '21243', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '821', '4', 'pending'), 
('3349', '2021-06-05', '0000-00-00', '21243', '', '117', '622', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '821', '4', 'pending'), 
('3350', '2021-06-05', '0000-00-00', '21243', '', '123', '561', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '821', '4', 'pending'), 
('3351', '2021-06-05', '0000-00-00', '99093', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '822', '4', 'pending'), 
('3352', '2021-06-05', '0000-00-00', '99093', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '822', '4', 'pending'), 
('3353', '2021-06-05', '0000-00-00', '99093', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '822', '4', 'pending'), 
('3354', '2021-06-05', '0000-00-00', '99093', '', '100', '583', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '822', '4', 'pending'), 
('3355', '2021-06-05', '0000-00-00', '99093', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '822', '4', 'pending'), 
('3356', '2021-06-05', '0000-00-00', '99093', '', '117', '451', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '822', '4', 'pending'), 
('3357', '2021-06-05', '0000-00-00', '99093', '', '121', '532', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '822', '4', 'pending'), 
('3358', '2021-06-05', '0000-00-00', '93164', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '823', '4', 'pending'), 
('3359', '2021-06-05', '0000-00-00', '93164', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '823', '4', 'pending'), 
('3360', '2021-06-05', '0000-00-00', '93164', '', '107', '372', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '823', '4', 'pending'), 
('3361', '2021-06-05', '0000-00-00', '93164', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '823', '4', 'pending'), 
('3362', '2021-06-05', '0000-00-00', '93164', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '823', '4', 'pending'), 
('3363', '2021-06-05', '0000-00-00', '93164', '', '112', '287', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '823', '4', 'pending'), 
('3364', '2021-06-05', '0000-00-00', '93164', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '823', '4', 'pending'), 
('3365', '2021-06-05', '0000-00-00', '93164', '', '117', '464', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '823', '4', 'pending'), 
('3366', '2021-06-05', '0000-00-00', '37539', '', '45', '101', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '824', '4', 'pending'), 
('3367', '2021-06-05', '0000-00-00', '37539', '', '97', '290', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '824', '4', 'pending'), 
('3368', '2021-06-05', '0000-00-00', '37539', '', '98', '297', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '824', '4', 'pending'), 
('3369', '2021-06-05', '0000-00-00', '37539', '', '103', '329', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '824', '4', 'pending'), 
('3370', '2021-06-05', '0000-00-00', '37539', '', '107', '366', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '824', '4', 'pending'), 
('3371', '2021-06-05', '0000-00-00', '37539', '', '117', '451', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '824', '4', 'pending'), 
('3372', '2021-06-05', '0000-00-00', '37539', '', '121', '532', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '824', '4', 'pending'), 
('3373', '2021-06-05', '0000-00-00', '47411', '', '45', '101', '', '6', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '825', '4', 'pending'), 
('3374', '2021-06-05', '0000-00-00', '47411', '', '42', '338', '', '6', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '825', '4', 'pending'), 
('3375', '2021-06-05', '0000-00-00', '47411', '', '99', '301', '', '6', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '825', '4', 'pending'), 
('3376', '2021-06-05', '0000-00-00', '47411', '', '123', '561', '', '6', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '825', '4', 'pending'), 
('3377', '2021-06-05', '0000-00-00', '39852', '', '45', '101', '', '18', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '826', '4', 'pending'), 
('3378', '2021-06-05', '0000-00-00', '39852', '', '97', '290', '', '18', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '826', '4', 'pending'), 
('3379', '2021-06-05', '0000-00-00', '39852', '', '98', '297', '', '18', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '826', '4', 'pending'), 
('3380', '2021-06-05', '0000-00-00', '39852', '', '42', '338', '', '18', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '826', '4', 'pending'), 
('3381', '2021-06-05', '0000-00-00', '39852', '', '117', '451', '', '18', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '826', '4', 'pending'), 
('3382', '2021-06-05', '0000-00-00', '39852', '', '121', '532', '', '18', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '826', '4', 'pending'), 
('3383', '2021-06-05', '0000-00-00', '17246', '', '117', '621', '', '91', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '827', '4', 'pending'), 
('3384', '2021-06-05', '0000-00-00', '62843', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '828', '4', 'pending'), 
('3385', '2021-06-05', '0000-00-00', '62843', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '828', '4', 'pending'), 
('3386', '2021-06-05', '0000-00-00', '62843', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '828', '4', 'pending'), 
('3387', '2021-06-05', '0000-00-00', '32040', '', '123', '519', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '829', '4', 'pending'), 
('3388', '2021-06-05', '0000-00-00', '57819', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '830', '4', 'pending'), 
('3389', '2021-06-05', '0000-00-00', '57819', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '830', '4', 'pending'), 
('3390', '2021-06-05', '0000-00-00', '57819', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '830', '4', 'pending'), 
('3391', '2021-06-05', '0000-00-00', '57819', '', '96', '642', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '830', '4', 'pending'), 
('3392', '2021-06-05', '0000-00-00', '76806', '', '117', '622', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '831', '4', 'pending'), 
('3400', '2021-06-05', '0000-00-00', '83367', '', '45', '101', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '833', '4', 'pending'), 
('3401', '2021-06-05', '0000-00-00', '83367', '', '97', '290', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '833', '4', 'pending'), 
('3402', '2021-06-05', '0000-00-00', '83367', '', '98', '297', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '833', '4', 'pending'), 
('3403', '2021-06-05', '0000-00-00', '83367', '', '107', '366', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '833', '4', 'pending'), 
('3404', '2021-06-05', '0000-00-00', '83367', '', '121', '532', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '833', '4', 'pending'), 
('3405', '2021-06-05', '0000-00-00', '83367', '', '121', '533', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '833', '4', 'pending'), 
('3406', '2021-06-05', '0000-00-00', '83367', '', '123', '467', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '833', '4', 'pending'), 
('3407', '2021-06-05', '0000-00-00', '21427', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '834', '4', 'pending'), 
('3408', '2021-06-05', '0000-00-00', '21427', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '834', '4', 'pending'), 
('3409', '2021-06-05', '0000-00-00', '21427', '', '118', '493', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '834', '4', 'pending'), 
('3410', '2021-06-05', '0000-00-00', '21427', '', '121', '532', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '834', '4', 'pending'), 
('3411', '2021-06-05', '0000-00-00', '91238', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '835', '4', 'pending'), 
('3412', '2021-06-05', '0000-00-00', '91238', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '835', '4', 'pending'), 
('3413', '2021-06-05', '0000-00-00', '91238', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '835', '4', 'pending'), 
('3414', '2021-06-05', '0000-00-00', '91238', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '835', '4', 'pending'), 
('3415', '2021-06-05', '0000-00-00', '91238', '', '117', '451', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '835', '4', 'pending'), 
('3416', '2021-06-05', '0000-00-00', '91238', '', '123', '561', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '835', '4', 'pending'), 
('3417', '2021-06-05', '0000-00-00', '91238', '', '121', '532', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '835', '4', 'pending'), 
('3418', '2021-06-05', '0000-00-00', '49879', '', '123', '519', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '836', '4', 'pending'), 
('3419', '2021-06-05', '0000-00-00', '49879', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '836', '4', 'pending'), 
('3420', '2021-06-05', '0000-00-00', '49879', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '836', '4', 'pending'), 
('3421', '2021-06-05', '0000-00-00', '49879', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '836', '4', 'pending'), 
('3422', '2021-06-05', '0000-00-00', '49879', '', '105', '616', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '836', '4', 'pending'), 
('3423', '2021-06-05', '0000-00-00', '49879', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '836', '4', 'pending'), 
('3424', '2021-06-05', '0000-00-00', '49879', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '836', '4', 'pending'), 
('3425', '2021-06-05', '0000-00-00', '81994', '', '121', '533', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '837', '4', 'pending'), 
('3426', '2021-06-05', '0000-00-00', '54610', '', '123', '524', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '838', '4', 'pending'), 
('3427', '2021-06-05', '0000-00-00', '46921', '', '35', '73', '', '98', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '839', '4', 'pending'), 
('3428', '2021-06-05', '0000-00-00', '46921', '', '97', '290', '', '98', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '839', '4', 'pending'), 
('3429', '2021-06-05', '0000-00-00', '46921', '', '103', '329', '', '98', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '839', '4', 'pending'), 
('3430', '2021-06-05', '0000-00-00', '46921', '', '42', '338', '', '98', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '839', '4', 'pending'), 
('3431', '2021-06-05', '0000-00-00', '46921', '', '105', '616', '', '98', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '839', '4', 'pending'), 
('3432', '2021-06-05', '0000-00-00', '46921', '', '123', '519', '', '98', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '839', '4', 'pending'), 
('3433', '2021-06-05', '0000-00-00', '46921', '', '107', '366', '', '98', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '839', '4', 'pending'), 
('3434', '2021-06-05', '0000-00-00', '24053', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '840', '4', 'pending'), 
('3435', '2021-06-05', '0000-00-00', '62699', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '841', '4', 'pending'), 
('3436', '2021-06-05', '0000-00-00', '95631', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '842', '4', 'pending'), 
('3437', '2021-06-06', '0000-00-00', '92336', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '844', '8', 'pending'), 
('3438', '2021-06-06', '0000-00-00', '24394', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '845', '8', 'pending'), 
('3439', '2021-06-06', '0000-00-00', '24394', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '845', '8', 'pending'), 
('3440', '2021-06-06', '0000-00-00', '24394', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '845', '8', 'pending'), 
('3441', '2021-06-06', '0000-00-00', '24394', '', '120', '634', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '845', '8', 'pending'), 
('3442', '2021-06-06', '0000-00-00', '51519', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '846', '8', 'pending'), 
('3443', '2021-06-06', '0000-00-00', '77384', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '847', '8', 'pending'), 
('3446', '2021-06-06', '0000-00-00', '60854', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '849', '8', 'pending'), 
('3447', '2021-06-06', '0000-00-00', '60854', '', '99', '598', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '849', '8', 'pending'), 
('3448', '2021-06-06', '0000-00-00', '64368', '', '117', '622', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '850', '8', 'pending'), 
('3449', '2021-06-06', '0000-00-00', '61838', '', '97', '290', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '851', '4', 'pending'), 
('3450', '2021-06-06', '0000-00-00', '61838', '', '103', '329', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '851', '4', 'pending'), 
('3451', '2021-06-06', '0000-00-00', '61838', '', '123', '519', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '851', '4', 'pending'), 
('3452', '2021-06-06', '0000-00-00', '68914', '', '45', '101', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '852', '4', 'pending'), 
('3453', '2021-06-06', '0000-00-00', '68914', '', '96', '282', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '852', '4', 'pending'), 
('3454', '2021-06-06', '0000-00-00', '68914', '', '42', '338', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '852', '4', 'pending'), 
('3455', '2021-06-06', '0000-00-00', '68914', '', '107', '374', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '852', '4', 'pending'), 
('3456', '2021-06-06', '0000-00-00', '68914', '', '123', '561', '', '6', '23', '', '', '', '0', '0.00', '', '0.00', '0.00', '852', '4', 'pending'), 
('3457', '2021-06-06', '0000-00-00', '19080', '', '123', '561', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '853', '4', 'pending'), 
('3458', '2021-06-06', '0000-00-00', '49662', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '854', '4', 'pending'), 
('3459', '2021-06-06', '0000-00-00', '49662', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '854', '4', 'pending'), 
('3460', '2021-06-06', '0000-00-00', '49662', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '854', '4', 'pending'), 
('3461', '2021-06-06', '0000-00-00', '49662', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '854', '4', 'pending'), 
('3463', '2021-06-06', '0000-00-00', '81508', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '856', '4', 'pending'), 
('3464', '2021-06-06', '0000-00-00', '81508', '', '117', '593', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '856', '4', 'pending'), 
('3465', '2021-06-06', '0000-00-00', '53875', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '857', '4', 'pending'), 
('3466', '2021-06-06', '0000-00-00', '38809', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '858', '4', 'pending'), 
('3467', '2021-06-06', '0000-00-00', '90467', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '859', '4', 'pending'), 
('3468', '2021-06-06', '0000-00-00', '90467', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '859', '4', 'pending'), 
('3469', '2021-06-06', '0000-00-00', '90467', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '859', '4', 'pending'), 
('3470', '2021-06-06', '0000-00-00', '61094', '', '117', '451', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '860', '4', 'pending'), 
('3471', '2021-06-06', '0000-00-00', '61094', '', '117', '478', '', '6', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '860', '4', 'pending'), 
('3472', '2021-06-06', '0000-00-00', '99482', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '861', '4', 'pending'), 
('3473', '2021-06-06', '0000-00-00', '99482', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '861', '4', 'pending'), 
('3474', '2021-06-06', '0000-00-00', '99482', '', '99', '301', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '861', '4', 'pending'), 
('3475', '2021-06-06', '0000-00-00', '99482', '', '121', '532', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '861', '4', 'pending'), 
('3476', '2021-06-06', '0000-00-00', '13924', '', '117', '657', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '862', '4', 'pending'), 
('3477', '2021-06-06', '0000-00-00', '13924', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '862', '4', 'pending'), 
('3478', '2021-06-06', '0000-00-00', '61418', '', '97', '290', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '863', '4', 'pending'), 
('3479', '2021-06-06', '0000-00-00', '61418', '', '103', '329', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '863', '4', 'pending'), 
('3480', '2021-06-06', '0000-00-00', '62948', '', '98', '297', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '864', '4', 'pending'), 
('3481', '2021-06-06', '0000-00-00', '62948', '', '97', '290', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '864', '4', 'pending'), 
('3482', '2021-06-06', '0000-00-00', '62948', '', '117', '451', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '864', '4', 'pending'), 
('3483', '2021-06-06', '0000-00-00', '62948', '', '123', '527', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '864', '4', 'pending'), 
('3484', '2021-06-06', '0000-00-00', '62948', '', '121', '532', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '864', '4', 'pending'), 
('3485', '2021-06-06', '0000-00-00', '79653', '', '45', '101', '', '59', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '865', '4', 'pending'), 
('3486', '2021-06-06', '0000-00-00', '79653', '', '97', '290', '', '59', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '865', '4', 'pending'), 
('3487', '2021-06-06', '0000-00-00', '79653', '', '98', '297', '', '59', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '865', '4', 'pending'), 
('3488', '2021-06-06', '0000-00-00', '79653', '', '107', '366', '', '59', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '865', '4', 'pending'), 
('3489', '2021-06-06', '0000-00-00', '79653', '', '103', '329', '', '59', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '865', '4', 'pending'), 
('3490', '2021-06-06', '0000-00-00', '79653', '', '42', '338', '', '59', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '865', '4', 'pending'), 
('3491', '2021-06-06', '0000-00-00', '79653', '', '121', '532', '', '59', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '865', '4', 'pending'), 
('3492', '2021-06-06', '0000-00-00', '79653', '', '117', '451', '', '59', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '865', '4', 'pending'), 
('3493', '2021-06-06', '0000-00-00', '79653', '', '117', '463', '', '59', '32', '', '', '', '0', '0.00', '', '0.00', '0.00', '865', '4', 'pending'), 
('3494', '2021-06-06', '0000-00-00', '99662', '', '42', '338', '', '59', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '866', '4', 'pending'), 
('3502', '2021-06-06', '0000-00-00', '83943', '', '45', '101', '', '8', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '868', '4', 'pending'), 
('3503', '2021-06-06', '0000-00-00', '83943', '', '97', '290', '', '8', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '868', '4', 'pending'), 
('3504', '2021-06-06', '0000-00-00', '83943', '', '98', '297', '', '8', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '868', '4', 'pending'), 
('3505', '2021-06-06', '0000-00-00', '83943', '', '117', '473', '', '8', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '868', '4', 'pending'), 
('3506', '2021-06-06', '0000-00-00', '83943', '', '123', '561', '', '8', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '868', '4', 'pending'), 
('3507', '2021-06-06', '0000-00-00', '83943', '', '114', '611', '', '8', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '868', '4', 'pending'), 
('3508', '2021-06-07', '0000-00-00', '26298', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '869', '8', 'pending'), 
('3509', '2021-06-07', '0000-00-00', '26298', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '869', '8', 'pending'), 
('3510', '2021-06-07', '0000-00-00', '26298', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '869', '8', 'pending'), 
('3511', '2021-06-07', '0000-00-00', '26298', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '869', '8', 'pending'), 
('3512', '2021-06-07', '0000-00-00', '26298', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '869', '8', 'pending'), 
('3513', '2021-06-07', '0000-00-00', '26298', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '869', '8', 'pending'), 
('3514', '2021-06-07', '0000-00-00', '26298', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '869', '8', 'pending'), 
('3515', '2021-06-07', '0000-00-00', '26298', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '869', '8', 'pending'), 
('3516', '2021-06-07', '0000-00-00', '65848', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '870', '8', 'pending'), 
('3517', '2021-06-07', '0000-00-00', '65848', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '870', '8', 'pending'), 
('3518', '2021-06-07', '0000-00-00', '65848', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '870', '8', 'pending'), 
('3519', '2021-06-07', '0000-00-00', '65848', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '870', '8', 'pending'), 
('3520', '2021-06-07', '0000-00-00', '65848', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '870', '8', 'pending'), 
('3521', '2021-06-07', '0000-00-00', '71498', '', '117', '646', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '871', '8', 'pending'), 
('3522', '2021-06-07', '0000-00-00', '71506', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '872', '8', 'pending'), 
('3523', '2021-06-07', '0000-00-00', '71506', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '872', '8', 'pending'), 
('3524', '2021-06-07', '0000-00-00', '71506', '', '99', '304', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '872', '8', 'pending'), 
('3525', '2021-06-07', '0000-00-00', '71506', '', '107', '377', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '872', '8', 'pending'), 
('3526', '2021-06-07', '0000-00-00', '71506', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '872', '8', 'pending'), 
('3532', '2021-06-07', '0000-00-00', '11225', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '874', '8', 'pending'), 
('3534', '2021-06-07', '0000-00-00', '69395', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '876', '8', 'pending'), 
('3535', '2021-06-07', '0000-00-00', '46968', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '877', '8', 'pending'), 
('3536', '2021-06-07', '0000-00-00', '40492', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '878', '8', 'pending'), 
('3537', '2021-06-07', '0000-00-00', '60639', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '879', '8', 'pending'), 
('3538', '2021-06-07', '0000-00-00', '39326', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '880', '8', 'pending'), 
('3539', '2021-06-07', '0000-00-00', '67683', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '881', '8', 'pending'), 
('3547', '2021-06-07', '0000-00-00', '76725', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '883', '8', 'pending'), 
('3549', '2021-06-07', '0000-00-00', '81690', '', '117', '469', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '885', '4', 'pending'), 
('3550', '2021-06-07', '0000-00-00', '63291', '', '45', '101', '', '59', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '886', '4', 'pending'), 
('3551', '2021-06-07', '0000-00-00', '63291', '', '97', '290', '', '59', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '886', '4', 'pending'), 
('3552', '2021-06-07', '0000-00-00', '63291', '', '103', '329', '', '59', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '886', '4', 'pending'), 
('3553', '2021-06-07', '0000-00-00', '63291', '', '98', '297', '', '59', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '886', '4', 'pending'), 
('3554', '2021-06-07', '0000-00-00', '63291', '', '107', '366', '', '59', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '886', '4', 'pending'), 
('3555', '2021-06-07', '0000-00-00', '63291', '', '121', '532', '', '59', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '886', '4', 'pending'), 
('3556', '2021-06-07', '0000-00-00', '63291', '', '117', '451', '', '59', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '886', '4', 'pending'), 
('3557', '2021-06-07', '0000-00-00', '62826', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '887', '4', 'pending'), 
('3558', '2021-06-07', '0000-00-00', '62826', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '887', '4', 'pending'), 
('3559', '2021-06-07', '0000-00-00', '62826', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '887', '4', 'pending'), 
('3560', '2021-06-07', '0000-00-00', '62826', '', '98', '297', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '887', '4', 'pending'), 
('3561', '2021-06-07', '0000-00-00', '62826', '', '96', '642', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '887', '4', 'pending'), 
('3562', '2021-06-07', '0000-00-00', '62826', '', '108', '407', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '887', '4', 'pending'), 
('3563', '2021-06-07', '0000-00-00', '62826', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '887', '4', 'pending'), 
('3564', '2021-06-07', '0000-00-00', '80641', '', '97', '290', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '888', '4', 'pending'), 
('3565', '2021-06-07', '0000-00-00', '80641', '', '98', '297', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '888', '4', 'pending'), 
('3566', '2021-06-07', '0000-00-00', '80641', '', '107', '366', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '888', '4', 'pending'), 
('3567', '2021-06-07', '0000-00-00', '80641', '', '117', '451', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '888', '4', 'pending'), 
('3568', '2021-06-07', '0000-00-00', '80641', '', '117', '461', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '888', '4', 'pending'), 
('3569', '2021-06-07', '0000-00-00', '80641', '', '117', '645', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '888', '4', 'pending'), 
('3570', '2021-06-07', '0000-00-00', '80641', '', '117', '462', '', '59', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '888', '4', 'pending'), 
('3571', '2021-06-07', '0000-00-00', '92061', '', '97', '290', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '889', '4', 'pending'), 
('3572', '2021-06-07', '0000-00-00', '92061', '', '103', '329', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '889', '4', 'pending'), 
('3573', '2021-06-07', '0000-00-00', '92061', '', '35', '73', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '889', '4', 'pending'), 
('3574', '2021-06-07', '0000-00-00', '35290', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '890', '4', 'pending'), 
('3575', '2021-06-07', '0000-00-00', '35290', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '890', '4', 'pending'), 
('3576', '2021-06-07', '0000-00-00', '35290', '', '105', '357', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '890', '4', 'pending'), 
('3577', '2021-06-07', '0000-00-00', '35290', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '890', '4', 'pending'), 
('3578', '2021-06-07', '0000-00-00', '35290', '', '40', '679', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '890', '4', 'pending'), 
('3579', '2021-06-07', '0000-00-00', '35290', '', '105', '687', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '890', '4', 'pending'), 
('3580', '2021-06-07', '0000-00-00', '35290', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '890', '4', 'pending'), 
('3581', '2021-06-07', '0000-00-00', '61018', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '891', '4', 'pending'), 
('3582', '2021-06-07', '0000-00-00', '61018', '', '98', '297', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '891', '4', 'pending'), 
('3583', '2021-06-07', '0000-00-00', '61018', '', '117', '451', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '891', '4', 'pending'), 
('3584', '2021-06-07', '0000-00-00', '37014', '', '45', '101', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '892', '4', 'pending'), 
('3585', '2021-06-07', '0000-00-00', '37014', '', '97', '290', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '892', '4', 'pending'), 
('3586', '2021-06-07', '0000-00-00', '37014', '', '98', '297', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '892', '4', 'pending'), 
('3587', '2021-06-07', '0000-00-00', '37014', '', '36', '102', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '892', '4', 'pending'), 
('3588', '2021-06-07', '0000-00-00', '37014', '', '42', '338', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '892', '4', 'pending'), 
('3589', '2021-06-07', '0000-00-00', '37014', '', '121', '532', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '892', '4', 'pending'), 
('3590', '2021-06-07', '0000-00-00', '37014', '', '117', '451', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '892', '4', 'pending'), 
('3591', '2021-06-07', '0000-00-00', '37014', '', '123', '561', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '892', '4', 'pending'), 
('3592', '2021-06-07', '0000-00-00', '47853', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '893', '4', 'pending'), 
('3593', '2021-06-07', '0000-00-00', '76193', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '894', '4', 'pending'), 
('3594', '2021-06-07', '0000-00-00', '14381', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '895', '4', 'pending'), 
('3595', '2021-06-07', '0000-00-00', '86619', '', '35', '73', '', '48', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '896', '4', 'pending'), 
('3596', '2021-06-07', '0000-00-00', '86619', '', '97', '290', '', '48', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '896', '4', 'pending'), 
('3597', '2021-06-07', '0000-00-00', '86619', '', '98', '297', '', '48', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '896', '4', 'pending'), 
('3598', '2021-06-07', '0000-00-00', '86619', '', '98', '299', '', '48', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '896', '4', 'pending'), 
('3599', '2021-06-07', '0000-00-00', '86619', '', '99', '301', '', '48', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '896', '4', 'pending'), 
('3600', '2021-06-07', '0000-00-00', '86619', '', '103', '329', '', '48', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '896', '4', 'pending'), 
('3601', '2021-06-07', '0000-00-00', '86619', '', '108', '394', '', '48', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '896', '4', 'pending'), 
('3602', '2021-06-07', '0000-00-00', '86619', '', '117', '451', '', '48', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '896', '4', 'pending'), 
('3603', '2021-06-07', '0000-00-00', '86619', '', '123', '561', '', '48', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '896', '4', 'pending'), 
('3604', '2021-06-07', '0000-00-00', '25515', '', '117', '593', '', '91', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '897', '4', 'pending'), 
('3605', '2021-06-07', '0000-00-00', '33839', '', '118', '655', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '898', '4', 'pending'), 
('3606', '2021-06-07', '0000-00-00', '33839', '', '117', '596', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '898', '4', 'pending'), 
('3607', '2021-06-07', '0000-00-00', '28371', '', '117', '473', '', '91', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '899', '4', 'pending'), 
('3608', '2021-06-07', '0000-00-00', '51954', '', '107', '366', '', '91', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '900', '4', 'pending'), 
('3609', '2021-06-07', '0000-00-00', '30573', '', '117', '451', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '901', '4', 'pending'), 
('3610', '2021-06-07', '0000-00-00', '38257', '', '107', '366', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '902', '4', 'pending'), 
('3611', '2021-06-07', '0000-00-00', '30605', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '903', '4', 'pending'), 
('3612', '2021-06-07', '0000-00-00', '30605', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '903', '4', 'pending'), 
('3613', '2021-06-07', '0000-00-00', '30605', '', '40', '679', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '903', '4', 'pending'), 
('3614', '2021-06-07', '0000-00-00', '30605', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '903', '4', 'pending'), 
('3615', '2021-06-08', '0000-00-00', '21630', '', '103', '335', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '904', '8', 'pending'), 
('3616', '2021-06-08', '0000-00-00', '21630', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '904', '8', 'pending'), 
('3617', '2021-06-08', '0000-00-00', '21630', '', '99', '304', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '904', '8', 'pending'), 
('3618', '2021-06-08', '0000-00-00', '21630', '', '99', '301', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '904', '8', 'pending'), 
('3619', '2021-06-08', '0000-00-00', '67680', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '905', '8', 'pending'), 
('3620', '2021-06-08', '0000-00-00', '67680', '', '121', '533', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '905', '8', 'pending'), 
('3621', '2021-06-08', '0000-00-00', '71578', '', '42', '338', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '906', '8', 'pending'), 
('3622', '2021-06-08', '0000-00-00', '71578', '', '97', '290', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '906', '8', 'pending'), 
('3623', '2021-06-08', '0000-00-00', '71578', '', '98', '297', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '906', '8', 'pending'), 
('3624', '2021-06-08', '0000-00-00', '71578', '', '107', '370', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '906', '8', 'pending'), 
('3625', '2021-06-08', '0000-00-00', '71578', '', '103', '329', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '906', '8', 'pending'), 
('3626', '2021-06-08', '0000-00-00', '71578', '', '105', '616', '', '17', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '906', '8', 'pending'), 
('3627', '2021-06-08', '0000-00-00', '85031', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '907', '8', 'pending'), 
('3628', '2021-06-08', '0000-00-00', '29906', '', '117', '451', '', '17', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '908', '8', 'pending'), 
('3629', '2021-06-08', '0000-00-00', '29906', '', '121', '533', '', '17', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '908', '8', 'pending'), 
('3630', '2021-06-08', '0000-00-00', '29906', '', '45', '101', '', '17', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '908', '8', 'pending'), 
('3631', '2021-06-08', '0000-00-00', '29906', '', '97', '290', '', '17', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '908', '8', 'pending'), 
('3632', '2021-06-08', '0000-00-00', '29906', '', '42', '338', '', '17', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '908', '8', 'pending'), 
('3633', '2021-06-08', '0000-00-00', '29906', '', '98', '297', '', '17', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '908', '8', 'pending'), 
('3634', '2021-06-08', '0000-00-00', '29906', '', '121', '532', '', '17', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '908', '8', 'pending'), 
('3635', '2021-06-08', '0000-00-00', '88769', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '909', '8', 'pending'), 
('3636', '2021-06-08', '0000-00-00', '37363', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '910', '8', 'pending'), 
('3637', '2021-06-08', '0000-00-00', '98887', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '911', '8', 'pending'), 
('3638', '2021-06-08', '0000-00-00', '98887', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '911', '8', 'pending'), 
('3639', '2021-06-08', '0000-00-00', '98887', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '911', '8', 'pending'), 
('3640', '2021-06-08', '0000-00-00', '98887', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '911', '8', 'pending'), 
('3641', '2021-06-08', '0000-00-00', '98887', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '911', '8', 'pending'), 
('3642', '2021-06-08', '0000-00-00', '98887', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '911', '8', 'pending'), 
('3643', '2021-06-08', '0000-00-00', '35476', '', '121', '532', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '912', '4', 'pending'), 
('3644', '2021-06-08', '0000-00-00', '35476', '', '121', '533', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '912', '4', 'pending'), 
('3645', '2021-06-08', '0000-00-00', '35476', '', '123', '527', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '912', '4', 'pending'), 
('3646', '2021-06-08', '0000-00-00', '52953', '', '45', '101', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '913', '4', 'pending'), 
('3647', '2021-06-08', '0000-00-00', '52953', '', '97', '290', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '913', '4', 'pending'), 
('3648', '2021-06-08', '0000-00-00', '52953', '', '107', '366', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '913', '4', 'pending'), 
('3649', '2021-06-08', '0000-00-00', '52953', '', '98', '297', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '913', '4', 'pending'), 
('3650', '2021-06-08', '0000-00-00', '52953', '', '121', '532', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '913', '4', 'pending'), 
('3651', '2021-06-08', '0000-00-00', '52953', '', '117', '451', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '913', '4', 'pending'), 
('3652', '2021-06-08', '0000-00-00', '52953', '', '118', '502', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '913', '4', 'pending'), 
('3653', '2021-06-08', '0000-00-00', '57620', '', '117', '451', '', '59', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '914', '4', 'pending'), 
('3654', '2021-06-08', '0000-00-00', '57620', '', '117', '650', '', '59', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '914', '4', 'pending'), 
('3655', '2021-06-08', '0000-00-00', '61795', '', '97', '290', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '915', '4', 'pending'), 
('3656', '2021-06-08', '0000-00-00', '61795', '', '98', '297', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '915', '4', 'pending'), 
('3657', '2021-06-08', '0000-00-00', '61795', '', '103', '329', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '915', '4', 'pending'), 
('3658', '2021-06-08', '0000-00-00', '61795', '', '107', '366', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '915', '4', 'pending'), 
('3659', '2021-06-08', '0000-00-00', '61795', '', '35', '73', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '915', '4', 'pending'), 
('3660', '2021-06-08', '0000-00-00', '61795', '', '121', '532', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '915', '4', 'pending'), 
('3661', '2021-06-08', '0000-00-00', '70264', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '916', '4', 'pending'), 
('3662', '2021-06-08', '0000-00-00', '70264', '', '40', '680', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '916', '4', 'pending'), 
('3663', '2021-06-08', '0000-00-00', '70264', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '916', '4', 'pending'), 
('3664', '2021-06-08', '0000-00-00', '70264', '', '114', '445', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '916', '4', 'pending'), 
('3665', '2021-06-08', '0000-00-00', '70264', '', '117', '461', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '916', '4', 'pending'), 
('3666', '2021-06-08', '0000-00-00', '91688', '', '35', '72', '', '59', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '917', '4', 'pending'), 
('3667', '2021-06-08', '0000-00-00', '91688', '', '107', '377', '', '59', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '917', '4', 'pending'), 
('3668', '2021-06-08', '0000-00-00', '55947', '', '97', '290', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '918', '4', 'pending'), 
('3669', '2021-06-08', '0000-00-00', '55947', '', '98', '297', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '918', '4', 'pending'), 
('3670', '2021-06-08', '0000-00-00', '55947', '', '35', '73', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '918', '4', 'pending'), 
('3671', '2021-06-08', '0000-00-00', '55947', '', '107', '366', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '918', '4', 'pending'), 
('3672', '2021-06-08', '0000-00-00', '55947', '', '40', '679', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '918', '4', 'pending'), 
('3673', '2021-06-08', '0000-00-00', '55947', '', '103', '329', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '918', '4', 'pending'), 
('3674', '2021-06-08', '0000-00-00', '55947', '', '42', '338', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '918', '4', 'pending'), 
('3675', '2021-06-08', '0000-00-00', '55947', '', '123', '519', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '918', '4', 'pending'), 
('3676', '2021-06-08', '0000-00-00', '82529', '', '107', '366', '', '59', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '919', '4', 'pending'), 
('3677', '2021-06-08', '0000-00-00', '62147', '', '45', '101', '', '59', '36', '', '', '', '0', '0.00', '', '0.00', '0.00', '920', '4', 'pending'), 
('3678', '2021-06-08', '0000-00-00', '62147', '', '97', '290', '', '59', '36', '', '', '', '0', '0.00', '', '0.00', '0.00', '920', '4', 'pending'), 
('3679', '2021-06-08', '0000-00-00', '62147', '', '40', '680', '', '59', '36', '', '', '', '0', '0.00', '', '0.00', '0.00', '920', '4', 'pending'), 
('3680', '2021-06-08', '0000-00-00', '62147', '', '98', '297', '', '59', '36', '', '', '', '0', '0.00', '', '0.00', '0.00', '920', '4', 'pending'), 
('3681', '2021-06-08', '0000-00-00', '62147', '', '42', '338', '', '59', '36', '', '', '', '0', '0.00', '', '0.00', '0.00', '920', '4', 'pending'), 
('3682', '2021-06-08', '0000-00-00', '62147', '', '121', '532', '', '59', '36', '', '', '', '0', '0.00', '', '0.00', '0.00', '920', '4', 'pending'), 
('3683', '2021-06-08', '0000-00-00', '62147', '', '117', '451', '', '59', '36', '', '', '', '0', '0.00', '', '0.00', '0.00', '920', '4', 'pending'), 
('3684', '2021-06-08', '0000-00-00', '64849', '', '45', '101', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '921', '4', 'pending'), 
('3685', '2021-06-08', '0000-00-00', '64849', '', '96', '282', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '921', '4', 'pending'), 
('3686', '2021-06-08', '0000-00-00', '64849', '', '97', '290', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '921', '4', 'pending'), 
('3687', '2021-06-08', '0000-00-00', '64849', '', '121', '532', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '921', '4', 'pending'), 
('3688', '2021-06-08', '0000-00-00', '64849', '', '117', '451', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '921', '4', 'pending'), 
('3689', '2021-06-08', '0000-00-00', '64849', '', '121', '533', '', '59', '34', '', '', '', '0', '0.00', '', '0.00', '0.00', '921', '4', 'pending'), 
('3693', '2021-06-08', '0000-00-00', '86575', '', '117', '461', '', '91', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '924', '4', 'pending'), 
('3694', '2021-06-08', '0000-00-00', '86575', '', '118', '655', '', '91', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '924', '4', 'pending'), 
('3695', '2021-06-08', '0000-00-00', '25198', '', '120', '531', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '925', '4', 'pending'), 
('3696', '2021-06-08', '0000-00-00', '81963', '', '45', '101', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '926', '4', 'pending'), 
('3697', '2021-06-08', '0000-00-00', '81963', '', '107', '588', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '926', '4', 'pending'), 
('3698', '2021-06-08', '0000-00-00', '81963', '', '42', '338', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '926', '4', 'pending'), 
('3699', '2021-06-08', '0000-00-00', '81963', '', '117', '622', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '926', '4', 'pending'), 
('3701', '2021-06-09', '0000-00-00', '43325', '', '97', '291', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '928', '8', 'pending'), 
('3702', '2021-06-09', '0000-00-00', '43325', '', '97', '295', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '928', '8', 'pending'), 
('3703', '2021-06-09', '0000-00-00', '35245', '', '99', '598', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '929', '8', 'pending'), 
('3704', '2021-06-09', '0000-00-00', '13835', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '930', '8', 'pending'), 
('3705', '2021-06-09', '0000-00-00', '13835', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '930', '8', 'pending'), 
('3706', '2021-06-09', '0000-00-00', '13835', '', '99', '301', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '930', '8', 'pending'), 
('3707', '2021-06-09', '0000-00-00', '13835', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '930', '8', 'pending'), 
('3708', '2021-06-09', '0000-00-00', '13835', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '930', '8', 'pending'), 
('3709', '2021-06-09', '0000-00-00', '13835', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '930', '8', 'pending'), 
('3710', '2021-06-09', '0000-00-00', '13835', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '930', '8', 'pending'), 
('3711', '2021-06-09', '0000-00-00', '13835', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '930', '8', 'pending'), 
('3712', '2021-06-09', '0000-00-00', '13835', '', '123', '561', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '930', '8', 'pending'), 
('3713', '2021-06-09', '0000-00-00', '13835', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '930', '8', 'pending'), 
('3714', '2021-06-09', '0000-00-00', '65311', '', '45', '101', '', '106', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '931', '8', 'pending'), 
('3715', '2021-06-09', '0000-00-00', '65311', '', '103', '329', '', '106', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '931', '8', 'pending'), 
('3716', '2021-06-09', '0000-00-00', '65311', '', '42', '338', '', '106', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '931', '8', 'pending'), 
('3717', '2021-06-09', '0000-00-00', '65311', '', '117', '451', '', '106', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '931', '8', 'pending'), 
('3718', '2021-06-09', '0000-00-00', '65311', '', '121', '532', '', '106', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '931', '8', 'pending'), 
('3719', '2021-06-09', '0000-00-00', '23478', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '932', '8', 'pending'), 
('3720', '2021-06-09', '0000-00-00', '23478', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '932', '8', 'pending'), 
('3721', '2021-06-09', '0000-00-00', '23478', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '932', '8', 'pending'), 
('3722', '2021-06-09', '0000-00-00', '23478', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '932', '8', 'pending'), 
('3723', '2021-06-09', '0000-00-00', '85647', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '933', '8', 'pending'), 
('3724', '2021-06-09', '0000-00-00', '85647', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '933', '8', 'pending'), 
('3725', '2021-06-09', '0000-00-00', '85647', '', '99', '304', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '933', '8', 'pending'), 
('3726', '2021-06-09', '0000-00-00', '85647', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '933', '8', 'pending'), 
('3727', '2021-06-09', '0000-00-00', '85647', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '933', '8', 'pending'), 
('3728', '2021-06-09', '0000-00-00', '85647', '', '42', '338', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '933', '8', 'pending'), 
('3729', '2021-06-09', '0000-00-00', '85647', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '933', '8', 'pending'), 
('3730', '2021-06-09', '0000-00-00', '85647', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '933', '8', 'pending'), 
('3731', '2021-06-09', '0000-00-00', '64071', '', '117', '451', '', '91', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '934', '8', 'pending'), 
('3733', '2021-06-09', '0000-00-00', '27482', '', '117', '451', '', '73', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '936', '8', 'pending'), 
('3734', '2021-06-09', '0000-00-00', '93161', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '937', '8', 'pending'), 
('3735', '2021-06-09', '0000-00-00', '93161', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '937', '8', 'pending'), 
('3736', '2021-06-09', '0000-00-00', '93161', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '937', '8', 'pending'), 
('3737', '2021-06-09', '0000-00-00', '93161', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '937', '8', 'pending'), 
('3747', '2021-06-09', '0000-00-00', '38506', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '939', '8', 'pending'), 
('3748', '2021-06-09', '0000-00-00', '38506', '', '117', '451', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '939', '8', 'pending'), 
('3749', '2021-06-09', '0000-00-00', '38506', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '939', '8', 'pending'), 
('3750', '2021-06-09', '0000-00-00', '38506', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '939', '8', 'pending'), 
('3751', '2021-06-09', '0000-00-00', '38506', '', '123', '561', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '939', '8', 'pending'), 
('3752', '2021-06-09', '0000-00-00', '38506', '', '99', '598', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '939', '8', 'pending'), 
('3753', '2021-06-09', '0000-00-00', '38506', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '939', '8', 'pending'), 
('3754', '2021-06-09', '0000-00-00', '38506', '', '105', '616', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '939', '8', 'pending'), 
('3755', '2021-06-09', '0000-00-00', '95765', '', '45', '101', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '940', '4', 'pending'), 
('3756', '2021-06-09', '0000-00-00', '95765', '', '97', '290', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '940', '4', 'pending'), 
('3757', '2021-06-09', '0000-00-00', '95765', '', '98', '297', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '940', '4', 'pending'), 
('3758', '2021-06-09', '0000-00-00', '95765', '', '99', '301', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '940', '4', 'pending'), 
('3759', '2021-06-09', '0000-00-00', '95765', '', '103', '329', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '940', '4', 'pending'), 
('3760', '2021-06-09', '0000-00-00', '95765', '', '107', '366', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '940', '4', 'pending'), 
('3761', '2021-06-09', '0000-00-00', '95765', '', '42', '338', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '940', '4', 'pending'), 
('3762', '2021-06-09', '0000-00-00', '95765', '', '117', '622', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '940', '4', 'pending'), 
('3763', '2021-06-09', '0000-00-00', '95765', '', '115', '450', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '940', '4', 'pending'), 
('3764', '2021-06-09', '0000-00-00', '39535', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '941', '8', 'pending'), 
('3765', '2021-06-09', '0000-00-00', '39535', '', '117', '451', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '941', '8', 'pending'), 
('3766', '2021-06-09', '0000-00-00', '39535', '', '117', '622', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '941', '8', 'pending'), 
('3767', '2021-06-09', '0000-00-00', '39535', '', '123', '561', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '941', '8', 'pending'), 
('3768', '2021-06-09', '0000-00-00', '39535', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '941', '8', 'pending'), 
('3769', '2021-06-09', '0000-00-00', '39535', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '941', '8', 'pending'), 
('3770', '2021-06-09', '0000-00-00', '39535', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '941', '8', 'pending'), 
('3771', '2021-06-09', '0000-00-00', '34159', '', '45', '101', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '942', '8', 'pending'), 
('3772', '2021-06-09', '0000-00-00', '34159', '', '99', '598', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '942', '8', 'pending'), 
('3773', '2021-06-09', '0000-00-00', '34159', '', '99', '304', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '942', '8', 'pending'), 
('3774', '2021-06-09', '0000-00-00', '34159', '', '123', '561', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '942', '8', 'pending'), 
('3775', '2021-06-09', '0000-00-00', '34159', '', '121', '532', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '942', '8', 'pending'), 
('3776', '2021-06-09', '0000-00-00', '34159', '', '97', '290', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '942', '8', 'pending'), 
('3777', '2021-06-09', '0000-00-00', '34159', '', '121', '533', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '942', '8', 'pending'), 
('3778', '2021-06-09', '0000-00-00', '34159', '', '42', '338', '', '6', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '942', '8', 'pending'), 
('3779', '2021-06-09', '0000-00-00', '61085', '', '117', '451', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '943', '4', 'pending'), 
('3780', '2021-06-09', '0000-00-00', '61085', '', '117', '595', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '943', '4', 'pending'), 
('3781', '2021-06-09', '0000-00-00', '95252', '', '45', '101', '', '108', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '944', '8', 'pending'), 
('3782', '2021-06-09', '0000-00-00', '95252', '', '107', '366', '', '108', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '944', '8', 'pending'), 
('3783', '2021-06-09', '0000-00-00', '95252', '', '107', '377', '', '108', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '944', '8', 'pending'), 
('3784', '2021-06-09', '0000-00-00', '95252', '', '98', '297', '', '108', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '944', '8', 'pending'), 
('3785', '2021-06-09', '0000-00-00', '95252', '', '103', '329', '', '108', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '944', '8', 'pending'), 
('3786', '2021-06-09', '0000-00-00', '95252', '', '112', '287', '', '108', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '944', '8', 'pending'), 
('3787', '2021-06-09', '0000-00-00', '95252', '', '117', '451', '', '108', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '944', '8', 'pending'), 
('3788', '2021-06-09', '0000-00-00', '95252', '', '117', '463', '', '108', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '944', '8', 'pending'), 
('3789', '2021-06-09', '0000-00-00', '84055', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '945', '8', 'pending'), 
('3790', '2021-06-09', '0000-00-00', '84055', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '945', '8', 'pending'), 
('3791', '2021-06-09', '0000-00-00', '84055', '', '107', '366', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '945', '8', 'pending'), 
('3792', '2021-06-09', '0000-00-00', '84055', '', '98', '297', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '945', '8', 'pending'), 
('3793', '2021-06-09', '0000-00-00', '84055', '', '103', '329', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '945', '8', 'pending'), 
('3794', '2021-06-09', '0000-00-00', '84055', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '945', '8', 'pending'), 
('3795', '2021-06-09', '0000-00-00', '84055', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '945', '8', 'pending'), 
('3796', '2021-06-09', '0000-00-00', '84055', '', '117', '463', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '945', '8', 'pending'), 
('3797', '2021-06-09', '0000-00-00', '84055', '', '123', '561', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '945', '8', 'pending'), 
('3798', '2021-06-09', '0000-00-00', '84055', '', '42', '338', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '945', '8', 'pending'), 
('3799', '2021-06-09', '0000-00-00', '99767', '', '99', '598', '', '59', '5', '', '', '', '0', '0.00', '', '0.00', '0.00', '946', '4', 'pending'), 
('3800', '2021-06-09', '0000-00-00', '79231', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '947', '8', 'pending'), 
('3801', '2021-06-09', '0000-00-00', '79231', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '947', '8', 'pending'), 
('3802', '2021-06-09', '0000-00-00', '79231', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '947', '8', 'pending'), 
('3803', '2021-06-09', '0000-00-00', '79231', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '947', '8', 'pending'), 
('3804', '2021-06-09', '0000-00-00', '79231', '', '121', '532', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '947', '8', 'pending'), 
('3805', '2021-06-09', '0000-00-00', '79231', '', '117', '451', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '947', '8', 'pending'), 
('3806', '2021-06-09', '0000-00-00', '79231', '', '100', '583', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '947', '8', 'pending'), 
('3807', '2021-06-09', '0000-00-00', '48533', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '948', '8', 'pending'), 
('3808', '2021-06-09', '0000-00-00', '48533', '', '97', '290', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '948', '8', 'pending'), 
('3809', '2021-06-09', '0000-00-00', '48533', '', '42', '338', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '948', '8', 'pending'), 
('3810', '2021-06-09', '0000-00-00', '48533', '', '98', '297', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '948', '8', 'pending'), 
('3811', '2021-06-09', '0000-00-00', '48533', '', '123', '561', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '948', '8', 'pending'), 
('3812', '2021-06-09', '0000-00-00', '84477', '', '117', '463', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '949', '4', 'pending'), 
('3813', '2021-06-09', '0000-00-00', '84477', '', '117', '451', '', '59', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '949', '4', 'pending'), 
('3814', '2021-06-09', '0000-00-00', '24906', '', '35', '73', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '950', '8', 'pending'), 
('3815', '2021-06-09', '0000-00-00', '24906', '', '107', '366', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '950', '8', 'pending'), 
('3816', '2021-06-09', '0000-00-00', '24906', '', '42', '338', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '950', '8', 'pending'), 
('3817', '2021-06-09', '0000-00-00', '24906', '', '97', '290', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '950', '8', 'pending'), 
('3818', '2021-06-09', '0000-00-00', '24906', '', '98', '297', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '950', '8', 'pending'), 
('3819', '2021-06-09', '0000-00-00', '24906', '', '40', '679', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '950', '8', 'pending'), 
('3820', '2021-06-09', '0000-00-00', '24906', '', '103', '329', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '950', '8', 'pending'), 
('3821', '2021-06-09', '0000-00-00', '24906', '', '123', '519', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '950', '8', 'pending'), 
('3822', '2021-06-09', '0000-00-00', '83290', '', '99', '598', '', '59', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '951', '4', 'pending'), 
('3823', '2021-06-09', '0000-00-00', '97841', '', '117', '644', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '952', '8', 'pending'), 
('3824', '2021-06-09', '0000-00-00', '97841', '', '97', '290', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '952', '8', 'pending'), 
('3825', '2021-06-09', '0000-00-00', '97841', '', '98', '297', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '952', '8', 'pending'), 
('3826', '2021-06-09', '0000-00-00', '97841', '', '107', '588', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '952', '8', 'pending'), 
('3827', '2021-06-09', '0000-00-00', '97841', '', '45', '101', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '952', '8', 'pending'), 
('3828', '2021-06-09', '0000-00-00', '43979', '', '45', '101', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '953', '8', 'pending'), 
('3829', '2021-06-09', '0000-00-00', '43979', '', '117', '463', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '953', '8', 'pending'), 
('3830', '2021-06-09', '0000-00-00', '43979', '', '36', '693', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '953', '8', 'pending'), 
('3831', '2021-06-09', '0000-00-00', '43979', '', '99', '301', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '953', '8', 'pending'), 
('3832', '2021-06-09', '0000-00-00', '58397', '', '117', '451', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '954', '8', 'pending'), 
('3833', '2021-06-09', '0000-00-00', '30800', '', '45', '101', '', '53', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '955', '8', 'pending'), 
('3834', '2021-06-09', '0000-00-00', '30800', '', '97', '290', '', '53', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '955', '8', 'pending'), 
('3835', '2021-06-09', '0000-00-00', '30800', '', '98', '297', '', '53', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '955', '8', 'pending'), 
('3836', '2021-06-09', '0000-00-00', '30800', '', '120', '638', '', '53', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '955', '8', 'pending'), 
('3837', '2021-06-09', '0000-00-00', '30800', '', '107', '366', '', '53', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '955', '8', 'pending'), 
('3838', '2021-06-09', '0000-00-00', '30800', '', '42', '338', '', '53', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '955', '8', 'pending'), 
('3839', '2021-06-09', '0000-00-00', '73516', '', '117', '629', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '956', '8', 'pending'), 
('3840', '2021-06-09', '0000-00-00', '73516', '', '117', '652', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '956', '8', 'pending'), 
('3841', '2021-06-09', '0000-00-00', '92401', '', '97', '294', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '957', '4', 'pending'), 
('3842', '2021-06-09', '0000-00-00', '92401', '', '97', '291', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '957', '4', 'pending'), 
('3843', '2021-06-09', '0000-00-00', '92401', '', '98', '297', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '957', '4', 'pending'), 
('3844', '2021-06-09', '0000-00-00', '92401', '', '98', '299', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '957', '4', 'pending'), 
('3845', '2021-06-09', '0000-00-00', '92401', '', '42', '338', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '957', '4', 'pending'), 
('3846', '2021-06-09', '0000-00-00', '92401', '', '123', '561', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '957', '4', 'pending'), 
('3847', '2021-06-09', '0000-00-00', '59805', '', '117', '644', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '958', '4', 'pending'), 
('3848', '2021-06-09', '0000-00-00', '96566', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '959', '4', 'pending'), 
('3849', '2021-06-09', '0000-00-00', '35808', '', '117', '451', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '960', '4', 'pending'), 
('3850', '2021-06-09', '0000-00-00', '35808', '', '117', '595', '', '14', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '960', '4', 'pending'), 
('3851', '2021-06-09', '0000-00-00', '79620', '', '117', '451', '', '74', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '961', '8', 'pending'), 
('3852', '2021-06-09', '0000-00-00', '59509', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '962', '8', 'pending'), 
('3853', '2021-06-09', '0000-00-00', '59509', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '962', '8', 'pending'), 
('3854', '2021-06-09', '0000-00-00', '59509', '', '99', '301', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '962', '8', 'pending'), 
('3855', '2021-06-09', '0000-00-00', '59509', '', '105', '357', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '962', '8', 'pending'), 
('3856', '2021-06-09', '0000-00-00', '59509', '', '121', '532', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '962', '8', 'pending'), 
('3857', '2021-06-09', '0000-00-00', '59509', '', '42', '338', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '962', '8', 'pending'), 
('3858', '2021-06-09', '0000-00-00', '54870', '', '105', '616', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '963', '8', 'pending'), 
('3859', '2021-06-09', '0000-00-00', '98276', '', '105', '616', '', '6', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '964', '8', 'pending'), 
('3860', '2021-06-09', '0000-00-00', '98276', '', '105', '355', '', '6', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '964', '8', 'pending'), 
('3861', '2021-06-09', '0000-00-00', '98276', '', '45', '101', '', '6', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '964', '8', 'pending'), 
('3862', '2021-06-09', '0000-00-00', '98276', '', '121', '532', '', '6', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '964', '8', 'pending'), 
('3863', '2021-06-09', '0000-00-00', '98276', '', '117', '451', '', '6', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '964', '8', 'pending'), 
('3864', '2021-06-09', '0000-00-00', '98276', '', '121', '534', '', '6', '31', '', '', '', '0', '0.00', '', '0.00', '0.00', '964', '8', 'pending'), 
('3865', '2021-06-09', '0000-00-00', '58037', '', '117', '451', '', '6', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '965', '8', 'pending'), 
('3866', '2021-06-09', '0000-00-00', '83466', '', '45', '101', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '966', '4', 'pending'), 
('3867', '2021-06-09', '0000-00-00', '83466', '', '97', '290', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '966', '4', 'pending'), 
('3868', '2021-06-09', '0000-00-00', '83466', '', '96', '642', '', '6', '30', '', '', '', '0', '0.00', '', '0.00', '0.00', '966', '4', 'pending'), 
('3869', '2021-06-09', '0000-00-00', '47061', '', '117', '451', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '967', '4', 'pending'), 
('3870', '2021-06-09', '0000-00-00', '47061', '', '121', '532', '', '6', '6', '', '', '', '0', '0.00', '', '0.00', '0.00', '967', '4', 'pending'), 
('3871', '2021-06-09', '0000-00-00', '67889', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '968', '4', 'pending'), 
('3872', '2021-06-09', '0000-00-00', '67889', '', '97', '290', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '968', '4', 'pending'), 
('3873', '2021-06-09', '0000-00-00', '67889', '', '121', '532', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '968', '4', 'pending'), 
('3874', '2021-06-09', '0000-00-00', '67889', '', '120', '634', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '968', '4', 'pending'), 
('3882', '2021-06-10', '0000-00-00', '20334', '', '35', '73', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '970', '8', 'pending'), 
('3883', '2021-06-10', '0000-00-00', '20334', '', '97', '290', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '970', '8', 'pending'), 
('3884', '2021-06-10', '0000-00-00', '20334', '', '103', '329', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '970', '8', 'pending'), 
('3885', '2021-06-10', '0000-00-00', '20334', '', '107', '366', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '970', '8', 'pending'), 
('3886', '2021-06-10', '0000-00-00', '20334', '', '107', '370', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '970', '8', 'pending'), 
('3887', '2021-06-10', '0000-00-00', '20334', '', '123', '519', '', '17', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '970', '8', 'pending'), 
('3888', '2021-06-10', '0000-00-00', '18483', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '971', '8', 'pending'), 
('3889', '2021-06-10', '0000-00-00', '18483', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '971', '8', 'pending'), 
('3890', '2021-06-10', '0000-00-00', '18483', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '971', '8', 'pending'), 
('3891', '2021-06-10', '0000-00-00', '18483', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '971', '8', 'pending'), 
('3892', '2021-06-10', '0000-00-00', '18483', '', '107', '366', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '971', '8', 'pending'), 
('3893', '2021-06-10', '0000-00-00', '18483', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '971', '8', 'pending'), 
('3894', '2021-06-10', '0000-00-00', '18483', '', '117', '463', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '971', '8', 'pending'), 
('3895', '2021-06-10', '0000-00-00', '52772', '', '45', '101', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '972', '8', 'pending'), 
('3896', '2021-06-10', '0000-00-00', '52772', '', '98', '297', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '972', '8', 'pending'), 
('3897', '2021-06-10', '0000-00-00', '52772', '', '121', '532', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '972', '8', 'pending'), 
('3898', '2021-06-10', '0000-00-00', '52772', '', '117', '451', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '972', '8', 'pending'), 
('3899', '2021-06-10', '0000-00-00', '52772', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '972', '8', 'pending'), 
('3900', '2021-06-10', '0000-00-00', '56521', '', '35', '73', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '973', '8', 'pending'), 
('3901', '2021-06-10', '0000-00-00', '56521', '', '97', '290', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '973', '8', 'pending'), 
('3902', '2021-06-10', '0000-00-00', '56521', '', '103', '329', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '973', '8', 'pending'), 
('3903', '2021-06-10', '0000-00-00', '23508', '', '35', '72', '', '109', '42', '', '', '', '0', '0.00', '', '0.00', '0.00', '975', '14', 'pending'), 
('3904', '2021-06-10', '0000-00-00', '23508', '', '42', '94', '', '109', '42', '', '', '', '0', '0.00', '', '0.00', '0.00', '975', '14', 'pending'), 
('3905', '2021-06-10', '0000-00-00', '23508', '', '45', '101', '', '109', '42', '', '', '', '0', '0.00', '', '0.00', '0.00', '975', '14', 'pending'), 
('3906', '2021-06-10', '2021-06-10', '99943', '', '125', '643', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3907', '2021-06-10', '2021-06-10', '99943', '', '125', '393', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3908', '2021-06-10', '2021-06-10', '99943', '', '123', '587', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3909', '2021-06-10', '2021-06-10', '99943', '', '123', '514', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3910', '2021-06-10', '2021-06-10', '99943', '', '123', '517', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3911', '2021-06-10', '2021-06-10', '99943', '', '123', '519', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3912', '2021-06-10', '2021-06-10', '99943', '', '123', '523', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3913', '2021-06-10', '2021-06-10', '99943', '', '123', '524', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3914', '2021-06-10', '2021-06-10', '99943', '', '123', '527', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3915', '2021-06-10', '2021-06-10', '99943', '', '123', '561', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3916', '2021-06-10', '2021-06-10', '99943', '', '123', '562', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3917', '2021-06-10', '2021-06-10', '99943', '', '123', '565', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3918', '2021-06-10', '2021-06-10', '99943', '', '123', '566', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3919', '2021-06-10', '2021-06-10', '99943', '', '123', '568', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3920', '2021-06-10', '2021-06-10', '99943', '', '123', '569', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3921', '2021-06-10', '2021-06-10', '99943', '', '123', '573', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3922', '2021-06-10', '2021-06-10', '99943', '', '123', '574', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3923', '2021-06-10', '2021-06-10', '99943', '', '123', '467', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3924', '2021-06-10', '2021-06-10', '99943', '', '125', '643', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3925', '2021-06-10', '2021-06-10', '99943', '', '125', '393', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3926', '2021-06-10', '2021-06-10', '99943', '', '96', '642', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3927', '2021-06-10', '2021-06-10', '99943', '', '96', '643', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3928', '2021-06-10', '2021-06-10', '99943', '', '96', '661', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3929', '2021-06-10', '2021-06-10', '99943', '', '96', '668', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3930', '2021-06-10', '2021-06-10', '99943', '', '96', '675', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3931', '2021-06-10', '2021-06-10', '99943', '', '96', '591', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3932', '2021-06-10', '2021-06-10', '99943', '', '96', '592', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3933', '2021-06-10', '2021-06-10', '99943', '', '96', '101', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3934', '2021-06-10', '2021-06-10', '99943', '', '96', '282', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3935', '2021-06-10', '2021-06-10', '99943', '', '96', '283', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3936', '2021-06-10', '2021-06-10', '99943', '', '96', '284', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3937', '2021-06-10', '2021-06-10', '99943', '', '96', '285', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3938', '2021-06-10', '2021-06-10', '99943', '', '96', '287', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3939', '2021-06-10', '2021-06-10', '99943', '', '96', '288', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3940', '2021-06-10', '2021-06-10', '99943', '', '96', '289', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3941', '2021-06-10', '2021-06-10', '99943', '', '96', '72', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3942', '2021-06-10', '2021-06-10', '99943', '', '96', '73', '', '109', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '976', '', 'pending'), 
('3943', '2021-06-10', '0000-00-00', '68076', '', '35', '107', '', '110', '42', '', '', '', '0', '0.00', '', '0.00', '0.00', '978', '14', 'pending'), 
('3944', '2021-06-10', '0000-00-00', '27258', '', '42', '94', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '979', '14', 'pending'), 
('3945', '2021-06-10', '0000-00-00', '27258', '', '42', '94', '', '6', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '979', '14', 'pending'), 
('3946', '2021-06-16', '0000-00-00', '32459', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '980', '14', 'pending'), 
('3947', '2021-06-16', '0000-00-00', '32459', '', '35', '72', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '980', '14', 'pending'), 
('3948', '2021-06-18', '0000-00-00', '43512', '', '127', '695', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '981', '14', 'pending'), 
('3949', '2021-06-19', '0000-00-00', '62574', '', '35', '72', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '982', '1001', 'pending'), 
('3950', '2021-06-19', '0000-00-00', '62574', '', '35', '73', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '982', '1001', 'pending'), 
('3951', '2021-06-19', '0000-00-00', '34889', '', '35', '72', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '983', '14', 'pending'), 
('3952', '2021-06-19', '0000-00-00', '37249', '', '127', '695', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '984', '14', 'pending'), 
('3953', '2021-06-19', '0000-00-00', '59492', '', '127', '695', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '985', '14', 'pending'), 
('3954', '2021-06-19', '0000-00-00', '12159', '', '97', '291', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '986', '14', 'pending'), 
('3955', '2021-06-19', '0000-00-00', '25550', '', '127', '695', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '987', '1001', 'pending'), 
('3956', '2021-06-19', '0000-00-00', '34311', '', '45', '101', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '988', '14', 'pending'), 
('3957', '2021-06-19', '0000-00-00', '50243', '', '35', '72', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '990', '14', 'pending'), 
('3958', '2021-06-20', '0000-00-00', '48142', '', '127', '695', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '991', '14', 'pending'), 
('3959', '2021-06-21', '0000-00-00', '18955', '', '127', '700', '', '6', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '992', '14', 'pending'), 
('3960', '2021-06-21', '0000-00-00', '18955', '', '127', '701', '', '6', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '992', '14', 'pending'), 
('3961', '2021-06-21', '0000-00-00', '18955', '', '127', '702', '', '6', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '992', '14', 'pending'), 
('3962', '2021-06-21', '0000-00-00', '25885', '', '127', '700', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '993', '1001', 'pending'), 
('3963', '2021-06-21', '0000-00-00', '51269', '', '127', '700', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '994', '1001', 'pending'), 
('3964', '2021-06-21', '0000-00-00', '43817', '', '128', '719', '', '6', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '995', '14', 'pending'), 
('3965', '2021-06-21', '0000-00-00', '43817', '', '128', '724', '', '6', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '995', '14', 'pending'), 
('3966', '2021-06-21', '0000-00-00', '97285', '', '130', '730', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '996', '14', 'pending'), 
('3967', '2021-06-21', '0000-00-00', '97285', '', '130', '725', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '996', '14', 'pending'), 
('3968', '2021-06-21', '0000-00-00', '43773', '', '135', '735', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '997', '14', 'pending'), 
('3970', '2021-06-22', '0000-00-00', '17131', '', '128', '719', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '999', '14', 'pending'), 
('3971', '2021-06-22', '0000-00-00', '95041', '', '128', '719', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '1000', '14', 'pending'), 
('3972', '2021-06-22', '0000-00-00', '95041', '', '127', '700', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '1000', '14', 'pending'), 
('3973', '2021-06-22', '0000-00-00', '95041', '', '127', '707', '', '6', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '1000', '14', 'pending'), 
('3974', '2021-06-22', '0000-00-00', '26074', '', '136', '736', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1001', '14', 'pending'), 
('3975', '2021-06-22', '0000-00-00', '94565', '', '137', '737', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1002', '14', 'pending'), 
('3976', '2021-06-23', '0000-00-00', '86763', '', '128', '719', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '1003', '14', 'pending'), 
('3977', '2021-06-23', '0000-00-00', '86763', '', '127', '700', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '1003', '14', 'pending'), 
('3978', '2021-06-23', '0000-00-00', '86763', '', '127', '707', '', '6', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '1003', '14', 'pending'), 
('3979', '2021-06-23', '0000-00-00', '93434', '', '127', '700', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '1004', '14', 'pending'), 
('3980', '2021-06-23', '0000-00-00', '93434', '', '127', '707', '', '6', '12', '', '', '', '0', '0.00', '', '0.00', '0.00', '1004', '14', 'pending'), 
('3981', '2021-06-23', '0000-00-00', '78529', '', '127', '700', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '1005', '14', 'pending'), 
('3982', '2021-06-23', '0000-00-00', '78529', '', '127', '707', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '1005', '14', 'pending'), 
('3983', '2021-06-23', '0000-00-00', '78529', '', '127', '717', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '1005', '14', 'pending'), 
('3984', '2021-06-23', '0000-00-00', '78529', '', '128', '719', '', '17', '13', '', '', '', '0', '0.00', '', '0.00', '0.00', '1005', '14', 'pending'), 
('3985', '2021-06-23', '0000-00-00', '36884', '', '128', '719', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '1006', '14', 'pending'), 
('3986', '2021-06-23', '0000-00-00', '36884', '', '127', '700', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '1006', '14', 'pending'), 
('3987', '2021-06-23', '0000-00-00', '36884', '', '127', '707', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '1006', '14', 'pending'), 
('3988', '2021-06-23', '0000-00-00', '36884', '', '127', '718', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '1006', '14', 'pending'), 
('3989', '2021-06-23', '0000-00-00', '36884', '', '127', '708', '', '17', '10', '', '', '', '0', '0.00', '', '0.00', '0.00', '1006', '14', 'pending'), 
('3990', '2021-06-23', '0000-00-00', '99712', '', '128', '719', '', '15', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '1007', '14', 'pending'), 
('3991', '2021-06-23', '0000-00-00', '99712', '', '127', '700', '', '15', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '1007', '14', 'pending'), 
('3992', '2021-06-23', '0000-00-00', '99712', '', '35', '107', '', '15', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '1007', '14', 'pending'), 
('3993', '2021-06-23', '0000-00-00', '99712', '', '127', '713', '', '15', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '1007', '14', 'pending'), 
('3994', '2021-06-24', '0000-00-00', '19263', '', '130', '730', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1008', '14', 'pending'), 
('3995', '2021-06-26', '0000-00-00', '93941', '', '128', '719', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1009', '14', 'pending'), 
('3996', '2021-06-26', '0000-00-00', '93941', '', '137', '737', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1009', '14', 'pending'), 
('3997', '2021-06-26', '0000-00-00', '93941', '', '135', '735', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1009', '14', 'pending'), 
('3998', '2021-06-26', '0000-00-00', '96097', '', '128', '738', '', '6', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1010', '14', 'pending'), 
('3999', '2021-06-26', '0000-00-00', '91067', '', '128', '721', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '1011', '14', 'pending'), 
('4000', '2021-06-26', '0000-00-00', '53378', '', '127', '700', '', '10', '8', '', '', '', '0', '0.00', '', '0.00', '0.00', '1012', '1001', 'pending'), 
('4001', '2021-06-26', '0000-00-00', '57911', '', '132', '739', '', '17', '14', '', '', '', '0', '0.00', '', '0.00', '0.00', '1013', '14', 'pending'), 
('4002', '2021-06-26', '0000-00-00', '57911', '', '132', '740', '', '17', '14', '', '', '', '0', '0.00', '', '0.00', '0.00', '1013', '14', 'pending'), 
('4003', '2021-06-26', '0000-00-00', '57911', '', '132', '748', '', '17', '14', '', '', '', '0', '0.00', '', '0.00', '0.00', '1013', '14', 'pending'), 
('4004', '2021-06-26', '0000-00-00', '57911', '', '132', '746', '', '17', '14', '', '', '', '0', '0.00', '', '0.00', '0.00', '1013', '14', 'pending'), 
('4005', '2021-06-26', '0000-00-00', '57911', '', '132', '744', '', '17', '14', '', '', '', '0', '0.00', '', '0.00', '0.00', '1013', '14', 'pending'), 
('4006', '2021-06-26', '0000-00-00', '57911', '', '35', '107', '', '17', '14', '', '', '', '0', '0.00', '', '0.00', '0.00', '1013', '14', 'pending'), 
('4007', '2021-06-26', '0000-00-00', '57911', '', '132', '745', '', '17', '14', '', '', '', '0', '0.00', '', '0.00', '0.00', '1013', '14', 'pending'), 
('4008', '2021-06-26', '0000-00-00', '43195', '', '127', '713', '', '10', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1014', '14', 'pending'), 
('4009', '2021-06-26', '0000-00-00', '75252', '', '128', '738', '', '10', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1015', '14', 'pending'), 
('4010', '2021-06-26', '0000-00-00', '76288', '', '130', '749', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '1016', '14', 'pending'), 
('4011', '2021-06-26', '0000-00-00', '35289', '', '130', '762', '', '17', '14', '', '', '', '0', '0.00', '', '0.00', '0.00', '1017', '14', 'pending'), 
('4016', '2021-06-26', '0000-00-00', '95564', '', '136', '736', '', '17', '15', '', '', '', '0', '0.00', '', '0.00', '0.00', '1022', '14', 'pending'), 
('4017', '2021-06-26', '0000-00-00', '80044', '', '127', '703', '', '10', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1023', '14', 'pending'), 
('4022', '2021-06-26', '0000-00-00', '30714', '', '130', '768', '', '10', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '1025', '1001', 'pending'), 
('4023', '2021-06-26', '0000-00-00', '30714', '', '130', '769', '', '10', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '1025', '1001', 'pending'), 
('4024', '2021-06-26', '0000-00-00', '30714', '', '130', '770', '', '10', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '1025', '1001', 'pending'), 
('4025', '2021-06-26', '0000-00-00', '46227', '', '135', '735', '', '10', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '1026', '14', 'pending'), 
('4026', '2021-06-26', '0000-00-00', '46227', '', '136', '736', '', '10', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '1026', '14', 'pending'), 
('4027', '2021-06-26', '0000-00-00', '46227', '', '137', '737', '', '10', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '1026', '14', 'pending'), 
('4028', '2021-06-26', '0000-00-00', '46227', '', '128', '719', '', '10', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '1026', '14', 'pending'), 
('4029', '2021-06-26', '0000-00-00', '46227', '', '127', '700', '', '10', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '1026', '14', 'pending'), 
('4030', '2021-06-26', '0000-00-00', '46227', '', '127', '707', '', '10', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '1026', '14', 'pending'), 
('4031', '2021-06-26', '0000-00-00', '46227', '', '127', '709', '', '10', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '1026', '14', 'pending'), 
('4032', '2021-06-27', '0000-00-00', '44625', '', '137', '737', '', '17', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '1027', '14', 'pending'), 
('4033', '2021-06-27', '0000-00-00', '75043', '', '127', '713', '', '10', '14', '', '', '', '0', '0.00', '', '0.00', '0.00', '1028', '14', 'pending'), 
('4034', '2021-06-27', '0000-00-00', '75043', '', '130', '749', '', '10', '14', '', '', '', '0', '0.00', '', '0.00', '0.00', '1028', '14', 'pending'), 
('4035', '2021-06-27', '0000-00-00', '75251', '', '128', '719', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1029', '14', 'pending'), 
('4036', '2021-06-27', '0000-00-00', '75251', '', '127', '718', '', '17', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1029', '14', 'pending'), 
('4037', '2021-06-27', '0000-00-00', '20362', '', '127', '700', '', '19', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '1030', '1001', 'pending'), 
('4038', '2021-06-27', '0000-00-00', '20362', '', '127', '701', '', '19', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '1030', '1001', 'pending'), 
('4039', '2021-06-27', '0000-00-00', '20362', '', '127', '702', '', '19', '4', '', '', '', '0', '0.00', '', '0.00', '0.00', '1030', '1001', 'pending'), 
('4040', '2021-06-27', '0000-00-00', '63329', '', '130', '725', '', '17', '9', '', '', '', '0', '0.00', '', '0.00', '0.00', '1031', '14', 'pending'), 
('4041', '2021-06-27', '0000-00-00', '18012', '', '128', '775', '', '17', '14', '', '', '', '0', '0.00', '', '0.00', '0.00', '1032', '14', 'pending'), 
('4042', '2021-06-27', '0000-00-00', '30369', '', '127', '712', '', '17', '16', '', '', '', '0', '0.00', '', '0.00', '0.00', '1033', '14', 'pending'), 
('4043', '2021-06-27', '0000-00-00', '38030', '', '137', '737', '', '17', '1', '', '', '', '0', '0.00', '', '0.00', '0.00', '1034', '1001', 'pending'), 
('4044', '2021-06-27', '0000-00-00', '11880', '', '136', '736', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1035', '14', 'pending'), 
('4045', '2021-06-27', '0000-00-00', '11880', '', '130', '731', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1035', '14', 'pending'), 
('4046', '2021-06-27', '0000-00-00', '77760', '', '130', '749', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1036', '14', 'pending'), 
('4047', '2021-06-27', '0000-00-00', '93620', '', '128', '787', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1037', '14', 'pending'), 
('4048', '2021-06-27', '0000-00-00', '95486', '', '127', '700', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1038', '14', 'pending'), 
('4049', '2021-06-27', '0000-00-00', '95486', '', '127', '703', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1038', '14', 'pending'), 
('4050', '2021-06-27', '0000-00-00', '95486', '', '127', '718', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1038', '14', 'pending'), 
('4051', '2021-06-27', '0000-00-00', '95486', '', '127', '712', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1038', '14', 'pending'), 
('4052', '2021-06-27', '0000-00-00', '95486', '', '127', '707', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1038', '14', 'pending'), 
('4053', '2021-06-27', '0000-00-00', '95486', '', '127', '705', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1038', '14', 'pending'), 
('4054', '2021-06-27', '0000-00-00', '95486', '', '127', '701', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1038', '14', 'pending'), 
('4055', '2021-06-27', '0000-00-00', '95486', '', '127', '780', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1038', '14', 'pending'), 
('4056', '2021-06-27', '0000-00-00', '95486', '', '127', '777', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1038', '14', 'pending'), 
('4057', '2021-06-27', '0000-00-00', '95486', '', '127', '778', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1038', '14', 'pending'), 
('4058', '2021-06-27', '0000-00-00', '93663', '', '137', '737', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1039', '14', 'pending'), 
('4059', '2021-06-27', '0000-00-00', '25442', '', '128', '787', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1040', '14', 'pending'), 
('4060', '2021-06-27', '0000-00-00', '19552', '', '128', '719', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1041', '14', 'pending'), 
('4061', '2021-06-27', '0000-00-00', '51328', '', '127', '701', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1042', '14', 'pending'), 
('4062', '2021-06-27', '0000-00-00', '51328', '', '127', '702', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1042', '14', 'pending'), 
('4063', '2021-06-27', '0000-00-00', '87887', '', '127', '701', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1043', '14', 'pending'), 
('4064', '2021-06-27', '0000-00-00', '26463', '', '128', '787', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1044', '14', 'pending'), 
('4065', '2021-06-27', '0000-00-00', '26463', '', '127', '700', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1044', '14', 'pending'), 
('4066', '2021-06-27', '0000-00-00', '26463', '', '127', '713', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1044', '14', 'pending'), 
('4067', '2021-06-27', '0000-00-00', '26463', '', '127', '707', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1044', '14', 'pending'), 
('4068', '2021-06-27', '0000-00-00', '26463', '', '127', '704', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1044', '14', 'pending'), 
('4069', '2021-06-27', '0000-00-00', '26463', '', '127', '776', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1044', '14', 'pending'), 
('4070', '2021-06-27', '0000-00-00', '26463', '', '135', '735', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1044', '14', 'pending'), 
('4071', '2021-06-28', '0000-00-00', '79246', '', '128', '719', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1045', '1001', 'pending'), 
('4072', '2021-06-28', '0000-00-00', '79246', '', '128', '787', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1045', '1001', 'pending'), 
('4073', '2021-06-28', '0000-00-00', '95632', '', '128', '719', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1046', '1001', 'pending'), 
('4074', '2021-06-28', '0000-00-00', '95632', '', '128', '787', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1046', '1001', 'pending'), 
('4075', '2021-06-28', '0000-00-00', '60316', '', '127', '709', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1047', '1001', 'pending'), 
('4076', '2021-06-28', '0000-00-00', '22247', '', '130', '764', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1048', '14', 'pending'), 
('4077', '2021-06-28', '0000-00-00', '18965', '', '135', '788', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1049', '14', 'pending'), 
('4078', '2021-06-28', '0000-00-00', '36887', '', '128', '719', '', '112', '44', '', '', '', '0', '0.00', 'sdfsdfsdfsdfsdfsdfsdfsdfsdfsdfsdfsdfsdfsdfsdfsdfsdfsdf', '0.00', '0.00', '1050', '1001', 'pending'), 
('4079', '2021-06-28', '0000-00-00', '78841', '', '128', '719', '', '112', '44', '', '', '', '0', '0.00', 'It is a long established fact that a reader will be distracted by the readable content of', '0.00', '0.00', '1051', '1001', 'pending'), 
('4080', '2021-06-28', '0000-00-00', '32273', '', '130', '729', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1052', '14', 'pending'), 
('4081', '2021-06-28', '0000-00-00', '32273', '', '130', '734', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1052', '14', 'pending'), 
('4082', '2021-06-28', '0000-00-00', '32273', '', '130', '730', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1052', '14', 'pending'), 
('4083', '2021-06-28', '0000-00-00', '32273', '', '130', '732', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1052', '14', 'pending'), 
('4084', '2021-06-28', '0000-00-00', '32273', '', '130', '728', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1052', '14', 'pending'), 
('4085', '2021-06-28', '0000-00-00', '32273', '', '130', '727', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1052', '14', 'pending'), 
('4086', '2021-06-28', '0000-00-00', '32273', '', '130', '726', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1052', '14', 'pending'), 
('4087', '2021-06-28', '0000-00-00', '71511', '', '127', '700', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1053', '1001', 'pending'), 
('4088', '2021-06-28', '0000-00-00', '71511', '', '127', '703', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1053', '1001', 'pending'), 
('4089', '2021-06-28', '0000-00-00', '84158', '', '137', '737', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1054', '14', 'pending'), 
('4090', '2021-06-28', '0000-00-00', '84158', '', '136', '736', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1054', '14', 'pending'), 
('4091', '2021-06-28', '0000-00-00', '84158', '', '135', '735', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1054', '14', 'pending'), 
('4092', '2021-06-29', '0000-00-00', '46335', '', '127', '713', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1055', '14', 'pending'), 
('4093', '2021-06-30', '0000-00-00', '73021', '', '128', '719', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1056', '14', 'pending'), 
('4094', '2021-06-30', '0000-00-00', '73021', '', '127', '700', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1056', '14', 'pending'), 
('4095', '2021-06-30', '0000-00-00', '73021', '', '127', '707', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1056', '14', 'pending'), 
('4096', '2021-07-03', '0000-00-00', '25344', '', '128', '719', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1057', '14', 'pending'), 
('4097', '2021-07-03', '0000-00-00', '25344', '', '127', '700', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1057', '14', 'pending'), 
('4098', '2021-07-03', '0000-00-00', '25344', '', '127', '718', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1057', '14', 'pending'), 
('4099', '2021-07-07', '0000-00-00', '92108', '', '128', '719', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1058', '14', 'pending'), 
('4100', '2021-07-07', '0000-00-00', '92108', '', '127', '707', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1058', '14', 'pending'), 
('4101', '2021-07-07', '0000-00-00', '92108', '', '127', '700', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1058', '14', 'pending'), 
('4102', '2021-07-07', '0000-00-00', '92108', '', '127', '706', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1058', '14', 'pending'), 
('4103', '2021-07-07', '0000-00-00', '92108', '', '130', '725', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1058', '14', 'pending'), 
('4104', '2021-07-07', '0000-00-00', '92108', '', '130', '731', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1058', '14', 'pending'), 
('4105', '2021-07-07', '0000-00-00', '92108', '', '130', '733', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1058', '14', 'pending'), 
('4106', '2021-07-07', '0000-00-00', '92108', '', '130', '730', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1058', '14', 'pending'), 
('4107', '2021-07-16', '0000-00-00', '98976', '', '127', '706', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1059', '14', 'pending'), 
('4108', '2021-07-16', '0000-00-00', '98976', '', '127', '707', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1059', '14', 'pending'), 
('4109', '2021-07-16', '0000-00-00', '98976', '', '127', '708', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1059', '14', 'pending'), 
('4110', '2021-07-16', '0000-00-00', '98976', '', '127', '718', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1059', '14', 'pending'), 
('4111', '2021-07-24', '0000-00-00', '80904', '', '128', '719', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1060', '14', 'pending'), 
('4112', '2021-07-24', '0000-00-00', '80904', '', '127', '700', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1060', '14', 'pending'), 
('4113', '2021-07-24', '0000-00-00', '80904', '', '127', '707', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1060', '14', 'pending'), 
('4114', '2021-07-24', '0000-00-00', '80904', '', '127', '718', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1060', '14', 'pending'), 
('4115', '2021-07-30', '0000-00-00', '11158', '', '127', '705', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1062', '14', 'pending'), 
('4116', '2021-07-30', '0000-00-00', '11158', '', '127', '700', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1062', '14', 'pending'), 
('4117', '2021-07-30', '0000-00-00', '11158', '', '127', '707', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1062', '14', 'pending'), 
('4118', '2021-07-30', '0000-00-00', '11158', '', '127', '709', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1062', '14', 'pending'), 
('4119', '2021-08-03', '0000-00-00', '89478', '', '128', '719', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1063', '15', 'pending'), 
('4120', '2021-08-03', '0000-00-00', '18901', '', '141', '790', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1064', '15', 'pending'), 
('4121', '2021-08-03', '0000-00-00', '67800', '', '141', '790', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1065', '15', 'pending'), 
('4122', '2021-08-03', '0000-00-00', '67800', '', '141', '806', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1065', '15', 'pending'), 
('4123', '2021-08-03', '0000-00-00', '67800', '', '141', '810', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1065', '15', 'pending'), 
('4124', '2021-08-03', '0000-00-00', '67800', '', '141', '811', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1065', '15', 'pending'), 
('4125', '2021-08-03', '0000-00-00', '67800', '', '141', '800', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1065', '15', 'pending'), 
('4126', '2021-08-04', '0000-00-00', '92745', '', '141', '797', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1066', '15', 'pending'), 
('4127', '2021-08-04', '0000-00-00', '92745', '', '141', '790', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1066', '15', 'pending'), 
('4128', '2021-08-04', '0000-00-00', '22919', '', '141', '792', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1067', '15', 'pending'), 
('4129', '2021-08-04', '0000-00-00', '22919', '', '141', '797', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1067', '15', 'pending'), 
('4130', '2021-08-04', '0000-00-00', '35418', '', '135', '822', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1068', '15', 'pending'), 
('4131', '2021-08-04', '0000-00-00', '35418', '', '137', '879', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1068', '15', 'pending'), 
('4132', '2021-08-04', '0000-00-00', '35418', '', '141', '805', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1068', '15', 'pending'), 
('4133', '2021-08-04', '0000-00-00', '35418', '', '141', '810', '', '112', '44', '', '', '', '0', '0.00', '', '0.00', '0.00', '1068', '15', 'pending'), 
('4134', '2021-08-04', '0000-00-00', '22083', '', '141', '800', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1069', '15', 'pending'), 
('4135', '2021-08-04', '0000-00-00', '22083', '', '141', '798', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1069', '15', 'pending'), 
('4136', '2021-08-04', '0000-00-00', '22083', '', '141', '799', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1069', '15', 'pending'), 
('4137', '2021-08-04', '0000-00-00', '28258', '', '141', '790', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1070', '15', 'pending'), 
('4138', '2021-08-04', '0000-00-00', '38468', '', '141', '792', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1071', '15', 'pending'), 
('4139', '2021-08-04', '0000-00-00', '38468', '', '141', '797', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1071', '15', 'pending'), 
('4140', '2021-08-04', '0000-00-00', '74695', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1072', '15', 'pending'), 
('4141', '2021-08-04', '0000-00-00', '74695', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1072', '15', 'pending'), 
('4142', '2021-08-05', '0000-00-00', '24101', '', '141', '805', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1073', '15', 'pending'), 
('4143', '2021-08-05', '0000-00-00', '68429', '', '141', '804', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1074', '15', 'pending'), 
('4144', '2021-08-05', '0000-00-00', '87671', '', '141', '807', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1075', '15', 'pending'), 
('4145', '2021-08-05', '0000-00-00', '87671', '', '141', '804', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1075', '15', 'pending'), 
('4146', '2021-08-05', '0000-00-00', '26128', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1076', '15', 'pending'), 
('4147', '2021-08-05', '0000-00-00', '26128', '', '141', '797', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1076', '15', 'pending'), 
('4148', '2021-08-08', '0000-00-00', '13056', '', '141', '790', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1077', '15', 'pending'), 
('4149', '2021-08-08', '0000-00-00', '13056', '', '141', '799', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1077', '15', 'pending'), 
('4150', '2021-08-08', '0000-00-00', '13056', '', '141', '802', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1077', '15', 'pending'), 
('4151', '2021-08-08', '0000-00-00', '12353', '', '141', '807', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1078', '15', 'pending'), 
('4152', '2021-08-08', '0000-00-00', '80401', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1079', '15', 'pending'), 
('4153', '2021-08-08', '0000-00-00', '80401', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1079', '15', 'pending'), 
('4154', '2021-08-08', '0000-00-00', '80401', '', '141', '797', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1079', '15', 'pending'), 
('4155', '2021-08-08', '0000-00-00', '46514', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1080', '15', 'pending'), 
('4156', '2021-08-08', '0000-00-00', '46514', '', '141', '811', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1080', '15', 'pending'), 
('4157', '2021-08-08', '0000-00-00', '46514', '', '141', '797', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1080', '15', 'pending'), 
('4158', '2021-08-08', '0000-00-00', '80492', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1081', '15', 'pending'), 
('4159', '2021-08-08', '0000-00-00', '80492', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1081', '15', 'pending'), 
('4160', '2021-08-08', '0000-00-00', '66673', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1082', '15', 'pending'), 
('4161', '2021-08-08', '0000-00-00', '66673', '', '141', '812', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1082', '15', 'pending'), 
('4162', '2021-08-08', '0000-00-00', '65055', '', '141', '805', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1083', '15', 'pending'), 
('4163', '2021-08-08', '0000-00-00', '65055', '', '135', '822', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1083', '15', 'pending'), 
('4164', '2021-08-08', '0000-00-00', '91598', '', '141', '805', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1084', '15', 'pending'), 
('4165', '2021-08-08', '0000-00-00', '91598', '', '141', '810', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1084', '15', 'pending'), 
('4166', '2021-08-08', '0000-00-00', '91598', '', '141', '811', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1084', '15', 'pending'), 
('4167', '2021-08-08', '0000-00-00', '91598', '', '135', '822', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1084', '15', 'pending'), 
('4168', '2021-08-08', '0000-00-00', '55517', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1085', '15', 'pending'), 
('4169', '2021-08-08', '0000-00-00', '55517', '', '141', '811', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1085', '15', 'pending'), 
('4170', '2021-08-08', '0000-00-00', '55517', '', '141', '818', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1085', '15', 'pending'), 
('4171', '2021-08-08', '0000-00-00', '55517', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1085', '15', 'pending'), 
('4172', '2021-08-08', '0000-00-00', '56137', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1086', '15', 'pending'), 
('4173', '2021-08-08', '0000-00-00', '56137', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1086', '15', 'pending'), 
('4174', '2021-08-08', '0000-00-00', '17986', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1087', '15', 'pending'), 
('4175', '2021-08-08', '0000-00-00', '17986', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1087', '15', 'pending'), 
('4176', '2021-08-08', '0000-00-00', '17986', '', '141', '811', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1087', '15', 'pending'), 
('4177', '2021-08-08', '0000-00-00', '17986', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1087', '15', 'pending'), 
('4178', '2021-08-08', '0000-00-00', '92556', '', '141', '898', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1088', '15', 'pending'), 
('4179', '2021-08-08', '0000-00-00', '92556', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1088', '15', 'pending'), 
('4180', '2021-08-08', '0000-00-00', '20496', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1089', '15', 'pending'), 
('4181', '2021-08-08', '0000-00-00', '20496', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1089', '15', 'pending'), 
('4182', '2021-08-08', '0000-00-00', '88070', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1090', '15', 'pending'), 
('4183', '2021-08-08', '0000-00-00', '88070', '', '141', '810', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1090', '15', 'pending'), 
('4184', '2021-08-08', '0000-00-00', '88070', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1090', '15', 'pending'), 
('4185', '2021-08-08', '0000-00-00', '67139', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1091', '15', 'pending'), 
('4186', '2021-08-08', '0000-00-00', '67139', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1091', '15', 'pending'), 
('4187', '2021-08-08', '0000-00-00', '53204', '', '141', '807', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1092', '15', 'pending'), 
('4188', '2021-08-08', '0000-00-00', '63524', '', '141', '805', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1093', '15', 'pending'), 
('4189', '2021-08-08', '0000-00-00', '60353', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1094', '15', 'pending'), 
('4190', '2021-08-08', '0000-00-00', '40846', '', '141', '898', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1095', '15', 'pending'), 
('4191', '2021-08-08', '0000-00-00', '40846', '', '141', '804', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1095', '15', 'pending'), 
('4192', '2021-08-08', '0000-00-00', '40846', '', '135', '822', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1095', '15', 'pending'), 
('4193', '2021-08-08', '0000-00-00', '92952', '', '141', '805', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1096', '15', 'pending'), 
('4194', '2021-08-08', '0000-00-00', '51278', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1097', '15', 'pending'), 
('4195', '2021-08-08', '0000-00-00', '51278', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1097', '15', 'pending'), 
('4196', '2021-08-08', '0000-00-00', '51278', '', '141', '800', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1097', '15', 'pending'), 
('4197', '2021-08-08', '0000-00-00', '51278', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1097', '15', 'pending'), 
('4198', '2021-08-08', '0000-00-00', '51278', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1097', '15', 'pending'), 
('4199', '2021-08-08', '0000-00-00', '57387', '', '141', '898', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1098', '15', 'pending'), 
('4200', '2021-08-08', '0000-00-00', '57387', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1098', '15', 'pending'), 
('4201', '2021-08-08', '0000-00-00', '57387', '', '141', '811', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1098', '15', 'pending'), 
('4202', '2021-08-08', '0000-00-00', '84910', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1099', '15', 'pending'), 
('4203', '2021-08-08', '0000-00-00', '84910', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1099', '15', 'pending'), 
('4204', '2021-08-08', '0000-00-00', '19404', '', '141', '792', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1100', '15', 'pending'), 
('4205', '2021-08-08', '0000-00-00', '19404', '', '141', '805', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1100', '15', 'pending'), 
('4206', '2021-08-08', '0000-00-00', '19404', '', '135', '822', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1100', '15', 'pending'), 
('4207', '2021-08-08', '0000-00-00', '38795', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1101', '15', 'pending'), 
('4208', '2021-08-08', '0000-00-00', '38795', '', '141', '797', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1101', '15', 'pending'), 
('4209', '2021-08-08', '0000-00-00', '26724', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1102', '15', 'pending'), 
('4210', '2021-08-08', '0000-00-00', '26724', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1102', '15', 'pending'), 
('4211', '2021-08-08', '0000-00-00', '44737', '', '141', '790', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1103', '15', 'pending'), 
('4212', '2021-08-08', '0000-00-00', '44737', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1103', '15', 'pending'), 
('4213', '2021-08-08', '0000-00-00', '44737', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1103', '15', 'pending'), 
('4214', '2021-08-08', '0000-00-00', '44737', '', '142', '823', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1103', '15', 'pending'), 
('4215', '2021-08-08', '0000-00-00', '71962', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1104', '15', 'pending'), 
('4216', '2021-08-08', '0000-00-00', '71962', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1104', '15', 'pending'), 
('4217', '2021-08-08', '0000-00-00', '71962', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1104', '15', 'pending'), 
('4218', '2021-08-08', '0000-00-00', '71962', '', '141', '800', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1104', '15', 'pending'), 
('4219', '2021-08-08', '0000-00-00', '71962', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1104', '15', 'pending'), 
('4220', '2021-08-08', '0000-00-00', '19685', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1105', '15', 'pending'), 
('4221', '2021-08-08', '0000-00-00', '19685', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1105', '15', 'pending'), 
('4222', '2021-08-08', '0000-00-00', '19685', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1105', '15', 'pending'), 
('4223', '2021-08-08', '0000-00-00', '87191', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1106', '15', 'pending'), 
('4224', '2021-08-08', '0000-00-00', '87191', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1106', '15', 'pending'), 
('4225', '2021-08-08', '0000-00-00', '87191', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1106', '15', 'pending'), 
('4226', '2021-08-09', '0000-00-00', '45531', '', '141', '805', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1107', '15', 'pending'), 
('4227', '2021-08-09', '0000-00-00', '45531', '', '141', '804', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1107', '15', 'pending'), 
('4228', '2021-08-10', '0000-00-00', '12761', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1108', '15', 'pending'), 
('4229', '2021-08-10', '0000-00-00', '12761', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1108', '15', 'pending'), 
('4230', '2021-08-10', '0000-00-00', '27939', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1109', '15', 'pending'), 
('4231', '2021-08-10', '0000-00-00', '27939', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1109', '15', 'pending'), 
('4232', '2021-08-10', '0000-00-00', '27939', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1109', '15', 'pending'), 
('4233', '2021-08-10', '0000-00-00', '27939', '', '141', '800', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1109', '15', 'pending'), 
('4234', '2021-08-10', '0000-00-00', '51442', '', '141', '805', '', '112', '49', '', '', '', '0', '0.00', '', '0.00', '0.00', '1110', '15', 'pending'), 
('4235', '2021-08-10', '0000-00-00', '23381', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1111', '15', 'pending'), 
('4236', '2021-08-10', '0000-00-00', '73086', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1112', '15', 'pending'), 
('4237', '2021-08-10', '0000-00-00', '80864', '', '141', '805', '', '112', '49', '', '', '', '0', '0.00', '', '0.00', '0.00', '1113', '15', 'pending'), 
('4238', '2021-08-10', '0000-00-00', '80864', '', '141', '810', '', '112', '49', '', '', '', '0', '0.00', '', '0.00', '0.00', '1113', '15', 'pending'), 
('4239', '2021-08-10', '0000-00-00', '80864', '', '135', '822', '', '112', '49', '', '', '', '0', '0.00', '', '0.00', '0.00', '1113', '15', 'pending'), 
('4240', '2021-08-10', '0000-00-00', '39375', '', '141', '805', '', '112', '49', '', '', '', '0', '0.00', '', '0.00', '0.00', '1114', '15', 'pending'), 
('4241', '2021-08-10', '0000-00-00', '55727', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1115', '15', 'pending'), 
('4242', '2021-08-10', '0000-00-00', '14027', '', '135', '822', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1116', '15', 'pending'), 
('4243', '2021-08-10', '0000-00-00', '98622', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1117', '15', 'pending'), 
('4244', '2021-08-10', '0000-00-00', '98622', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1117', '15', 'pending'), 
('4245', '2021-08-10', '0000-00-00', '98622', '', '141', '810', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1117', '15', 'pending'), 
('4246', '2021-08-10', '0000-00-00', '98622', '', '139', '880', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1117', '15', 'pending'), 
('4247', '2021-08-10', '0000-00-00', '89487', '', '141', '790', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1118', '15', 'pending'), 
('4248', '2021-08-10', '0000-00-00', '89487', '', '141', '793', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1118', '15', 'pending'), 
('4249', '2021-08-10', '0000-00-00', '89487', '', '141', '801', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1118', '15', 'pending'), 
('4250', '2021-08-10', '0000-00-00', '89487', '', '141', '799', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1118', '15', 'pending'), 
('4251', '2021-08-10', '0000-00-00', '89487', '', '139', '887', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1118', '15', 'pending'), 
('4252', '2021-08-10', '0000-00-00', '89487', '', '138', '854', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1118', '15', 'pending'), 
('4253', '2021-08-11', '0000-00-00', '72160', '', '141', '807', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1119', '15', 'pending'), 
('4254', '2021-08-11', '0000-00-00', '87927', '', '141', '800', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1120', '15', 'pending'), 
('4256', '2021-08-11', '0000-00-00', '83705', '', '141', '899', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1122', '15', 'pending'), 
('4257', '2021-08-11', '0000-00-00', '14836', '', '141', '899', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1123', '15', 'pending'), 
('4258', '2021-08-11', '0000-00-00', '51413', '', '143', '902', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1124', '15', 'pending'), 
('4259', '2021-08-11', '0000-00-00', '40360', '', '139', '880', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1125', '15', 'pending'), 
('4260', '2021-08-11', '0000-00-00', '12007', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1126', '15', 'pending'), 
('4261', '2021-08-11', '0000-00-00', '33490', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1127', '15', 'pending'), 
('4262', '2021-08-11', '0000-00-00', '85397', '', '139', '882', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1128', '15', 'pending'), 
('4263', '2021-08-11', '0000-00-00', '47245', '', '141', '811', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1129', '15', 'pending'), 
('4264', '2021-08-11', '0000-00-00', '47245', '', '141', '805', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1129', '15', 'pending'), 
('4266', '2021-08-11', '0000-00-00', '56857', '', '141', '807', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1131', '15', 'pending'), 
('4268', '2021-08-11', '0000-00-00', '47331', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1133', '15', 'pending'), 
('4269', '2021-08-11', '0000-00-00', '47331', '', '141', '804', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1133', '15', 'pending'), 
('4271', '2021-08-11', '0000-00-00', '51117', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1135', '15', 'pending'), 
('4272', '2021-08-11', '0000-00-00', '75723', '', '138', '840', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1136', '15', 'pending'), 
('4273', '2021-08-11', '0000-00-00', '78898', '', '139', '883', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1137', '15', 'pending'), 
('4274', '2021-08-11', '0000-00-00', '78898', '', '138', '827', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1137', '15', 'pending'), 
('4275', '2021-08-11', '0000-00-00', '78898', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1137', '15', 'pending'), 
('4276', '2021-08-11', '0000-00-00', '78898', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1137', '15', 'pending'), 
('4277', '2021-08-11', '0000-00-00', '01140', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1138', '15', 'pending'), 
('4278', '2021-08-11', '0000-00-00', '01140', '', '140', '876', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1138', '15', 'pending'), 
('4279', '2021-08-11', '0000-00-00', '01140', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1138', '15', 'pending'), 
('4280', '2021-08-11', '0000-00-00', '01140', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1138', '15', 'pending'), 
('4281', '2021-08-11', '0000-00-00', '01142', '', '139', '880', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1139', '15', 'pending'), 
('4282', '2021-08-11', '0000-00-00', '01142', '', '141', '804', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1139', '15', 'pending'), 
('4283', '2021-08-11', '0000-00-00', '01143', '', '138', '866', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1140', '15', 'pending'), 
('4285', '2021-08-11', '0000-00-00', '01145', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1142', '15', 'pending'), 
('4288', '2021-08-11', '0000-00-00', '01148', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1145', '15', 'pending'), 
('4289', '2021-08-11', '0000-00-00', '01148', '', '138', '853', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1145', '15', 'pending'), 
('4290', '2021-08-11', '0000-00-00', '01149', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1146', '15', 'pending'), 
('4291', '2021-08-11', '0000-00-00', '01149', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1146', '15', 'pending'), 
('4292', '2021-08-11', '0000-00-00', '01149', '', '139', '883', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1146', '15', 'pending'), 
('4293', '2021-08-11', '0000-00-00', '01149', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1146', '15', 'pending'), 
('4294', '2021-08-11', '0000-00-00', '01150', '', '141', '792', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1147', '15', 'pending'), 
('4295', '2021-08-11', '0000-00-00', '01150', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1147', '15', 'pending'), 
('4296', '2021-08-11', '0000-00-00', '01151', '', '139', '880', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1148', '15', 'pending'), 
('4297', '2021-08-11', '0000-00-00', '01152', '', '141', '791', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1149', '15', 'pending'), 
('4298', '2021-08-11', '0000-00-00', '01152', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1149', '15', 'pending'), 
('4299', '2021-08-11', '0000-00-00', '01153', '', '139', '882', '', '112', '54', '', '', '', '0', '0.00', '', '0.00', '0.00', '1150', '15', 'pending'), 
('4300', '2021-08-11', '0000-00-00', '01154', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1151', '15', 'pending'), 
('4301', '2021-08-11', '0000-00-00', '01154', '', '138', '828', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1151', '15', 'pending'), 
('4302', '2021-08-11', '0000-00-00', '01154', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1151', '15', 'pending'), 
('4303', '2021-08-11', '0000-00-00', '01154', '', '141', '797', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1151', '15', 'pending'), 
('4304', '2021-08-11', '0000-00-00', '01154', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1151', '15', 'pending'), 
('4305', '2021-08-11', '0000-00-00', '01154', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1151', '15', 'pending'), 
('4306', '2021-08-11', '0000-00-00', '01155', '', '139', '882', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1152', '15', 'pending'), 
('4307', '2021-08-11', '0000-00-00', '01156', '', '139', '881', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1153', '15', 'pending'), 
('4308', '2021-08-11', '0000-00-00', '01157', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1154', '15', 'pending'), 
('4309', '2021-08-11', '0000-00-00', '01158', '', '139', '880', '', '112', '54', '', '', '', '0', '0.00', '', '0.00', '0.00', '1155', '15', 'pending'), 
('4310', '2021-08-11', '0000-00-00', '01159', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1156', '15', 'pending'), 
('4311', '2021-08-11', '0000-00-00', '01160', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1157', '15', 'pending'), 
('4312', '2021-08-11', '0000-00-00', '01161', '', '141', '807', '', '112', '54', '', '', '', '0', '0.00', '', '0.00', '0.00', '1158', '15', 'pending'), 
('4313', '2021-08-11', '0000-00-00', '01162', '', '141', '807', '', '112', '54', '', '', '', '0', '0.00', '', '0.00', '0.00', '1159', '15', 'pending'), 
('4314', '2021-08-11', '0000-00-00', '01163', '', '141', '807', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1160', '15', 'pending'), 
('4315', '2021-08-11', '0000-00-00', '01164', '', '140', '876', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1161', '15', 'pending'), 
('4316', '2021-08-11', '0000-00-00', '01165', '', '140', '876', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1162', '15', 'pending'), 
('4317', '2021-08-11', '0000-00-00', '01166', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1163', '15', 'pending'), 
('4318', '2021-08-11', '0000-00-00', '01166', '', '141', '800', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1163', '15', 'pending'), 
('4319', '2021-08-11', '0000-00-00', '01166', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1163', '15', 'pending'), 
('4320', '2021-08-11', '0000-00-00', '01166', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1163', '15', 'pending'), 
('4321', '2021-08-11', '0000-00-00', '01166', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1163', '15', 'pending'), 
('4322', '2021-08-11', '0000-00-00', '01167', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1164', '15', 'pending'), 
('4323', '2021-08-11', '0000-00-00', '01168', '', '141', '791', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1165', '15', 'pending'), 
('4324', '2021-08-11', '0000-00-00', '01168', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1165', '15', 'pending'), 
('4325', '2021-08-11', '0000-00-00', '01168', '', '138', '843', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1165', '15', 'pending'), 
('4326', '2021-08-11', '0000-00-00', '01169', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1166', '15', 'pending'), 
('4327', '2021-08-11', '0000-00-00', '01169', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1166', '15', 'pending'), 
('4328', '2021-08-11', '0000-00-00', '01170', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1167', '15', 'pending'), 
('4329', '2021-08-11', '0000-00-00', '01170', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1167', '15', 'pending');  



INSERT INTO `doctor_payment` ( `id`, `date`, `doctor_id`, `total_paid`, `payment`, `less`, `due`, `trash`) VALUES 
('1', '2021-04-18', '2', '150.00', '100.00', '50.00', '300.00', '0'), 
('2', '2021-04-20', '2', '250.00', '100.00', '0.00', '700.00', '0'), 
('3', '2021-06-10', '42', '500.00', '500.00', '0.00', '-500.00', '0');  



INSERT INTO `doctors` ( `id`, `fullName`, `designation`, `degree`, `specialised`, `hospital`, `mobile`, `phone`, `email`, `fee`, `commission`, `address`, `image`, `room_no`, `status`) VALUES 
('1', 'Office', 'Office', '', 'N/A', '', '', '', '', '0.00', '', '', '', '', '0'), 
('2', 'Test Doctor', 'khkjh', 'MBBS', 'Medicine', 'hjkhjh', '01236547896', '45454', 'shfdhsfdh@gmil.com', '500.00', '40', 'dhfhsf', '', '205', '0'), 
('3', 'DR.MD.ABDUL MOJIT', 'SURGERY', 'MBBS.BCS(H)FCPS', 'CARDILOGY', 'MMCH', '01742556660', '', '', '0.00', '', '', '', '102', '0'), 
('4', 'DR.MD. SHOFIQUL  ISLAM', 'Asst_Professor', 'MBBS.(DHAKA)BCS(HEALTH)MS(GENERAL SURGERY)', '(SURGERY WORD)UNIT FAST', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('5', 'DR.MOHAMMED ZAKIR HOSSEN', 'SURGERY', 'MBBS.(DHAKA)FCPS(SUR)MRCS(ENGLAND)', 'SURGERY WORD', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('6', 'Dr. Md.Atikur Rahman', 'Consultent', 'MBBS,BCS(HEALTH), MD(MEDICINE)', 'Medicine Specialist', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('7', '22-04-19', 'sdfdaf', 'asdfda', 'safda', 'safa', '36987456321', '01856945621', 'rangdaanu@gmail.com', '10.00', '30', 'gds', '', '10', '0'), 
('8', 'Prof. Dr. Hajji Mohammad. Abdul Mansur', 'Professor', 'MBBS, MCPS, DCPS, DFM (BSMMU)', 'physiology', '', '', '', '', '0.00', '', '', '', '', '0'), 
('9', 'DR.MOHAMMAD SHAOWKAT ALI', 'ASSI.PRO.', 'MBBS.(DHAKA)BCS(H)MS(CHILD SURGERY)', 'CHILD SURGERY', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('10', 'DR.AM.AMINUL ISLAM', 'Asst_Professor', 'MBBS.(DU)MS(ORTHO SUR.)', 'ORTHOPEDICS SURGERY', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('11', 'DR.MOHAMMAD ULLAH SIMUL', 'CONSULTANT', 'MBBS.(DHAKA)BCS(HEALTH)D-ORTHO SURGERY', 'ORTHOPEDICES', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('12', 'DR.AFSANA ROWSAN', 'ASSI.PRO.', 'MBBS.FCPS(GYNEE)', 'GYNEE SURGERY', 'SHMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('13', 'DR.ROKSANA KARIM', 'ASSI.PRO.', 'MBBS.(DHAKA)PGT.DGU(DU)', 'LAPROSCOPY SURGON AND GYNEE SURGERY', 'MYMENSINGH', '', '', '', '0.00', '', '', '', '', '0'), 
('14', 'DR.A.F.M.AZIMUS SADAD(SUMON)', 'ASSI.PRO.', 'MBBS.(DHAKA)DVD(BSMMU)CCD(BARDEM)', 'DARMATO,KOSMETIC,SKIN,LEZAR SURGON', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('15', 'DR.BINOY KRISHNA BISWAS', 'Asst_Professor', 'MBBS.(DHAKA)DLO(DU)', 'DLO SURGERY', 'CBMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('16', 'DR. HEFJUL BARI KHAN', 'ASSI.PRO.', 'MBBS(D-U)DTCT(DU)', 'PHYSICOLOGY,HEAD,MEDICINE AJMA SPECIALIST', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('17', 'DR.MIR MD.MARUF HASAN', 'MEDICAL OFFICER', 'MBBS,(DU),DMU(BTIB)CCD,EDC(BARDEM)', 'DIABETICS', 'RHP&DS', '', '', '', '0.00', '', '', '', '', '0'), 
('18', 'DR.MOHAMMAD RUHUL AMIN(RAFIN)', 'ASSI.PRO.', 'MBBS(DMC)FCPS(MED)FCPS(GASTRO)', 'GASTROLIVER MEDICINE', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('19', 'DR.SAMIR KUMAR DAS', 'ASSI.PRO.', 'MBBS(DHAKA)BCS(HEALTH)FCPS(MED)FP MD(NEPROLOGY)', 'KIDNUY& MEDICINE SPECIALIST', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('20', 'DR.MD.SIDDIQUR RAHMAN', 'ASSI.PRO.', 'MBBS.(DHAKA)MS(UROLOGY)MRCS(ENLAND)', 'UROLOGY SURGON& CENCER SPECIALIST', 'CANCER INITUTE HOSPITAL DHAKA', '', '', '', '0.00', '', '', '', '', '0'), 
('21', 'DR. NUSRAT JAHAN', 'CONSULTANT CARDIOLOGY WORD', 'MBBS(DHAKA)D-CARD(DU)CCD(BARDEM)', 'MEDICINE& CARDIOLOGY SPECIALIST', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('22', 'DR. NUSRAT JAHAN', 'CONSULTANT CARDIOLOGY WORD', 'MBBS(DHAKA)D-CARD(DU)CCD(BARDEM)', 'MEDICINE& CARDIOLOGY SPECIALIST', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('23', 'DR.KHALEDA BEGUM(BRISTY)', 'CONSULTANT', 'MBBS.BCS(HEALTH)MCPS.FCPS.MD(CHILD)', 'CHILD SPECIALIST', 'BMDC', '', '', '', '0.00', '', '', '', '', '0'), 
('24', 'DR.Md.Shofiqul Islam', 'Asst_Professor', 'MBBS.BCS(HEALTH)PGT.MD(CARDIOLOGY)FCPS(MED)FP', 'CARDIOLOGY&MEDICINE', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('25', 'DR.M.A.BARI', 'PROFESSOR', 'MBBS.BCS(HEALTH)', 'CARDIOLOGY', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('26', 'DR.JAMAL UDDIN', 'PROFESSOR', 'MBBS.BCS.FCPS', 'SKIN SPECIALIST', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('27', 'DR. HAMIDA AKTER', 'PROFESSOR', 'MBBS.BCS.FCPS(GYNEE)', 'GYNEE& SURGERY', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('28', 'DR.NUSRAT JAHAN', 'Consultant', 'MBBS (Dhaka),D-Card (DU), CCD (Bardem)', 'Medicine & Cardiology', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('29', 'DR.KHALEDA BEGUM BRISTY', 'Consultant (Child)', 'MBBS,BCS (Health),MCPS,MD (Child)', 'Child & Adolescent', '', '', '', '', '0.00', '', '', '', '', '0'), 
('30', 'Dr. M.A Zamam', 'PROFESSOR', 'MBBS,BCS (Health) MCPS (Skin & VD) FCPS (Skin VD) Ex-Reg. (Medicin) Lecturer(Pharmcolpgy)', 'Skin & VD', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('31', 'Dr.Mohammad Rukunuzzaman', 'CONSULTANT', 'MBBS (MMC) BCS (Health) CCD (Birdem) C.M.U (Ultra) M.Phil (Thesis)', 'Ultra', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('32', 'Dr.Lobib Khan', 'REGISTER', 'MBBS,BCS(Health) DLO (BSMMU)', 'ENT', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('33', 'Dr.md. shofiqul islam', 'genarel surgery', 'mbbs.(dhaka)bcs(health)', 'associate profesor', 'mmch', '', '', '', '0.00', '', '', '', '', '0'), 
('34', 'DR.MD.HIKMAT ALI', 'ASSI.PRO.&HEAD OF DEPARTMENT', 'MBBS.(DHAKA)MD(CARDIOLOGY)', 'CARDIOLOGY', 'CTMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('35', 'Dr.Mohammad Al- Ujjol', 'Register', 'BUMS (DU)  CMU ,DMDS,DMF,MLOP CHW, PDT', 'Gynecology', '', '', '', '', '0.00', '', '', '', '', '0'), 
('36', 'DR.MD.HIKMOT ALI', 'ASSI.PRO.', 'MBBS.MD', 'CARDILOGY', 'CTMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('37', 'Dr.Lucky Rahaman', 'Assistant Professor', 'MBBS (Dhaka), MCPS,FCPS (Gynae & Obs), Special Training in Infertility.', 'Gynecology', 'Dhaka', '', '', '', '0.00', '', '', '', '', '0'), 
('38', 'Dr.Ashesh Kumar Roy', 'Consultant', 'MBBS DCH', '(Pediatrics) ', 'MMCH.', '', '', '', '0.00', '', '', '', '', '0'), 
('39', 'Dr.Md Akikul ISlam', 'Register', 'MBBS,BCS (Health), Fcps (Surgery)', 'Surgery', 'MMCH.', '', '', '', '0.00', '', '', '', '', '0'), 
('40', 'DR.A.K.M.NAJMUL HAQUE', 'CONSULTANT', 'MBBS.BCS(H)MS(ORTHO-SURGERY)', 'ORTHOPEDICS', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('41', 'DR.MD.KHURSED ALAM', 'ASSI.PRO. OF HEAD', 'MBBS.BCS(H)MD(MED)MACP(MED)', 'MEDICINE', 'MMCH', '', '', '', '0.00', '', '', '', '', '0'), 
('42', 'Md.Mahbubur Rahman', 'Asst_Professor', 'mbbs', '65413', 'Mymensingh medical ', '0564320', '42014204', 'e.hoque65@gmail.com', '600.00', '2', 'mymensingh', '', '106', '0'), 
('43', 'Romi', 'MBBS,MD', 'MBBS,MD', 'MBBS,MD', '', '01797548988', '', '', '0.00', '', '', '', '', '0'), 
('44', 'Test Dr ', 'Asst_Professor', 'MBBS,BCS,FCPS,MS,MD Mymensingh Medical College Hospital', 'MEdicine', '', '', '', '', '0.00', '', '', '', '', '0'), 
('45', 'Dr.Mohiuddin Ahmed Sumon', 'MBBS,PGT', 'MBBS,PGT', 'Medicine ', 'Talukdar clinic', '12345678910', '222', 'sumon@gmail.com', '300.00', '0', '0', '', '200', '1'), 
('46', 'Dr.Polash Datta', 'MBBS,BCS,CCD,MD,FCPS (MMCH)', 'MBBS,BCS,CCD,MD,FCPS (MMCH)', 'Kidney ,Heart,Medicine', 'MMCH', '10250265201', '22522', 'Polash@gmail.com', '500.00', '0', 'Mymensingh', '', '101', '1'), 
('47', 'Dr.Binoy Krishna Biswas', 'MBBS,DLO Associate Professor Dept of ENT(CBMCH)', 'MBBS,DLO Associate Professor Dept of ENT(CBMCH)', 'ENT', 'CBMCH', '12052360201', '22562', 'binoy@gmail.com', '600.00', '0', 'CBMCH', '', '102', '1'), 
('48', 'Dr.Naznin Akter Shewly', 'MBBS,BCS,MS', 'MBBS,BCS,MS', 'Synergy ', 'UHC', '20536505481', '225', 'shewly@gmail.com', '300.00', '0', 'UCH', '', '89', '1'), 
('49', 'Dr.Shofiqul Islam', 'MBBS,BCS,FCPS,MD (Cardiology)', 'MBBS,BCS,FCPS,MD (Cardiology)', 'Heart', 'MMCH', '10253620142', '22562', 'Shafiq@gmail.com', '500.00', '0', 'MMCH', '', '209', '1'), 
('50', 'Dr.Sekandar ALi', 'SMF,PC', 'SMF,PC', 'medicine', 'TCDC', '120562015203', '2562', 'sekandarali@gmail.com', '200.00', '0', '.', '', '2', '1'), 
('51', 'Dr.Porimol Kumar Paul', 'MBBS,BCS,PGT (Ortho )', 'MBBS,BCS,PGT (Ortho )', 'Orthopedics', 'DMCH', '12054602530', '2552', 'PKekandarali@gmail.com', '500.00', '0', '0', '', '205', '1'), 
('52', 'Dr.Azharul Islam', 'MBBS,BCS,MS,FCPS', 'MBBS,BCS,MS,FCPS', 'Surgery', 'MMCH', '12054236501', '2255', 'AZkandarali@gmail.com', '500.00', '0', '0', '', '206', '1'), 
('53', 'Dr.Azharul Islam Akhib', 'MBBS,PGT,( EYE  )', 'MBBS,PGT,( EYE  )', 'EYE', 'Dhopkhula', '12054265021', '22563', 'AAkandarali@gmail.com', '300.00', '0', '0', '', '208', '1'), 
('54', 'Self', '-', '-', 'Medicine ', '.', '12054256210', '22', 'sumon@gmail.com', '150.00', '0', '0', '', '201', '1');  



INSERT INTO `due_collection` ( `id`, `date`, `name`, `pid`, `admission_id`, `contact`, `amount`, `previous_paid`, `due`, `paid`) VALUES 
('1', '2021-04-24', 'Abdullah 1', '0', '1', '', '2000.00', '500.00', '1300.00', '200.00'), 
('2', '2021-06-10', 'Alamin', '0', '2', '0171354654', '50000.00', '20000.00', '10000.00', '20000.00');  



INSERT INTO `due_payment` ( `id`, `date`, `time`, `voucher_number`, `total_amount`, `prev_paid`, `prev_due`, `paid`, `due`, `user_id`, `remission`) VALUES 
('1', '2021-04-22', '04:56:25 PM', '2104220027', '1400.00', '0.00', '0.00', '1200.00', '0.00', '', '200.00'), 
('2', '2021-04-24', '11:51:30 PM', '2104240049', '400.00', '300.00', '0.00', '50.00', '50.00', '', '0.00'), 
('3', '2021-04-26', '02:42:30 PM', '2104260073', '1550.00', '0.00', '0.00', '1550.00', '0.00', '', '0.00'), 
('4', '2021-04-26', '02:43:14 PM', '2104260073', '1550.00', '0.00', '0.00', '0.00', '1550.00', '', '0.00'), 
('5', '2021-04-26', '07:50:10 PM', '2104260077', '6100.00', '2000.00', '0.00', '4100.00', '0.00', '', '0.00'), 
('6', '2021-04-27', '03:58:56 PM', '2104270078', '900.00', '0.00', '0.00', '900.00', '0.00', '', '0.00'), 
('7', '2021-04-27', '08:08:14 PM', '2104270079', '6050.00', '0.00', '0.00', '6050.00', '0.00', '', '0.00'), 
('8', '2021-04-27', '08:09:12 PM', '2104270079', '6050.00', '6050.00', '0.00', '6050.00', '-6050.00', '', '0.00'), 
('9', '2021-04-28', '11:59:52 AM', '2104270079', '6050.00', '12100.00', '0.00', '6050.00', '-12100.00', '', '0.00'), 
('10', '2021-04-28', '12:00:45 PM', '2104270079', '6050.00', '18150.00', '0.00', '-12100.00', '0.00', '', '0.00'), 
('11', '2021-04-28', '12:01:31 PM', '2104270079', '6050.00', '6050.00', '0.00', '-6050.00', '6050.00', '', '0.00'), 
('12', '2021-04-28', '12:01:52 PM', '2104270079', '6050.00', '0.00', '0.00', '6050.00', '0.00', '', '0.00'), 
('13', '2021-04-28', '01:48:31 PM', '2104270079', '6050.00', '6050.00', '0.00', '6050.00', '-6050.00', '', '0.00'), 
('14', '2021-04-28', '02:04:07 PM', '2104260076', '3500.00', '0.00', '0.00', '3500.00', '0.00', '', '0.00'), 
('15', '2021-04-28', '02:29:13 PM', '2104270079', '6050.00', '12100.00', '0.00', '-6050.00', '0.00', '', '0.00'), 
('16', '2021-04-29', '04:49:08 PM', '2104290089', '3600.00', '0.00', '0.00', '3000.00', '600.00', '', '0.00'), 
('17', '2021-04-29', '04:53:11 PM', '2104290085', '3600.00', '0.00', '0.00', '3600.00', '0.00', '', '0.00'), 
('18', '2021-04-29', '04:53:57 PM', '2104290088', '2500.00', '0.00', '0.00', '1900.00', '600.00', '', '0.00'), 
('19', '2021-04-29', '06:11:23 PM', '2104290093', '2650.00', '0.00', '0.00', '1000.00', '1650.00', '', '0.00'), 
('20', '2021-04-29', '07:56:57 PM', '2104280082', '150.00', '0.00', '0.00', '0.00', '0.00', '', '150.00'), 
('21', '2021-04-29', '08:00:38 PM', '2104290089', '3600.00', '3000.00', '0.00', '0.00', '0.00', '', '600.00'), 
('22', '2021-04-29', '08:02:05 PM', '2104260075', '7450.00', '0.00', '0.00', '0.00', '0.00', '', '7450.00'), 
('23', '2021-04-30', '05:11:46 PM', '2104300094', '2200.00', '1500.00', '0.00', '700.00', '0.00', '', '0.00'), 
('24', '2021-05-02', '02:36:40 PM', '2105010102', '700.00', '550.00', '0.00', '150.00', '0.00', '', '0.00'), 
('25', '2021-05-02', '03:26:10 PM', '2105020109', '3150.00', '0.00', '0.00', '2500.00', '650.00', '', '0.00'), 
('26', '2021-05-02', '06:04:21 PM', '2105020112', '2850.00', '2000.00', '0.00', '600.00', '0.00', '', '250.00'), 
('27', '2021-05-02', '07:18:15 PM', '2105020109', '3150.00', '2500.00', '0.00', '500.00', '0.00', '', '150.00'), 
('28', '2021-05-03', '02:06:20 PM', '2105020107', '1100.00', '0.00', '0.00', '1.00', '1099.00', '', '0.00'), 
('29', '2021-05-03', '03:54:21 PM', '2104290091', '3800.00', '3000.00', '0.00', '0.00', '0.00', '', '800.00'), 
('30', '2021-05-03', '04:12:02 PM', '2105030126', '650.00', '0.00', '0.00', '650.00', '0.00', '', '0.00'), 
('31', '2021-05-03', '05:22:12 PM', '2105030122', '3350.00', '1000.00', '0.00', '900.00', '0.00', '', '1450.00'), 
('32', '2021-05-03', '06:10:24 PM', '2105030131', '800.00', '700.00', '0.00', '100.00', '0.00', '', '0.00'), 
('33', '2021-05-04', '03:41:22 PM', '2105040137', '1100.00', '0.00', '0.00', '800.00', '0.00', '', '300.00'), 
('34', '2021-05-04', '05:11:29 PM', '2105040142', '2250.00', '0.00', '0.00', '2200.00', '0.00', '', '50.00'), 
('35', '2021-05-04', '05:25:01 PM', '2105040142', '2000.00', '2250.00', '0.00', '2000.00', '-2250.00', '', '0.00'), 
('36', '2021-05-04', '05:50:45 PM', '2105040140', '2450.00', '1000.00', '0.00', '0.00', '0.00', '', '1450.00'), 
('37', '2021-05-04', '06:25:11 PM', '2105030134', '2350.00', '1500.00', '0.00', '0.00', '0.00', '', '850.00'), 
('38', '2021-05-05', '02:39:03 PM', '2105050149', '3150.00', '1000.00', '0.00', '1.00', '2149.00', '9', '0.00'), 
('39', '2021-05-05', '04:14:37 PM', '2105050152', '750.00', '500.00', '0.00', '250.00', '0.00', '4', '0.00'), 
('40', '2021-05-05', '04:56:27 PM', '50766803531', '100.00', '50.00', '0.00', '12.00', '38.00', '9', '0.00'), 
('41', '2021-05-05', '07:19:55 PM', '90630574772', '1900.00', '1000.00', '0.00', '800.00', '0.00', '4', '100.00'), 
('42', '2021-05-05', '07:57:35 PM', '99395935485', '2100.00', '500.00', '0.00', '1200.00', '0.00', '4', '400.00'), 
('43', '2021-05-08', '10:14:57 AM', '77429546829', '2500.00', '1000.00', '0.00', '1500.00', '0.00', '4', '0.00'), 
('44', '2021-05-08', '03:55:26 PM', '43767492141', '5000.00', '3600.00', '0.00', '1400.00', '0.00', '8', '0.00'), 
('45', '2021-05-08', '04:11:14 PM', '19923196525', '100.00', '50.00', '0.00', '10.00', '40.00', '4', '0.00'), 
('46', '2021-05-08', '04:12:43 PM', '19923196525', '100.00', '60.00', '0.00', '10.00', '30.00', '4', '0.00'), 
('47', '2021-05-09', '05:18:42 PM', '92949838605', '1100.00', '0.00', '0.00', '1100.00', '0.00', '8', '0.00'), 
('48', '2021-05-10', '05:07:26 PM', '72466135645', '3000.00', '700.00', '0.00', '2300.00', '0.00', '8', '0.00'), 
('49', '2021-05-18', '04:09:21 PM', '78384478017', '4750.00', '2000.00', '0.00', '1500.00', '0.00', '4', '1250.00'), 
('50', '2021-05-18', '04:15:01 PM', '47027041887', '5150.00', '2500.00', '0.00', '1500.00', '1150.00', '4', '0.00'), 
('51', '2021-05-18', '06:20:05 PM', '24596972266', '3600.00', '1000.00', '0.00', '800.00', '0.00', '4', '1800.00'), 
('52', '2021-05-18', '06:42:48 PM', '68253738267', '2900.00', '2000.00', '0.00', '700.00', '0.00', '4', '200.00'), 
('53', '2021-05-19', '02:20:51 PM', '29191284999', '2750.00', '1000.00', '0.00', '1.00', '1749.00', '4', '0.00'), 
('54', '2021-05-19', '02:36:54 PM', '97078676563', '2000.00', '200.00', '0.00', '1800.00', '0.00', '4', '0.00'), 
('55', '2021-05-19', '03:33:44 PM', '79951917338', '200.00', '0.00', '0.00', '1.00', '199.00', '4', '0.00'), 
('56', '2021-05-19', '03:40:29 PM', '79951917338', '200.00', '1.00', '0.00', '50.00', '149.00', '10', '0.00'), 
('57', '2021-05-19', '03:44:04 PM', '79951917338', '200.00', '51.00', '0.00', '9.00', '140.00', '10', '0.00'), 
('58', '2021-05-19', '03:45:16 PM', '94222298057', '2200.00', '500.00', '0.00', '1.00', '1699.00', '4', '0.00'), 
('59', '2021-05-19', '05:51:04 PM', '94222298057', '2200.00', '501.00', '0.00', '1200.00', '0.00', '4', '499.00'), 
('60', '2021-05-19', '05:57:48 PM', '29191284999', '2750.00', '1001.00', '0.00', '1000.00', '0.00', '4', '749.00'), 
('61', '2021-05-19', '07:15:44 PM', '95429276716', '3750.00', '1000.00', '0.00', '1500.00', '0.00', '4', '1250.00'), 
('62', '2021-05-20', '09:36:36 AM', '58999151570', '350.00', '0.00', '0.00', '50.00', '300.00', '4', '0.00'), 
('63', '2021-05-20', '06:20:13 PM', '18006437727', '3750.00', '1500.00', '0.00', '1700.00', '0.00', '4', '550.00'), 
('64', '2021-05-20', '06:20:46 PM', '15379231298', '4850.00', '3000.00', '0.00', '850.00', '0.00', '4', '1000.00'), 
('65', '2021-05-20', '06:25:48 PM', '97734863931', '2100.00', '800.00', '0.00', '600.00', '0.00', '4', '700.00'), 
('66', '2021-05-20', '06:59:07 PM', '17916279410', '3650.00', '2500.00', '0.00', '900.00', '0.00', '4', '250.00'), 
('67', '2021-05-21', '01:42:20 PM', '13908538429', '1100.00', '0.00', '0.00', '700.00', '0.00', '4', '400.00'), 
('68', '2021-05-21', '07:28:22 PM', '61151384603', '150.00', '0.00', '0.00', '100.00', '0.00', '4', '50.00'), 
('69', '2021-05-21', '07:30:28 PM', '23809064469', '150.00', '0.00', '0.00', '100.00', '0.00', '4', '50.00'), 
('70', '2021-05-21', '07:30:47 PM', '91263288300', '1100.00', '0.00', '0.00', '800.00', '0.00', '4', '300.00'), 
('71', '2021-05-22', '10:43:55 AM', '20002106494', '300.00', '50.00', '0.00', '50.00', '200.00', '4', '0.00'), 
('72', '2021-05-22', '10:44:48 AM', '20002106494', '300.00', '100.00', '0.00', '0.00', '100.00', '4', '100.00'), 
('73', '2021-05-22', '11:07:30 AM', '91587899252', '200.00', '50.00', '0.00', '0.00', '100.00', '4', '50.00'), 
('74', '2021-05-22', '11:29:27 AM', '16765041773', '1200.00', '400.00', '0.00', '800.00', '0.00', '8', '0.00'), 
('75', '2021-05-22', '02:10:16 PM', '82055827975', '1050.00', '500.00', '0.00', '100.00', '0.00', '8', '450.00'), 
('76', '2021-05-22', '02:55:11 PM', '54219624234', '800.00', '500.00', '0.00', '300.00', '0.00', '8', '0.00'), 
('77', '2021-05-22', '05:56:13 PM', '67192620577', '800.00', '600.00', '0.00', '0.00', '0.00', '4', '200.00'), 
('78', '2021-05-22', '06:47:28 PM', '17592250679', '4200.00', '500.00', '0.00', '2500.00', '0.00', '4', '1200.00'), 
('79', '2021-05-22', '07:01:18 PM', '60517010630', '1500.00', '800.00', '0.00', '0.00', '0.00', '4', '700.00'), 
('80', '2021-05-23', '11:01:16 AM', '95732078038', '1500.00', '500.00', '0.00', '500.00', '0.00', '8', '500.00'), 
('81', '2021-05-23', '02:30:07 PM', '40949727718', '1000.00', '400.00', '0.00', '0.00', '0.00', '4', '600.00'), 
('82', '2021-05-23', '03:07:23 PM', '57667398576', '350.00', '100.00', '0.00', '50.00', '200.00', '4', '0.00'), 
('83', '2021-05-23', '03:08:01 PM', '86960325100', '300.00', '100.00', '0.00', '1.00', '199.00', '4', '0.00'), 
('84', '2021-05-23', '05:35:52 PM', '46926022859', '400.00', '300.00', '0.00', '0.00', '0.00', '4', '100.00'), 
('85', '2021-05-23', '05:36:24 PM', '15067749884', '400.00', '200.00', '0.00', '0.00', '0.00', '4', '200.00'), 
('86', '2021-05-23', '06:12:29 PM', '17993038313', '3900.00', '1000.00', '0.00', '1000.00', '0.00', '4', '1900.00'), 
('87', '2021-05-23', '06:13:00 PM', '42032445884', '4100.00', '2000.00', '0.00', '1800.00', '0.00', '4', '300.00'), 
('88', '2021-05-23', '07:35:05 PM', '40404222408', '3850.00', '2500.00', '0.00', '500.00', '0.00', '4', '850.00'), 
('89', '2021-05-23', '08:00:05 PM', '90170025080', '5950.00', '3000.00', '0.00', '900.00', '0.00', '4', '2050.00'), 
('90', '2021-05-23', '08:09:40 PM', '12510642657', '5000.00', '1000.00', '0.00', '2000.00', '0.00', '4', '2000.00'), 
('91', '2021-05-24', '04:42:54 PM', '34206749498', '1000.00', '700.00', '0.00', '0.00', '0.00', '4', '300.00'), 
('92', '2021-05-24', '05:45:48 PM', '92806308261', '1200.00', '500.00', '0.00', '100.00', '0.00', '4', '600.00'), 
('93', '2021-05-24', '06:33:36 PM', '87485356918', '3300.00', '3000.00', '0.00', '200.00', '0.00', '4', '100.00'), 
('94', '2021-05-24', '07:04:28 PM', '41689322019', '4550.00', '4000.00', '0.00', '400.00', '0.00', '4', '150.00'), 
('95', '2021-05-24', '07:20:42 PM', '75362726383', '5300.00', '3000.00', '0.00', '800.00', '0.00', '4', '1500.00'), 
('96', '2021-05-24', '08:27:22 PM', '31755799344', '1500.00', '500.00', '0.00', '500.00', '0.00', '4', '500.00'), 
('97', '2021-05-24', '08:29:08 PM', '14387123286', '5700.00', '2000.00', '0.00', '3000.00', '0.00', '4', '700.00'), 
('98', '2021-05-24', '08:46:09 PM', '22821008662', '3650.00', '1000.00', '0.00', '2600.00', '0.00', '4', '50.00'), 
('99', '2021-05-25', '04:45:19 PM', '84609914860', '1100.00', '1000.00', '0.00', '1.00', '99.00', '4', '0.00'), 
('100', '2021-05-25', '04:52:18 PM', '40949727718', '1000.00', '1000.00', '0.00', '1.00', '-1.00', '4', '0.00'), 
('101', '2021-05-25', '04:53:24 PM', '46926022859', '400.00', '400.00', '0.00', '1.00', '-1.00', '4', '0.00'), 
('102', '2021-05-25', '06:09:35 PM', '84609914860', '1100.00', '1001.00', '0.00', '100.00', '-1.00', '4', '0.00'), 
('103', '2021-05-25', '06:10:37 PM', '49630735028', '2000.00', '500.00', '0.00', '1500.00', '0.00', '4', '0.00'), 
('104', '2021-05-25', '06:13:24 PM', '40541379815', '4600.00', '4500.00', '0.00', '100.00', '0.00', '4', '0.00'), 
('105', '2021-05-25', '06:21:45 PM', '25072407101', '250.00', '0.00', '0.00', '250.00', '0.00', '4', '0.00'), 
('106', '2021-05-25', '06:21:55 PM', '26111088693', '250.00', '0.00', '0.00', '250.00', '0.00', '4', '0.00'), 
('107', '2021-05-25', '06:44:17 PM', '97398072025', '2400.00', '2000.00', '0.00', '400.00', '0.00', '4', '0.00'), 
('108', '2021-05-25', '07:36:27 PM', '55263008632', '2700.00', '500.00', '0.00', '900.00', '0.00', '4', '1300.00'), 
('109', '2021-05-26', '05:00:24 PM', '20495134509', '1200.00', '1000.00', '0.00', '200.00', '0.00', '4', '0.00'), 
('110', '2021-05-26', '06:38:55 PM', '39726485229', '2900.00', '1000.00', '0.00', '1030.00', '0.00', '4', '870.00'), 
('111', '2021-05-26', '08:38:06 PM', '99857264260', '2200.00', '2000.00', '0.00', '0.00', '0.00', '4', '200.00'), 
('112', '2021-05-26', '08:38:20 PM', '49541080536', '2450.00', '2000.00', '0.00', '0.00', '0.00', '4', '450.00'), 
('113', '2021-05-27', '04:33:24 PM', '12313899604', '3200.00', '3000.00', '0.00', '0.00', '0.00', '4', '200.00'), 
('114', '2021-05-27', '05:15:05 PM', '72473446610', '3700.00', '1000.00', '0.00', '1800.00', '0.00', '4', '900.00'), 
('115', '2021-05-27', '07:15:35 PM', '29115409900', '5000.00', '500.00', '0.00', '4500.00', '0.00', '4', '0.00'), 
('116', '2021-05-27', '07:55:17 PM', '48450029061', '4100.00', '2500.00', '0.00', '0.00', '0.00', '4', '1600.00'), 
('117', '2021-05-27', '08:04:12 PM', '16286812308', '3200.00', '1500.00', '0.00', '1300.00', '0.00', '4', '400.00'), 
('118', '2021-05-27', '08:51:20 PM', '49953369920', '800.00', '500.00', '0.00', '200.00', '0.00', '4', '100.00'), 
('119', '2021-05-28', '02:23:12 PM', '30172545048', '2500.00', '1500.00', '0.00', '1000.00', '0.00', '8', '0.00'), 
('120', '2021-05-28', '04:05:13 PM', '50482562598', '900.00', '600.00', '0.00', '300.00', '0.00', '8', '0.00'), 
('121', '2021-05-29', '12:07:57 PM', '38045050245', '2700.00', '2000.00', '0.00', '600.00', '0.00', '8', '100.00'), 
('122', '2021-05-29', '06:07:08 PM', '37691671939', '6100.00', '5000.00', '0.00', '1000.00', '0.00', '4', '100.00'), 
('123', '2021-05-29', '06:09:24 PM', '83170537691', '3750.00', '3000.00', '0.00', '0.00', '0.00', '4', '750.00'), 
('124', '2021-05-29', '06:45:34 PM', '57195524871', '7700.00', '1000.00', '0.00', '1200.00', '0.00', '4', '5500.00'), 
('125', '2021-05-29', '06:58:00 PM', '96534101913', '400.00', '0.00', '0.00', '200.00', '0.00', '4', '200.00'), 
('126', '2021-05-29', '06:58:35 PM', '65127690012', '1000.00', '0.00', '0.00', '700.00', '0.00', '4', '300.00'), 
('127', '2021-05-30', '05:01:03 PM', '79129401511', '1200.00', '200.00', '0.00', '1000.00', '0.00', '4', '0.00'), 
('128', '2021-05-30', '05:13:57 PM', '39251386870', '3400.00', '1500.00', '0.00', '900.00', '0.00', '4', '1000.00'), 
('129', '2021-05-30', '05:55:41 PM', '66789450703', '3800.00', '2500.00', '0.00', '0.00', '0.00', '4', '1300.00'), 
('130', '2021-05-30', '06:48:27 PM', '95911456561', '7950.00', '6700.00', '0.00', '0.00', '0.00', '4', '1250.00'), 
('131', '2021-05-30', '08:53:48 PM', '24776185096', '2300.00', '1000.00', '0.00', '0.00', '0.00', '4', '1300.00'), 
('132', '2021-05-30', '08:55:52 PM', '77668442701', '3850.00', '2000.00', '0.00', '1800.00', '0.00', '4', '50.00'), 
('133', '2021-05-31', '03:42:09 PM', '79763428949', '3000.00', '500.00', '0.00', '0.00', '0.00', '4', '2500.00'), 
('134', '2021-05-31', '06:04:30 PM', '66114325655', '2000.00', '500.00', '0.00', '1000.00', '0.00', '4', '500.00'), 
('135', '2021-05-31', '06:49:49 PM', '60228608093', '1900.00', '700.00', '0.00', '250.00', '0.00', '4', '950.00'), 
('136', '2021-05-31', '06:51:01 PM', '13729541872', '1500.00', '0.00', '0.00', '1000.00', '0.00', '4', '500.00'), 
('137', '2021-05-31', '06:52:15 PM', '27904388763', '2000.00', '1000.00', '0.00', '0.00', '0.00', '4', '1000.00'), 
('138', '2021-05-31', '07:01:04 PM', '76813078216', '3100.00', '1500.00', '0.00', '100.00', '0.00', '4', '1500.00'), 
('139', '2021-05-31', '07:45:23 PM', '32546780961', '2950.00', '2000.00', '0.00', '500.00', '0.00', '4', '450.00'), 
('140', '2021-06-01', '03:40:52 PM', '22991583703', '1950.00', '500.00', '0.00', '300.00', '0.00', '4', '1150.00'), 
('141', '2021-06-01', '04:50:25 PM', '99936878184', '2050.00', '1300.00', '0.00', '750.00', '0.00', '4', '0.00'), 
('142', '2021-06-01', '06:17:36 PM', '80612431094', '2200.00', '1000.00', '0.00', '1100.00', '0.00', '4', '100.00'), 
('143', '2021-06-01', '06:49:03 PM', '94985285773', '3950.00', '1000.00', '0.00', '2500.00', '0.00', '4', '450.00'), 
('144', '2021-06-01', '07:15:29 PM', '18701912710', '1200.00', '0.00', '0.00', '1000.00', '0.00', '4', '200.00'), 
('145', '2021-06-01', '07:19:57 PM', '62437945107', '200.00', '0.00', '0.00', '100.00', '0.00', '4', '100.00'), 
('146', '2021-06-01', '07:20:32 PM', '13087768728', '3050.00', '2000.00', '0.00', '800.00', '0.00', '4', '250.00'), 
('147', '2021-06-01', '07:21:17 PM', '95631764208', '2950.00', '1000.00', '0.00', '400.00', '0.00', '4', '1550.00'), 
('148', '2021-06-01', '09:13:34 PM', '85564555186', '2900.00', '500.00', '0.00', '1700.00', '0.00', '4', '700.00'), 
('149', '2021-06-02', '03:44:00 PM', '96221248101', '110.00', '10.00', '0.00', '0.00', '90.00', '1001', '10.00'), 
('150', '2021-06-02', '03:55:32 PM', '52645668345', '150.00', '0.00', '0.00', '0.00', '140.00', '1001', '10.00'), 
('151', '2021-06-02', '03:58:34 PM', '52645668345', '150.00', '10.00', '0.00', '10.00', '130.00', '1001', '0.00'), 
('152', '2021-06-02', '03:59:38 PM', '51217643833', '100.00', '10.00', '0.00', '0.00', '80.00', '1001', '10.00'), 
('153', '2021-06-02', '04:00:07 PM', '51217643833', '100.00', '20.00', '0.00', '80.00', '0.00', '1001', '0.00'), 
('154', '2021-06-02', '06:16:53 PM', '90684601416', '2900.00', '2000.00', '0.00', '500.00', '0.00', '4', '400.00'), 
('155', '2021-06-02', '06:38:44 PM', '70799840200', '3300.00', '1000.00', '0.00', '1500.00', '0.00', '4', '800.00'), 
('156', '2021-06-02', '06:46:44 PM', '45054551131', '5150.00', '3000.00', '0.00', '1000.00', '1150.00', '4', '0.00'), 
('157', '2021-06-02', '06:48:51 PM', '26448718209', '1000.00', '0.00', '0.00', '300.00', '0.00', '4', '700.00'), 
('158', '2021-06-02', '07:01:55 PM', '35286767077', '1200.00', '500.00', '0.00', '0.00', '0.00', '4', '700.00'), 
('159', '2021-06-02', '07:02:46 PM', '45054551131', '5150.00', '4000.00', '0.00', '0.00', '0.00', '4', '1150.00'), 
('160', '2021-06-02', '07:20:15 PM', '99923379677', '3050.00', '1500.00', '0.00', '1400.00', '0.00', '4', '150.00'), 
('161', '2021-06-02', '07:42:49 PM', '61308279964', '2100.00', '2000.00', '0.00', '100.00', '0.00', '4', '0.00'), 
('162', '2021-06-02', '07:52:20 PM', '55792197046', '2150.00', '2000.00', '0.00', '0.00', '0.00', '4', '150.00'), 
('163', '2021-06-03', '09:55:30 AM', '83689688104', '4750.00', '2000.00', '0.00', '2050.00', '0.00', '8', '700.00'), 
('164', '2021-06-03', '05:13:50 PM', '29208003398', '6700.00', '1000.00', '0.00', '2500.00', '0.00', '4', '3200.00'), 
('165', '2021-06-03', '06:32:49 PM', '21654035192', '4300.00', '4000.00', '0.00', '0.00', '0.00', '4', '300.00'), 
('166', '2021-06-03', '07:08:24 PM', '33734826412', '1750.00', '0.00', '0.00', '1500.00', '0.00', '4', '250.00'), 
('167', '2021-06-03', '07:25:56 PM', '77994318761', '3550.00', '1500.00', '0.00', '500.00', '0.00', '4', '1550.00'), 
('168', '2021-06-03', '08:04:23 PM', '18946406741', '2300.00', '0.00', '0.00', '1000.00', '0.00', '4', '1300.00'), 
('169', '2021-06-04', '12:58:46 PM', '91068367204', '300.00', '0.00', '0.00', '300.00', '0.00', '4', '0.00'), 
('170', '2021-06-04', '03:48:04 PM', '68747517011', '2700.00', '0.00', '0.00', '2300.00', '0.00', '4', '400.00'), 
('171', '2021-06-04', '04:07:13 PM', '63476627899', '400.00', '0.00', '0.00', '400.00', '0.00', '4', '0.00'), 
('172', '2021-06-04', '07:26:07 PM', '75797214069', '200.00', '0.00', '0.00', '200.00', '0.00', '4', '0.00'), 
('173', '2021-06-05', '12:29:13 PM', '35185443941', '2150.00', '0.00', '0.00', '2000.00', '0.00', '4', '150.00'), 
('174', '2021-06-05', '01:50:08 PM', '97594119194', '3400.00', '0.00', '0.00', '3000.00', '0.00', '4', '400.00'), 
('175', '2021-06-05', '02:00:13 PM', '85316401720', '800.00', '0.00', '0.00', '400.00', '0.00', '4', '400.00'), 
('176', '2021-06-05', '02:48:32 PM', '40353467522', '500.00', '0.00', '0.00', '500.00', '0.00', '4', '0.00'), 
('177', '2021-06-05', '02:50:20 PM', '66120367455', '7000.00', '6000.00', '0.00', '1000.00', '0.00', '4', '0.00'), 
('178', '2021-06-05', '03:25:43 PM', '22221700143', '1500.00', '0.00', '0.00', '1500.00', '0.00', '4', '0.00'), 
('179', '2021-06-05', '05:41:16 PM', '72906041145', '2450.00', '1500.00', '0.00', '0.00', '0.00', '4', '950.00'), 
('180', '2021-06-05', '06:37:59 PM', '50473197094', '3350.00', '0.00', '0.00', '3350.00', '0.00', '4', '0.00'), 
('181', '2021-06-05', '06:44:58 PM', '87307005830', '2000.00', '0.00', '0.00', '500.00', '1500.00', '4', '0.00'), 
('182', '2021-06-05', '07:09:26 PM', '36858095601', '3700.00', '2000.00', '0.00', '1700.00', '0.00', '4', '0.00'), 
('183', '2021-06-05', '07:20:20 PM', '65829153979', '2550.00', '1000.00', '0.00', '1000.00', '0.00', '4', '550.00'), 
('184', '2021-06-05', '08:03:21 PM', '99384806346', '2400.00', '2000.00', '0.00', '0.00', '0.00', '4', '400.00'), 
('185', '2021-06-05', '08:55:24 PM', '71901329110', '3250.00', '0.00', '0.00', '3250.00', '0.00', '4', '0.00'), 
('186', '2021-06-05', '09:55:55 PM', '24582722162', '3200.00', '1500.00', '0.00', '300.00', '0.00', '4', '1400.00'), 
('187', '2021-06-05', '09:56:43 PM', '27154688412', '4500.00', '1500.00', '0.00', '2500.00', '0.00', '4', '500.00'), 
('188', '2021-06-05', '10:02:25 PM', '76042577458', '1400.00', '300.00', '0.00', '0.00', '0.00', '4', '1100.00'), 
('189', '2021-06-05', '10:02:37 PM', '29841992921', '3800.00', '3700.00', '0.00', '0.00', '0.00', '4', '100.00'), 
('190', '2021-06-06', '02:35:22 PM', '67681468071', '2300.00', '1000.00', '0.00', '1200.00', '0.00', '4', '100.00'), 
('191', '2021-06-06', '05:31:25 PM', '53426637293', '800.00', '500.00', '0.00', '300.00', '0.00', '4', '0.00'), 
('192', '2021-06-06', '05:40:14 PM', '92679098952', '1000.00', '0.00', '0.00', '1000.00', '0.00', '4', '0.00'), 
('193', '2021-06-07', '02:16:10 PM', '90257552017', '400.00', '0.00', '0.00', '400.00', '0.00', '4', '0.00'), 
('194', '2021-06-07', '03:04:36 PM', '35940168425', '2900.00', '1000.00', '0.00', '1900.00', '0.00', '4', '0.00'), 
('195', '2021-06-07', '03:40:43 PM', '95672717193', '350.00', '0.00', '0.00', '300.00', '0.00', '4', '50.00'), 
('196', '2021-06-07', '05:10:45 PM', '95715559356', '2600.00', '2000.00', '0.00', '0.00', '0.00', '4', '600.00'), 
('197', '2021-06-07', '07:32:24 PM', '31630672804', '1600.00', '500.00', '0.00', '500.00', '0.00', '4', '600.00'), 
('198', '2021-06-07', '08:55:32 PM', '89690386669', '400.00', '100.00', '0.00', '0.00', '0.00', '4', '300.00'), 
('199', '2021-06-07', '09:03:56 PM', '95033759996', '4700.00', '2000.00', '0.00', '350.00', '0.00', '4', '2350.00'), 
('200', '2021-06-08', '10:36:05 AM', '29852131381', '4200.00', '1000.00', '0.00', '2500.00', '0.00', '8', '700.00'), 
('201', '2021-06-08', '02:08:55 PM', '56854931678', '2550.00', '2000.00', '0.00', '0.00', '0.00', '4', '550.00'), 
('202', '2021-06-08', '02:24:51 PM', '42287309964', '1200.00', '900.00', '0.00', '100.00', '0.00', '4', '200.00'), 
('203', '2021-06-08', '02:46:53 PM', '33231413778', '2800.00', '1000.00', '0.00', '400.00', '0.00', '4', '1400.00'), 
('204', '2021-06-08', '04:42:00 PM', '46818912774', '1700.00', '1000.00', '0.00', '600.00', '0.00', '4', '100.00'), 
('205', '2021-06-08', '06:19:51 PM', '41344191961', '1650.00', '500.00', '0.00', '1150.00', '0.00', '4', '0.00'), 
('206', '2021-06-08', '06:23:22 PM', '61760254121', '3400.00', '0.00', '0.00', '3400.00', '0.00', '4', '0.00'), 
('207', '2021-06-08', '06:52:39 PM', '83032460262', '2600.00', '2000.00', '0.00', '0.00', '0.00', '4', '600.00'), 
('208', '2021-06-08', '07:15:31 PM', '83320295562', '5000.00', '2500.00', '0.00', '2500.00', '0.00', '4', '0.00'), 
('209', '2021-06-08', '07:27:51 PM', '33234947836', '3000.00', '1000.00', '0.00', '2000.00', '0.00', '4', '0.00'), 
('210', '2021-06-08', '07:30:30 PM', '87820951061', '1600.00', '1500.00', '0.00', '100.00', '0.00', '4', '0.00'), 
('211', '2021-06-08', '07:53:46 PM', '55929204200', '800.00', '0.00', '0.00', '500.00', '0.00', '4', '300.00'), 
('212', '2021-06-09', '11:46:57 AM', '43935151977', '1000.00', '0.00', '0.00', '300.00', '0.00', '8', '700.00'), 
('213', '2021-06-09', '05:51:46 PM', '82170833605', '400.00', '0.00', '0.00', '250.00', '0.00', '8', '150.00'), 
('214', '2021-06-09', '06:17:35 PM', '15113539952', '600.00', '500.00', '0.00', '50.00', '0.00', '4', '50.00'), 
('215', '2021-06-09', '06:52:41 PM', '61607051723', '3300.00', '1000.00', '0.00', '2100.00', '0.00', '8', '200.00'), 
('216', '2021-06-09', '06:53:27 PM', '59177684328', '3300.00', '1500.00', '0.00', '1800.00', '0.00', '8', '0.00'), 
('217', '2021-06-09', '06:57:12 PM', '78546318494', '5800.00', '1500.00', '0.00', '3700.00', '0.00', '8', '600.00'), 
('218', '2021-06-09', '08:16:53 PM', '12932182848', '700.00', '0.00', '0.00', '700.00', '0.00', '4', '0.00'), 
('219', '2021-06-09', '08:17:10 PM', '93433537458', '2950.00', '2000.00', '0.00', '300.00', '0.00', '4', '650.00'), 
('220', '2021-06-09', '08:27:11 PM', '89549946991', '1500.00', '1000.00', '0.00', '200.00', '0.00', '4', '300.00'), 
('221', '2021-06-09', '09:58:14 PM', '58430153876', '300.00', '0.00', '0.00', '300.00', '0.00', '4', '0.00'), 
('222', '2021-06-10', '03:39:02 PM', '95820241628', '1200.00', '1000.00', '0.00', '0.00', '200.00', '14', '0.00'), 
('223', '2021-06-10', '03:39:14 PM', '95820241628', '1200.00', '1000.00', '0.00', '200.00', '0.00', '14', '0.00'), 
('224', '2021-06-23', '07:40:38 PM', '86905251277', '2050.00', '1000.00', '0.00', '0.00', '1050.00', '14', '0.00'), 
('225', '2021-06-23', '07:41:04 PM', '86905251277', '2050.00', '1000.00', '0.00', '0.00', '1050.00', '14', '0.00'), 
('226', '2021-06-23', '07:41:51 PM', '86905251277', '2050.00', '1000.00', '0.00', '1050.00', '0.00', '14', '0.00'), 
('227', '2021-06-23', '07:42:16 PM', '48942536736', '1250.00', '0.00', '0.00', '1250.00', '0.00', '14', '0.00'), 
('228', '2021-06-23', '07:42:40 PM', '14253144752', '500.00', '0.00', '0.00', '500.00', '0.00', '14', '0.00'), 
('229', '2021-06-23', '07:42:51 PM', '83451288317', '1000.00', '0.00', '0.00', '1000.00', '0.00', '14', '0.00'), 
('230', '2021-06-24', '11:56:27 AM', '55402182622', '400.00', '0.00', '0.00', '400.00', '0.00', '14', '0.00'), 
('231', '2021-06-26', '11:27:02 AM', '20877861065', '1000.00', '0.00', '0.00', '1000.00', '0.00', '14', '0.00'), 
('232', '2021-06-26', '11:27:15 AM', '79454407013', '300.00', '0.00', '0.00', '300.00', '0.00', '14', '0.00'), 
('233', '2021-06-26', '11:27:24 AM', '33827060667', '150.00', '0.00', '0.00', '150.00', '0.00', '14', '0.00'), 
('234', '2021-06-26', '11:48:42 AM', '30979107982', '150.00', '0.00', '0.00', '150.00', '0.00', '1001', '0.00'), 
('235', '2021-06-26', '03:31:49 PM', '12028274188', '4950.00', '0.00', '0.00', '0.00', '0.00', '14', '4950.00'), 
('236', '2021-06-27', '11:04:24 AM', '20210627001', '350.00', '0.00', '0.00', '350.00', '0.00', '14', '0.00'), 
('237', '2021-06-27', '01:04:02 PM', '20210627004', '450.00', '0.00', '0.00', '450.00', '0.00', '14', '0.00'), 
('238', '2021-06-27', '01:04:16 PM', '20210627002', '1150.00', '0.00', '0.00', '1150.00', '0.00', '14', '0.00'), 
('239', '2021-06-27', '01:04:27 PM', '20210627006', '200.00', '0.00', '0.00', '200.00', '0.00', '14', '0.00'), 
('240', '2021-06-27', '01:29:15 PM', '20210627008', '350.00', '0.00', '0.00', '350.00', '0.00', '14', '0.00'), 
('241', '2021-06-27', '01:29:26 PM', '20210627005', '150.00', '0.00', '0.00', '150.00', '0.00', '14', '0.00'), 
('242', '2021-06-27', '01:29:37 PM', '20210627009', '550.00', '0.00', '0.00', '550.00', '0.00', '14', '0.00'), 
('243', '2021-06-27', '01:29:46 PM', '20210627007', '800.00', '0.00', '0.00', '800.00', '0.00', '14', '0.00'), 
('244', '2021-06-27', '05:56:33 PM', '20210627012', '5000.00', '0.00', '0.00', '0.00', '0.00', '14', '5000.00'), 
('245', '2021-06-27', '05:56:47 PM', '20210627014', '500.00', '0.00', '0.00', '500.00', '0.00', '14', '0.00'), 
('246', '2021-06-27', '05:56:56 PM', '20210627011', '500.00', '0.00', '0.00', '500.00', '0.00', '14', '0.00'), 
('247', '2021-06-27', '05:57:05 PM', '20210627010', '800.00', '0.00', '0.00', '800.00', '0.00', '14', '0.00'), 
('248', '2021-06-27', '05:57:15 PM', '20210627013', '350.00', '0.00', '0.00', '350.00', '0.00', '14', '0.00'), 
('249', '2021-06-27', '06:53:35 PM', '20210627016', '300.00', '0.00', '0.00', '300.00', '0.00', '14', '0.00'), 
('250', '2021-06-28', '10:27:24 AM', '20210628002', '1000.00', '100.00', '0.00', '0.00', '0.00', '1001', '900.00'), 
('251', '2021-06-28', '02:49:24 PM', '20210628009', '300.00', '50.00', '0.00', '50.00', '200.00', '1001', '0.00'), 
('252', '2021-08-04', '07:17:42 PM', '20210804005', '450.00', '0.00', '0.00', '450.00', '0.00', '15', '0.00'), 
('253', '2021-08-04', '07:17:59 PM', '20210804004', '1300.00', '0.00', '0.00', '1300.00', '0.00', '15', '0.00'), 
('254', '2021-08-04', '07:18:15 PM', '20210804003', '1000.00', '0.00', '0.00', '1000.00', '0.00', '15', '0.00'), 
('255', '2021-08-04', '07:18:24 PM', '20210804001', '900.00', '0.00', '0.00', '900.00', '0.00', '15', '0.00'), 
('256', '2021-08-04', '07:18:33 PM', '20210804002', '600.00', '0.00', '0.00', '600.00', '0.00', '15', '0.00'), 
('257', '2021-08-10', '08:10:35 PM', '20210810011', '2750.00', '0.00', '0.00', '2000.00', '0.00', '15', '750.00'), 
('258', '2021-08-11', '02:00:45 PM', '20210811022', '1500.00', '500.00', '0.00', '1000.00', '0.00', '15', '0.00');  



 



INSERT INTO `employee` ( `id`, `date`, `emp_id`, `name`, `joining_date`, `gender`, `mobile`, `email`, `overtime`, `entry_time`, `exit_time`, `present_address`, `permanent_address`, `designation`, `type`, `employee_salary`, `status`, `path`) VALUES 
('1', '2021-06-10', '21001', 'Mahbubur ', '2021-06-10', 'Male', '01953238865', 'admin@gmail.com', '500', '10:30:00', '04:38:00', 'Jamalpur', 'Jamalpur', 'Managing Director', 'Monthly', '40000', 'active', 'public/employee/employee_63231_21001.jpg'), 
('2', '2021-06-24', '21002', 'Sumaiya afroz Prema', '2021-08-01', 'Female', '01909673852', 'rashed.jrdr@gmail.com', '0', '08:00:00', '17:00:00', 'Vill: Coto Kamar kundu jhenidah
Dist+Thana+Post=Jhenidah', 'Vill: Coto Kamar kundu jhenidah
Dist+Thana+Post=Jhenidah', 'Nurse', 'Daily', '15000', 'active', '0');  



INSERT INTO `group_mapping` ( `id`, `group_id`, `test_id`) VALUES 
('1', '11', '9'), 
('2', '18', '3'), 
('5', '23', '71'), 
('6', '23', '68'), 
('7', '23', '69'), 
('8', '23', '70'), 
('20', '37', '79'), 
('21', '38', '85'), 
('22', '38', '86'), 
('23', '38', '83'), 
('24', '38', '84'), 
('32', '41', '90'), 
('38', '44', '100'), 
('39', '45', '101'), 
('69', '35', '107'), 
('70', '35', '72'), 
('71', '35', '73'), 
('72', '35', '74'), 
('73', '35', '75'), 
('81', '47', '110'), 
('82', '46', '109'), 
('87', '39', '108'), 
('88', '39', '112'), 
('89', '39', '113'), 
('90', '39', '96'), 
('91', '39', '98'), 
('92', '39', '89'), 
('93', '39', '97'), 
('94', '39', '87'), 
('95', '39', '91'), 
('96', '43', '114'), 
('97', '49', '115'), 
('98', '50', '116'), 
('99', '51', '117'), 
('100', '53', '118'), 
('101', '54', '119'), 
('102', '55', '120'), 
('103', '56', '121'), 
('104', '60', '122'), 
('106', '57', '123'), 
('107', '58', '124'), 
('108', '61', '125'), 
('109', '62', '126'), 
('111', '63', '129'), 
('112', '69', '130'), 
('114', '73', '132'), 
('115', '74', '133'), 
('116', '75', '134'), 
('117', '76', '135'), 
('118', '78', '137'), 
('119', '79', '138'), 
('120', '80', '139'), 
('121', '81', '140'), 
('122', '82', '141'), 
('123', '48', '142'), 
('124', '83', '143'), 
('125', '84', '144'), 
('126', '85', '145'), 
('139', '87', '148'), 
('141', '88', '149'), 
('142', '89', '150'), 
('143', '89', '82'), 
('144', '90', '151'), 
('145', '91', '152'), 
('146', '92', '153'), 
('147', '93', '154'), 
('148', '94', '155'), 
('149', '95', '156'), 
('193', '98', '296'), 
('194', '98', '297'), 
('195', '98', '298'), 
('196', '98', '299'), 
('197', '98', '300'), 
('217', '101', '314'), 
('218', '101', '315'), 
('219', '101', '316'), 
('220', '101', '317'), 
('221', '102', '318'), 
('222', '102', '319'), 
('223', '102', '320'), 
('224', '102', '321'), 
('225', '102', '322'), 
('226', '102', '323'), 
('227', '102', '324'), 
('228', '102', '325'), 
('229', '102', '326'), 
('237', '103', '327'), 
('238', '103', '328'), 
('239', '103', '329'), 
('240', '103', '331'), 
('241', '103', '332'), 
('242', '103', '333'), 
('243', '103', '334'), 
('244', '103', '335'), 
('245', '103', '336'), 
('246', '103', '337'), 
('302', '106', '364'), 
('303', '106', '365'), 
('358', '109', '409'), 
('359', '109', '410'), 
('360', '109', '411'), 
('361', '109', '412'), 
('362', '109', '413'), 
('383', '112', '286'), 
('384', '112', '287'), 
('385', '112', '429'), 
('386', '112', '430'), 
('387', '112', '431'), 
('388', '112', '432'), 
('392', '113', '339'), 
('393', '113', '437'), 
('394', '113', '438'), 
('395', '113', '439'), 
('396', '113', '441'), 
('397', '113', '442'), 
('522', '119', '503'), 
('523', '119', '504'), 
('524', '119', '505'), 
('525', '119', '506'), 
('526', '119', '507'), 
('527', '119', '508'), 
('528', '119', '509'), 
('529', '119', '510'), 
('530', '119', '511'), 
('579', '121', '532'), 
('580', '121', '533'), 
('581', '121', '534'), 
('648', '100', '583'), 
('649', '100', '308'), 
('650', '100', '309'), 
('651', '100', '310'), 
('652', '100', '311'), 
('653', '100', '312'), 
('654', '100', '313'), 
('931', '99', '598'), 
('932', '99', '301'), 
('933', '99', '302'), 
('934', '99', '303'), 
('935', '99', '304'), 
('936', '99', '305'), 
('937', '99', '306'), 
('938', '99', '307'), 
('1257', '122', '582'), 
('1258', '122', '584'), 
('1259', '122', '585'), 
('1260', '122', '586'), 
('1261', '122', '597'), 
('1262', '122', '599'), 
('1263', '122', '600'), 
('1264', '122', '601'), 
('1265', '122', '602'), 
('1266', '122', '603'), 
('1267', '122', '604'), 
('1268', '122', '605'), 
('1269', '122', '606'), 
('1270', '122', '607'), 
('1271', '122', '608'), 
('1272', '122', '609'), 
('1273', '122', '610'), 
('1274', '122', '512'), 
('1275', '122', '513'), 
('1276', '122', '514'), 
('1277', '122', '536'), 
('1278', '122', '537'), 
('1279', '122', '538'), 
('1280', '122', '539'), 
('1281', '122', '540'), 
('1282', '122', '541'), 
('1283', '122', '546'), 
('1284', '122', '547'), 
('1285', '122', '549'), 
('1286', '122', '550'), 
('1287', '122', '551'), 
('1288', '122', '552'), 
('1289', '122', '553'), 
('1290', '122', '555'), 
('1291', '122', '556'), 
('1292', '122', '557'), 
('1293', '122', '558'), 
('1294', '122', '559'), 
('1295', '122', '499'), 
('1300', '114', '611'), 
('1301', '114', '613'), 
('1302', '114', '443'), 
('1303', '114', '444'), 
('1304', '114', '445'), 
('1940', '107', '588'), 
('1941', '107', '632'), 
('1942', '107', '366'), 
('1943', '107', '367'), 
('1944', '107', '368'), 
('1945', '107', '369'), 
('1946', '107', '370'), 
('1947', '107', '371'), 
('1948', '107', '372'), 
('1949', '107', '373'), 
('1950', '107', '374'), 
('1951', '107', '375'), 
('1952', '107', '376'), 
('1953', '107', '377'), 
('1954', '107', '378'), 
('1955', '107', '379'), 
('1956', '107', '380'), 
('1957', '107', '381'), 
('1958', '107', '382'), 
('1959', '107', '383'), 
('1960', '107', '384'), 
('1961', '107', '385'), 
('1962', '107', '386'), 
('1963', '107', '387'), 
('1964', '107', '388'), 
('1965', '107', '389'), 
('1966', '107', '390'), 
('1967', '107', '391'), 
('1968', '107', '392'), 
('2114', '123', '587'), 
('2115', '123', '514'), 
('2116', '123', '517'), 
('2117', '123', '519'), 
('2118', '123', '523'), 
('2119', '123', '524'), 
('2120', '123', '527'), 
('2121', '123', '561'), 
('2122', '123', '562'), 
('2123', '123', '565'), 
('2124', '123', '566'), 
('2125', '123', '568'), 
('2126', '123', '569'), 
('2127', '123', '573'), 
('2128', '123', '574'), 
('2129', '123', '467'), 
('2131', '125', '643'), 
('2132', '125', '393'), 
('2755', '111', '656'), 
('2756', '111', '421'), 
('2757', '111', '422'), 
('2758', '111', '423'), 
('2759', '111', '424'), 
('2760', '111', '425'), 
('2761', '111', '426'), 
('2830', '108', '659'), 
('2831', '108', '639'), 
('2832', '108', '393'), 
('2833', '108', '394'), 
('2834', '108', '396'), 
('2835', '108', '397'), 
('2836', '108', '398'), 
('2837', '108', '399'), 
('2838', '108', '400'), 
('2839', '108', '401'), 
('2840', '108', '402'), 
('2841', '108', '403'), 
('2842', '108', '404'), 
('2843', '108', '405'), 
('2844', '108', '406'), 
('2845', '108', '407'), 
('2846', '108', '408'), 
('2847', '116', '658'), 
('2848', '116', '660'), 
('2849', '116', '575'), 
('2850', '116', '576'), 
('2851', '116', '577'), 
('2852', '116', '578'), 
('2853', '116', '579'), 
('2854', '116', '580'), 
('2983', '110', '666'), 
('2984', '110', '633'), 
('2985', '110', '414'), 
('2986', '110', '415'), 
('2987', '110', '416'), 
('2988', '110', '417'), 
('2989', '110', '418'), 
('2990', '110', '419'), 
('2991', '110', '420'), 
('2992', '120', '662'), 
('2993', '120', '665'), 
('2994', '120', '667'), 
('2995', '120', '638'), 
('2996', '120', '634'), 
('2997', '120', '513'), 
('2998', '120', '516'), 
('2999', '120', '517'), 
('3000', '120', '518'), 
('3001', '120', '519'), 
('3002', '120', '520'), 
('3003', '120', '521'), 
('3004', '120', '522'), 
('3005', '120', '523'), 
('3006', '120', '524'), 
('3007', '120', '525'), 
('3008', '120', '527'), 
('3009', '120', '528'), 
('3010', '120', '529'), 
('3011', '120', '531'), 
('3155', '97', '670'), 
('3156', '97', '290'), 
('3157', '97', '291'), 
('3158', '97', '292'), 
('3159', '97', '293'), 
('3160', '97', '294'), 
('3161', '97', '295'), 
('3188', '118', '655'), 
('3189', '118', '671'), 
('3190', '118', '672'), 
('3191', '118', '581'), 
('3192', '118', '589'), 
('3193', '118', '590'), 
('3194', '118', '481'), 
('3195', '118', '482'), 
('3196', '118', '483'), 
('3197', '118', '484'), 
('3198', '118', '485'), 
('3199', '118', '486'), 
('3200', '118', '487'), 
('3201', '118', '488'), 
('3202', '118', '489'), 
('3203', '118', '490'), 
('3204', '118', '491'), 
('3205', '118', '492'), 
('3206', '118', '493'), 
('3207', '118', '494'), 
('3208', '118', '495'), 
('3209', '118', '496'), 
('3210', '118', '497'), 
('3211', '118', '498'), 
('3212', '118', '500'), 
('3213', '118', '501'), 
('3214', '118', '502'), 
('3228', '96', '642'), 
('3229', '96', '643'), 
('3230', '96', '661'), 
('3231', '96', '668'), 
('3232', '96', '675'), 
('3233', '96', '591'), 
('3234', '96', '592'), 
('3235', '96', '101'), 
('3236', '96', '282'), 
('3237', '96', '283'), 
('3238', '96', '284'), 
('3239', '96', '285'), 
('3240', '96', '287'), 
('3241', '96', '288'), 
('3242', '96', '289'), 
('3243', '96', '72'), 
('3244', '96', '73'), 
('3254', '40', '676'), 
('3255', '40', '678'), 
('3256', '40', '679'), 
('3257', '40', '680'), 
('3258', '40', '111'), 
('3333', '105', '685'), 
('3334', '105', '686'), 
('3335', '105', '687'), 
('3336', '105', '688'), 
('3337', '105', '614'), 
('3338', '105', '615'), 
('3339', '105', '616'), 
('3340', '105', '617'), 
('3341', '105', '635'), 
('3342', '105', '310'), 
('3343', '105', '353'), 
('3344', '105', '354'), 
('3345', '105', '355'), 
('3346', '105', '356'), 
('3347', '105', '357'), 
('3348', '105', '358'), 
('3349', '105', '359'), 
('3350', '105', '360'), 
('3351', '105', '361'), 
('3352', '105', '362'), 
('3353', '105', '363'), 
('3354', '105', '421'), 
('3384', '42', '689'), 
('3385', '42', '690'), 
('3386', '42', '691'), 
('3387', '42', '338'), 
('3388', '42', '339'), 
('3389', '42', '340'), 
('3390', '42', '341'), 
('3391', '42', '342'), 
('3392', '42', '343'), 
('3393', '42', '344'), 
('3394', '42', '345'), 
('3395', '42', '346'), 
('3396', '42', '93'), 
('3397', '42', '95'), 
('3398', '42', '94'), 
('3399', '42', '92'), 
('3408', '115', '673'), 
('3409', '115', '674'), 
('3410', '115', '692'), 
('3411', '115', '446'), 
('3412', '115', '447'), 
('3413', '115', '448'), 
('3414', '115', '449'), 
('3415', '115', '450'), 
('3546', '117', '644'), 
('3547', '117', '645'), 
('3548', '117', '646'), 
('3549', '117', '647'), 
('3550', '117', '649'), 
('3551', '117', '650'), 
('3552', '117', '652'), 
('3553', '117', '653'), 
('3554', '117', '654'), 
('3555', '117', '657'), 
('3556', '117', '663'), 
('3557', '117', '669'), 
('3558', '117', '636'), 
('3559', '117', '589'), 
('3560', '117', '590'), 
('3561', '117', '593'), 
('3562', '117', '594'), 
('3563', '117', '595'), 
('3564', '117', '596'), 
('3565', '117', '618'), 
('3566', '117', '619'), 
('3567', '117', '620'), 
('3568', '117', '621'), 
('3569', '117', '622'), 
('3570', '117', '623'), 
('3571', '117', '624'), 
('3572', '117', '625'), 
('3573', '117', '626'), 
('3574', '117', '627'), 
('3575', '117', '628'), 
('3576', '117', '629'), 
('3577', '117', '630'), 
('3578', '117', '556'), 
('3579', '117', '560'), 
('3580', '117', '401'), 
('3581', '117', '451'), 
('3582', '117', '452'), 
('3583', '117', '453'), 
('3584', '117', '454'), 
('3585', '117', '455'), 
('3586', '117', '456'), 
('3587', '117', '457'), 
('3588', '117', '458'), 
('3589', '117', '459'), 
('3590', '117', '460'), 
('3591', '117', '461'), 
('3592', '117', '462'), 
('3593', '117', '463'), 
('3594', '117', '464'), 
('3595', '117', '465'), 
('3596', '117', '466'), 
('3597', '117', '467'), 
('3598', '117', '468'), 
('3599', '117', '469'), 
('3600', '117', '470'), 
('3601', '117', '471'), 
('3602', '117', '472'), 
('3603', '117', '473'), 
('3604', '117', '474'), 
('3605', '117', '475'), 
('3606', '117', '476'), 
('3607', '117', '477'), 
('3608', '117', '478'), 
('3609', '117', '479'), 
('3610', '117', '480'), 
('3611', '117', '498'), 
('3612', '36', '681'), 
('3613', '36', '682'), 
('3614', '36', '683'), 
('3615', '36', '684'), 
('3616', '36', '693'), 
('3617', '36', '102'), 
('3618', '104', '298'), 
('3619', '104', '300'), 
('3620', '104', '309'), 
('3621', '104', '347'), 
('3622', '104', '348'), 
('3623', '104', '349'), 
('3624', '104', '437'), 
('3625', '104', '445'), 
('3626', '104', '93'), 
('3748', '136', '736'), 
('3800', '133', '753'), 
('3801', '133', '754'), 
('3802', '133', '755'), 
('3803', '133', '756'), 
('3804', '133', '757'), 
('3805', '133', '758'), 
('3806', '133', '759'), 
('3807', '133', '760'), 
('3808', '133', '761'), 
('3833', '129', '772'), 
('3834', '129', '773'), 
('3835', '129', '774'), 
('3868', '127', '776'), 
('3869', '127', '777'), 
('3870', '127', '778'), 
('3871', '127', '779'), 
('3872', '127', '780'), 
('3873', '127', '783'), 
('3874', '127', '784'), 
('3875', '127', '785'), 
('3876', '127', '700'), 
('3877', '127', '701'), 
('3878', '127', '702'), 
('3879', '127', '703'), 
('3880', '127', '704'), 
('3881', '127', '705'), 
('3882', '127', '706'), 
('3883', '127', '707'), 
('3884', '127', '708'), 
('3885', '127', '709'), 
('3886', '127', '710'), 
('3887', '127', '711'), 
('3888', '127', '712'), 
('3889', '127', '713'), 
('3890', '127', '714'), 
('3891', '127', '715'), 
('3892', '127', '716'), 
('3893', '127', '717'), 
('3894', '127', '718'), 
('3895', '130', '786'), 
('3896', '130', '768'), 
('3897', '130', '769'), 
('3898', '130', '770'), 
('3899', '130', '771'), 
('3900', '130', '725'), 
('3901', '130', '726'), 
('3902', '130', '727'), 
('3903', '130', '728'), 
('3904', '130', '729'), 
('3905', '130', '730'), 
('3906', '130', '731'), 
('3907', '130', '732'), 
('3908', '130', '733'), 
('3909', '130', '734'), 
('3910', '130', '749'), 
('3911', '130', '750'), 
('3912', '130', '751'), 
('3913', '130', '752'), 
('3914', '130', '762'), 
('3915', '130', '763'), 
('3916', '130', '764'), 
('3917', '130', '765'), 
('3918', '130', '766'), 
('3919', '130', '767'), 
('3920', '128', '787'), 
('3921', '128', '775'), 
('3922', '128', '719'), 
('3923', '128', '720'), 
('3924', '128', '721'), 
('3925', '128', '722'), 
('3926', '128', '723'), 
('3927', '128', '724'), 
('3928', '128', '738'), 
('4032', '135', '822'), 
('4033', '142', '823'), 
('4066', '132', '824'), 
('4067', '132', '825'), 
('4068', '132', '826'), 
('4118', '140', '876'), 
('4119', '140', '877'), 
('4120', '140', '878'), 
('4121', '137', '879'), 
('4122', '139', '880'), 
('4123', '139', '881'), 
('4124', '139', '882'), 
('4125', '139', '883'), 
('4126', '139', '884'), 
('4127', '139', '885'), 
('4128', '139', '886'), 
('4129', '139', '887'), 
('4130', '139', '888'), 
('4131', '139', '889'), 
('4132', '139', '890'), 
('4133', '139', '891'), 
('4134', '139', '892'), 
('4135', '139', '893'), 
('4136', '139', '894'), 
('4137', '139', '895'), 
('4138', '139', '896'), 
('4139', '139', '897'), 
('4207', '141', '790'), 
('4208', '141', '791'), 
('4209', '141', '792'), 
('4210', '141', '793'), 
('4211', '141', '794'), 
('4212', '141', '795'), 
('4213', '141', '796'), 
('4214', '141', '797'), 
('4215', '141', '798'), 
('4216', '141', '799'), 
('4217', '141', '800'), 
('4218', '141', '801'), 
('4219', '141', '802'), 
('4220', '141', '803'), 
('4221', '141', '804'), 
('4222', '141', '805'), 
('4223', '141', '806'), 
('4224', '141', '807'), 
('4225', '141', '808'), 
('4226', '141', '809'), 
('4227', '141', '810'), 
('4228', '141', '811'), 
('4229', '141', '812'), 
('4230', '141', '813'), 
('4231', '141', '814'), 
('4232', '141', '815'), 
('4233', '141', '816'), 
('4234', '141', '817'), 
('4235', '141', '818'), 
('4236', '141', '819'), 
('4237', '141', '820'), 
('4238', '141', '821'), 
('4239', '141', '898'), 
('4240', '141', '899'), 
('4241', '141', '900'), 
('4242', '138', '827'), 
('4243', '138', '828'), 
('4244', '138', '829'), 
('4245', '138', '830'), 
('4246', '138', '831'), 
('4247', '138', '832'), 
('4248', '138', '833'), 
('4249', '138', '834'), 
('4250', '138', '835'), 
('4251', '138', '836'), 
('4252', '138', '837'), 
('4253', '138', '838'), 
('4254', '138', '839'), 
('4255', '138', '840'), 
('4256', '138', '841'), 
('4257', '138', '842'), 
('4258', '138', '843'), 
('4259', '138', '844'), 
('4260', '138', '845'), 
('4261', '138', '846'), 
('4262', '138', '847'), 
('4263', '138', '848'), 
('4264', '138', '849'), 
('4265', '138', '850'), 
('4266', '138', '851'), 
('4267', '138', '852'), 
('4268', '138', '853'), 
('4269', '138', '854'), 
('4270', '138', '855'), 
('4271', '138', '856'), 
('4272', '138', '857'), 
('4273', '138', '858'), 
('4274', '138', '859'), 
('4275', '138', '860'), 
('4276', '138', '861'), 
('4277', '138', '862'), 
('4278', '138', '863'), 
('4279', '138', '864'), 
('4280', '138', '865'), 
('4281', '138', '866'), 
('4282', '138', '867'), 
('4283', '138', '868'), 
('4284', '138', '869'), 
('4285', '138', '870'), 
('4286', '138', '871'), 
('4287', '138', '872'), 
('4288', '138', '873'), 
('4289', '138', '874'), 
('4290', '138', '875'), 
('4291', '138', '901'), 
('4292', '143', '902');  



INSERT INTO `group_name` ( `id`, `position`, `group_name`, `trash`) VALUES 
('1', '0', 'BIOCHEMICAL_EXAMI', '0'), 
('2', '1', 'SEROLOGICAL_&_BLOOD_EXAMINATION REPORT', '0'), 
('4', '2', 'URINE_EXAMINATION_REPORT', '0'), 
('16', '3', 'STOOL', '0'), 
('24', '7', 'STOOL__EXAMINATION_REPORT', '0'), 
('25', '8', 'ABC', '0'), 
('26', '9', 'Blood', '0'), 
('28', '4', 'BIOCAMISTRI', '0'), 
('29', '5', 'IMONOLOGY', '0'), 
('30', '6', 'OTHERS', '0'), 
('32', '', 'Blood_Group', '0'), 
('33', '', 'Haematology', '0');  



 



INSERT INTO `income` ( `id`, `date`, `income_field`, `description`, `amount`, `income_by`, `trash`) VALUES 
('1', '2021-06-10', '0001', 'Bil', '1250.00', 'Mahbubur', '1');  



INSERT INTO `income_field` ( `id`, `code`, `income_field`, `trash`) VALUES 
('1', '0001', 'Doctor Commision', '0');  



INSERT INTO `investigation` ( `id`, `date`, `group`, `test_name`, `name`, `test_fee`, `cost`, `room`, `unit`, `reference_value`) VALUES 
('1', '2021-04-20', 'Haematology', 'CBC', 'CBC', '500', '0.00', '401', '0', '0'), 
('2', '2021-04-20', 'Haematology', 'ESR', 'ESR', '200', '0.00', '402', '0', '0');  



INSERT INTO `items` ( `id`, `name`, `price`, `status`, `trash`) VALUES 
('1', 'O.T', '5000.00', 'available', '0'), 
('2', 'O.T ', '2000.00', 'available', '0');  



INSERT INTO `journal` ( `id`, `date`, `ref`, `details`, `amount`, `status`) VALUES 
('1', '2021-04-05', 'pid:00001', 'diagnosis', '800.00', 'income'), 
('2', '2021-04-18', '', 'consultancy', '300.00', 'income'), 
('3', '2021-04-18', 'pid:0002', 'diagnosis', '0.00', 'income'), 
('4', '2021-04-18', '', 'consultancy', '500.00', 'income'), 
('5', '2021-04-18', 'pid:0004', 'diagnosis', '200.00', 'income'), 
('6', '2021-04-20', '', 'consultancy', '500.00', 'income'), 
('7', '2021-04-20', 'pid:0006', 'diagnosis', '400.00', 'income'), 
('8', '2021-04-20', '', 'consultancy', '500.00', 'income'), 
('9', '2021-04-20', '', 'consultancy', '500.00', 'income'), 
('10', '2021-04-20', '', 'consultancy', '500.00', 'income'), 
('11', '2021-04-20', '', 'consultancy', '500.00', 'income'), 
('12', '2021-04-20', 'pid:00002', 'diagnosis', '300.00', 'income'), 
('13', '2021-04-20', 'pid:00002', 'diagnosis', '200.00', 'income'), 
('14', '2021-04-20', 'pid:00002', 'diagnosis', '200.00', 'income'), 
('15', '2021-04-20', 'pid:00003', 'diagnosis', '300.00', 'income'), 
('16', '2021-04-20', 'pid:00004', 'diagnosis', '400.00', 'income'), 
('17', '2021-04-20', 'pid:00004', 'diagnosis', '400.00', 'income'), 
('18', '2021-04-20', 'pid:00004', 'diagnosis', '400.00', 'income'), 
('19', '2021-04-21', 'pid:00005', 'diagnosis', '300.00', 'income'), 
('20', '2021-04-21', '', 'consultancy', '0.00', 'income'), 
('21', '2021-04-21', '', 'consultancy', '0.00', 'income'), 
('22', '2021-04-21', '', 'consultancy', '0.00', 'income'), 
('23', '2021-04-22', 'pid:00006', 'diagnosis', '0.00', 'income'), 
('24', '2021-04-22', 'pid:00007', 'diagnosis', '900.00', 'income'), 
('25', '2021-04-22', 'pid:00008', 'diagnosis', '0.00', 'income'), 
('26', '2021-04-22', 'pid:00009', 'diagnosis', '0.00', 'income'), 
('27', '2021-04-22', 'pid:00010', 'diagnosis', '0.00', 'income'), 
('28', '2021-04-22', 'pid:00010', 'diagnosis', '0.00', 'income'), 
('29', '2021-04-22', 'pid:00011', 'diagnosis', '400.00', 'income'), 
('30', '2021-04-22', 'pid:00012', 'diagnosis', '120.00', 'income'), 
('31', '2021-04-22', 'pid:00012', 'diagnosis', '0.00', 'income'), 
('32', '2021-04-22', 'pid:00013', 'diagnosis', '100.00', 'income'), 
('33', '2021-04-22', 'pid:00014', 'diagnosis', '1050.00', 'income'), 
('34', '2021-04-22', 'pid:00015', 'diagnosis', '0.00', 'income'), 
('35', '2021-04-22', 'pid:00016', 'diagnosis', '0.00', 'income'), 
('36', '2021-04-24', 'pid:00017', 'diagnosis', '0.00', 'income'), 
('37', '2021-04-24', 'pid:00017', 'diagnosis', '0.00', 'income'), 
('38', '2021-04-24', 'pid:00018', 'diagnosis', '0.00', 'income'), 
('39', '2021-04-24', 'pid:00019', 'diagnosis', '0.00', 'income'), 
('40', '2021-04-24', 'pid:00020', 'diagnosis', '0.00', 'income'), 
('41', '2021-04-24', 'pid:00021', 'diagnosis', '0.00', 'income'), 
('42', '2021-04-24', 'pid:00021', 'diagnosis', '1000.00', 'income'), 
('43', '2021-04-24', 'pid:00021', 'diagnosis', '1000.00', 'income'), 
('44', '2021-04-24', 'pid:00022', 'diagnosis', '0.00', 'income'), 
('45', '2021-04-24', 'pid:00023', 'diagnosis', '0.00', 'income'), 
('46', '2021-04-24', 'pid:00024', 'diagnosis', '0.00', 'income'), 
('47', '2021-04-24', 'pid:00025', 'diagnosis', '2000.00', 'income'), 
('48', '2021-04-24', 'pid:00026', 'diagnosis', '300.00', 'income'), 
('49', '2021-04-24', 'pid:00027', 'diagnosis', '300.00', 'income'), 
('50', '2021-04-25', 'pid:00028', 'diagnosis', '0.00', 'income'), 
('51', '2021-04-25', 'pid:00029', 'diagnosis', '0.00', 'income'), 
('52', '2021-04-25', 'pid:00030', 'diagnosis', '100.00', 'income'), 
('53', '2021-04-25', 'pid:00031', 'diagnosis', '0.00', 'income'), 
('54', '2021-04-25', 'pid:00032', 'diagnosis', '300.00', 'income'), 
('55', '2021-04-25', 'pid:00033', 'diagnosis', '0.00', 'income'), 
('56', '2021-04-25', 'pid:00033', 'diagnosis', '0.00', 'income'), 
('57', '2021-04-25', 'pid:00034', 'diagnosis', '400.00', 'income'), 
('58', '2021-04-25', 'pid:00035', 'diagnosis', '100.00', 'income'), 
('59', '2021-04-25', 'pid:00036', 'diagnosis', '0.00', 'income'), 
('60', '2021-04-25', 'pid:00037', 'diagnosis', '850.00', 'income'), 
('61', '2021-04-25', 'pid:00037', 'diagnosis', '550.00', 'income'), 
('62', '2021-04-25', 'pid:00038', 'diagnosis', '0.00', 'income'), 
('63', '2021-04-25', 'pid:00039', 'diagnosis', '0.00', 'income'), 
('64', '2021-04-25', 'pid:00040', 'diagnosis', '0.00', 'income'), 
('65', '2021-04-25', 'pid:00041', 'diagnosis', '0.00', 'income'), 
('66', '2021-04-25', 'pid:00042', 'diagnosis', '600.00', 'income'), 
('67', '2021-04-25', 'pid:00043', 'diagnosis', '1500.00', 'income'), 
('68', '2021-04-26', 'pid:00044', 'diagnosis', '0.00', 'income'), 
('69', '2021-04-26', 'pid:00044', 'diagnosis', '3000.00', 'income'), 
('70', '2021-04-26', 'pid:00045', 'diagnosis', '1000.00', 'income'), 
('71', '2021-04-26', 'pid:00045', 'diagnosis', '3000.00', 'income'), 
('72', '2021-04-26', 'pid:00046', 'diagnosis', '0.00', 'income'), 
('73', '2021-04-26', 'pid:00047', 'diagnosis', '0.00', 'income'), 
('74', '2021-04-26', 'pid:00048', 'diagnosis', '0.00', 'income'), 
('75', '2021-04-26', 'pid:00049', 'diagnosis', '0.00', 'income'), 
('76', '2021-04-26', 'pid:00050', 'diagnosis', '0.00', 'income'), 
('77', '2021-04-26', 'pid:00051', 'diagnosis', '2000.00', 'income'), 
('78', '2021-04-27', 'pid:00052', 'diagnosis', '0.00', 'income'), 
('79', '2021-04-27', 'pid:00053', 'diagnosis', '0.00', 'income'), 
('80', '2021-04-27', 'pid:00054', 'diagnosis', '4000.00', 'income'), 
('81', '2021-04-28', 'pid:00055', 'diagnosis', '1200.00', 'income'), 
('82', '2021-04-28', 'pid:0002', 'diagnosis', '0.00', 'income'), 
('83', '2021-04-28', 'pid:00056', 'diagnosis', '800.00', 'income'), 
('84', '2021-04-28', 'pid:00057', 'diagnosis', '10000.00', 'income'), 
('85', '2021-04-29', 'pid:00058', 'diagnosis', '0.00', 'income'), 
('86', '2021-04-29', 'pid:00058', 'diagnosis', '0.00', 'income'), 
('87', '2021-04-29', 'pid:00058', 'diagnosis', '0.00', 'income'), 
('88', '2021-04-29', 'pid:00059', 'diagnosis', '0.00', 'income'), 
('89', '2021-04-29', 'pid:00060', 'diagnosis', '0.00', 'income'), 
('90', '2021-04-29', 'pid:00061', 'diagnosis', '2500.00', 'income'), 
('91', '2021-04-29', 'pid:00062', 'diagnosis', '3000.00', 'income'), 
('92', '2021-04-29', 'pid:00063', 'diagnosis', '3000.00', 'income'), 
('93', '2021-04-29', 'pid:00064', 'diagnosis', '0.00', 'income'), 
('94', '2021-04-30', 'pid:00065', 'diagnosis', '1500.00', 'income'), 
('95', '2021-05-01', 'pid:00066', 'diagnosis', '0.00', 'income'), 
('96', '2021-05-01', 'pid:00067', 'diagnosis', '1000.00', 'income'), 
('97', '2021-05-01', 'pid:00067', 'diagnosis', '0.00', 'income'), 
('98', '2021-05-01', 'pid:00068', 'diagnosis', '2500.00', 'income'), 
('99', '2021-05-01', 'pid:00069', 'diagnosis', '3000.00', 'income'), 
('100', '2021-05-01', 'pid:00070', 'diagnosis', '2500.00', 'income'), 
('101', '2021-05-01', 'pid:00071', 'diagnosis', '3000.00', 'income'), 
('102', '2021-05-01', 'pid:00072', 'diagnosis', '550.00', 'income'), 
('103', '2021-05-01', 'pid:00073', 'diagnosis', '800.00', 'income'), 
('104', '2021-05-02', 'pid:00074', 'diagnosis', '250.00', 'income'), 
('105', '2021-05-02', 'pid:00075', 'diagnosis', '2000.00', 'income'), 
('106', '2021-05-02', 'pid:00076', 'diagnosis', '530.00', 'income'), 
('107', '2021-05-02', 'pid:00077', 'diagnosis', '0.00', 'income'), 
('108', '2021-05-02', 'pid:00078', 'diagnosis', '0.00', 'income'), 
('109', '2021-05-02', 'pid:00079', 'diagnosis', '0.00', 'income'), 
('110', '2021-05-02', 'pid:00078', 'diagnosis', '2000.00', 'income'), 
('111', '2021-05-02', 'pid:00080', 'diagnosis', '2000.00', 'income'), 
('112', '2021-05-02', 'pid:00081', 'diagnosis', '2000.00', 'income'), 
('113', '2021-05-02', 'pid:00081', 'diagnosis', '3400.00', 'income'), 
('114', '2021-05-02', 'pid:00082', 'diagnosis', '3400.00', 'income'), 
('115', '2021-05-02', 'pid:00083', 'diagnosis', '3400.00', 'income'), 
('116', '2021-05-02', 'pid:00084', 'diagnosis', '800.00', 'income'), 
('117', '2021-05-02', 'pid:00085', 'diagnosis', '2000.00', 'income'), 
('118', '2021-05-02', 'pid:00086', 'diagnosis', '2000.00', 'income'), 
('119', '2021-05-02', 'pid:00087', 'diagnosis', '700.00', 'income'), 
('120', '2021-05-02', 'pid:00088', 'diagnosis', '600.00', 'income'), 
('121', '2021-05-03', 'pid:00089', 'diagnosis', '800.00', 'income'), 
('122', '2021-05-03', 'pid:00090', 'diagnosis', '1000.00', 'income'), 
('123', '2021-05-03', 'pid:00091', 'diagnosis', '4200.00', 'income'), 
('124', '2021-05-03', 'pid:00092', 'diagnosis', '1000.00', 'income'), 
('125', '2021-05-03', 'pid:00093', 'diagnosis', '1300.00', 'income'), 
('126', '2021-05-03', 'pid:00094', 'diagnosis', '0.00', 'income'), 
('127', '2021-05-03', 'pid:00095', 'diagnosis', '1000.00', 'income'), 
('128', '2021-05-03', 'pid:00096', 'diagnosis', '1300.00', 'income'), 
('129', '2021-05-03', 'pid:00097', 'diagnosis', '1000.00', 'income'), 
('130', '2021-05-03', 'pid:00098', 'diagnosis', '1300.00', 'income'), 
('131', '2021-05-03', 'pid:00099', 'diagnosis', '700.00', 'income'), 
('132', '2021-05-03', 'pid:00100', 'diagnosis', '1000.00', 'income'), 
('133', '2021-05-03', 'pid:00101', 'diagnosis', '300.00', 'income'), 
('134', '2021-05-03', 'pid:00102', 'diagnosis', '1500.00', 'income'), 
('135', '2021-05-04', 'pid:00103', 'diagnosis', '0.00', 'income'), 
('136', '2021-05-04', 'pid:00104', 'diagnosis', '600.00', 'income'), 
('137', '2021-05-04', 'pid:00105', 'diagnosis', '0.00', 'income'), 
('138', '2021-05-04', 'pid:00106', 'diagnosis', '0.00', 'income'), 
('139', '2021-05-04', 'pid:00107', 'diagnosis', '3000.00', 'income'), 
('140', '2021-05-04', 'pid:00108', 'diagnosis', '1300.00', 'income'), 
('141', '2021-05-04', 'pid:00109', 'diagnosis', '1000.00', 'income'), 
('142', '2021-05-04', 'pid:00110', 'diagnosis', '0.00', 'income'), 
('143', '2021-05-04', 'pid:00111', 'diagnosis', '2200.00', 'income'), 
('144', '2021-05-04', 'pid:00112', 'diagnosis', '2000.00', 'income'), 
('145', '2021-05-04', 'pid:00113', 'diagnosis', '0.00', 'income'), 
('146', '2021-05-04', 'pid:00114', 'diagnosis', '2000.00', 'income'), 
('147', '2021-05-04', 'pid:00115', 'diagnosis', '2000.00', 'income'), 
('148', '2021-05-04', 'pid:00116', 'diagnosis', '2200.00', 'income'), 
('149', '2021-05-05', 'pid:00117', 'diagnosis', '1000.00', 'income'), 
('150', '2021-05-05', 'pid:00118', 'diagnosis', '1300.00', 'income'), 
('151', '2021-05-05', 'pid:00119', 'diagnosis', '1100.00', 'income'), 
('152', '2021-05-05', 'pid:00120', 'diagnosis', '500.00', 'income'), 
('153', '2021-05-05', 'pid:00121', 'diagnosis', '3600.00', 'income'), 
('154', '2021-05-05', 'pid:0010', 'diagnosis', '50.00', 'income'), 
('155', '2021-05-05', 'pid:00121', 'diagnosis', '1100.00', 'income'), 
('156', '2021-05-05', 'pid:00122', 'diagnosis', '1100.00', 'income'), 
('157', '2021-05-05', 'pid:0020', 'diagnosis', '50.00', 'income'), 
('158', '2021-05-05', 'pid:00122', 'diagnosis', '101.00', 'income'), 
('159', '2021-05-05', 'pid:00118', 'diagnosis', '100.00', 'income'), 
('160', '2021-05-05', 'pid:00118', 'diagnosis', '250.00', 'income'), 
('161', '2021-05-05', 'pid:00118', 'diagnosis', '50.00', 'income'), 
('162', '2021-05-05', 'pid:00122', 'diagnosis', '250.00', 'income'), 
('163', '2021-05-05', 'pid:00123', 'diagnosis', '1000.00', 'income'), 
('164', '2021-05-05', 'pid:00124', 'diagnosis', '1000.00', 'income'), 
('165', '2021-05-05', 'pid:00125', 'diagnosis', '1000.00', 'income'), 
('166', '2021-05-05', 'pid:00126', 'diagnosis', '50.00', 'income'), 
('167', '2021-05-05', 'pid:17374', 'diagnosis', '100.00', 'income'), 
('168', '2021-05-05', 'pid:62782', 'diagnosis', '50.00', 'income'), 
('169', '2021-05-05', 'pid:73888', 'diagnosis', '500.00', 'income'), 
('170', '2021-05-05', 'pid:73888', 'diagnosis', '500.00', 'income'), 
('171', '2021-05-05', 'pid:88818', 'diagnosis', '0.00', 'income'), 
('172', '2021-05-05', 'pid:88818', 'diagnosis', '500.00', 'income'), 
('173', '2021-05-06', 'pid:88818', 'diagnosis', '6000.00', 'income'), 
('174', '2021-05-06', 'pid:94895', 'diagnosis', '6000.00', 'income'), 
('175', '2021-05-06', 'pid:94895', 'diagnosis', '700.00', 'income'), 
('176', '2021-05-06', 'pid:94895', 'diagnosis', '4800.00', 'income'), 
('177', '2021-05-06', 'pid:94895', 'diagnosis', '1450.00', 'income'), 
('178', '2021-05-06', 'pid:94895', 'diagnosis', '950.00', 'income'), 
('179', '2021-05-06', 'pid:94895', 'diagnosis', '1000.00', 'income'), 
('180', '2021-05-06', 'pid:94895', 'diagnosis', '1200.00', 'income'), 
('181', '2021-05-06', 'pid:94895', 'diagnosis', '1600.00', 'income'), 
('182', '2021-05-07', 'pid:94895', 'diagnosis', '1600.00', 'income'), 
('183', '2021-05-07', 'pid:95175', 'diagnosis', '420.00', 'income'), 
('184', '2021-05-07', 'pid:95175', 'diagnosis', '1000.00', 'income'), 
('185', '2021-05-07', 'pid:95175', 'diagnosis', '1000.00', 'income'), 
('186', '2021-05-07', 'pid:95175', 'diagnosis', '1850.00', 'income'), 
('187', '2021-05-07', 'pid:95175', 'diagnosis', '600.00', 'income'), 
('188', '2021-05-07', 'pid:95175', 'diagnosis', '1500.00', 'income'), 
('189', '2021-05-08', 'pid:95175', 'diagnosis', '3600.00', 'income'), 
('190', '2021-05-08', 'pid:95175', 'diagnosis', '3600.00', 'income'), 
('191', '2021-05-08', 'pid:95175', 'diagnosis', '1200.00', 'income'), 
('192', '2021-05-08', 'pid:95175', 'diagnosis', '1000.00', 'income'), 
('193', '2021-05-08', 'pid:95175', 'diagnosis', '400.00', 'income'), 
('194', '2021-05-08', 'pid:95175', 'diagnosis', '800.00', 'income'), 
('195', '2021-05-08', 'pid:95175', 'diagnosis', '3600.00', 'income'), 
('196', '2021-05-08', 'pid:95175', 'diagnosis', '2000.00', 'income'), 
('197', '2021-05-08', 'pid:95175', 'diagnosis', '2000.00', 'income'), 
('198', '2021-05-08', 'pid:95175', 'diagnosis', '3600.00', 'income'), 
('199', '2021-05-08', 'pid:95175', 'diagnosis', '700.00', 'income'), 
('200', '2021-05-08', 'pid:95175', 'diagnosis', '50.00', 'income'), 
('201', '2021-05-08', 'pid:95175', 'diagnosis', '2400.00', 'income'), 
('202', '2021-05-08', 'pid:95175', 'diagnosis', '1150.00', 'income'), 
('203', '2021-05-08', 'pid:95175', 'diagnosis', '1200.00', 'income'), 
('204', '2021-05-08', 'pid:95175', 'diagnosis', '600.00', 'income'), 
('205', '2021-05-08', 'pid:95175', 'diagnosis', '800.00', 'income'), 
('206', '2021-05-08', 'pid:95175', 'diagnosis', '900.00', 'income'), 
('207', '2021-05-09', 'pid:95175', 'diagnosis', '2400.00', 'income'), 
('208', '2021-05-09', 'pid:95175', 'diagnosis', '1700.00', 'income'), 
('209', '2021-05-09', 'pid:95175', 'diagnosis', '2300.00', 'income'), 
('210', '2021-05-09', 'pid:95175', 'diagnosis', '0.00', 'income'), 
('211', '2021-05-09', 'pid:95175', 'diagnosis', '800.00', 'income'), 
('212', '2021-05-09', 'pid:95175', 'diagnosis', '600.00', 'income'), 
('213', '2021-05-09', 'pid:95175', 'diagnosis', '0.00', 'income'), 
('214', '2021-05-09', 'pid:95175', 'diagnosis', '1500.00', 'income'), 
('215', '2021-05-09', 'pid:95175', 'diagnosis', '670.00', 'income'), 
('216', '2021-05-09', 'pid:95175', 'diagnosis', '800.00', 'income'), 
('217', '2021-05-09', 'pid:95175', 'diagnosis', '800.00', 'income'), 
('218', '2021-05-10', 'pid:95175', 'diagnosis', '1400.00', 'income'), 
('219', '2021-05-10', 'pid:95175', 'diagnosis', '600.00', 'income'), 
('220', '2021-05-10', 'pid:95175', 'diagnosis', '1600.00', 'income'), 
('221', '2021-05-10', 'pid:95175', 'diagnosis', '1340.00', 'income'), 
('222', '2021-05-10', 'pid:95175', 'diagnosis', '1340.00', 'income'), 
('223', '2021-05-10', 'pid:95175', 'diagnosis', '600.00', 'income'), 
('224', '2021-05-10', 'pid:95175', 'diagnosis', '600.00', 'income'), 
('225', '2021-05-10', 'pid:95175', 'diagnosis', '900.00', 'income'), 
('226', '2021-05-11', 'pid:95175', 'diagnosis', '800.00', 'income'), 
('227', '2021-05-11', 'pid:95175', 'diagnosis', '1500.00', 'income'), 
('228', '2021-05-11', 'pid:95175', 'diagnosis', '500.00', 'income'), 
('229', '2021-05-11', 'pid:95175', 'diagnosis', '800.00', 'income'), 
('230', '2021-05-12', 'pid:95175', 'diagnosis', '3000.00', 'income'), 
('231', '2021-05-12', 'pid:95175', 'diagnosis', '2000.00', 'income'), 
('232', '2021-05-12', 'pid:95175', 'diagnosis', '3200.00', 'income'), 
('233', '2021-05-12', 'pid:95175', 'diagnosis', '200.00', 'income'), 
('234', '2021-05-12', 'pid:95175', 'diagnosis', '2000.00', 'income'), 
('235', '2021-05-12', 'pid:96814', 'diagnosis', '250.00', 'income'), 
('236', '2021-05-12', 'pid:96814', 'diagnosis', '0.00', 'income'), 
('237', '2021-05-12', 'pid:96814', 'diagnosis', '2100.00', 'income'), 
('238', '2021-05-12', 'pid:96814', 'diagnosis', '1600.00', 'income'), 
('239', '2021-05-12', 'pid:96814', 'diagnosis', '250.00', 'income'), 
('240', '2021-05-12', 'pid:96814', 'diagnosis', '1600.00', 'income'), 
('241', '2021-05-12', 'pid:96814', 'diagnosis', '2300.00', 'income'), 
('242', '2021-05-16', 'pid:96814', 'diagnosis', '3500.00', 'income'), 
('243', '2021-05-16', 'pid:96814', 'diagnosis', '1200.00', 'income'), 
('244', '2021-05-16', 'pid:96814', 'diagnosis', '2600.00', 'income'), 
('245', '2021-05-16', 'pid:96814', 'diagnosis', '2500.00', 'income'), 
('246', '2021-05-16', 'pid:96814', 'diagnosis', '3300.00', 'income'), 
('247', '2021-05-16', 'pid:96814', 'diagnosis', '4500.00', 'income'), 
('248', '2021-05-16', 'pid:96814', 'diagnosis', '1700.00', 'income'), 
('249', '2021-05-16', 'pid:96814', 'diagnosis', '1500.00', 'income'), 
('250', '2021-05-16', 'pid:96814', 'diagnosis', '3300.00', 'income'), 
('251', '2021-05-16', 'pid:96814', 'diagnosis', '1500.00', 'income'), 
('252', '2021-05-16', 'pid:96814', 'diagnosis', '1000.00', 'income'), 
('253', '2021-05-16', 'pid:96814', 'diagnosis', '1000.00', 'income'), 
('254', '2021-05-16', 'pid:96814', 'diagnosis', '800.00', 'income'), 
('255', '2021-05-17', 'pid:96814', 'diagnosis', '3000.00', 'income'), 
('256', '2021-05-17', 'pid:96814', 'diagnosis', '5500.00', 'income'), 
('257', '2021-05-17', 'pid:98058', 'diagnosis', '2500.00', 'income'), 
('258', '2021-05-17', 'pid:98058', 'diagnosis', '3000.00', 'income'), 
('259', '2021-05-17', 'pid:98058', 'diagnosis', '1650.00', 'income'), 
('260', '2021-05-17', 'pid:98058', 'diagnosis', '1100.00', 'income'), 
('261', '2021-05-17', 'pid:98058', 'diagnosis', '1000.00', 'income'), 
('262', '2021-05-17', 'pid:98058', 'diagnosis', '2750.00', 'income'), 
('263', '2021-05-17', 'pid:98058', 'diagnosis', '1500.00', 'income'), 
('264', '2021-05-17', 'pid:98058', 'diagnosis', '300.00', 'income'), 
('265', '2021-05-17', 'pid:98058', 'diagnosis', '500.00', 'income'), 
('266', '2021-05-17', 'pid:98058', 'diagnosis', '1000.00', 'income'), 
('267', '2021-05-17', 'pid:98058', 'diagnosis', '3000.00', 'income'), 
('268', '2021-05-17', 'pid:98058', 'diagnosis', '800.00', 'income'), 
('269', '2021-05-17', 'pid:98058', 'diagnosis', '3800.00', 'income'), 
('270', '2021-05-17', 'pid:98058', 'diagnosis', '550.00', 'income'), 
('271', '2021-05-17', 'pid:98058', 'diagnosis', '1500.00', 'income'), 
('272', '2021-05-17', 'pid:98058', 'diagnosis', '1500.00', 'income'), 
('273', '2021-05-17', 'pid:98058', 'diagnosis', '2000.00', 'income'), 
('274', '2021-05-17', 'pid:98058', 'diagnosis', '2000.00', 'income'), 
('275', '2021-05-17', 'pid:98058', 'diagnosis', '825.00', 'income'), 
('276', '2021-05-17', 'pid:98058', 'diagnosis', '900.00', 'income'), 
('277', '2021-05-17', 'pid:98058', 'diagnosis', '350.00', 'income'), 
('278', '2021-05-17', 'pid:98058', 'diagnosis', '1900.00', 'income'), 
('279', '2021-05-17', 'pid:98058', 'diagnosis', '1000.00', 'income'), 
('280', '2021-05-17', 'pid:98058', 'diagnosis', '2900.00', 'income'), 
('281', '2021-05-17', 'pid:98058', 'diagnosis', '4000.00', 'income'), 
('282', '2021-05-17', 'pid:98058', 'diagnosis', '1400.00', 'income'), 
('283', '2021-05-17', 'pid:98058', 'diagnosis', '1300.00', 'income'), 
('284', '2021-05-18', 'pid:98058', 'diagnosis', '2500.00', 'income'), 
('285', '2021-05-18', 'pid:98058', 'diagnosis', '2000.00', 'income'), 
('286', '2021-05-18', 'pid:98058', 'diagnosis', '1200.00', 'income'), 
('287', '2021-05-18', 'pid:98058', 'diagnosis', '800.00', 'income'), 
('288', '2021-05-18', 'pid:98058', 'diagnosis', '600.00', 'income'), 
('289', '2021-05-18', 'pid:98058', 'diagnosis', '600.00', 'income'), 
('290', '2021-05-18', 'pid:98058', 'diagnosis', '3200.00', 'income'), 
('291', '2021-05-18', 'pid:98058', 'diagnosis', '0.00', 'income'), 
('292', '2021-05-18', 'pid:98058', 'diagnosis', '4000.00', 'income'), 
('293', '2021-05-18', 'pid:98058', 'diagnosis', '2300.00', 'income'), 
('294', '2021-05-18', 'pid:98058', 'diagnosis', '1100.00', 'income'), 
('295', '2021-05-18', 'pid:98058', 'diagnosis', '2000.00', 'income'), 
('296', '2021-05-18', 'pid:98058', 'diagnosis', '1250.00', 'income'), 
('297', '2021-05-18', 'pid:98058', 'diagnosis', '3500.00', 'income'), 
('298', '2021-05-18', 'pid:98058', 'diagnosis', '0.00', 'income'), 
('299', '2021-05-18', 'pid:98058', 'diagnosis', '1000.00', 'income'), 
('300', '2021-05-18', 'pid:98058', 'diagnosis', '1200.00', 'income'), 
('301', '2021-05-18', 'pid:98058', 'diagnosis', '1000.00', 'income'), 
('302', '2021-05-18', 'pid:98058', 'diagnosis', '1500.00', 'income'), 
('303', '2021-05-18', 'pid:98058', 'diagnosis', '2000.00', 'income'), 
('304', '2021-05-18', 'pid:98058', 'diagnosis', '1000.00', 'income'), 
('305', '2021-05-18', 'pid:98073', 'diagnosis', '250.00', 'income'), 
('306', '2021-05-19', 'pid:98073', 'diagnosis', '1500.00', 'income'), 
('307', '2021-05-19', 'pid:98073', 'diagnosis', '0.00', 'income'), 
('308', '2021-05-19', 'pid:98073', 'diagnosis', '200.00', 'income'), 
('309', '2021-05-19', 'pid:98073', 'diagnosis', '1000.00', 'income'), 
('310', '2021-05-19', 'pid:98697', 'diagnosis', '1000.00', 'income'), 
('311', '2021-05-19', 'pid:98697', 'diagnosis', '100.00', 'income'), 
('312', '2021-05-19', 'pid:98697', 'diagnosis', '100.00', 'income'), 
('313', '2021-05-19', 'pid:98697', 'diagnosis', '300.00', 'income'), 
('314', '2021-05-19', 'pid:98697', 'diagnosis', '400.00', 'income'), 
('315', '2021-05-19', 'pid:98697', 'diagnosis', '500.00', 'income'), 
('316', '2021-05-19', 'pid:98697', 'diagnosis', '500.00', 'income'), 
('317', '2021-05-19', 'pid:98697', 'diagnosis', '1700.00', 'income'), 
('318', '2021-05-19', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('319', '2021-05-19', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('320', '2021-05-19', 'pid:98697', 'diagnosis', '400.00', 'income'), 
('321', '2021-05-19', 'pid:98697', 'diagnosis', '400.00', 'income'), 
('322', '2021-05-19', 'pid:98697', 'diagnosis', '1000.00', 'income'), 
('323', '2021-05-19', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('324', '2021-05-19', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('325', '2021-05-19', 'pid:98697', 'diagnosis', '2400.00', 'income'), 
('326', '2021-05-19', 'pid:98697', 'diagnosis', '1500.00', 'income'), 
('327', '2021-05-19', 'pid:98697', 'diagnosis', '100.00', 'income'), 
('328', '2021-05-19', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('329', '2021-05-19', 'pid:98697', 'diagnosis', '500.00', 'income'), 
('330', '2021-05-19', 'pid:98697', 'diagnosis', '2000.00', 'income'), 
('331', '2021-05-19', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('332', '2021-05-19', 'pid:98697', 'diagnosis', '2000.00', 'income'), 
('333', '2021-05-19', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('334', '2021-05-19', 'pid:98697', 'diagnosis', '400.00', 'income'), 
('335', '2021-05-19', 'pid:98697', 'diagnosis', '450.00', 'income'), 
('336', '2021-05-19', 'pid:98697', 'diagnosis', '1000.00', 'income'), 
('337', '2021-05-20', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('338', '2021-05-20', 'pid:98697', 'diagnosis', '100.00', 'income'), 
('339', '2021-05-20', 'pid:98697', 'diagnosis', '100.00', 'income'), 
('340', '2021-05-20', 'pid:98697', 'diagnosis', '100.00', 'income'), 
('341', '2021-05-20', 'pid:98697', 'diagnosis', '500.00', 'income'), 
('342', '2021-05-20', 'pid:98697', 'diagnosis', '1200.00', 'income'), 
('343', '2021-05-20', 'pid:98697', 'diagnosis', '1500.00', 'income'), 
('344', '2021-05-20', 'pid:98697', 'diagnosis', '3000.00', 'income'), 
('345', '2021-05-20', 'pid:98697', 'diagnosis', '400.00', 'income'), 
('346', '2021-05-20', 'pid:98697', 'diagnosis', '250.00', 'income'), 
('347', '2021-05-20', 'pid:98697', 'diagnosis', '400.00', 'income'), 
('348', '2021-05-20', 'pid:98697', 'diagnosis', '1000.00', 'income'), 
('349', '2021-05-20', 'pid:98697', 'diagnosis', '2000.00', 'income'), 
('350', '2021-05-20', 'pid:98697', 'diagnosis', '1000.00', 'income'), 
('351', '2021-05-20', 'pid:98697', 'diagnosis', '800.00', 'income'), 
('352', '2021-05-20', 'pid:98697', 'diagnosis', '400.00', 'income'), 
('353', '2021-05-20', 'pid:98697', 'diagnosis', '250.00', 'income'), 
('354', '2021-05-20', 'pid:98697', 'diagnosis', '250.00', 'income'), 
('355', '2021-05-20', 'pid:98697', 'diagnosis', '3000.00', 'income'), 
('356', '2021-05-20', 'pid:98697', 'diagnosis', '1000.00', 'income'), 
('357', '2021-05-20', 'pid:98697', 'diagnosis', '800.00', 'income'), 
('358', '2021-05-20', 'pid:98697', 'diagnosis', '250.00', 'income'), 
('359', '2021-05-20', 'pid:98697', 'diagnosis', '250.00', 'income'), 
('360', '2021-05-20', 'pid:98697', 'diagnosis', '2500.00', 'income'), 
('361', '2021-05-20', 'pid:98697', 'diagnosis', '250.00', 'income'), 
('362', '2021-05-20', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('363', '2021-05-20', 'pid:98697', 'diagnosis', '3000.00', 'income'), 
('364', '2021-05-20', 'pid:98697', 'diagnosis', '300.00', 'income'), 
('365', '2021-05-20', 'pid:98697', 'diagnosis', '200.00', 'income'), 
('366', '2021-05-20', 'pid:98697', 'diagnosis', '3000.00', 'income'), 
('367', '2021-05-20', 'pid:98697', 'diagnosis', '1900.00', 'income'), 
('368', '2021-05-21', 'pid:98697', 'diagnosis', '300.00', 'income'), 
('369', '2021-05-21', 'pid:98697', 'diagnosis', '400.00', 'income'), 
('370', '2021-05-21', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('371', '2021-05-21', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('372', '2021-05-21', 'pid:98697', 'diagnosis', '200.00', 'income'), 
('373', '2021-05-21', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('374', '2021-05-21', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('375', '2021-05-21', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('376', '2021-05-21', 'pid:98697', 'diagnosis', '200.00', 'income'), 
('377', '2021-05-21', 'pid:98697', 'diagnosis', '400.00', 'income'), 
('378', '2021-05-21', 'pid:98697', 'diagnosis', '600.00', 'income'), 
('379', '2021-05-21', 'pid:98697', 'diagnosis', '1000.00', 'income'), 
('380', '2021-05-21', 'pid:98697', 'diagnosis', '2700.00', 'income'), 
('381', '2021-05-21', 'pid:98697', 'diagnosis', '1600.00', 'income'), 
('382', '2021-05-21', 'pid:98697', 'diagnosis', '150.00', 'income'), 
('383', '2021-05-21', 'pid:98697', 'diagnosis', '400.00', 'income'), 
('384', '2021-05-21', 'pid:98697', 'diagnosis', '300.00', 'income'), 
('385', '2021-05-21', 'pid:98697', 'diagnosis', '100.00', 'income'), 
('386', '2021-05-21', 'pid:98697', 'diagnosis', '100.00', 'income'), 
('387', '2021-05-22', 'pid:98697', 'diagnosis', '450.00', 'income'), 
('388', '2021-05-22', 'pid:98697', 'diagnosis', '1200.00', 'income'), 
('389', '2021-05-22', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('390', '2021-05-22', 'pid:98697', 'diagnosis', '50.00', 'income'), 
('391', '2021-05-22', 'pid:98697', 'diagnosis', '2500.00', 'income'), 
('392', '2021-05-22', 'pid:98697', 'diagnosis', '50.00', 'income'), 
('393', '2021-05-22', 'pid:98697', 'diagnosis', '300.00', 'income'), 
('394', '2021-05-22', 'pid:98697', 'diagnosis', '200.00', 'income'), 
('395', '2021-05-22', 'pid:98697', 'diagnosis', '500.00', 'income'), 
('396', '2021-05-22', 'pid:98697', 'diagnosis', '850.00', 'income'), 
('397', '2021-05-22', 'pid:98697', 'diagnosis', '600.00', 'income'), 
('398', '2021-05-22', 'pid:98697', 'diagnosis', '800.00', 'income'), 
('399', '2021-05-22', 'pid:98697', 'diagnosis', '1050.00', 'income'), 
('400', '2021-05-22', 'pid:98697', 'diagnosis', '800.00', 'income'), 
('401', '2021-05-22', 'pid:98697', 'diagnosis', '600.00', 'income'), 
('402', '2021-05-22', 'pid:98697', 'diagnosis', '400.00', 'income'), 
('403', '2021-05-22', 'pid:98697', 'diagnosis', '0.00', 'income'), 
('404', '2021-05-22', 'pid:98697', 'diagnosis', '2400.00', 'income'), 
('405', '2021-05-22', 'pid:98697', 'diagnosis', '500.00', 'income'), 
('406', '2021-05-22', 'pid:98697', 'diagnosis', '1200.00', 'income'), 
('407', '2021-05-22', 'pid:98697', 'diagnosis', '2000.00', 'income'), 
('408', '2021-05-22', 'pid:98697', 'diagnosis', '400.00', 'income'), 
('409', '2021-05-22', 'pid:98697', 'diagnosis', '1500.00', 'income'), 
('410', '2021-05-22', 'pid:98697', 'diagnosis', '2900.00', 'income'), 
('411', '2021-05-22', 'pid:98697', 'diagnosis', '1200.00', 'income'), 
('412', '2021-05-22', 'pid:98697', 'diagnosis', '1700.00', 'income'), 
('413', '2021-05-22', 'pid:98697', 'diagnosis', '1700.00', 'income'), 
('414', '2021-05-22', 'pid:98697', 'diagnosis', '1000.00', 'income'), 
('415', '2021-05-22', 'pid:98697', 'diagnosis', '1500.00', 'income'), 
('416', '2021-05-22', 'pid:98697', 'diagnosis', '2500.00', 'income'), 
('417', '2021-05-22', 'pid:98697', 'diagnosis', '1500.00', 'income'), 
('418', '2021-05-22', 'pid:98697', 'diagnosis', '3350.00', 'income'), 
('419', '2021-05-22', 'pid:98697', 'diagnosis', '3000.00', 'income'), 
('420', '2021-05-22', 'pid:98697', 'diagnosis', '3200.00', 'income'), 
('421', '2021-05-22', 'pid:98697', 'diagnosis', '1500.00', 'income'), 
('422', '2021-05-22', 'pid:98697', 'diagnosis', '2000.00', 'income'), 
('423', '2021-05-22', 'pid:98697', 'diagnosis', '800.00', 'income'), 
('424', '2021-05-22', 'pid:98697', 'diagnosis', '500.00', 'income'), 
('425', '2021-05-22', 'pid:98697', 'diagnosis', '3000.00', 'income'), 
('426', '2021-05-22', 'pid:98697', 'diagnosis', '500.00', 'income'), 
('427', '2021-05-22', 'pid:98697', 'diagnosis', '1900.00', 'income'), 
('428', '2021-05-22', 'pid:98697', 'diagnosis', '1200.00', 'income'), 
('429', '2021-05-23', 'pid:98697', 'diagnosis', '375.00', 'income'), 
('430', '2021-05-23', 'pid:98697', 'diagnosis', '3800.00', 'income'), 
('431', '2021-05-23', 'pid:98697', 'diagnosis', '150.00', 'income'), 
('432', '2021-05-23', 'pid:98697', 'diagnosis', '1000.00', 'income'), 
('433', '2021-05-23', 'pid:99868', 'diagnosis', '0.00', 'income'), 
('434', '2021-05-23', 'pid:99868', 'diagnosis', '0.00', 'income'), 
('435', '2021-05-23', 'pid:99868', 'diagnosis', '1000.00', 'income'), 
('436', '2021-05-23', 'pid:99868', 'diagnosis', '500.00', 'income'), 
('437', '2021-05-23', 'pid:99868', 'diagnosis', '300.00', 'income'), 
('438', '2021-05-23', 'pid:99868', 'diagnosis', '200.00', 'income'), 
('439', '2021-05-23', 'pid:99868', 'diagnosis', '2700.00', 'income'), 
('440', '2021-05-23', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('441', '2021-05-23', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('442', '2021-05-23', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('443', '2021-05-23', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('444', '2021-05-23', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('445', '2021-05-23', 'pid:99943', 'diagnosis', '200.00', 'income'), 
('446', '2021-05-23', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('447', '2021-05-23', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('448', '2021-05-23', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('449', '2021-05-23', 'pid:99943', 'diagnosis', '2300.00', 'income'), 
('450', '2021-05-23', 'pid:99943', 'diagnosis', '800.00', 'income'), 
('451', '2021-05-23', 'pid:99943', 'diagnosis', '2500.00', 'income'), 
('452', '2021-05-23', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('453', '2021-05-23', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('454', '2021-05-23', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('455', '2021-05-23', 'pid:99943', 'diagnosis', '700.00', 'income'), 
('456', '2021-05-23', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('457', '2021-05-23', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('458', '2021-05-24', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('459', '2021-05-24', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('460', '2021-05-24', 'pid:99943', 'diagnosis', '150.00', 'income'), 
('461', '2021-05-24', 'pid:99943', 'diagnosis', '40.00', 'income'), 
('462', '2021-05-24', 'pid:99943', 'diagnosis', '800.00', 'income'), 
('463', '2021-05-24', 'pid:99943', 'diagnosis', '4000.00', 'income'), 
('464', '2021-05-24', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('465', '2021-05-24', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('466', '2021-05-24', 'pid:99943', 'diagnosis', '700.00', 'income'), 
('467', '2021-05-24', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('468', '2021-05-24', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('469', '2021-05-24', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('470', '2021-05-24', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('471', '2021-05-24', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('472', '2021-05-24', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('473', '2021-05-24', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('474', '2021-05-24', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('475', '2021-05-24', 'pid:99943', 'diagnosis', '150.00', 'income'), 
('476', '2021-05-24', 'pid:99943', 'diagnosis', '800.00', 'income'), 
('477', '2021-05-24', 'pid:99943', 'diagnosis', '300.00', 'income'), 
('478', '2021-05-25', 'pid:99943', 'diagnosis', '600.00', 'income'), 
('479', '2021-05-25', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('480', '2021-05-25', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('481', '2021-05-25', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('482', '2021-05-25', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('483', '2021-05-25', 'pid:99943', 'diagnosis', '40.00', 'income'), 
('484', '2021-05-25', 'pid:99943', 'diagnosis', '4500.00', 'income'), 
('485', '2021-05-25', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('486', '2021-05-25', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('487', '2021-05-25', 'pid:99943', 'diagnosis', '800.00', 'income'), 
('488', '2021-05-25', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('489', '2021-05-25', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('490', '2021-05-25', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('491', '2021-05-25', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('492', '2021-05-25', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('493', '2021-05-25', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('494', '2021-05-25', 'pid:99943', 'diagnosis', '300.00', 'income'), 
('495', '2021-05-25', 'pid:99943', 'diagnosis', '2500.00', 'income'), 
('496', '2021-05-25', 'pid:99943', 'diagnosis', '2500.00', 'income'), 
('497', '2021-05-25', 'pid:99943', 'diagnosis', '800.00', 'income'), 
('498', '2021-05-25', 'pid:99943', 'diagnosis', '4000.00', 'income'), 
('499', '2021-05-25', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('500', '2021-05-25', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('501', '2021-05-25', 'pid:99943', 'diagnosis', '2200.00', 'income'), 
('502', '2021-05-25', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('503', '2021-05-25', 'pid:99943', 'diagnosis', '1450.00', 'income'), 
('504', '2021-05-25', 'pid:99943', 'diagnosis', '2200.00', 'income'), 
('505', '2021-05-25', 'pid:99943', 'diagnosis', '2500.00', 'income'), 
('506', '2021-05-25', 'pid:99943', 'diagnosis', '1200.00', 'income'), 
('507', '2021-05-25', 'pid:99943', 'diagnosis', '3800.00', 'income'), 
('508', '2021-05-25', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('509', '2021-05-25', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('510', '2021-05-25', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('511', '2021-05-25', 'pid:99943', 'diagnosis', '1400.00', 'income'), 
('512', '2021-05-25', 'pid:99943', 'diagnosis', '200.00', 'income'), 
('513', '2021-05-25', 'pid:99943', 'diagnosis', '700.00', 'income'), 
('514', '2021-05-25', 'pid:99943', 'diagnosis', '700.00', 'income'), 
('515', '2021-05-25', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('516', '2021-05-25', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('517', '2021-05-25', 'pid:99943', 'diagnosis', '4500.00', 'income'), 
('518', '2021-05-25', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('519', '2021-05-25', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('520', '2021-05-26', 'pid:99943', 'diagnosis', '1400.00', 'income'), 
('521', '2021-05-26', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('522', '2021-05-26', 'pid:99943', 'diagnosis', '1100.00', 'income'), 
('523', '2021-05-26', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('524', '2021-05-26', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('525', '2021-05-26', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('526', '2021-05-26', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('527', '2021-05-26', 'pid:99943', 'diagnosis', '150.00', 'income'), 
('528', '2021-05-26', 'pid:99943', 'diagnosis', '150.00', 'income'), 
('529', '2021-05-26', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('530', '2021-05-26', 'pid:99943', 'diagnosis', '1100.00', 'income'), 
('531', '2021-05-26', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('532', '2021-05-26', 'pid:99943', 'diagnosis', '1200.00', 'income'), 
('533', '2021-05-26', 'pid:99943', 'diagnosis', '5000.00', 'income'), 
('534', '2021-05-26', 'pid:99943', 'diagnosis', '1950.00', 'income'), 
('535', '2021-05-26', 'pid:99943', 'diagnosis', '1950.00', 'income'), 
('536', '2021-05-26', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('537', '2021-05-26', 'pid:99943', 'diagnosis', '700.00', 'income'), 
('538', '2021-05-26', 'pid:99943', 'diagnosis', '4000.00', 'income'), 
('539', '2021-05-26', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('540', '2021-05-26', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('541', '2021-05-26', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('542', '2021-05-26', 'pid:99943', 'diagnosis', '600.00', 'income'), 
('543', '2021-05-26', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('544', '2021-05-26', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('545', '2021-05-26', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('546', '2021-05-26', 'pid:99943', 'diagnosis', '40.00', 'income'), 
('547', '2021-05-26', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('548', '2021-05-26', 'pid:99943', 'diagnosis', '600.00', 'income'), 
('549', '2021-05-26', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('550', '2021-05-26', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('551', '2021-05-26', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('552', '2021-05-26', 'pid:99943', 'diagnosis', '300.00', 'income'), 
('553', '2021-05-26', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('554', '2021-05-26', 'pid:99943', 'diagnosis', '800.00', 'income'), 
('555', '2021-05-26', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('556', '2021-05-26', 'pid:99943', 'diagnosis', '40.00', 'income'), 
('557', '2021-05-26', 'pid:99943', 'diagnosis', '40.00', 'income'), 
('558', '2021-05-26', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('559', '2021-05-26', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('560', '2021-05-26', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('561', '2021-05-26', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('562', '2021-05-27', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('563', '2021-05-27', 'pid:99943', 'diagnosis', '3500.00', 'income'), 
('564', '2021-05-27', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('565', '2021-05-27', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('566', '2021-05-27', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('567', '2021-05-27', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('568', '2021-05-27', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('569', '2021-05-27', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('570', '2021-05-27', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('571', '2021-05-27', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('572', '2021-05-27', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('573', '2021-05-27', 'pid:99943', 'diagnosis', '700.00', 'income'), 
('574', '2021-05-27', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('575', '2021-05-27', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('576', '2021-05-27', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('577', '2021-05-27', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('578', '2021-05-27', 'pid:99943', 'diagnosis', '2500.00', 'income'), 
('579', '2021-05-27', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('580', '2021-05-27', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('581', '2021-05-27', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('582', '2021-05-27', 'pid:99943', 'diagnosis', '1600.00', 'income'), 
('583', '2021-05-27', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('584', '2021-05-27', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('585', '2021-05-27', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('586', '2021-05-27', 'pid:99943', 'diagnosis', '1900.00', 'income'), 
('587', '2021-05-27', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('588', '2021-05-27', 'pid:99943', 'diagnosis', '2500.00', 'income'), 
('589', '2021-05-27', 'pid:99943', 'diagnosis', '1350.00', 'income'), 
('590', '2021-05-27', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('591', '2021-05-27', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('592', '2021-05-27', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('593', '2021-05-27', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('594', '2021-05-27', 'pid:99943', 'diagnosis', '900.00', 'income'), 
('595', '2021-05-28', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('596', '2021-05-28', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('597', '2021-05-28', 'pid:99943', 'diagnosis', '1800.00', 'income'), 
('598', '2021-05-28', 'pid:99943', 'diagnosis', '600.00', 'income'), 
('599', '2021-05-28', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('600', '2021-05-28', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('601', '2021-05-28', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('602', '2021-05-28', 'pid:99943', 'diagnosis', '600.00', 'income'), 
('603', '2021-05-28', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('604', '2021-05-28', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('605', '2021-05-28', 'pid:99943', 'diagnosis', '1350.00', 'income'), 
('606', '2021-05-28', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('607', '2021-05-28', 'pid:99943', 'diagnosis', '1400.00', 'income'), 
('608', '2021-05-28', 'pid:99943', 'diagnosis', '1200.00', 'income'), 
('609', '2021-05-28', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('610', '2021-05-28', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('611', '2021-05-28', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('612', '2021-05-28', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('613', '2021-05-28', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('614', '2021-05-28', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('615', '2021-05-29', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('616', '2021-05-29', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('617', '2021-05-29', 'pid:99943', 'diagnosis', '2450.00', 'income'), 
('618', '2021-05-29', 'pid:99943', 'diagnosis', '2700.00', 'income'), 
('619', '2021-05-29', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('620', '2021-05-29', 'pid:99943', 'diagnosis', '850.00', 'income'), 
('621', '2021-05-29', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('622', '2021-05-29', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('623', '2021-05-29', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('624', '2021-05-29', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('625', '2021-05-29', 'pid:99943', 'diagnosis', '3100.00', 'income'), 
('626', '2021-05-29', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('627', '2021-05-29', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('628', '2021-05-29', 'pid:99943', 'diagnosis', '200.00', 'income'), 
('629', '2021-05-29', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('630', '2021-05-29', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('631', '2021-05-29', 'pid:99943', 'diagnosis', '1400.00', 'income'), 
('632', '2021-05-29', 'pid:99943', 'diagnosis', '5000.00', 'income'), 
('633', '2021-05-29', 'pid:99943', 'diagnosis', '2800.00', 'income'), 
('634', '2021-05-29', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('635', '2021-05-29', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('636', '2021-05-29', 'pid:99943', 'diagnosis', '800.00', 'income'), 
('637', '2021-05-29', 'pid:99943', 'diagnosis', '2800.00', 'income'), 
('638', '2021-05-29', 'pid:99943', 'diagnosis', '2200.00', 'income'), 
('639', '2021-05-29', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('640', '2021-05-29', 'pid:99943', 'diagnosis', '2500.00', 'income'), 
('641', '2021-05-29', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('642', '2021-05-29', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('643', '2021-05-29', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('644', '2021-05-29', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('645', '2021-05-29', 'pid:99943', 'diagnosis', '1700.00', 'income'), 
('646', '2021-05-29', 'pid:99943', 'diagnosis', '1600.00', 'income'), 
('647', '2021-05-29', 'pid:99943', 'diagnosis', '1700.00', 'income'), 
('648', '2021-05-29', 'pid:99943', 'diagnosis', '1150.00', 'income'), 
('649', '2021-05-30', 'pid:99943', 'diagnosis', '1200.00', 'income'), 
('650', '2021-05-30', 'pid:99943', 'diagnosis', '1600.00', 'income'), 
('651', '2021-05-30', 'pid:99943', 'diagnosis', '150.00', 'income'), 
('652', '2021-05-30', 'pid:99943', 'diagnosis', '4000.00', 'income'), 
('653', '2021-05-30', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('654', '2021-05-30', 'pid:99943', 'diagnosis', '800.00', 'income'), 
('655', '2021-05-30', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('656', '2021-05-30', 'pid:99943', 'diagnosis', '4000.00', 'income'), 
('657', '2021-05-30', 'pid:99943', 'diagnosis', '1800.00', 'income'), 
('658', '2021-05-30', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('659', '2021-05-30', 'pid:99943', 'diagnosis', '200.00', 'income'), 
('660', '2021-05-30', 'pid:99943', 'diagnosis', '2500.00', 'income'), 
('661', '2021-05-30', 'pid:99943', 'diagnosis', '3100.00', 'income'), 
('662', '2021-05-30', 'pid:99943', 'diagnosis', '4200.00', 'income'), 
('663', '2021-05-30', 'pid:99943', 'diagnosis', '1250.00', 'income'), 
('664', '2021-05-30', 'pid:99943', 'diagnosis', '6700.00', 'income'), 
('665', '2021-05-30', 'pid:99943', 'diagnosis', '700.00', 'income'), 
('666', '2021-05-30', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('667', '2021-05-30', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('668', '2021-05-30', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('669', '2021-05-30', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('670', '2021-05-30', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('671', '2021-05-30', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('672', '2021-05-30', 'pid:99943', 'diagnosis', '200.00', 'income'), 
('673', '2021-05-30', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('674', '2021-05-30', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('675', '2021-05-30', 'pid:99943', 'diagnosis', '1100.00', 'income'), 
('676', '2021-05-30', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('677', '2021-05-30', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('678', '2021-05-30', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('679', '2021-05-30', 'pid:99943', 'diagnosis', '200.00', 'income'), 
('680', '2021-05-31', 'pid:99943', 'diagnosis', '700.00', 'income'), 
('681', '2021-05-31', 'pid:99943', 'diagnosis', '300.00', 'income'), 
('682', '2021-05-31', 'pid:99943', 'diagnosis', '4000.00', 'income'), 
('683', '2021-05-31', 'pid:99943', 'diagnosis', '1800.00', 'income'), 
('684', '2021-05-31', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('685', '2021-05-31', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('686', '2021-05-31', 'pid:99943', 'diagnosis', '1300.00', 'income'), 
('687', '2021-05-31', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('688', '2021-05-31', 'pid:99943', 'diagnosis', '2900.00', 'income'), 
('689', '2021-05-31', 'pid:99943', 'diagnosis', '3200.00', 'income'), 
('690', '2021-05-31', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('691', '2021-05-31', 'pid:99943', 'diagnosis', '3200.00', 'income'), 
('692', '2021-05-31', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('693', '2021-05-31', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('694', '2021-05-31', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('695', '2021-05-31', 'pid:99943', 'diagnosis', '3500.00', 'income'), 
('696', '2021-05-31', 'pid:99943', 'diagnosis', '2700.00', 'income'), 
('697', '2021-05-31', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('698', '2021-05-31', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('699', '2021-05-31', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('700', '2021-05-31', 'pid:99943', 'diagnosis', '700.00', 'income'), 
('701', '2021-05-31', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('702', '2021-05-31', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('703', '2021-05-31', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('704', '2021-05-31', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('705', '2021-05-31', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('706', '2021-05-31', 'pid:99943', 'diagnosis', '800.00', 'income'), 
('707', '2021-05-31', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('708', '2021-05-31', 'pid:99943', 'diagnosis', '700.00', 'income'), 
('709', '2021-05-31', 'pid:99943', 'diagnosis', '200.00', 'income'), 
('710', '2021-06-01', 'pid:99943', 'diagnosis', '1200.00', 'income'), 
('711', '2021-06-01', 'pid:99943', 'diagnosis', '150.00', 'income'), 
('712', '2021-06-01', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('713', '2021-06-01', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('714', '2021-06-01', 'pid:99943', 'diagnosis', '3200.00', 'income'), 
('715', '2021-06-01', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('716', '2021-06-01', 'pid:99943', 'diagnosis', '700.00', 'income'), 
('717', '2021-06-01', 'pid:99943', 'diagnosis', '4000.00', 'income'), 
('718', '2021-06-01', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('719', '2021-06-01', 'pid:99943', 'diagnosis', '200.00', 'income'), 
('720', '2021-06-01', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('721', '2021-06-01', 'pid:99943', 'diagnosis', '2500.00', 'income'), 
('722', '2021-06-01', 'pid:99943', 'diagnosis', '1750.00', 'income'), 
('723', '2021-06-01', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('724', '2021-06-01', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('725', '2021-06-01', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('726', '2021-06-01', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('727', '2021-06-01', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('728', '2021-06-01', 'pid:99943', 'diagnosis', '1050.00', 'income'), 
('729', '2021-06-01', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('730', '2021-06-01', 'pid:99943', 'diagnosis', '3400.00', 'income'), 
('731', '2021-06-01', 'pid:99943', 'diagnosis', '2900.00', 'income'), 
('732', '2021-06-01', 'pid:99943', 'diagnosis', '2400.00', 'income'), 
('733', '2021-06-01', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('734', '2021-06-02', 'pid:99943', 'diagnosis', '80.00', 'income'), 
('735', '2021-06-02', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('736', '2021-06-02', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('737', '2021-06-02', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('738', '2021-06-02', 'pid:99943', 'diagnosis', '100.00', 'income'), 
('739', '2021-06-02', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('740', '2021-06-02', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('741', '2021-06-02', 'pid:99943', 'diagnosis', '200.00', 'income'), 
('742', '2021-06-02', 'pid:99943', 'diagnosis', '2200.00', 'income'), 
('743', '2021-06-02', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('744', '2021-06-02', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('745', '2021-06-02', 'pid:99943', 'diagnosis', '4300.00', 'income'), 
('746', '2021-06-02', 'pid:99943', 'diagnosis', '10.00', 'income'), 
('747', '2021-06-02', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('748', '2021-06-02', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('749', '2021-06-02', 'pid:99943', 'diagnosis', '10.00', 'income'), 
('750', '2021-06-02', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('751', '2021-06-02', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('752', '2021-06-02', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('753', '2021-06-02', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('754', '2021-06-02', 'pid:99943', 'diagnosis', '200.00', 'income'), 
('755', '2021-06-02', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('756', '2021-06-02', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('757', '2021-06-02', 'pid:99943', 'diagnosis', '50.00', 'income'), 
('758', '2021-06-02', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('759', '2021-06-02', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('760', '2021-06-02', 'pid:99943', 'diagnosis', '300.00', 'income'), 
('761', '2021-06-02', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('762', '2021-06-02', 'pid:99943', 'diagnosis', '1700.00', 'income'), 
('763', '2021-06-02', 'pid:99943', 'diagnosis', '4250.00', 'income'), 
('764', '2021-06-02', 'pid:99943', 'diagnosis', '350.00', 'income'), 
('765', '2021-06-03', 'pid:99943', 'diagnosis', '3000.00', 'income'), 
('766', '2021-06-03', 'pid:99943', 'diagnosis', '2700.00', 'income'), 
('767', '2021-06-03', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('768', '2021-06-03', 'pid:99943', 'diagnosis', '2700.00', 'income'), 
('769', '2021-06-03', 'pid:99943', 'diagnosis', '150.00', 'income'), 
('770', '2021-06-03', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('771', '2021-06-03', 'pid:99943', 'diagnosis', '1780.00', 'income'), 
('772', '2021-06-03', 'pid:99943', 'diagnosis', '2200.00', 'income'), 
('773', '2021-06-03', 'pid:99943', 'diagnosis', '2000.00', 'income'), 
('774', '2021-06-03', 'pid:99943', 'diagnosis', '4000.00', 'income'), 
('775', '2021-06-03', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('776', '2021-06-03', 'pid:99943', 'diagnosis', '200.00', 'income'), 
('777', '2021-06-03', 'pid:99943', 'diagnosis', '300.00', 'income'), 
('778', '2021-06-03', 'pid:99943', 'diagnosis', '2800.00', 'income'), 
('779', '2021-06-03', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('780', '2021-06-03', 'pid:99943', 'diagnosis', '1000.00', 'income'), 
('781', '2021-06-03', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('782', '2021-06-03', 'pid:99943', 'diagnosis', '250.00', 'income'), 
('783', '2021-06-03', 'pid:99943', 'diagnosis', '400.00', 'income'), 
('784', '2021-06-03', 'pid:99943', 'diagnosis', '1600.00', 'income'), 
('785', '2021-06-03', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('786', '2021-06-03', 'pid:99943', 'diagnosis', '3500.00', 'income'), 
('787', '2021-06-03', 'pid:99943', 'diagnosis', '1500.00', 'income'), 
('788', '2021-06-03', 'pid:99943', 'diagnosis', '0.00', 'income'), 
('789', '2021-06-03', 'pid:99943', 'diagnosis', '500.00', 'income'), 
('790', '2021-06-03', 'pid:99943', 'diagnosis', '2600.00', 'inco